/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.offer.gui;

import de.datomino.peppergis.client.gui.area.MultiAreaObjectSelectionPane;
import de.datomino.peppergis.client.gui.customer.CustomerSearchPane;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.Model;
import de.datomino.peppergis.client.model.area.AreaObjectModel;
import de.datomino.peppergis.client.model.offer.OfferAreaRelationModel;
import de.datomino.peppergis.client.model.offer.OfferAreaRelationModelImpl;
import de.datomino.peppergis.client.model.offer.OfferModel;
import de.datomino.peppergis.client.model.offer.OfferModelImpl;
import de.datomino.peppergis.offer.gui.OfferSettingsPane;
import de.datomino.peppergis.offer.gui.extension.ExtensionPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.ktde.util.datatypes.Tupel;

public abstract class AbstractOfferPane<T extends Model>
extends JPanel {
    private static final long serialVersionUID = -7060103489191596079L;
    private CustomerSearchPane customerSearchPane;
    private MultiAreaObjectSelectionPane multiAreaObjectSelectionPane;
    private OfferSettingsPane offerSettingsPane;
    private ModelEnviroment modelEnviroment;

    public AbstractOfferPane(ModelEnviroment modelEnviroment) {
        super(new BorderLayout());
        this.modelEnviroment = modelEnviroment;
        this.buildLayout();
    }

    protected void buildLayout() {
        JTabbedPane tabbedPane = new JTabbedPane();
        this.customerSearchPane = new CustomerSearchPane(this.modelEnviroment, true, true);
        tabbedPane.addTab(ModelEnviroment.getMessageResolver().resolveMessage("messages.customer", new Serializable[0]), this.customerSearchPane);
        this.multiAreaObjectSelectionPane = this.createAreaObjectSelectionPane();
        tabbedPane.addTab(ModelEnviroment.getMessageResolver().resolveMessage("messages.area.areas", new Serializable[0]), this.multiAreaObjectSelectionPane);
        this.offerSettingsPane = this.createOfferSettingsPane(this.modelEnviroment);
        tabbedPane.addTab(ModelEnviroment.getMessageResolver().resolveMessage("messages.offer.common", new Serializable[0]), this.offerSettingsPane);
        List<ExtensionPane> tupels = this.getExtensionComponents();
        for (ExtensionPane tupel : tupels) {
            tabbedPane.addTab(tupel.getTabName(), tupel.getComponent());
        }
        this.add((Component)tabbedPane, "Center");
    }

    protected OfferSettingsPane createOfferSettingsPane(ModelEnviroment modelEnviroment) {
        return new OfferSettingsPane(modelEnviroment);
    }

    protected MultiAreaObjectSelectionPane createAreaObjectSelectionPane() {
        return new MultiAreaObjectSelectionPane(this.modelEnviroment);
    }

    protected ModelEnviroment getModelEnviroment() {
        return this.modelEnviroment;
    }

    protected abstract List<ExtensionPane> getExtensionComponents();

    public Tupel<OfferModel, T> getOfferModel() {
        String offerNumber = this.createOfferNumber();
        OfferModel offerModel = this.modelEnviroment.getAllCaller().getOfferCaller().getOfferByNumber(offerNumber);
        if (offerModel == null) {
            offerModel = new OfferModelImpl();
            offerModel.setOfferNumber(offerNumber);
        }
        offerModel.setCustomer(this.customerSearchPane.getAdaptedCustomer(false));
        T extension = this.createOrGetExtensionModel(offerModel);
        this.adaptAreaValuesToModel(offerModel, extension);
        this.offerSettingsPane.adaptOfferToModel(offerModel);
        return new Tupel<OfferModel, T>(offerModel, extension);
    }

    protected String createOfferNumber() {
        return this.customerSearchPane.getOfferNumber();
    }

    protected abstract T createOrGetExtensionModel(OfferModel var1);

    protected void adaptAreaValuesToModel(OfferModel offerModel, T extension) {
        Collection<AreaObjectModel> areaObjectModels = this.multiAreaObjectSelectionPane.getSelectedAreaObjects();
        for (OfferAreaRelationModel offerAreaRelationModel : offerModel.iterableOfferAreaRelations()) {
            offerAreaRelationModel.delete();
        }
        offerModel.clearOfferAreaRelations();
        for (AreaObjectModel areaObjectModel : areaObjectModels) {
            OfferAreaRelationModelImpl offerAreaRelationModel = new OfferAreaRelationModelImpl();
            offerAreaRelationModel.setOffer(offerModel);
            offerAreaRelationModel.setArea(areaObjectModel);
            offerModel.addOfferAreaRelation(offerAreaRelationModel);
        }
    }

    protected void fillWithValuesFromOffer(OfferModel offer) {
        this.offerSettingsPane.fillWithValuesFromOffer(offer);
        ArrayList<AreaObjectModel> areaObjects = new ArrayList<AreaObjectModel>(offer.countOfferAreaRelations());
        for (OfferAreaRelationModel offerAreaRelationModel : offer.iterableOfferAreaRelations()) {
            areaObjects.add(offerAreaRelationModel.getArea());
        }
        this.multiAreaObjectSelectionPane.setSelectedAreaObjects(areaObjects);
    }

    protected MultiAreaObjectSelectionPane getMultiAreaObjectSelectionPane() {
        return this.multiAreaObjectSelectionPane;
    }

    protected CustomerSearchPane getCustomerSearchPane() {
        return this.customerSearchPane;
    }

    public boolean checkForPrint() {
        return this.customerSearchPane.checkCustomerValues();
    }

    public boolean checkForSave() {
        return this.customerSearchPane.checkCustomerValues();
    }

    protected OfferSettingsPane getOfferSettingsPane() {
        return this.offerSettingsPane;
    }
}

