/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.importer.subscription;

import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractCellEditor;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.ktde.util.StringUtil;
import org.ktde.util.datatypes.Tripel;

public class SubscriptionImporterBreakTimePanel
extends JPanel {
    private static final long serialVersionUID = -7892110702690241701L;
    private JTable breakTimeTable;
    private List<Tripel<String, String, String>> breakTimeColumns = new LinkedList<Tripel<String, String, String>>();
    private Action removeAction;
    private List<String> headLine;

    public SubscriptionImporterBreakTimePanel() {
        super(new BorderLayout());
        this.buildLayout();
    }

    private void buildLayout() {
        this.breakTimeTable = new JTable(new BreakTimeTableModel());
        this.add((Component)new JScrollPane(this.breakTimeTable), "Center");
        JPanel buttonPanel = new JPanel(new BorderLayout());
        this.removeAction = new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.remove", new Serializable[0])){
            private static final long serialVersionUID = -3522235550523112659L;

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] selectedRows = SubscriptionImporterBreakTimePanel.this.breakTimeTable.getSelectedRows();
                for (int i = selectedRows.length - 1; i >= 0; --i) {
                    SubscriptionImporterBreakTimePanel.this.breakTimeColumns.remove(i);
                }
                ((BreakTimeTableModel)SubscriptionImporterBreakTimePanel.this.breakTimeTable.getModel()).fireTableChanged();
            }
        };
        JButton remove = new JButton(this.removeAction);
        this.removeAction.setEnabled(false);
        buttonPanel.add((Component)remove, "West");
        JButton add = new JButton(new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.add", new Serializable[0])){
            private static final long serialVersionUID = -8038350146355815057L;

            @Override
            public void actionPerformed(ActionEvent e) {
                SubscriptionImporterBreakTimePanel.this.breakTimeColumns.add(new Tripel());
                ((BreakTimeTableModel)SubscriptionImporterBreakTimePanel.this.breakTimeTable.getModel()).fireTableChanged();
            }
        });
        buttonPanel.add((Component)add, "East");
        this.add((Component)buttonPanel, "South");
        this.breakTimeTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int[] selectedRows = SubscriptionImporterBreakTimePanel.this.breakTimeTable.getSelectedRows();
                SubscriptionImporterBreakTimePanel.this.removeAction.setEnabled(selectedRows != null && selectedRows.length > 0);
            }
        });
    }

    public void setHeadLine(List<String> headLine) {
        this.headLine = headLine;
        TableColumnModel columnModel = this.breakTimeTable.getColumnModel();
        columnModel.getColumn(0).setCellEditor(new ValueCellEditor());
        columnModel.getColumn(1).setCellEditor(new ValueCellEditor());
        columnModel.getColumn(2).setCellEditor(new ValueCellEditor());
    }

    public List<Tripel<String, String, String>> getBreakTimes() {
        return this.breakTimeColumns;
    }

    private class ValueCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private static final long serialVersionUID = -604259925709240971L;
        private JComboBox comboBox;

        public ValueCellEditor() {
            Vector<String> vector = new Vector<String>(1 + SubscriptionImporterBreakTimePanel.this.headLine.size());
            vector.add(" ");
            vector.addAll(SubscriptionImporterBreakTimePanel.this.headLine);
            this.comboBox = new JComboBox(vector);
            this.comboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ValueCellEditor.this.stopCellEditing();
                }
            });
        }

        @Override
        public Object getCellEditorValue() {
            if (this.comboBox.getSelectedIndex() == 0) {
                return null;
            }
            return (String)this.comboBox.getSelectedItem();
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            String valueTableEntry = (String)value;
            if (valueTableEntry == null) {
                this.comboBox.setSelectedIndex(0);
            } else {
                this.comboBox.setSelectedItem(valueTableEntry);
            }
            return this.comboBox;
        }
    }

    private class BreakTimeTableModel
    implements TableModel {
        private List<TableModelListener> listeners = new LinkedList<TableModelListener>();

        private BreakTimeTableModel() {
        }

        @Override
        public int getRowCount() {
            return SubscriptionImporterBreakTimePanel.this.breakTimeColumns.size();
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public String getColumnName(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return ModelEnviroment.getMessageResolver().resolveMessage("messages.subscription.breakTime.start", new Serializable[0]);
                }
                case 1: {
                    return ModelEnviroment.getMessageResolver().resolveMessage("messages.subscription.breakTime.end", new Serializable[0]);
                }
                case 2: {
                    return ModelEnviroment.getMessageResolver().resolveMessage("messages.subscription.breakTime.lendSubscription", new Serializable[0]);
                }
            }
            return "";
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return String.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return true;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            Tripel tripel = (Tripel)SubscriptionImporterBreakTimePanel.this.breakTimeColumns.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    String s = (String)tripel.getElement1();
                    if (s == null) {
                        s = " ";
                    }
                    return s;
                }
                case 1: {
                    String s = (String)tripel.getElement2();
                    if (s == null) {
                        s = " ";
                    }
                    return s;
                }
                case 2: {
                    String s = (String)tripel.getElement3();
                    if (s == null) {
                        s = " ";
                    }
                    return s;
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            Tripel tripel = (Tripel)SubscriptionImporterBreakTimePanel.this.breakTimeColumns.get(rowIndex);
            if (StringUtil.isBlank(StringUtil.nullToEmpty(aValue))) {
                aValue = null;
            }
            switch (columnIndex) {
                case 0: {
                    tripel.setElement1((String)aValue);
                }
                case 1: {
                    tripel.setElement2((String)aValue);
                }
                case 2: {
                    tripel.setElement3((String)aValue);
                }
            }
        }

        @Override
        public void addTableModelListener(TableModelListener l) {
            this.listeners.add(l);
        }

        @Override
        public void removeTableModelListener(TableModelListener l) {
            this.listeners.remove(l);
        }

        void fireTableChanged() {
            TableModelEvent e = new TableModelEvent(this);
            for (TableModelListener listener : this.listeners) {
                listener.tableChanged(e);
            }
        }
    }
}

