/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.importer.subscription;

import de.datomino.logistic.dto.LogisticLocationDto;
import de.datomino.logistic.dto.LogisticQualifiedLocationDto;
import de.datomino.logistic.dto.qualifiers.LocationQualifierDescriptorDto;
import de.datomino.logistic.dto.qualifiers.NominatimLocationQualifierDescriptorDto;
import de.datomino.logistic.searchevaluation.SearchEvaluation;
import de.datomino.logistic.searchevaluation.SearchEvaluationAddressWrapper;
import de.datomino.logistic.searchevaluation.SearchEvaluationWeights;
import de.datomino.peppergis.client.communication.ImportCaller;
import de.datomino.peppergis.client.communication.StreetNetCaller;
import de.datomino.peppergis.client.communication.UserCaller;
import de.datomino.peppergis.client.gui.ErrorMessagesDialog;
import de.datomino.peppergis.client.gui.login.UserComboxCellEditor;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.gui.renderer.MultiLineHeaderRenderer;
import de.datomino.peppergis.client.model.UndoManager;
import de.datomino.peppergis.client.model.admin.UserModel;
import de.datomino.peppergis.client.model.area.AreaLayerModel;
import de.datomino.peppergis.client.model.area.AreaObjectModel;
import de.datomino.peppergis.client.model.base.CustomerModel;
import de.datomino.peppergis.client.model.base.ImportedLocationModel;
import de.datomino.peppergis.client.model.base.LocationModel;
import de.datomino.peppergis.client.model.base.SubscriptionModel;
import de.datomino.peppergis.client.model.map.ParcelModel;
import de.datomino.peppergis.client.util.LocationModelUtil;
import de.datomino.peppergis.client.util.LogisticTourDtoUtil;
import de.datomino.peppergis.client.util.SubscriptionModelUtil;
import de.datomino.peppergis.client.util.model.location.LocationWrapper;
import de.datomino.peppergis.client.util.model.location.LocationWrapperFactory;
import de.datomino.peppergis.dto.importer.ParcelImportDto;
import de.datomino.peppergis.dto.importer.ParcelImportResultDto;
import de.datomino.peppergis.dto.importer.ResultDto;
import de.datomino.peppergis.exception.ClientImportException;
import de.datomino.peppergis.exception.ValidateException;
import de.datomino.peppergis.importer.AbstractImportEditorPane;
import de.datomino.peppergis.importer.subscription.ImportLocationTableCellRenderer;
import de.datomino.peppergis.importer.subscription.ImportSubscriptionTableCellRenderer;
import de.datomino.peppergis.importer.util.ImportUtil;
import de.datomino.peppergis.type.ImportedLocationProcess;
import de.datomino.peppergis.type.ImportedLocationStatus;
import de.datomino.peppergis.type.SubscriptionImportStatus;
import de.datomino.peppergis.util.FormUtil;
import de.datomino.peppergis.util.GeoUtil;
import de.datomino.util.collection.CollectionUtil;
import de.datomino.util.geo.ImmutableGeoObjectFactory;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.geo.dto.ImmutablePointDto;
import de.datomino.util.international.country.CountryUtil;
import de.datomino.util.message.MessageResolver;
import de.datomino.util.message.error.ErrorMessages;
import de.datomino.util.swing.ExceptionMessageDialog;
import de.datomino.util.swing.SwingUtils;
import de.datomino.util.swing.TableHeaderWithComponentLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedSet;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import org.ktde.math.projection.Coordinate;
import org.ktde.math.projection.Wgs84Factory;
import org.ktde.util.StringUtil;
import org.ktde.util.datatypes.Tupel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportSubscriptionEditorGui
extends AbstractImportEditorPane {
    private static final long serialVersionUID = -611537118588006621L;
    private static final Logger LOGGER = LoggerFactory.getLogger(ImportSubscriptionEditorGui.class);
    private static final int SIZEOFADDRESSCOLS = 8;
    private static final int COLOFMATCHING = 7;
    private static final int COLOFEDITOR = 8;
    private static final int COLOFINFO = 9;
    private static final int COLOFPROCESS = 10;
    private static final int COLOFDELETE = 11;
    private static final int COLOFSTATUS = 12;
    private static final int SIZEOFSUBSCRIPTIONCOLS = 13;
    private Map<String, SubscriptionModel> hausIdMap;
    private JTabbedPane tabbedPane;
    private DefaultTableModel addressTableModel;
    private JTable addressTable;
    private DefaultTableModel subscriptionTableModel;
    private JTable subscriptionTable;
    private LogisticQualifiedLocationDto selectedLocation;
    private LinkedHashMap<LogisticQualifiedLocationDto, Tupel<Collection<SubscriptionModel>, Collection<ImportedLocationModel>>> subscriptionMap;

    public ImportSubscriptionEditorGui(ModelEnviroment modelEnviroment, Properties properties, Collection<SubscriptionModel> subscriptionModels, boolean withAddressEditor) {
        super(modelEnviroment, properties, "importsubscription.editor.address.modifiable");
        UndoManager undoManager = this.getModelEnviroment().getUndoManager();
        undoManager.startTransaction();
        this.matching = new JTextField();
        this.subscriptionMap = new LinkedHashMap();
        long id = 0L;
        for (SubscriptionModel subscription : subscriptionModels) {
            Tupel<Collection<SubscriptionModel>, Collection<ImportedLocationModel>> tupel;
            LocationModel location = subscription.getLocation();
            if (location == null || location.getParcel() != null || location.getImportedLocation() == null) continue;
            ImportedLocationModel importedLocation = location.getImportedLocation();
            if (GeoUtil.isNullPoint(importedLocation.getGeoLocation()) || importedLocation.getStatus() == null) {
                importedLocation.setGeoLocation(ImmutableGeoObjectFactory.createImmutablePoint(Wgs84Factory.INSTANCE.createCoordinate(0.0, 0.0)));
                importedLocation.setStatus(ImportedLocationStatus.NOTCHANGED);
            }
            String countryString = importedLocation.getCountry() == null ? null : importedLocation.getCountry().getVehicleSign();
            String housenumberString = importedLocation.getHousenumber() == null ? null : String.valueOf(importedLocation.getHousenumber());
            ImmutablePointDto geom = ImmutablePointDto.create(importedLocation.getGeoLocation());
            LogisticQualifiedLocationDto qualifiedLocationDto = new LogisticQualifiedLocationDto(id++, geom, geom, CountryUtil.searchCountryFuzzy(countryString), importedLocation.getPostcode(), importedLocation.getCity(), importedLocation.getDistrict(), importedLocation.getStreet(), housenumberString, importedLocation.getHousenumberExtension(), null);
            for (LogisticQualifiedLocationDto key : this.subscriptionMap.keySet()) {
                if (!qualifiedLocationDto.isSameAddress(key)) continue;
                qualifiedLocationDto = key;
                break;
            }
            if ((tupel = this.subscriptionMap.get(qualifiedLocationDto)) == null) {
                tupel = new Tupel(new HashSet(), new HashSet());
                this.subscriptionMap.put(qualifiedLocationDto, tupel);
            }
            tupel.getElement1().add(subscription);
            tupel.getElement2().add(importedLocation);
            if (subscription.getImportStatus() == null && importedLocation.getStatus() != null) {
                ImportedLocationStatus status = importedLocation.getStatus();
                switch (status) {
                    case CHANGED: {
                        subscription.setImportStatus(SubscriptionImportStatus.CHANGED);
                        break;
                    }
                    case CHECKED: {
                        subscription.setImportStatus(SubscriptionImportStatus.CHECKED);
                        break;
                    }
                    case NOTCHECKED: {
                        subscription.setImportStatus(SubscriptionImportStatus.NOTCHECKED);
                        break;
                    }
                    case NOTCHANGED: 
                    case REMOVED: {
                        subscription.setImportStatus(SubscriptionImportStatus.NOMATCHING);
                    }
                }
            }
            ++id;
        }
        this.hausIdMap = new HashMap<String, SubscriptionModel>();
        if (withAddressEditor) {
            LOGGER.info("qualify " + subscriptionModels.size() + " addresses with google api");
            for (LogisticQualifiedLocationDto key : this.subscriptionMap.keySet()) {
                ArrayList<LogisticQualifiedLocationDto> qualifiedLocations = new ArrayList<LogisticQualifiedLocationDto>(this.getModelEnviroment().getAllCaller().getStreetNetCaller().searchAddressWithQualifiersParameterized(key, 3, new LocationQualifierDescriptorDto[]{new NominatimLocationQualifierDescriptorDto()}));
                for (LogisticQualifiedLocationDto qualifiedLocation : qualifiedLocations) {
                    qualifiedLocation.setMatching(SearchEvaluation.matching(key, (SearchEvaluationAddressWrapper)qualifiedLocation, 100, new SearchEvaluationWeights()));
                }
            }
            this.fillAddressTable();
        } else {
            this.tabbedPane.remove(0);
        }
        this.fillSubscriptionTable();
    }

    private String storeSubcriptions() {
        if (!this.deleteSubcriptions()) {
            return "Die ausgew\u00e4hlten Abonennten k\u00f6nnen nicht gel\u00f6scht werden";
        }
        for (LogisticQualifiedLocationDto qualifiedLocation : this.subscriptionMap.keySet()) {
            Object valueInfo = null;
            for (int row = 0; row < this.subscriptionTable.getRowCount(); ++row) {
                LogisticQualifiedLocationDto logisticQualifiedLocationDto = (LogisticQualifiedLocationDto)((Tupel)this.subscriptionTable.getValueAt(row, 0)).getElement2();
                if (!logisticQualifiedLocationDto.equals(qualifiedLocation)) continue;
                valueInfo = this.subscriptionTable.getValueAt(row, 9);
            }
            for (ImportedLocationModel importedLocationModel : this.subscriptionMap.get(qualifiedLocation).getElement2()) {
                String newInfo;
                String oldInfo;
                if (qualifiedLocation.getMatching() != null && qualifiedLocation.getMatching().equals(100.0)) {
                    ImmutablePointDto geom;
                    if (this.addressModifiable && LocationModelUtil.changedAddress(importedLocationModel, (LogisticLocationDto<Long>)qualifiedLocation)) {
                        importedLocationModel.setCountry(qualifiedLocation.getCountry());
                        importedLocationModel.setCity(qualifiedLocation.getCity());
                        importedLocationModel.setPostcode(qualifiedLocation.getPostcode());
                        importedLocationModel.setStreet(qualifiedLocation.getStreet());
                        importedLocationModel.setHousenumber(Integer.valueOf(qualifiedLocation.getHousenumber()));
                        importedLocationModel.setHousenumberExtension(qualifiedLocation.getExtension());
                    }
                    if ((geom = qualifiedLocation.getGeom()) != null && !GeoUtil.isNullPoint((ImmutablePoint)geom.getGeoObject()) && !GeoUtil.areSamedPoints((ImmutablePoint)geom.getGeoObject(), importedLocationModel.getGeoLocation(), (Double)0.0)) {
                        importedLocationModel.setGeoLocation((ImmutablePoint)geom.getGeoObject());
                        if (importedLocationModel.getStatus() == null || importedLocationModel.getStatus() == ImportedLocationStatus.NOTCHANGED) {
                            importedLocationModel.setStatus(ImportedLocationStatus.NOTCHECKED);
                            for (SubscriptionModel sub : this.subscriptionMap.get(qualifiedLocation).getElement1()) {
                                sub.setImportStatus(SubscriptionImportStatus.NOTCHECKED);
                            }
                        }
                    }
                }
                if ((oldInfo = importedLocationModel.getInformation() == null ? "" : importedLocationModel.getInformation().trim()).equals(newInfo = valueInfo == null ? "" : valueInfo.toString().trim())) continue;
                importedLocationModel.setInformation(newInfo);
            }
        }
        String error = null;
        UndoManager undoManager = this.getModelEnviroment().getUndoManager();
        UserModel loginUser = ModelEnviroment.getUserInformation().getUserModel();
        Collection<ImportedLocationModel> changedImportedLocations = undoManager.getChangedObjects(ImportedLocationModel.class);
        for (ImportedLocationModel il : changedImportedLocations) {
            il.setLoginUser(loginUser);
        }
        undoManager.finishTransaction("Speichern der Abonennten");
        try {
            undoManager.storeTransactions();
        }
        catch (ValidateException validateException) {
            undoManager.rollbackTransaction();
            error = validateException.getMessage();
        }
        return error;
    }

    private boolean deleteSubcriptions() {
        LinkedList<Tupel<Integer, Collection<SubscriptionModel>>> forDelete = new LinkedList<Tupel<Integer, Collection<SubscriptionModel>>>();
        for (int row = 0; row < this.subscriptionTableModel.getRowCount(); ++row) {
            Boolean delete = (Boolean)this.subscriptionTableModel.getValueAt(row, 11);
            if (delete == null || !delete.booleanValue()) continue;
            Tupel valueAt = (Tupel)this.subscriptionTable.getValueAt(row, 0);
            Tupel<Collection<SubscriptionModel>, Collection<ImportedLocationModel>> tupel = this.subscriptionMap.get(valueAt.getElement2());
            forDelete.add(new Tupel<Integer, Collection<SubscriptionModel>>(row, tupel.getElement1()));
        }
        if (forDelete.size() == 0) {
            return true;
        }
        Collections.reverse(forDelete);
        int d = JOptionPane.showConfirmDialog(this, "Alle markierten Abonennten werden gel\u00f6scht. Wollen Sie es fortsetzen?", ModelEnviroment.getMessageResolver().resolveMessage("messages.default.confirm", new Serializable[0]), 0);
        switch (d) {
            case 0: {
                UndoManager undoManager = this.getModelEnviroment().getUndoManager();
                undoManager.startTransaction();
                for (Tupel tupel : forDelete) {
                    try {
                        for (SubscriptionModel subscription : (Collection)tupel.getElement2()) {
                            SubscriptionModelUtil.deleteSubscription(subscription, this.getModelEnviroment());
                        }
                        this.subscriptionTableModel.removeRow((Integer)tupel.getElement1());
                    }
                    catch (Exception e) {
                        BufferedImage image;
                        try {
                            image = ImageIO.read(ImportSubscriptionEditorGui.class.getResourceAsStream("/images/pepper.png"));
                        }
                        catch (IOException ioEx) {
                            throw new RuntimeException(ioEx);
                        }
                        ExceptionMessageDialog exceptionMessageDialog = new ExceptionMessageDialog(SwingUtils.findWindowParent(this), e, image);
                        exceptionMessageDialog.setVisible(true);
                        return false;
                    }
                }
                return true;
            }
        }
        return false;
    }

    protected String storeParcels() throws UnsupportedEncodingException {
        ImportCaller importCaller = this.getModelEnviroment().getAllCaller().getImportCaller();
        StreetNetCaller streetNetCaller = this.getModelEnviroment().getAllCaller().getStreetNetCaller();
        HashSet<LogisticQualifiedLocationDto> locations = new HashSet<LogisticQualifiedLocationDto>();
        String houseId = null;
        HashSet<SubscriptionModel> subscriptions = new HashSet<SubscriptionModel>();
        for (Tupel<Collection<SubscriptionModel>, Collection<ImportedLocationModel>> tupel : this.subscriptionMap.values()) {
            subscriptions.addAll(tupel.getElement1());
        }
        for (SubscriptionModel subscription : subscriptions) {
            houseId = streetNetCaller.generateImportParcelKey(houseId);
            LocationWrapper wrapper = LocationWrapperFactory.INSTANCE.createLocationWrapper(subscription.getLocation());
            LogisticQualifiedLocationDto location = new LogisticQualifiedLocationDto(LogisticTourDtoUtil.createLogisticLocationDtoLong(wrapper, 0L, null));
            location.setInternalId(houseId);
            location.setMatching(this.getBestMatching(subscription));
            this.hausIdMap.put(houseId, subscription);
        }
        ParcelImportDto parcelImportDto = ImportUtil.createParcelImportDto(locations);
        if (parcelImportDto == null) {
            LOGGER.info("importer.houseId.length or importer.houseId.prefix is incorrent");
            return "Fehler: Einstellung in Client-Properties";
        }
        StringBuilder error = new StringBuilder();
        try {
            ResultDto result = importCaller.importParcels(parcelImportDto);
            ParcelImportResultDto parcelImportResult = (ParcelImportResultDto)result;
            SortedSet<String> parcelIds = parcelImportResult.getNews();
            for (String parcelId : parcelIds) {
                ParcelModel parcel = streetNetCaller.fetchParcelByImportKey(parcelId);
                SubscriptionModel subscription = this.hausIdMap.get(parcel.getImportKey());
                subscription.getLocation().setParcel(parcel);
                if (this.getBestMatching(subscription) == 100.0) {
                    subscription.setImportStatus(SubscriptionImportStatus.NOTCHECKED);
                    continue;
                }
                subscription.setImportStatus(SubscriptionImportStatus.NOMATCHING);
            }
            ErrorMessages errorMessages = parcelImportResult.getErrorMessages();
            if (errorMessages.hasErrors()) {
                error.append("Fehler:\n");
                error.append(ModelEnviroment.getMessageResolver().resolveMessages(errorMessages, "\n"));
            }
        }
        catch (ClientImportException e) {
            LOGGER.warn(e.getMessage(), e);
            ErrorMessages errorMessages = e.getErrorMessages();
            if (errorMessages != null && errorMessages.hasErrors()) {
                error.append(ModelEnviroment.getMessageResolver().resolveMessages(errorMessages, "\n"));
            }
            error.append(e.getMessage());
        }
        return error.toString();
    }

    @Override
    protected JTabbedPane createTopPanel(JPanel undoManagerPane) {
        this.tabbedPane = new JTabbedPane(1);
        JButton subscriptionSaveButton = new JButton(new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessages(CollectionUtil.buildArrayList("messages.default.save", "messages.default.and", "messages.default.close"), new String[0])){
            private static final long serialVersionUID = 8828360661798978952L;

            @Override
            public void actionPerformed(ActionEvent arg0) {
                String error = ImportSubscriptionEditorGui.this.storeSubcriptions();
                if (error != null) {
                    ErrorMessagesDialog.creatAndShow(error, ImportSubscriptionEditorGui.this.subscriptionTable);
                    return;
                }
                ImportSubscriptionEditorGui.this.doClosing();
            }
        });
        JButton parcelSaveButton = new JButton(new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessages(CollectionUtil.buildArrayList("messages.default.save", "messages.default.and", "messages.default.close"), new String[0])){
            private static final long serialVersionUID = 7997838507322056329L;

            @Override
            public void actionPerformed(ActionEvent arg0) {
                String error = null;
                try {
                    error = ImportSubscriptionEditorGui.this.storeParcels();
                }
                catch (UnsupportedEncodingException e) {
                    error = e.getLocalizedMessage();
                }
                if (error != null) {
                    ErrorMessagesDialog.creatAndShow(error, ImportSubscriptionEditorGui.this.addressTable);
                    return;
                }
                ImportSubscriptionEditorGui.this.tabbedPane.removeTabAt(0);
                ImportSubscriptionEditorGui.this.clearAddress();
            }
        });
        this.addressTableModel = new AbstractImportEditorPane.EditableCellTableModel((Object[][])null, (Object[])this.createParcelColumnHeader()){
            private static final long serialVersionUID = 4291773693703644117L;

            @Override
            protected int[] getEditableColumns() {
                return new int[]{1, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20};
            }
        };
        this.addressTable = new JTable(this.addressTableModel);
        this.setParcelTableStyle(this.addressTable);
        this.addressTable.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.addressTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int selectedRow = ImportSubscriptionEditorGui.this.addressTable.getSelectedRow();
                if (selectedRow > -1) {
                    Tupel selected = (Tupel)ImportSubscriptionEditorGui.this.subscriptionTable.getValueAt(selectedRow, 0);
                    ImportSubscriptionEditorGui.this.selectedLocation = (LogisticQualifiedLocationDto)selected.getElement2();
                    ImportSubscriptionEditorGui.this.fillAddress();
                }
            }
        });
        JPanel parcelPanel = new JPanel(new BorderLayout());
        parcelPanel.add((Component)new JScrollPane(this.addressTable), "Center");
        JPanel parcelButtonPanel = new JPanel();
        parcelButtonPanel.add(parcelSaveButton);
        parcelButtonPanel.add(new JButton(new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("buttons.cancel", new Serializable[0])){
            private static final long serialVersionUID = 4879922383719130422L;

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ImportSubscriptionEditorGui.this.doClosing();
            }
        }));
        parcelPanel.add((Component)parcelButtonPanel, "South");
        this.tabbedPane.addTab("Geb\u00e4ude-Liste", parcelPanel);
        this.subscriptionTableModel = new AbstractImportEditorPane.EditableCellTableModel(this, null, this.createSubscriptionColumnHeader());
        this.subscriptionTable = new JTable(this.subscriptionTableModel){
            private static final long serialVersionUID = -1137983188375789962L;

            @Override
            public Class<?> getColumnClass(int column) {
                switch (column) {
                    case 0: {
                        return Integer.class;
                    }
                    case 10: 
                    case 11: 
                    case 12: {
                        return Boolean.class;
                    }
                }
                return super.getColumnClass(column);
            }
        };
        this.subscriptionTable.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                int firstRow = e.getFirstRow();
                if (e.getType() == 0 && firstRow == e.getLastRow()) {
                    int row = firstRow;
                    int col = e.getColumn();
                    Boolean value = null;
                    int oCol1 = -1;
                    int oCol2 = -1;
                    switch (col) {
                        case 10: {
                            oCol1 = 11;
                            oCol2 = 12;
                            break;
                        }
                        case 11: {
                            oCol1 = 10;
                            oCol2 = 12;
                            break;
                        }
                        case 12: {
                            oCol1 = 10;
                            oCol2 = 11;
                        }
                    }
                    if (oCol1 >= 0 && oCol2 >= 0) {
                        value = (Boolean)ImportSubscriptionEditorGui.this.subscriptionTable.getValueAt(row, col);
                        if (value == null) {
                            value = false;
                        }
                        if (value != null && value.booleanValue()) {
                            ImportSubscriptionEditorGui.this.subscriptionTable.setValueAt(false, row, oCol1);
                            ImportSubscriptionEditorGui.this.subscriptionTable.setValueAt(false, row, oCol2);
                        }
                    }
                }
            }
        });
        this.setSubscriptionTableStyle(this.subscriptionTable);
        this.subscriptionTable.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.subscriptionTable.getSelectionModel().setSelectionMode(0);
        this.subscriptionTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int selectedRow = ImportSubscriptionEditorGui.this.subscriptionTable.getSelectedRow();
                if (selectedRow > -1) {
                    Tupel selected = (Tupel)ImportSubscriptionEditorGui.this.subscriptionTable.getValueAt(selectedRow, 0);
                    ImportSubscriptionEditorGui.this.selectedLocation = (LogisticQualifiedLocationDto)selected.getElement2();
                    ImportSubscriptionEditorGui.this.fillAddress();
                    int selectedCol = ImportSubscriptionEditorGui.this.subscriptionTable.getSelectedColumn();
                    if (selectedCol == 12) {
                        ImportSubscriptionEditorGui.this.updateImportLocationStatus(selectedRow, (LogisticQualifiedLocationDto)selected.getElement2());
                    } else if (selectedCol == 10) {
                        ImportSubscriptionEditorGui.this.updateImportLocationlProcess(selectedRow, (LogisticQualifiedLocationDto)selected.getElement2());
                    } else if (selectedCol == 11) {
                        ImportSubscriptionEditorGui.this.updateLocationDelete(selectedRow);
                    }
                }
                ImportSubscriptionEditorGui.this.subscriptionTable.clearSelection();
            }
        });
        this.subscriptionTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int selectedRow = ImportSubscriptionEditorGui.this.subscriptionTable.getSelectedRow();
                if (selectedRow > -1) {
                    Tupel selected = (Tupel)ImportSubscriptionEditorGui.this.subscriptionTable.getValueAt(selectedRow, 0);
                    ImportSubscriptionEditorGui.this.selectedLocation = (LogisticQualifiedLocationDto)selected.getElement2();
                    ImportSubscriptionEditorGui.this.fillAddress();
                }
            }
        });
        JPanel subscriptionPanel = new JPanel(new BorderLayout());
        subscriptionPanel.add((Component)new JScrollPane(this.subscriptionTable), "Center");
        JPanel subscriptionButtonPanel = new JPanel(new BorderLayout());
        JPanel subscriptionButtonPaneLeft = new JPanel(new FlowLayout());
        subscriptionButtonPaneLeft.add(this.createPasteCoordinateButton());
        subscriptionButtonPanel.add((Component)subscriptionButtonPaneLeft, "West");
        JPanel subscriptionButtonPaneRight = new JPanel(new FlowLayout());
        subscriptionButtonPaneRight.add(subscriptionSaveButton);
        subscriptionButtonPaneRight.add(new JButton(new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("buttons.cancel", new Serializable[0])){
            private static final long serialVersionUID = 4879922383719130422L;

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ImportSubscriptionEditorGui.this.doClosing();
            }
        }));
        subscriptionButtonPanel.add((Component)subscriptionButtonPaneRight, "East");
        subscriptionPanel.add((Component)subscriptionButtonPanel, "South");
        this.tabbedPane.addTab("Abonnenten-Liste", subscriptionPanel);
        this.tabbedPane.setMinimumSize(new Dimension(700, 500));
        return this.tabbedPane;
    }

    private void updateLocationDelete(int row) {
        Object o = this.subscriptionTable.getValueAt(row, 11);
        if (!((Boolean)o).booleanValue()) {
            this.subscriptionTable.setValueAt(Boolean.TRUE, row, 11);
        } else {
            this.subscriptionTable.setValueAt(Boolean.FALSE, row, 11);
        }
        this.subscriptionTable.repaint(10L);
    }

    private void updateImportLocationlProcess(int row, LogisticQualifiedLocationDto locationDto) {
        Tupel<Collection<SubscriptionModel>, Collection<ImportedLocationModel>> tupel = this.subscriptionMap.get(locationDto);
        SubscriptionImportStatus subscriptionImportStatus = null;
        ImportedLocationProcess process = null;
        ImportedLocationStatus status = null;
        Object o = this.subscriptionTable.getValueAt(row, 10);
        if (!((Boolean)o).booleanValue()) {
            process = ImportedLocationProcess.INPROGRESS;
            this.subscriptionTable.setValueAt(Boolean.TRUE, row, 10);
            status = ImportedLocationStatus.NOTCHECKED;
            subscriptionImportStatus = SubscriptionImportStatus.NOTCHECKED;
        } else {
            process = ImportedLocationProcess.OPEN;
            this.subscriptionTable.setValueAt(Boolean.FALSE, row, 10);
        }
        for (ImportedLocationModel il : tupel.getElement2()) {
            if (process != null) {
                il.setProcess(process);
            }
            if (status == null) continue;
            il.setStatus(status);
        }
        for (SubscriptionModel sub : tupel.getElement1()) {
            if (subscriptionImportStatus == null) continue;
            sub.setImportStatus(subscriptionImportStatus);
        }
        this.subscriptionTable.repaint(10L);
    }

    private void updateImportLocationStatus(int row, LogisticQualifiedLocationDto locationDto) {
        Tupel<Collection<SubscriptionModel>, Collection<ImportedLocationModel>> tupel = this.subscriptionMap.get(locationDto);
        SubscriptionImportStatus subscriptionImportStatus = null;
        ImportedLocationProcess process = null;
        ImportedLocationStatus status = null;
        Object o = this.subscriptionTable.getValueAt(row, 12);
        if (!GeoUtil.isNullPoint((ImmutablePoint)locationDto.getGeom().getGeoObject())) {
            if (((Boolean)o).booleanValue()) {
                status = ImportedLocationStatus.NOTCHECKED;
                this.subscriptionTable.setValueAt(Boolean.FALSE, row, 12);
                subscriptionImportStatus = SubscriptionImportStatus.NOTCHECKED;
            } else {
                status = ImportedLocationStatus.CHECKED;
                this.subscriptionTable.setValueAt(Boolean.TRUE, row, 12);
                process = ImportedLocationProcess.OPEN;
                subscriptionImportStatus = SubscriptionImportStatus.CHECKED;
            }
        } else {
            status = ImportedLocationStatus.NOTCHANGED;
            this.subscriptionTable.setValueAt(Boolean.FALSE, row, 12);
            subscriptionImportStatus = SubscriptionImportStatus.NOMATCHING;
            JOptionPane.showMessageDialog(this, "Das Abonnement hat noch keine Koordinate.", "", 2);
        }
        for (ImportedLocationModel il : tupel.getElement2()) {
            if (process != null) {
                il.setProcess(process);
            }
            if (status == null) continue;
            il.setStatus(status);
        }
        for (SubscriptionModel sub : tupel.getElement1()) {
            if (subscriptionImportStatus == null) continue;
            sub.setImportStatus(subscriptionImportStatus);
        }
        this.subscriptionTable.repaint(10L);
    }

    protected void fillAddress() {
        this.clearAddress();
        LogisticQualifiedLocationDto location = this.selectedLocation;
        this.country.setText(FormUtil.getStringDisplay(location.getCountry() == null ? "" : location.getCountry().getIso3166_2()));
        this.city.setText(FormUtil.getStringDisplay(location.getCity()));
        this.postcode.setText(FormUtil.getStringDisplay(location.getPostcode()));
        this.street.setText(FormUtil.getStringDisplay(location.getStreet()));
        this.housenumber.setText(FormUtil.getStringDisplay(String.valueOf(location.getHousenumber())));
        this.housenumberExtension.setText(FormUtil.getStringDisplay(location.getExtension()));
        if (location.getGeom() != null) {
            this.coordinateEditorMapPane.setCoordinate(((ImmutablePoint)location.getGeom().getGeoObject()).getCoordinate(), true);
            this.coordinateEditorMapPane.gotoCoordinate();
            Coordinate c = this.coordinateEditorMapPane.getCoordinateOnMap();
            this.coordinateX.setValue(c.getX());
            this.coordinateY.setValue(c.getY());
        } else {
            this.coordinateEditorMapPane.setCoordinate(null, true);
        }
        this.coordinateEditorMapPane.getNavigatorPanel().repaint(10L);
    }

    @Override
    protected void store() {
        UndoManager undoManager = this.getModelEnviroment().getUndoManager();
        undoManager.startTransaction();
        if (this.selectedLocation != null && this.coordinate != null) {
            LogisticQualifiedLocationDto location = this.selectedLocation;
            if (this.addressModifiable) {
                location.setCountry(this.country.getText());
                location.setCity(this.city.getText());
                location.setPostcode(this.postcode.getText());
                location.setStreet(this.street.getText());
                location.setHousenumber(this.housenumber.getText());
                location.setExtension(this.housenumberExtension.getText());
            }
            Double matchingValue = null;
            try {
                matchingValue = Double.parseDouble(this.matching.getText());
            }
            catch (Exception exception) {
                // empty catch block
            }
            ImmutablePoint point = ImmutableGeoObjectFactory.createImmutablePoint(this.coordinate);
            if (!GeoUtil.isNullPoint(point)) {
                Double currentX = (Double)this.coordinateX.getValue();
                Double currentY = (Double)this.coordinateY.getValue();
                if (currentX == null || !currentX.equals(this.coordinate.getX()) || currentY == null || !currentY.equals(this.coordinate.getY())) {
                    JOptionPane.showMessageDialog(this.getParent(), "Bitte die richtige Koordinate \u00fcbernehmen");
                } else {
                    location.setGeom(ImmutablePointDto.create(point));
                    location.setMatching(matchingValue);
                }
            }
        }
        this.fillAddressTable();
        this.fillSubscriptionTable();
        this.addressTable.repaint(10L);
        this.subscriptionTable.repaint(20L);
        this.tabbedPane.repaint(30L);
    }

    private void fillAddressTable() {
        this.addressTableModel.setDataVector(this.createAddressDataVector(this.subscriptionMap.keySet()), this.createParcelColumnHeader());
        this.addressTableModel.fireTableDataChanged();
        this.setParcelTableStyle(this.addressTable);
    }

    private String[][] createAddressDataVector(Set<LogisticQualifiedLocationDto> addressSet) {
        String[][] dataVector = new String[addressSet.size()][8];
        int row = 0;
        for (LogisticQualifiedLocationDto dto : addressSet) {
            dataVector[row] = this.createAddressRowData(dto, row);
            ++row;
        }
        return dataVector;
    }

    private String[] createAddressRowData(LogisticQualifiedLocationDto dto, int row) {
        String[] rowData = new String[8];
        if (dto == null) {
            return rowData;
        }
        rowData[0] = String.valueOf(row + 1);
        rowData[1] = dto.getCountry() == null ? "" : dto.getCountry().getIso3166_2();
        rowData[2] = dto.getCity();
        rowData[3] = dto.getPostcode();
        rowData[4] = dto.getStreet();
        rowData[5] = dto.getHousenumber();
        rowData[6] = dto.getExtension();
        rowData[7] = String.valueOf(dto.getMatching() == null ? 0.0 : dto.getMatching());
        return rowData;
    }

    private void setParcelTableStyle(JTable parcelTable) {
        parcelTable.getColumnModel().getColumn(0).setPreferredWidth(20);
        parcelTable.getColumnModel().getColumn(1).setPreferredWidth(50);
        parcelTable.getColumnModel().getColumn(2).setPreferredWidth(100);
        parcelTable.getColumnModel().getColumn(3).setPreferredWidth(50);
        parcelTable.getColumnModel().getColumn(4).setPreferredWidth(100);
        parcelTable.getColumnModel().getColumn(5).setPreferredWidth(50);
        parcelTable.getColumnModel().getColumn(6).setPreferredWidth(50);
        parcelTable.getColumnModel().getColumn(7).setPreferredWidth(100);
        MultiLineHeaderRenderer headerHenderer = new MultiLineHeaderRenderer();
        Enumeration<TableColumn> enumeration = parcelTable.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = enumeration.nextElement();
            tableColumn.setHeaderRenderer(headerHenderer);
            tableColumn.setCellRenderer(new ImportLocationTableCellRenderer<Object>(null){

                @Override
                protected boolean isSelected(int row, int column) {
                    return false;
                }
            });
        }
        parcelTable.setCellSelectionEnabled(false);
        parcelTable.setRowHeight(40);
        parcelTable.setRowMargin(5);
    }

    private String[] createParcelColumnHeader() {
        String[] columnHeader = new String[]{" \n#\n \n", this.getFormatedString(ModelEnviroment.getMessageResolver().resolveMessage("address.country", new Serializable[0])), this.getFormatedString(ModelEnviroment.getMessageResolver().resolveMessage("address.city", new Serializable[0])), this.getFormatedString(ModelEnviroment.getMessageResolver().resolveMessage("address.postcode", new Serializable[0])), this.getFormatedString(ModelEnviroment.getMessageResolver().resolveMessage("address.street", new Serializable[0])), this.getFormatedString(ModelEnviroment.getMessageResolver().resolveMessage("address.housenumber", new Serializable[0])), this.getFormatedString(ModelEnviroment.getMessageResolver().resolveMessage("address.housenumberExt", new Serializable[0])), this.getFormatedString(ModelEnviroment.getMessageResolver().resolveMessage("address.matching", new Serializable[0]))};
        return columnHeader;
    }

    private void fillSubscriptionTable() {
        this.subscriptionTableModel.setDataVector(this.createSubscriptionDataVector(this.subscriptionMap.keySet()), this.createSubscriptionColumnHeader());
        this.subscriptionTableModel.fireTableDataChanged();
        this.setSubscriptionTableStyle(this.subscriptionTable);
        this.addTabelCellComponents();
    }

    private void addTabelCellComponents() {
        UserCaller userCaller = this.getModelEnviroment().getAllCaller().getUserCaller();
        List<UserModel> allUsers = userCaller.getAllUsers();
        UserComboxCellEditor userEditor = new UserComboxCellEditor(this.subscriptionTable){

            @Override
            protected void afterChange(int row, UserModel user) {
                Tupel tupel = (Tupel)ImportSubscriptionEditorGui.this.subscriptionTable.getValueAt(row, 0);
                Collection ils = (Collection)((Tupel)ImportSubscriptionEditorGui.this.subscriptionMap.get(tupel.getElement2())).getElement2();
                for (ImportedLocationModel ip : ils) {
                    UserModel editorUser;
                    UserModel userModel = editorUser = ip == null ? null : ip.getEditorUser();
                    if (ip == null || editorUser != null && editorUser.equals(user)) continue;
                    ip.setEditorUser(user);
                }
                ImportSubscriptionEditorGui.this.subscriptionTable.repaint(10L);
            }
        };
        for (int row = 0; row < this.subscriptionTable.getRowCount(); ++row) {
            userEditor.setEditorAt(row, allUsers);
        }
        this.subscriptionTable.getColumnModel().getColumn(8).setCellEditor(userEditor);
    }

    private Object[][] createSubscriptionDataVector(Set<LogisticQualifiedLocationDto> set) {
        Object[][] dataVector = new Object[set.size()][13];
        int row = 0;
        for (LogisticQualifiedLocationDto dto : set) {
            dataVector[row] = this.createSubscriptionRowData(dto, row);
            ++row;
        }
        return dataVector;
    }

    /*
     * WARNING - void declaration
     */
    private Object[] createSubscriptionRowData(LogisticQualifiedLocationDto dto, int row) {
        void var14_19;
        Object[] rowData = new Object[13];
        if (dto == null) {
            return rowData;
        }
        rowData[0] = new Tupel<Integer, LogisticQualifiedLocationDto>(row + 1, dto);
        Tupel<Collection<SubscriptionModel>, Collection<ImportedLocationModel>> tupel = this.subscriptionMap.get(dto);
        String number = "";
        String name = "";
        String lastName = "";
        String firstName = "";
        String areaName = "";
        String layerName = "";
        for (SubscriptionModel subscription : tupel.getElement1()) {
            AreaLayerModel areaLayer;
            AreaObjectModel areaObjectModel;
            CustomerModel customer = subscription.getCustomer();
            number = number + subscription.getSubscriptionNumber() + " / ";
            if (customer != null) {
                name = name + customer.getName() + " / ";
                lastName = lastName + customer.getLastName() + " / ";
                firstName = firstName + customer.getFirstName() + " / ";
            }
            if ((areaObjectModel = subscription.getAreaObject()) != null) {
                areaName = areaName + areaObjectModel.getShortcut() + " / ";
            }
            if ((areaLayer = subscription.getAreaLayer()) == null) continue;
            layerName = layerName + areaLayer.getDisplayname() + " / ";
        }
        rowData[1] = StringUtil.isBlank(number) ? number : number.substring(0, number.lastIndexOf("/") - 1);
        rowData[2] = StringUtil.isBlank(name) ? name : name.substring(0, name.lastIndexOf("/") - 1);
        rowData[3] = StringUtil.isBlank(lastName) ? lastName : lastName.substring(0, lastName.lastIndexOf("/") - 1);
        rowData[4] = StringUtil.isBlank(firstName) ? firstName : firstName.substring(0, firstName.lastIndexOf("/") - 1);
        rowData[5] = StringUtil.isBlank(areaName) ? areaName : areaName.substring(0, areaName.lastIndexOf("/") - 1);
        rowData[6] = StringUtil.isBlank(layerName) ? layerName : layerName.substring(0, layerName.lastIndexOf("/") - 1);
        rowData[7] = dto.getMatching();
        UserModel editorUser = null;
        String info = null;
        for (ImportedLocationModel importedLocationModel : tupel.getElement2()) {
            if (importedLocationModel.getEditorUser() != null) {
                editorUser = importedLocationModel.getEditorUser();
            }
            if (importedLocationModel.getInformation() == null) continue;
            info = importedLocationModel.getInformation();
        }
        rowData[8] = editorUser == null ? "" : editorUser.getName();
        rowData[9] = info;
        ImportedLocationProcess process = ImportedLocationProcess.OPEN;
        for (ImportedLocationModel il : tupel.getElement2()) {
            if (il.getProcess() == null) continue;
            process = il.getProcess();
        }
        SubscriptionImportStatus subscriptionImportStatus = SubscriptionImportStatus.NOMATCHING;
        for (SubscriptionModel sub : tupel.getElement1()) {
            if (sub.getStatus() == null) continue;
            SubscriptionImportStatus subscriptionImportStatus2 = sub.getImportStatus();
        }
        rowData[10] = process == ImportedLocationProcess.INPROGRESS;
        rowData[11] = false;
        rowData[12] = var14_19 == SubscriptionImportStatus.CHECKED || var14_19 == SubscriptionImportStatus.CHANGED;
        return rowData;
    }

    private void setSubscriptionTableStyle(JTable subscriptionTable) {
        subscriptionTable.getColumnModel().getColumn(0).setPreferredWidth(20);
        subscriptionTable.getColumnModel().getColumn(1).setPreferredWidth(100);
        subscriptionTable.getColumnModel().getColumn(2).setPreferredWidth(100);
        subscriptionTable.getColumnModel().getColumn(3).setPreferredWidth(100);
        subscriptionTable.getColumnModel().getColumn(4).setPreferredWidth(200);
        subscriptionTable.getColumnModel().getColumn(5).setPreferredWidth(100);
        subscriptionTable.getColumnModel().getColumn(6).setPreferredWidth(100);
        subscriptionTable.getColumnModel().getColumn(7).setPreferredWidth(70);
        subscriptionTable.getColumnModel().getColumn(8).setPreferredWidth(50);
        subscriptionTable.getColumnModel().getColumn(9).setPreferredWidth(100);
        subscriptionTable.getColumnModel().getColumn(10).setPreferredWidth(30);
        subscriptionTable.getColumnModel().getColumn(11).setPreferredWidth(30);
        subscriptionTable.getColumnModel().getColumn(12).setPreferredWidth(30);
        MultiLineHeaderRenderer headerHenderer = new MultiLineHeaderRenderer();
        Enumeration<TableColumn> enumeration = subscriptionTable.getColumnModel().getColumns();
        int columnIndex = 0;
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = enumeration.nextElement();
            tableColumn.setHeaderRenderer(headerHenderer);
            if (columnIndex < 10) {
                tableColumn.setCellRenderer(new ImportSubscriptionTableCellRenderer(this.subscriptionMap){

                    @Override
                    protected boolean isSelected(int row, int column) {
                        Tupel valueAt;
                        return row > -1 && (valueAt = (Tupel)ImportSubscriptionEditorGui.this.subscriptionTable.getValueAt(row, 0)) != null && ((LogisticQualifiedLocationDto)valueAt.getElement2()).equals(ImportSubscriptionEditorGui.this.selectedLocation);
                    }
                });
            }
            ++columnIndex;
        }
        subscriptionTable.setCellSelectionEnabled(false);
        subscriptionTable.setRowHeight(40);
        subscriptionTable.setRowMargin(5);
        JTableHeader th = this.subscriptionTable.getTableHeader();
        th.setLayout(new TableHeaderWithComponentLayout());
        for (int i = 0; i < 11; ++i) {
            th.add((Component)new JLabel(""), (Object)i);
        }
        JCheckBox deleteAll = new JCheckBox(new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.all", new Serializable[0])){
            private static final long serialVersionUID = -342150695528817526L;

            @Override
            public void actionPerformed(ActionEvent e) {
                JCheckBox source = (JCheckBox)e.getSource();
                for (int row = 0; row < ImportSubscriptionEditorGui.this.subscriptionTableModel.getRowCount(); ++row) {
                    ImportSubscriptionEditorGui.this.subscriptionTableModel.setValueAt(source.isSelected(), row, 11);
                }
                ImportSubscriptionEditorGui.this.subscriptionTable.repaint(10L);
            }
        });
        deleteAll.setFont(UIManager.getDefaults().getFont("TextField.font"));
        th.add((Component)deleteAll, (Object)11);
    }

    private String[] createSubscriptionColumnHeader() {
        String[] columnHeader = new String[13];
        columnHeader[0] = " \n#\n \n";
        MessageResolver messageResolver = ModelEnviroment.getMessageResolver();
        columnHeader[1] = this.getFormatedString(messageResolver.resolveMessage("messages.subscription.subscriptionNumber", new Serializable[0]));
        columnHeader[2] = this.getFormatedString(messageResolver.resolveMessage("messages.customer.customers", new Serializable[0]));
        columnHeader[3] = this.getFormatedString(messageResolver.resolveMessage("messages.customer.lastName", new Serializable[0]));
        columnHeader[4] = this.getFormatedString(messageResolver.resolveMessage("messages.customer.firstName", new Serializable[0]));
        columnHeader[5] = this.getFormatedString(messageResolver.resolveMessage("gui.area.areaObject", new Serializable[0]));
        columnHeader[6] = this.getFormatedString(messageResolver.resolveMessage("gui.area.areaLayer", new Serializable[0]));
        columnHeader[7] = this.getFormatedString(messageResolver.resolveMessage("address.matching", new Serializable[0]));
        columnHeader[8] = " \n" + messageResolver.resolveMessage("messages.default.editor", new Serializable[0]);
        columnHeader[9] = " \n" + messageResolver.resolveMessage("messages.default.information", new Serializable[0]);
        columnHeader[10] = " \n" + messageResolver.resolveMessage("messages.default.inprogress", new Serializable[0]);
        columnHeader[11] = " \n" + messageResolver.resolveMessage("messages.default.delete", new Serializable[0]);
        columnHeader[12] = " \n" + messageResolver.resolveMessage("messages.default.take", new Serializable[0]);
        return columnHeader;
    }

    private Double getBestMatching(SubscriptionModel subscriptionModel) {
        Double bestMatching = null;
        for (LogisticQualifiedLocationDto qualifiedLocation : this.subscriptionMap.keySet()) {
            Collection<SubscriptionModel> subscriptions = this.subscriptionMap.get(qualifiedLocation).getElement1();
            if (!subscriptions.contains(subscriptionModel)) continue;
            bestMatching = qualifiedLocation.getMatching();
        }
        return bestMatching == null ? 0.0 : bestMatching;
    }

    private void doClosing() {
        UndoManager undoManager = this.getModelEnviroment().getUndoManager();
        undoManager.rollbackTransaction();
        Window window = SwingUtils.findWindowParent(this);
        if (window != null) {
            window.dispose();
        } else {
            this.setVisible(false);
        }
        super.getModelEnviroment().close();
    }

    public void showDialog(String titel, Component parent) {
        JDialog dialog = new JDialog(SwingUtils.findWindowParent(parent));
        try {
            dialog.setIconImage(ImageIO.read(ImportSubscriptionEditorGui.class.getResourceAsStream("/images/pepper.png")));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        dialog.setPreferredSize(new Dimension(1600, 850));
        dialog.setDefaultCloseOperation(0);
        dialog.setTitle(titel);
        dialog.getContentPane().add(this);
        dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ImportSubscriptionEditorGui.this.doClosing();
            }
        });
        dialog.pack();
        SwingUtils.centerDialog(dialog, parent);
        dialog.setVisible(true);
    }

    @Override
    protected void sortAndFilter() {
    }

    @Override
    protected void doAfterFindingCoordinate(ImmutablePoint point) {
    }
}

