/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.importer.stop;

import de.datomino.logistic.dto.LogisticLocationDto;
import de.datomino.logistic.dto.LogisticQualifiedLocationDto;
import de.datomino.peppergis.client.communication.UserCaller;
import de.datomino.peppergis.client.gui.ErrorMessagesDialog;
import de.datomino.peppergis.client.gui.login.UserComboxCellEditor;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.gui.renderer.MultiLineHeaderRenderer;
import de.datomino.peppergis.client.model.UndoManager;
import de.datomino.peppergis.client.model.admin.UserModel;
import de.datomino.peppergis.client.model.base.ImportedLocationModel;
import de.datomino.peppergis.client.model.tour.StopModel;
import de.datomino.peppergis.client.model.tour.TimeWindowModel;
import de.datomino.peppergis.client.util.ClientFormUtil;
import de.datomino.peppergis.client.util.LocationModelUtil;
import de.datomino.peppergis.client.util.StopModelUtil;
import de.datomino.peppergis.exception.ValidateException;
import de.datomino.peppergis.importer.AbstractImportEditorPane;
import de.datomino.peppergis.importer.subscription.ImportLocationTableCellRenderer;
import de.datomino.peppergis.type.ImportedLocationProcess;
import de.datomino.peppergis.type.ImportedLocationStatus;
import de.datomino.peppergis.util.FormUtil;
import de.datomino.peppergis.util.GeoUtil;
import de.datomino.util.collection.CollectionUtil;
import de.datomino.util.geo.ImmutableGeoObjectFactory;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.geo.dto.ImmutablePointDto;
import de.datomino.util.international.country.CountryUtil;
import de.datomino.util.message.MessageResolver;
import de.datomino.util.swing.ExceptionMessageDialog;
import de.datomino.util.swing.SwingUtils;
import de.datomino.util.swing.TableHeaderWithComponentLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.RowSorter;
import javax.swing.UIManager;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import javax.swing.table.TableStringConverter;
import org.ktde.math.projection.Coordinate;
import org.ktde.util.datatypes.Tupel;

public class ImportStopEditorGui
extends AbstractImportEditorPane {
    private static final long serialVersionUID = -4902573735741910897L;
    private static final int COLOFDATE = 9;
    private static final int COLOFMATCHING = 10;
    private static final int COLOFEDITOR = 11;
    private static final int COLOFINFO = 12;
    private static final int COLOFPROCESS = 13;
    private static final int COLOFDELETE = 14;
    private static final int COLOFSTATUS = 15;
    private static final int SIZEOFSTOPCOLS = 16;
    private DefaultTableModel stopTableModel;
    private JTable stopTable;
    private LogisticQualifiedLocationDto selectedLocation;
    private LinkedHashMap<LogisticQualifiedLocationDto, Tupel<Collection<StopModel>, Collection<ImportedLocationModel>>> stopMap;

    public ImportStopEditorGui(ModelEnviroment modelEnviroment, Properties properties, Collection<StopModel> stops) {
        super(modelEnviroment, properties, "importstop.editor.address.modifiable");
        this.sizeOfFilters = 12;
        this.filters = new JComboBox[this.sizeOfFilters];
        this.matching = new JTextField();
        this.stopMap = new LinkedHashMap();
        long id = 0L;
        for (StopModel stop : stops) {
            Tupel<Collection<StopModel>, Collection<ImportedLocationModel>> tupel;
            if (stop == null || stop.getLocation() == null || stop.getLocation().getImportedLocation() == null) continue;
            ImportedLocationModel importedLocation = stop.getLocation().getImportedLocation();
            String countryString = importedLocation.getCountry() == null ? null : importedLocation.getCountry().getVehicleSign();
            String housenumberString = importedLocation.getHousenumber() == null ? null : String.valueOf(importedLocation.getHousenumber());
            ImmutablePointDto geom = ImmutablePointDto.create(importedLocation.getGeoLocation());
            LogisticQualifiedLocationDto qualifiedLocationDto = new LogisticQualifiedLocationDto(id++, geom, geom, CountryUtil.searchCountryFuzzy(countryString), importedLocation.getPostcode(), importedLocation.getCity(), importedLocation.getDistrict(), importedLocation.getStreet(), housenumberString, importedLocation.getHousenumberExtension(), null);
            for (LogisticQualifiedLocationDto key : this.stopMap.keySet()) {
                if (!qualifiedLocationDto.isSameAddress(key)) continue;
                qualifiedLocationDto = key;
                break;
            }
            if ((tupel = this.stopMap.get(qualifiedLocationDto)) == null) {
                tupel = new Tupel(new HashSet(), new HashSet());
                this.stopMap.put(qualifiedLocationDto, tupel);
            }
            tupel.getElement1().add(stop);
            tupel.getElement2().add(importedLocation);
        }
        this.fillStopTable(true);
    }

    @Override
    protected JComponent createTopPanel(JPanel undoManagerPane) {
        UndoManager undoManager = this.getModelEnviroment().getUndoManager();
        undoManager.joinTransaction();
        undoManager.startTransaction();
        JButton stopSaveButton = new JButton(new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.save", new Serializable[0])){
            private static final long serialVersionUID = 7997838507322056329L;

            @Override
            public void actionPerformed(ActionEvent arg0) {
                String error = ImportStopEditorGui.this.storeStops();
                if (error != null) {
                    ErrorMessagesDialog.creatAndShow(error, ImportStopEditorGui.this.stopTable);
                    return;
                }
            }
        });
        JButton stopSaveCloseButton = new JButton(new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessages(CollectionUtil.buildArrayList("messages.default.save", "messages.default.and", "messages.default.close"), new String[0])){
            private static final long serialVersionUID = 7997838507322056329L;

            @Override
            public void actionPerformed(ActionEvent arg0) {
                String error = ImportStopEditorGui.this.storeStops();
                if (error != null) {
                    ErrorMessagesDialog.creatAndShow(error, ImportStopEditorGui.this.stopTable);
                    return;
                }
                ImportStopEditorGui.this.doClosing();
            }
        });
        this.stopTableModel = new AbstractImportEditorPane.EditableCellTableModel((Object[][])null, (Object[])this.createStopColumnHeader()){
            private static final long serialVersionUID = -7150235426679594196L;

            @Override
            protected int[] getEditableColumns() {
                return new int[]{1, 11, 12, 14, 15, 16, 17, 18, 19, 20};
            }
        };
        this.stopTable = new JTable(this.stopTableModel){
            private static final long serialVersionUID = -2499573455000248830L;

            @Override
            public Class<?> getColumnClass(int column) {
                switch (column) {
                    case 0: {
                        return Integer.class;
                    }
                    case 1: {
                        return StopName.class;
                    }
                    case 13: 
                    case 14: 
                    case 15: {
                        return Boolean.class;
                    }
                }
                return super.getColumnClass(column);
            }
        };
        this.stopTable.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                int firstRow = e.getFirstRow();
                if (e.getType() == 0 && firstRow == e.getLastRow()) {
                    int row = firstRow;
                    int col = e.getColumn();
                    Boolean value = null;
                    int oCol1 = -1;
                    int oCol2 = -1;
                    switch (col) {
                        case 13: {
                            oCol1 = 14;
                            oCol2 = 15;
                            break;
                        }
                        case 14: {
                            oCol1 = 13;
                            oCol2 = 15;
                            break;
                        }
                        case 15: {
                            oCol1 = 13;
                            oCol2 = 14;
                        }
                    }
                    if (oCol1 >= 0 && oCol2 >= 0) {
                        value = (Boolean)ImportStopEditorGui.this.stopTable.getValueAt(row, col);
                        if (value == null) {
                            value = false;
                        }
                        if (value != null && value.booleanValue()) {
                            ImportStopEditorGui.this.stopTable.setValueAt(false, row, oCol1);
                            ImportStopEditorGui.this.stopTable.setValueAt(false, row, oCol2);
                        }
                    }
                }
            }
        });
        this.stopTable.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.stopTable.getSelectionModel().setSelectionMode(0);
        this.stopTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int selectedRow = ImportStopEditorGui.this.stopTable.getSelectedRow();
                if (selectedRow > -1) {
                    Tupel selected = (Tupel)ImportStopEditorGui.this.stopTable.getValueAt(selectedRow, 0);
                    ImportStopEditorGui.this.selectedLocation = (LogisticQualifiedLocationDto)selected.getElement2();
                    ImportStopEditorGui.this.fillAddress();
                    int selectedCol = ImportStopEditorGui.this.stopTable.getSelectedColumn();
                    if (selectedCol == 15) {
                        ImportStopEditorGui.this.updateImportLocationStatus(selectedRow, (LogisticQualifiedLocationDto)selected.getElement2());
                    } else if (selectedCol == 13) {
                        ImportStopEditorGui.this.updateImportLocationlProcess(selectedRow, (LogisticQualifiedLocationDto)selected.getElement2());
                    } else if (selectedCol == 14) {
                        ImportStopEditorGui.this.updateLocationDelete(selectedRow);
                    }
                }
                ImportStopEditorGui.this.stopTable.clearSelection();
            }
        });
        JPanel stopPanel = new JPanel(new BorderLayout());
        stopPanel.add((Component)new JScrollPane(this.stopTable), "Center");
        JPanel stopButtonPanel = new JPanel(new BorderLayout());
        JPanel stopButtonPaneLeft = new JPanel(new FlowLayout());
        stopButtonPaneLeft.add(this.createPasteCoordinateButton());
        stopButtonPanel.add((Component)stopButtonPaneLeft, "West");
        JPanel stopButtonPaneRight = new JPanel(new FlowLayout());
        stopButtonPaneRight.add(stopSaveButton);
        stopButtonPaneRight.add(stopSaveCloseButton);
        stopButtonPaneRight.add(new JButton(new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("buttons.cancel", new Serializable[0])){
            private static final long serialVersionUID = 4879922383719130422L;

            @Override
            public void actionPerformed(ActionEvent arg0) {
                UndoManager undoManager = ImportStopEditorGui.this.getModelEnviroment().getUndoManager();
                undoManager.rollbackTransaction();
                ImportStopEditorGui.this.doClosing();
            }
        }));
        stopButtonPanel.add((Component)stopButtonPaneRight, "East");
        stopPanel.add((Component)stopButtonPanel, "South");
        return stopPanel;
    }

    private void updateLocationDelete(int row) {
        Object o = this.stopTable.getValueAt(row, 14);
        if (!((Boolean)o).booleanValue()) {
            this.stopTable.setValueAt(Boolean.TRUE, row, 14);
        } else {
            this.stopTable.setValueAt(Boolean.FALSE, row, 14);
        }
        this.stopTable.repaint(10L);
    }

    private void updateImportLocationlProcess(int row, LogisticQualifiedLocationDto locationDto) {
        Tupel<Collection<StopModel>, Collection<ImportedLocationModel>> tupel = this.stopMap.get(locationDto);
        ImportedLocationProcess process = null;
        ImportedLocationStatus status = null;
        Object o = this.stopTable.getValueAt(row, 13);
        if (!((Boolean)o).booleanValue()) {
            process = ImportedLocationProcess.INPROGRESS;
            this.stopTable.setValueAt(Boolean.TRUE, row, 13);
            status = ImportedLocationStatus.NOTCHECKED;
        } else {
            process = ImportedLocationProcess.OPEN;
            this.stopTable.setValueAt(Boolean.FALSE, row, 13);
        }
        for (ImportedLocationModel il : tupel.getElement2()) {
            if (process != null) {
                il.setProcess(process);
            }
            if (status == null) continue;
            il.setStatus(status);
        }
        this.stopTable.repaint(10L);
    }

    private void updateImportLocationStatus(int row, LogisticQualifiedLocationDto locationDto) {
        Tupel<Collection<StopModel>, Collection<ImportedLocationModel>> tupel = this.stopMap.get(locationDto);
        ImportedLocationProcess process = null;
        ImportedLocationStatus status = null;
        Object o = this.stopTable.getValueAt(row, 15);
        if (!GeoUtil.isNullPoint((ImmutablePoint)locationDto.getGeom().getGeoObject())) {
            if (((Boolean)o).booleanValue()) {
                status = ImportedLocationStatus.NOTCHECKED;
                this.stopTable.setValueAt(Boolean.FALSE, row, 15);
            } else {
                status = ImportedLocationStatus.CHECKED;
                this.stopTable.setValueAt(Boolean.TRUE, row, 15);
                process = ImportedLocationProcess.OPEN;
            }
        } else {
            status = ImportedLocationStatus.NOTCHANGED;
            this.stopTable.setValueAt(Boolean.FALSE, row, 15);
            JOptionPane.showMessageDialog(this, "Die Abladestelle hat noch keine Koordinate.", "", 2);
        }
        for (ImportedLocationModel il : tupel.getElement2()) {
            if (process != null) {
                il.setProcess(process);
            }
            if (status == null) continue;
            il.setStatus(status);
        }
        this.stopTable.repaint(10L);
    }

    private void doClosing() {
        UndoManager undoManager = this.getModelEnviroment().getUndoManager();
        undoManager.rollbackTransaction();
        Window window = SwingUtils.findWindowParent(this);
        if (window != null) {
            window.dispose();
        } else {
            this.setVisible(false);
        }
        this.getModelEnviroment().close();
    }

    private boolean hasPendingChanges() {
        for (LogisticQualifiedLocationDto qualifiedLocation : this.stopMap.keySet()) {
            if (qualifiedLocation.getMatching() == null || !qualifiedLocation.getMatching().equals(100.0)) continue;
            ImportedLocationModel importedLocation = this.stopMap.get(qualifiedLocation).getElement2().iterator().next();
            if (this.addressModifiable && LocationModelUtil.changedAddress(importedLocation, (LogisticLocationDto<Long>)qualifiedLocation)) {
                return true;
            }
            ImmutablePointDto geom = qualifiedLocation.getGeom();
            if (geom == null || GeoUtil.isNullPoint((ImmutablePoint)geom.getGeoObject()) || GeoUtil.areSamedPoints((ImmutablePoint)geom.getGeoObject(), importedLocation.getGeoLocation(), (Double)1.0)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String storeStops() {
        if (!this.deleteStops()) {
            return "Die ausgew\u00e4hlten Abladestellen k\u00f6nnen nicht gel\u00f6scht werden";
        }
        for (LogisticQualifiedLocationDto qualifiedLocation : this.stopMap.keySet()) {
            Object valueInfo = null;
            for (int row = 0; row < this.stopTable.getRowCount(); ++row) {
                LogisticQualifiedLocationDto dto = (LogisticQualifiedLocationDto)((Tupel)this.stopTable.getValueAt(row, 0)).getElement2();
                if (!dto.equals(qualifiedLocation)) continue;
                valueInfo = this.stopTable.getValueAt(row, 12);
            }
            for (ImportedLocationModel importedLocation : this.stopMap.get(qualifiedLocation).getElement2()) {
                String newInfo;
                String oldInfo;
                if (qualifiedLocation.getMatching() != null && qualifiedLocation.getMatching().equals(100.0)) {
                    ImmutablePointDto geom;
                    if (this.addressModifiable && LocationModelUtil.changedAddress(importedLocation, (LogisticLocationDto<Long>)qualifiedLocation)) {
                        importedLocation.setCountry(qualifiedLocation.getCountry());
                        importedLocation.setCity(qualifiedLocation.getCity());
                        importedLocation.setPostcode(qualifiedLocation.getPostcode());
                        importedLocation.setStreet(qualifiedLocation.getStreet());
                        importedLocation.setHousenumber(Integer.valueOf(qualifiedLocation.getHousenumber()));
                        importedLocation.setHousenumberExtension(qualifiedLocation.getExtension());
                    }
                    if ((geom = qualifiedLocation.getGeom()) != null && !GeoUtil.isNullPoint((ImmutablePoint)geom.getGeoObject()) && !GeoUtil.areSamedPoints((ImmutablePoint)geom.getGeoObject(), importedLocation.getGeoLocation(), (Double)0.0)) {
                        importedLocation.setGeoLocation((ImmutablePoint)geom.getGeoObject());
                        if (importedLocation.getStatus() == null || importedLocation.getStatus() == ImportedLocationStatus.NOTCHANGED) {
                            importedLocation.setStatus(ImportedLocationStatus.NOTCHECKED);
                        }
                    }
                }
                if ((oldInfo = importedLocation.getInformation() == null ? "" : importedLocation.getInformation().trim()).equals(newInfo = valueInfo == null ? "" : valueInfo.toString().trim())) continue;
                importedLocation.setInformation(newInfo);
            }
        }
        UndoManager undoManager = this.getModelEnviroment().getUndoManager();
        UserModel loginUser = ModelEnviroment.getUserInformation().getUserModel();
        Collection<ImportedLocationModel> changedImportedLocations = undoManager.getChangedObjects(ImportedLocationModel.class);
        for (ImportedLocationModel il : changedImportedLocations) {
            il.setLoginUser(loginUser);
        }
        undoManager.finishTransaction("check stops");
        String error = null;
        try {
            undoManager.storeTransactions();
        }
        catch (ValidateException e) {
            undoManager.rollbackTransaction();
            error = e.getMessage();
        }
        finally {
            undoManager.joinTransaction();
            undoManager.startTransaction();
        }
        return error;
    }

    private boolean deleteStops() {
        LinkedList forDelete = new LinkedList();
        for (int row = 0; row < this.stopTableModel.getRowCount(); ++row) {
            Boolean delete = (Boolean)this.stopTableModel.getValueAt(row, 14);
            if (delete == null || !delete.booleanValue()) continue;
            Tupel tupel = (Tupel)this.stopTable.getValueAt(row, 0);
            forDelete.add(new Tupel(row, tupel.getElement2()));
        }
        if (forDelete.size() == 0) {
            return true;
        }
        Collections.reverse(forDelete);
        int d = JOptionPane.showConfirmDialog(this, "Alle markierten Abladestellen werden gel\u00f6scht. Wollen Sie es fortsetzen?", ModelEnviroment.getMessageResolver().resolveMessage("messages.default.confirm", new Serializable[0]), 0);
        switch (d) {
            case 0: {
                UndoManager undoManager = this.getModelEnviroment().getUndoManager();
                undoManager.joinTransaction();
                undoManager.startTransaction();
                for (Tupel tupel : forDelete) {
                    Tupel<Collection<StopModel>, Collection<ImportedLocationModel>> tupel2 = this.stopMap.get(tupel.getElement2());
                    try {
                        for (StopModel stop : tupel2.getElement1()) {
                            StopModelUtil.deleteStop(stop, this.getModelEnviroment());
                        }
                        this.stopTableModel.removeRow((Integer)tupel.getElement1());
                        this.stopMap.remove(tupel);
                    }
                    catch (Exception e) {
                        BufferedImage image;
                        try {
                            image = ImageIO.read(ImportStopEditorGui.class.getResourceAsStream("/images/pepper.png"));
                        }
                        catch (IOException ioEx) {
                            throw new RuntimeException(ioEx);
                        }
                        ExceptionMessageDialog exceptionMessageDialog = new ExceptionMessageDialog(SwingUtils.findWindowParent(this), e, image);
                        exceptionMessageDialog.setVisible(true);
                        return false;
                    }
                }
                return true;
            }
        }
        return false;
    }

    @Override
    protected void store() {
        UndoManager undoManager = this.getModelEnviroment().getUndoManager();
        undoManager.startTransaction();
        if (this.selectedLocation != null && this.coordinate != null) {
            LogisticQualifiedLocationDto location = this.selectedLocation;
            if (this.addressModifiable) {
                location.setCountry(this.country.getText());
                location.setCity(this.city.getText());
                location.setPostcode(this.postcode.getText());
                location.setStreet(this.street.getText());
                location.setHousenumber(this.housenumber.getText());
                location.setExtension(this.housenumberExtension.getText());
            }
            Double matchingValue = null;
            try {
                matchingValue = Double.parseDouble(this.matching.getText());
            }
            catch (Exception exception) {
                // empty catch block
            }
            ImmutablePoint point = ImmutableGeoObjectFactory.createImmutablePoint(this.coordinate);
            if (!GeoUtil.isNullPoint(point)) {
                Double currentX = (Double)this.coordinateX.getValue();
                Double currentY = (Double)this.coordinateY.getValue();
                if (currentX == null || !currentX.equals(this.coordinate.getX()) || currentY == null || !currentY.equals(this.coordinate.getY())) {
                    JOptionPane.showMessageDialog(this.getParent(), "Bitte die richtige Koordinate \u00fcbernehmen");
                } else {
                    location.setGeom(ImmutablePointDto.create(point));
                    location.setMatching(matchingValue);
                }
            }
        }
        this.fillStopTable(false);
        this.stopTable.repaint(10L);
    }

    protected void fillAddress() {
        this.clearAddress();
        try {
            LogisticQualifiedLocationDto location = this.selectedLocation;
            String countryString = location.getCountry() == null ? "" : location.getCountry().getIso3166_2();
            this.country.setText(FormUtil.getStringDisplay(countryString));
            this.city.setText(FormUtil.getStringDisplay(location.getCity()));
            this.postcode.setText(FormUtil.getStringDisplay(location.getPostcode()));
            this.street.setText(FormUtil.getStringDisplay(location.getStreet()));
            this.district.setText(FormUtil.getStringDisplay(location.getDistrict()));
            this.housenumber.setText(FormUtil.getStringDisplay(location.getHousenumber()));
            this.housenumberExtension.setText(FormUtil.getStringDisplay(location.getExtension()));
            this.matching1.setText(ClientFormUtil.getNumberString(location.getMatching()));
            this.coordinateEditorMapPane.setCoordinate(((ImmutablePoint)location.getGeom().getGeoObject()).getCoordinate(), true);
            this.coordinateEditorMapPane.gotoCoordinate();
            Coordinate c = this.coordinateEditorMapPane.getCoordinateOnMap();
            this.coordinateX.setValue(c.getX());
            this.coordinateY.setValue(c.getY());
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.coordinateEditorMapPane.getNavigatorPanel().repaint(10L);
    }

    @Override
    protected Set<Integer> getExcludedFilterColumns() {
        return Collections.singleton(1);
    }

    private void fillStopTable(boolean initFilters) {
        Object[][] dataVector = this.createStopDataVector();
        this.filters[10] = this.createFilterComoBox(dataVector, 10);
        this.fillFilters(dataVector, initFilters);
        this.stopTableModel.setDataVector(dataVector, this.createStopColumnHeader());
        this.stopTableModel.fireTableDataChanged();
        this.stopTable.setRowSorter((RowSorter<? extends TableModel>)new TableRowSorter<TableModel>((TableModel)this.stopTableModel){

            @Override
            public Comparator<?> getComparator(int column) {
                if (column == 0) {
                    return new Comparator<String>(){

                        @Override
                        public int compare(String o1, String o2) {
                            return Integer.parseInt(o1) - Integer.parseInt(o2);
                        }
                    };
                }
                return super.getComparator(column);
            }
        });
        ((TableRowSorter)this.stopTable.getRowSorter()).setStringConverter(new TableStringConverter(){

            @Override
            public String toString(TableModel model, int row, int column) {
                String string;
                Object value = model.getValueAt(row, column);
                String string2 = string = value == null ? "" : value.toString();
                if (column == 0) {
                    Tupel tupel = (Tupel)value;
                    string = String.valueOf(tupel.getElement1());
                }
                return string;
            }
        });
        this.setStopTableStyle(this.stopTable);
        this.addTabelCellComponents();
    }

    private void addTabelCellComponents() {
        UserCaller userCaller = this.getModelEnviroment().getAllCaller().getUserCaller();
        List<UserModel> allUsers = userCaller.getAllUsers();
        UserComboxCellEditor userEditor = new UserComboxCellEditor(this.stopTable){

            @Override
            protected void afterChange(int row, UserModel user) {
                Tupel tupel = (Tupel)ImportStopEditorGui.this.stopTable.getValueAt(row, 0);
                Collection ils = (Collection)((Tupel)ImportStopEditorGui.this.stopMap.get(tupel.getElement2())).getElement2();
                for (ImportedLocationModel ip : ils) {
                    UserModel editorUser;
                    UserModel userModel = editorUser = ip == null ? null : ip.getEditorUser();
                    if (ip == null || editorUser != null && editorUser.equals(user)) continue;
                    ip.setEditorUser(user);
                }
                String newItem = user.getName();
                boolean found = false;
                int index = 0;
                ComboBoxModel comboBoxModel = ImportStopEditorGui.this.filters[11].getModel();
                for (int i = 0; i < comboBoxModel.getSize(); ++i) {
                    Object item = comboBoxModel.getElementAt(i);
                    int compare = FILTER_COMPARATOR.compare(item, newItem);
                    if (compare < 0) {
                        ++index;
                    }
                    if (item == null || !item.equals(newItem)) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    ImportStopEditorGui.this.filters[11].insertItemAt(newItem, index);
                }
                ImportStopEditorGui.this.stopTable.setValueAt(newItem, row, 11);
                ImportStopEditorGui.this.stopTable.repaint(10L);
            }
        };
        for (int row = 0; row < this.stopTable.getRowCount(); ++row) {
            userEditor.setEditorAt(row, allUsers);
        }
        this.stopTable.getColumnModel().getColumn(11).setCellEditor(userEditor);
    }

    private Object[][] createStopDataVector() {
        LinkedList<LogisticQualifiedLocationDto> filtered = new LinkedList<LogisticQualifiedLocationDto>();
        for (LogisticQualifiedLocationDto l : this.stopMap.keySet()) {
            if (!this.inFilters(l)) continue;
            filtered.add(l);
        }
        Object[][] dataVector = new Object[filtered.size()][16];
        int row = 0;
        for (LogisticQualifiedLocationDto l : filtered) {
            dataVector[row] = this.createStopRowData(l, row);
            ++row;
        }
        return dataVector;
    }

    private Object[] createStopRowData(LogisticQualifiedLocationDto locationDto, int row) {
        Object[] rowData = new Object[16];
        try {
            Tupel<Collection<StopModel>, Collection<ImportedLocationModel>> tupel = this.stopMap.get(locationDto);
            rowData[0] = new Tupel<String, LogisticQualifiedLocationDto>(String.valueOf(row + 1), locationDto);
            Collection<StopModel> stops = tupel.getElement1();
            String dateString = this.getDateValue(stops);
            rowData[1] = new StopName(stops);
            rowData[2] = locationDto.getCountry() == null ? "" : locationDto.getCountry().getIso3166_2();
            rowData[3] = locationDto.getPostcode();
            rowData[4] = locationDto.getCity();
            rowData[5] = locationDto.getDistrict();
            rowData[6] = locationDto.getStreet();
            rowData[7] = locationDto.getHousenumber();
            rowData[8] = locationDto.getExtension();
            rowData[9] = dateString;
            rowData[10] = locationDto.getMatching();
            UserModel editorUser = null;
            String info = null;
            for (ImportedLocationModel il : tupel.getElement2()) {
                if (il.getEditorUser() != null) {
                    editorUser = il.getEditorUser();
                }
                if (il.getInformation() == null) continue;
                info = il.getInformation();
            }
            rowData[11] = editorUser == null ? "" : editorUser.getName();
            rowData[12] = info;
            ImportedLocationProcess process = ImportedLocationProcess.OPEN;
            ImportedLocationStatus status = ImportedLocationStatus.NOTCHANGED;
            for (ImportedLocationModel il : tupel.getElement2()) {
                if (il.getProcess() != null) {
                    process = il.getProcess();
                }
                if (il.getStatus() == null) continue;
                status = il.getStatus();
            }
            rowData[13] = process == ImportedLocationProcess.INPROGRESS;
            rowData[14] = false;
            rowData[15] = status == ImportedLocationStatus.CHECKED || status == ImportedLocationStatus.CHANGED;
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return rowData;
    }

    private String getDateValue(Collection<StopModel> stops) {
        Date minDate = null;
        Date timeWindowMinDate = null;
        for (StopModel stop : stops) {
            Date date = stop.getEstimatedTimeOfArrival();
            if (date != null && (minDate == null || date.compareTo(minDate) < 0)) {
                minDate = date;
            }
            for (TimeWindowModel timeWindowModel : stop.iterableTimeWindows()) {
                date = timeWindowModel.getStartTime();
                if (date == null || timeWindowMinDate != null && date.compareTo(timeWindowMinDate) >= 0) continue;
                timeWindowMinDate = date;
            }
        }
        if (minDate == null) {
            minDate = timeWindowMinDate;
        }
        return minDate == null ? "" : new SimpleDateFormat(FormUtil.DATEFORMAT).format(minDate);
    }

    private void setStopTableStyle(JTable stopTable) {
        stopTable.setCellSelectionEnabled(false);
        stopTable.setRowHeight(40);
        stopTable.setRowMargin(5);
        stopTable.getColumnModel().getColumn(0).setPreferredWidth(20);
        stopTable.getColumnModel().getColumn(1).setPreferredWidth(50);
        stopTable.getColumnModel().getColumn(2).setPreferredWidth(15);
        stopTable.getColumnModel().getColumn(3).setPreferredWidth(50);
        stopTable.getColumnModel().getColumn(4).setPreferredWidth(100);
        stopTable.getColumnModel().getColumn(5).setPreferredWidth(100);
        stopTable.getColumnModel().getColumn(6).setPreferredWidth(200);
        stopTable.getColumnModel().getColumn(7).setPreferredWidth(50);
        stopTable.getColumnModel().getColumn(8).setPreferredWidth(50);
        stopTable.getColumnModel().getColumn(9).setPreferredWidth(100);
        stopTable.getColumnModel().getColumn(10).setPreferredWidth(70);
        stopTable.getColumnModel().getColumn(11).setPreferredWidth(50);
        stopTable.getColumnModel().getColumn(12).setPreferredWidth(100);
        stopTable.getColumnModel().getColumn(13).setPreferredWidth(30);
        stopTable.getColumnModel().getColumn(14).setPreferredWidth(30);
        stopTable.getColumnModel().getColumn(15).setPreferredWidth(30);
        MultiLineHeaderRenderer headerHenderer = new MultiLineHeaderRenderer();
        Enumeration<TableColumn> enumeration = stopTable.getColumnModel().getColumns();
        int columnIndex = 0;
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = enumeration.nextElement();
            tableColumn.setHeaderRenderer(headerHenderer);
            if (columnIndex < 13) {
                tableColumn.setCellRenderer(new ImportLocationTableCellRenderer<StopModel>(this.stopMap){

                    @Override
                    protected boolean isSelected(int row, int column) {
                        Tupel valueAt;
                        return row > -1 && (valueAt = (Tupel)ImportStopEditorGui.this.stopTable.getValueAt(row, 0)) != null && ((LogisticQualifiedLocationDto)valueAt.getElement2()).equals(ImportStopEditorGui.this.selectedLocation);
                    }

                    @Override
                    protected Component getComponent(JTable table, Object value) {
                        if (value instanceof StopName) {
                            StopName stopName = (StopName)value;
                            return stopName.getComboBox();
                        }
                        return super.getComponent(table, value);
                    }
                });
            }
            ++columnIndex;
        }
        this.stopTable.setDefaultEditor(StopName.class, new TableCellEditor(){

            @Override
            public boolean stopCellEditing() {
                return true;
            }

            @Override
            public boolean shouldSelectCell(EventObject anEvent) {
                return false;
            }

            @Override
            public void removeCellEditorListener(CellEditorListener l) {
            }

            @Override
            public boolean isCellEditable(EventObject anEvent) {
                return true;
            }

            @Override
            public Object getCellEditorValue() {
                return null;
            }

            @Override
            public void cancelCellEditing() {
            }

            @Override
            public void addCellEditorListener(CellEditorListener l) {
            }

            @Override
            public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                StopName stopName = (StopName)value;
                return stopName.getComboBox();
            }
        });
        JTableHeader th = this.stopTable.getTableHeader();
        th.setLayout(new TableHeaderWithComponentLayout());
        th.add((Component)new JButton(new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("buttons.clear", new Serializable[0])){
            private static final long serialVersionUID = -6258824252005279477L;

            @Override
            public void actionPerformed(ActionEvent arg0) {
                for (int i = 0; i < ImportStopEditorGui.this.filters.length; ++i) {
                    JComboBox comboBox = ImportStopEditorGui.this.filters[i];
                    if (comboBox == null) continue;
                    comboBox.setSelectedIndex(0);
                }
                ImportStopEditorGui.this.sortAndFilter();
            }
        }), (Object)0);
        for (int i = 1; i < this.sizeOfFilters; ++i) {
            JComboBox comp = this.filters[i];
            if (comp == null) continue;
            th.add((Component)comp, (Object)i);
        }
        th.add((Component)new JLabel(""), (Object)12);
        th.add((Component)new JLabel(""), (Object)13);
        JCheckBox deleteAll = new JCheckBox(new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.all", new Serializable[0])){
            private static final long serialVersionUID = -342150695528817526L;

            @Override
            public void actionPerformed(ActionEvent e) {
                JCheckBox source = (JCheckBox)e.getSource();
                for (int row = 0; row < ImportStopEditorGui.this.stopTableModel.getRowCount(); ++row) {
                    ImportStopEditorGui.this.stopTableModel.setValueAt(source.isSelected(), row, 14);
                }
                ImportStopEditorGui.this.stopTable.repaint(10L);
            }
        });
        deleteAll.setFont(UIManager.getDefaults().getFont("TextField.font"));
        th.add((Component)deleteAll, (Object)14);
    }

    private String[] createStopColumnHeader() {
        String[] columnHeader = new String[16];
        columnHeader[0] = " \n#\n \n \n";
        MessageResolver messageResolver = ModelEnviroment.getMessageResolver();
        columnHeader[1] = this.getFormatedString(messageResolver.resolveMessage("gui.stop.stops", new Serializable[0]));
        columnHeader[2] = this.getFormatedString(messageResolver.resolveMessage("address.country", new Serializable[0]));
        columnHeader[3] = this.getFormatedString(messageResolver.resolveMessage("address.postcode", new Serializable[0]));
        columnHeader[4] = this.getFormatedString(messageResolver.resolveMessage("address.city", new Serializable[0]));
        columnHeader[5] = this.getFormatedString(messageResolver.resolveMessage("address.district", new Serializable[0]));
        columnHeader[6] = this.getFormatedString(messageResolver.resolveMessage("address.street", new Serializable[0]));
        columnHeader[7] = this.getFormatedString(messageResolver.resolveMessage("address.housenumber", new Serializable[0]));
        columnHeader[8] = this.getFormatedString(messageResolver.resolveMessage("address.housenumberExt", new Serializable[0]));
        columnHeader[9] = this.getFormatedString(messageResolver.resolveMessage("gui.date.date", new Serializable[0]));
        columnHeader[10] = this.getFormatedString(messageResolver.resolveMessage("address.matching", new Serializable[0]));
        columnHeader[11] = " \n" + messageResolver.resolveMessage("messages.default.editor", new Serializable[0]);
        columnHeader[12] = " \n" + messageResolver.resolveMessage("messages.default.information", new Serializable[0]);
        columnHeader[13] = " \n" + messageResolver.resolveMessage("messages.default.inprogress", new Serializable[0]);
        columnHeader[14] = " \n" + messageResolver.resolveMessage("messages.default.delete", new Serializable[0]);
        columnHeader[15] = " \n" + messageResolver.resolveMessage("messages.default.take", new Serializable[0]);
        return columnHeader;
    }

    @Override
    protected void sortAndFilter() {
        this.stopTable.removeAll();
        this.fillStopTable(false);
        this.stopTable.repaint(10L);
    }

    private boolean inFilters(LogisticQualifiedLocationDto importedLocation) {
        for (int column = 1; column < this.sizeOfFilters; ++column) {
            String o;
            JComboBox jComboBox = this.filters[column];
            if (jComboBox == null || jComboBox.getSelectedItem() == null) continue;
            Object s = jComboBox.getSelectedItem();
            Object[] os = this.createStopRowData(importedLocation, 0);
            String string = o = os[column] == null ? "" : os[column];
            if (!(o instanceof Collection ? !((Collection)((Object)o)).contains(s) : !o.equals(s))) continue;
            return false;
        }
        return true;
    }

    public void showDialog(String titel, final Component parent) {
        JDialog dialog = new JDialog(SwingUtils.findWindowParent(parent));
        try {
            dialog.setIconImage(ImageIO.read(ImportStopEditorGui.class.getResourceAsStream("/images/pepper.png")));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        dialog.setPreferredSize(new Dimension(1860, 850));
        dialog.setDefaultCloseOperation(0);
        dialog.setTitle(titel);
        dialog.getContentPane().add(this);
        dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                UndoManager undoManager = ImportStopEditorGui.this.getModelEnviroment().getUndoManager();
                if (ImportStopEditorGui.this.hasPendingChanges()) {
                    int d = JOptionPane.showConfirmDialog(parent, ModelEnviroment.getMessageResolver().resolveMessage("gui.stop.saveBeforeClose", new Serializable[0]), ModelEnviroment.getMessageResolver().resolveMessage("messages.default.question", new Serializable[0]), 1, 3);
                    switch (d) {
                        case 0: {
                            String error = ImportStopEditorGui.this.storeStops();
                            if (error != null) {
                                ErrorMessagesDialog.creatAndShow(error, ImportStopEditorGui.this.stopTable);
                                return;
                            }
                            ImportStopEditorGui.this.doClosing();
                            break;
                        }
                        case 1: {
                            undoManager.rollbackTransaction();
                            ImportStopEditorGui.this.doClosing();
                            break;
                        }
                        case 2: {
                            return;
                        }
                    }
                } else {
                    undoManager.rollbackTransaction();
                    ImportStopEditorGui.this.doClosing();
                }
            }
        });
        dialog.pack();
        SwingUtils.centerDialog(dialog, parent);
        dialog.setVisible(true);
    }

    @Override
    protected void doAfterFindingCoordinate(ImmutablePoint point) {
    }

    static class StopName {
        private List<StopModel> stops;
        private JComboBox<StopModel> comboBox;

        public StopName(Collection<StopModel> stops) {
            this.stops = new ArrayList<StopModel>(stops);
            Collections.sort(this.stops, new Comparator<StopModel>(){

                @Override
                public int compare(StopModel o1, StopModel o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            });
            this.comboBox = new JComboBox<StopModel>(new Vector<StopModel>(this.getStops()));
            final ListCellRenderer<StopModel> renderer = this.comboBox.getRenderer();
            this.comboBox.setRenderer(new ListCellRenderer<StopModel>(){

                @Override
                public Component getListCellRendererComponent(JList<? extends StopModel> list, StopModel value, int index, boolean isSelected, boolean cellHasFocus) {
                    return renderer.getListCellRendererComponent(list, value.getName(), index, isSelected, cellHasFocus);
                }
            });
        }

        public List<StopModel> getStops() {
            return this.stops;
        }

        public JComboBox<StopModel> getComboBox() {
            return this.comboBox;
        }
    }
}

