/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.importer.poi;

import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.importer.AbstractAddressCsvImporter;
import de.datomino.peppergis.client.message.EnumMessageResolverNameGenerator;
import de.datomino.peppergis.client.model.area.AreaLayerModel;
import de.datomino.peppergis.client.util.ClientSwingUtil;
import de.datomino.peppergis.dto.area.AreaLayerDto;
import de.datomino.peppergis.dto.importer.GenericCsvDto;
import de.datomino.peppergis.dto.importer.PoiCsvImportDto;
import de.datomino.peppergis.dto.importer.PoiImportResultDto;
import de.datomino.peppergis.type.AreaObjectGenInfoDiscriminator;
import de.datomino.peppergis.type.PoiType;
import de.datomino.util.assistant.editor.Worker;
import de.datomino.util.assistant.model.ChoiceField;
import de.datomino.util.assistant.model.CsvColumnChoiceField;
import de.datomino.util.assistant.model.Fieldset;
import java.awt.Window;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.ktde.math.projection.CoordinateFactory;
import org.ktde.util.NameGenerator;
import org.ktde.util.StringUtil;
import org.ktde.util.datatypes.Tupel;

public class PoiImporter
extends AbstractAddressCsvImporter<PoiCsvImportDto> {
    private ModelEnviroment modelEnviroment;
    private CsvColumnChoiceField deleteField;
    private ChoiceField<CoordinateFactory.Projections> coordinateFactoryField;
    private ChoiceField<AreaLayerModel> layerField;
    private ChoiceField<PoiType> poiField;

    public PoiImporter() {
        LinkedList<PoiType> poiTypes = new LinkedList<PoiType>(Arrays.asList(PoiType.values()));
        poiTypes.remove((Object)PoiType.END_POINT);
        poiTypes.remove((Object)PoiType.ORIGIN);
        poiTypes.remove((Object)PoiType.REMOVED);
        poiTypes.remove((Object)PoiType.LAYOVER);
        PoiType[] poiTypeArray = new PoiType[poiTypes.size()];
        poiTypeArray = poiTypes.toArray(poiTypeArray);
        this.modelEnviroment = new ModelEnviroment(null);
        Collection<AreaLayerModel> areaLayers = new ModelEnviroment(null).getAllCaller().getAreaCaller().getAreaLayersForType(AreaObjectGenInfoDiscriminator.values());
        this.layerField = new ChoiceField<1>(ModelEnviroment.getMessageResolver().resolveMessage("messages.import.area.layer", new Serializable[0]), (Collection<1>)areaLayers, new NameGenerator<AreaLayerModel>(){

            @Override
            public String getName(AreaLayerModel t) {
                return t == null ? ModelEnviroment.getMessageResolver().resolveMessage("messages.default.pleaseChoose", new Serializable[0]) : t.getDisplayname();
            }
        });
        this.deleteField = new CsvColumnChoiceField(ModelEnviroment.getMessageResolver().resolveMessageForEnum(PoiCsvImportDto.Columns.DELETE), (Serializable)((Object)PoiCsvImportDto.Columns.DELETE), this.createRegex("L\u00f6schen", "zu l\u00f6schen", "entfernen", "del", "delete"), true);
        Collection<CoordinateFactory.Projections> projections = CoordinateFactory.getListableProjections();
        CoordinateFactory.Projections[] values = new CoordinateFactory.Projections[projections.size()];
        values = projections.toArray(values);
        this.coordinateFactoryField = new ChoiceField<CoordinateFactory.Projections>(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.coordinateFactory", new Serializable[0]), values, new EnumMessageResolverNameGenerator(""), CoordinateFactory.Projections.Wgs84);
        this.poiField = new ChoiceField<PoiType>(ModelEnviroment.getMessageResolver().resolveMessage(PoiType.class.getName(), new Serializable[0]), poiTypeArray, new EnumMessageResolverNameGenerator(""), PoiType.AREAOBJECT_LOCATION);
    }

    @Override
    public Worker getWorker(final Window parent) {
        return new Worker(){
            private Worker.State state;
            private PoiImportResultDto poiImportResultDto;

            @Override
            public void process() {
                PoiCsvImportDto poiCsvImportDto = new PoiCsvImportDto();
                PoiImporter.this.writeToDto(poiCsvImportDto);
                this.poiImportResultDto = PoiImporter.this.modelEnviroment.getAllCaller().getImportCaller().importPois(poiCsvImportDto);
                this.state = this.poiImportResultDto.isError() ? Worker.State.ERROR : Worker.State.OK;
                ClientSwingUtil.saveContentToFile(this.poiImportResultDto.getContent(), parent);
            }

            @Override
            public String getResultString() {
                StringBuilder sb = new StringBuilder();
                if (this.poiImportResultDto.isError()) {
                    sb.append(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.error", new Serializable[0])).append(":\n\n");
                    sb.append(ModelEnviroment.getMessageResolver().resolveMessages(this.poiImportResultDto.getErrorMessages(), "\n", 10)).append("\n\n");
                }
                sb.append(this.makeCountBlock(this.poiImportResultDto.getNewPoiNumbers(), "messages.import.pois.newPois")).append("\n\n");
                sb.append(this.makeCountBlock(this.poiImportResultDto.getUpdatedPoiNumbers(), "messages.import.pois.updatedPois")).append("\n\n");
                sb.append(this.makeCountBlock(this.poiImportResultDto.getDeletedPoiNumbers(), "messages.import.pois.deletedPois")).append("\n\n");
                sb.append(this.makeCountBlock(this.poiImportResultDto.getRejectedPoiNumbers(), "messages.import.pois.rejectedPois")).append("\n\n");
                sb.append(this.makeCountBlock(this.poiImportResultDto.getPostWorkPoiNumbers(), "messages.import.pois.postWork"));
                return sb.toString();
            }

            private String makeCountBlock(Collection<Tupel<String, Long>> poiNumbers, String key) {
                ArrayList<String> poiNumbersList = new ArrayList<String>(poiNumbers.size());
                for (Tupel<String, Long> tupel : poiNumbers) {
                    poiNumbersList.add(tupel.getElement1());
                }
                return ModelEnviroment.getMessageResolver().resolveMessage(key, new Serializable[]{Integer.valueOf(poiNumbers.size()), StringUtil.implode(poiNumbersList, "\n")});
            }

            @Override
            public Worker.State getResultState() {
                return this.state;
            }
        };
    }

    @Override
    protected void addCsvFields(List<CsvColumnChoiceField> choiceFields) {
        choiceFields.add(new CsvColumnChoiceField(this.getMessageForEnum(PoiCsvImportDto.Columns.POI_NUMBER), (Serializable)((Object)PoiCsvImportDto.Columns.POI_NUMBER), this.createRegex("nummer", "number", "Fixpunktnummer", "Fixpunkt-Nr."), true));
        choiceFields.add(new CsvColumnChoiceField(this.getMessageForEnum(PoiCsvImportDto.Columns.NAME), (Serializable)((Object)PoiCsvImportDto.Columns.NAME), this.createRegex("name"), true));
        choiceFields.add(new CsvColumnChoiceField(this.getMessageForEnum(PoiCsvImportDto.Columns.INFORMATION), (Serializable)((Object)PoiCsvImportDto.Columns.INFORMATION), this.createRegex("information", "info"), true));
        choiceFields.add(new CsvColumnChoiceField(this.getMessageForEnum(PoiCsvImportDto.Columns.IMAGE_NAME), (Serializable)((Object)PoiCsvImportDto.Columns.IMAGE_NAME), this.createRegex("icon", "Bildname", "Bild"), true));
        super.addCsvFields(choiceFields);
        choiceFields.add(new CsvColumnChoiceField(this.getMessageForEnum(GenericCsvDto.AddressColumns.X), (Serializable)((Object)GenericCsvDto.AddressColumns.X), this.createRegexForXCoordinate(), true));
        choiceFields.add(new CsvColumnChoiceField(this.getMessageForEnum(GenericCsvDto.AddressColumns.Y), (Serializable)((Object)GenericCsvDto.AddressColumns.Y), this.createRegexForYCoordinate(), true));
        choiceFields.add(this.deleteField);
        choiceFields.add(new CsvColumnChoiceField(ModelEnviroment.getMessageResolver().resolveMessage("gui.area.areaObject", new Serializable[0]), (Serializable)((Object)PoiCsvImportDto.Columns.AREAOBJECT_NAME), this.createRegex("bezirk", "gebiet", "Gebietsnummer", "Bezirks-ID"), true));
        choiceFields.add(new CsvColumnChoiceField(this.getMessageForEnum(PoiCsvImportDto.Columns.AREAOBJECT_FIRST_PICK_POINT), (Serializable)((Object)PoiCsvImportDto.Columns.AREAOBJECT_FIRST_PICK_POINT), this.createRegex("Erster Abholungspunkt"), true));
        choiceFields.add(new CsvColumnChoiceField(this.getMessageForEnum(PoiCsvImportDto.Columns.AREAOBJECT_LAST_PICK_POINT), (Serializable)((Object)PoiCsvImportDto.Columns.AREAOBJECT_LAST_PICK_POINT), this.createRegex("Letzter Abholungspunkt"), true));
    }

    protected String getMessageForEnum(Enum<?> value) {
        return ModelEnviroment.getMessageResolver().resolveMessage(value.getClass().getName().replace('$', '.') + "." + value.name(), new Serializable[0]);
    }

    @Override
    public String getTitle() {
        return ModelEnviroment.getMessageResolver().resolveMessage("messages.import.pois", new Serializable[0]);
    }

    @Override
    protected List<Fieldset> getAdditionalFieldsets() {
        Fieldset geo = new Fieldset(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.generalSettings", new Serializable[0]));
        geo.addField(this.layerField);
        geo.addField(this.poiField);
        geo.addField(this.coordinateFactoryField);
        return Collections.singletonList(geo);
    }

    @Override
    public void writeToDto(PoiCsvImportDto dto) {
        super.writeToDto(dto);
        dto.setCoordinateFactory((CoordinateFactory.Projections)((Object)this.coordinateFactoryField.getValue()));
        dto.setAreaLayer((AreaLayerDto)((Object)((AreaLayerModel)this.layerField.getValue()).createDto()));
        dto.setPoiType((PoiType)((Object)this.poiField.getValue()));
    }
}

