/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.importer.parcel;

import de.datomino.peppergis.client.gui.asynchronous.AbstractAsynchronousDialog;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.importer.AbstractCsvImporter;
import de.datomino.peppergis.client.model.area.AreaLayerModel;
import de.datomino.peppergis.dto.area.AreaLayerDto;
import de.datomino.peppergis.dto.asynchronous.AsynchronousDto;
import de.datomino.peppergis.dto.importer.GenericCsvDto;
import de.datomino.peppergis.dto.importer.ParcelAreaRelationFields;
import de.datomino.peppergis.dto.importer.ParcelAreaRelationImportResultDto;
import de.datomino.peppergis.type.AreaObjectGenInfoDiscriminator;
import de.datomino.util.assistant.editor.Worker;
import de.datomino.util.assistant.model.BooleanField;
import de.datomino.util.assistant.model.ChoiceField;
import de.datomino.util.assistant.model.CsvColumnChoiceField;
import de.datomino.util.assistant.model.Fieldset;
import de.datomino.util.common.PrimitiveUtil;
import de.datomino.util.message.Message;
import java.awt.Window;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.ktde.util.NameGenerator;
import org.ktde.util.StringUtil;
import org.ktde.util.datatypes.Tupel;

public class ParcelAreaRelationImporter
extends AbstractCsvImporter<GenericCsvDto> {
    private CsvColumnChoiceField parcelKeyField;
    private CsvColumnChoiceField areaShortcutField;
    private CsvColumnChoiceField areaNameField;
    private BooleanField clearLayerField;
    private ChoiceField<AreaLayerModel> layerField;
    private ModelEnviroment modelEnv;
    private Window parent;

    public ParcelAreaRelationImporter(Window parent) {
        this.parent = parent;
        this.modelEnv = new ModelEnviroment(null);
        this.parcelKeyField = new CsvColumnChoiceField(ModelEnviroment.getMessageResolver().resolveMessage("importer.parcel.column.ID", new Serializable[0]), (Serializable)((Object)ParcelAreaRelationFields.PARCEL_KEY), this.createRegex("key", "id", "haus-id", "geb\u00e4ude-id", "geb\u00e4ude-nr."), false);
        this.areaShortcutField = new CsvColumnChoiceField(ModelEnviroment.getMessageResolver().resolveMessage("messages.area.areaKey", new Serializable[0]), (Serializable)((Object)ParcelAreaRelationFields.AREA_SHORTCUT), this.createRegex("area", "Gebietsnummer", "Bezirksnummer", "Bezirks-ID", "Gebiets-ID"), false);
        this.areaNameField = new CsvColumnChoiceField(ModelEnviroment.getMessageResolver().resolveMessage("messages.area.displayName", new Serializable[0]), (Serializable)((Object)ParcelAreaRelationFields.AREA_NAME), this.createRegex("name", "Gebietsname", "Bezirksname"), true);
        this.clearLayerField = new BooleanField(ModelEnviroment.getMessageResolver().resolveMessage("messages.import.parcelAreaRelations.layerClear", new Serializable[0]), true, "");
        Collection<AreaLayerModel> areaLayers = this.modelEnv.getAllCaller().getAreaCaller().getAreaLayersForType(AreaObjectGenInfoDiscriminator.values());
        this.layerField = new ChoiceField<1>(ModelEnviroment.getMessageResolver().resolveMessage("messages.import.area.layer", new Serializable[0]), (Collection<1>)areaLayers, new NameGenerator<AreaLayerModel>(){

            @Override
            public String getName(AreaLayerModel t) {
                return t == null ? ModelEnviroment.getMessageResolver().resolveMessage("messages.default.pleaseChoose", new Serializable[0]) : t.getDisplayname();
            }
        });
    }

    @Override
    public Worker getWorker(Window parent) {
        return new Worker(){
            private String resultString;
            private Worker.State resultState;

            @Override
            public void process() {
                Tupel resultDto;
                ModelEnviroment modelEnviroment = new ModelEnviroment(ParcelAreaRelationImporter.this.parent);
                final GenericCsvDto dto = new GenericCsvDto();
                ParcelAreaRelationImporter.this.writeToDto(dto);
                AbstractAsynchronousDialog<ParcelAreaRelationImportResultDto> asyncDialog = new AbstractAsynchronousDialog<ParcelAreaRelationImportResultDto>(ParcelAreaRelationImporter.this.parent, ModelEnviroment.getMessageResolver().resolveMessage("messages.import.parcelAreaRelations.importing", new Serializable[0]), ModelEnviroment.getMessageResolver().resolveMessage("messages.import.parcelAreaRelations.importing", new Serializable[0]), 1, true, modelEnviroment){
                    private static final long serialVersionUID = -1393361866358292364L;

                    @Override
                    protected String startAsynchronous() {
                        return this.getModelEnviroment().getAllCaller().getAsynchronousCaller().importParcelAreaRelations(dto, ParcelAreaRelationImporter.this.isClearLayer(), ParcelAreaRelationImporter.this.getLayer());
                    }

                    @Override
                    protected AsynchronousDto<ParcelAreaRelationImportResultDto> getAsynchronousDto(String token) {
                        return this.getModelEnviroment().getAllCaller().getAsynchronousCaller().getImportParcelAreaRelationsResult(token);
                    }
                };
                try {
                    resultDto = asyncDialog.run();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                StringBuilder sb = new StringBuilder();
                ParcelAreaRelationImportResultDto parcelAreaRelationImportResultDto = (ParcelAreaRelationImportResultDto)resultDto.getElement1();
                if (parcelAreaRelationImportResultDto.isError()) {
                    for (Message message : parcelAreaRelationImportResultDto.getErrorMessages()) {
                        sb.append(ModelEnviroment.getMessageResolver().resolveMessage(message)).append("\n");
                    }
                    this.resultState = Worker.State.ERROR;
                } else {
                    ArrayList<String> parcelIds = new ArrayList<String>(parcelAreaRelationImportResultDto.getNotFoundParcels());
                    Collections.sort(parcelIds);
                    sb.append(ModelEnviroment.getMessageResolver().resolveMessage("importer.parcelarearel.resultMessage", new Serializable[]{parcelAreaRelationImportResultDto.getImportedRelationCount(), StringUtil.implode(parcelIds, "\n")}));
                    this.resultState = parcelIds.isEmpty() ? Worker.State.OK : Worker.State.WARNING;
                }
                this.resultString = sb.toString();
            }

            @Override
            public String getResultString() {
                return this.resultString;
            }

            @Override
            public Worker.State getResultState() {
                return this.resultState;
            }
        };
    }

    @Override
    protected void addCsvFields(List<CsvColumnChoiceField> choiceFields) {
        choiceFields.add(this.parcelKeyField);
        choiceFields.add(this.areaShortcutField);
        choiceFields.add(this.areaNameField);
    }

    @Override
    protected List<Fieldset> getAdditionalFieldsets() {
        Fieldset geo = new Fieldset(ModelEnviroment.getMessageResolver().resolveMessage("messages.import.parcelAreaRelations.parameters", new Serializable[0]));
        geo.addField(this.clearLayerField);
        this.refreshLayerField();
        geo.addField(this.layerField);
        return Collections.singletonList(geo);
    }

    private void refreshLayerField() {
        Collection<AreaLayerModel> areaLayers = this.modelEnv.getAllCaller().getAreaCaller().getAreaLayersForType(AreaObjectGenInfoDiscriminator.values());
        AreaLayerModel selected = (AreaLayerModel)this.layerField.getValue();
        AreaLayerModel[] areaLayerArray = new AreaLayerModel[areaLayers.size()];
        areaLayerArray = areaLayers.toArray(areaLayerArray);
        this.layerField.setChoices((AreaLayerModel[])areaLayerArray);
        this.layerField.setValue(selected);
    }

    protected boolean isClearLayer() {
        return PrimitiveUtil.nullToFalse((Boolean)this.clearLayerField.getValue());
    }

    protected AreaLayerDto getLayer() {
        AreaLayerModel value = (AreaLayerModel)this.layerField.getValue();
        AreaLayerDto layer = (AreaLayerDto)((Object)value.createDto());
        return layer;
    }

    @Override
    public String getTitle() {
        return ModelEnviroment.getMessageResolver().resolveMessage("messages.importer.parcelAreaRelation", new Serializable[0]);
    }
}

