/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.importer.parcel;

import de.datomino.logistic.dto.LogisticLocationDto;
import de.datomino.logistic.dto.LogisticQualifiedLocationDto;
import de.datomino.logistic.dto.qualifiers.LocationQualifierDescriptorDto;
import de.datomino.logistic.dto.qualifiers.NominatimLocationQualifierDescriptorDto;
import de.datomino.peppergis.client.communication.ImportCaller;
import de.datomino.peppergis.client.communication.StreetNetCaller;
import de.datomino.peppergis.client.communication.UserCaller;
import de.datomino.peppergis.client.geometric.GeoClientHelper;
import de.datomino.peppergis.client.gui.ErrorMessagesDialog;
import de.datomino.peppergis.client.gui.blocking.BusyDialogShowingBusyHandler;
import de.datomino.peppergis.client.gui.location.GeomEditorResult;
import de.datomino.peppergis.client.gui.login.UserComboxCellEditor;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.gui.parcel.DeleteParcelDialog;
import de.datomino.peppergis.client.gui.renderer.MultiLineHeaderRenderer;
import de.datomino.peppergis.client.model.ModelCache;
import de.datomino.peppergis.client.model.UndoManager;
import de.datomino.peppergis.client.model.admin.UserModel;
import de.datomino.peppergis.client.model.map.CityModel;
import de.datomino.peppergis.client.model.map.DistrictModel;
import de.datomino.peppergis.client.model.map.ParcelModel;
import de.datomino.peppergis.client.model.map.PostcodeDistrictRelationModel;
import de.datomino.peppergis.client.model.map.PostcodeModel;
import de.datomino.peppergis.client.model.map.StreetModel;
import de.datomino.peppergis.client.util.ParcelModelUtil;
import de.datomino.peppergis.exception.ValidateException;
import de.datomino.peppergis.importer.AbstractImportEditorPane;
import de.datomino.peppergis.importer.parcel.AbstractAddParcelAction;
import de.datomino.peppergis.importer.parcel.editor.ImportParcelModelTableCellRenderer;
import de.datomino.peppergis.type.ImportParcelProcess;
import de.datomino.peppergis.type.ImportParcelStatus;
import de.datomino.peppergis.util.FormUtil;
import de.datomino.peppergis.util.GeoUtil;
import de.datomino.util.collection.CollectionUtil;
import de.datomino.util.geo.ImmutableGeoObjectFactory;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.geo.dto.ImmutablePointDto;
import de.datomino.util.international.country.Country;
import de.datomino.util.international.country.CountryUtil;
import de.datomino.util.message.MessageResolver;
import de.datomino.util.message.error.ErrorMessages;
import de.datomino.util.swing.ErrorMessageDialog;
import de.datomino.util.swing.SwingUtils;
import de.datomino.util.swing.TableHeaderWithComponentLayout;
import de.datomino.util.swing.blocking.AbstractBusyHandlingAction;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import javax.swing.table.TableStringConverter;
import org.ktde.math.projection.Coordinate;
import org.ktde.math.projection.GeoDecimal100Factory;
import org.ktde.math.projection.Wgs84Factory;
import org.ktde.util.StringUtil;
import org.ktde.util.datatypes.Tupel;
import org.ktde.util.io.CsvWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportParcelEditorGui
extends AbstractImportEditorPane {
    private static final long serialVersionUID = 2843878578408481881L;
    private static final Logger LOGGER = LoggerFactory.getLogger(ImportParcelEditorGui.class);
    private static final int COLOFEDITOR = 9;
    private static final int COLOFPROCESS = 10;
    private static final int COLOFDELETE = 11;
    private static final int COLOFSTATUS = 12;
    private static final int SIZEOFPARCELCOLS = 13;
    private Map<ParcelModel, Integer> importMap;
    private ParcelModel selectedParcel;
    private DefaultTableModel parcelTableModel;
    private JTable parcelTable;
    private Long parcelId1;
    private Action moveParcelAction;
    private String preImportParcelKey;
    private GeoClientHelper geoClientHelper;

    public ImportParcelEditorGui(ModelEnviroment modelEnviroment, Properties properties, List<ParcelModel> parcelTupels) {
        super(modelEnviroment, properties, "importparcel.editor.address.modifiable");
        this.geoClientHelper = new GeoClientHelper(modelEnviroment);
        this.sizeOfFilters = 10;
        this.filters = new JComboBox[this.sizeOfFilters];
        Collections.sort(parcelTupels, new Comparator<ParcelModel>(){

            @Override
            public int compare(ParcelModel o1, ParcelModel o2) {
                String postcode1 = ParcelModelUtil.getPostcodeName(o1);
                String postcode2 = ParcelModelUtil.getPostcodeName(o2);
                if (postcode1 == null && postcode2 == null) {
                    return 0;
                }
                if (postcode1 == null) {
                    return -1;
                }
                if (postcode2 == null) {
                    return 1;
                }
                return postcode1.compareToIgnoreCase(postcode2);
            }
        });
        this.importMap = new HashMap<ParcelModel, Integer>();
        Integer index = 1;
        for (ParcelModel tupel : parcelTupels) {
            if (tupel.getImportKey() == null) {
                this.preImportParcelKey = modelEnviroment.getAllCaller().getStreetNetCaller().generateImportParcelKey(this.preImportParcelKey);
                tupel.setImportKey(this.preImportParcelKey);
                tupel.setImportProcess(ImportParcelProcess.OPEN);
                tupel.setImportStatus(ImportParcelStatus.NOTCHANGED);
                UndoManager undoManager = this.getModelEnviroment().getUndoManager();
                undoManager.finishTransaction("add import parcel");
                try {
                    undoManager.storeTransactions();
                }
                catch (ValidateException e) {
                    undoManager.handleValidateException(e);
                }
                undoManager.startTransaction();
            }
            this.importMap.put(tupel, index);
            Integer n = index;
            Integer n2 = index = Integer.valueOf(index + 1);
        }
        this.fillParcelTable(parcelTupels, true);
    }

    @Override
    protected JComponent createTopPanel(JPanel undoManagerPane) {
        UndoManager undoManager = this.getModelEnviroment().getUndoManager();
        undoManager.joinTransaction();
        undoManager.startTransaction();
        JButton parcelAddButton = new JButton(new AbstractAddParcelAction(super.getModelEnviroment(), this){
            private static final long serialVersionUID = 8231785279068904950L;

            @Override
            protected boolean update(ParcelModel parcelModel) {
                return ImportParcelEditorGui.this.addParcel(parcelModel);
            }
        });
        JButton parcelSaveButton = new JButton(new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessages(CollectionUtil.buildArrayList("messages.default.save"), new String[0])){
            private static final long serialVersionUID = 7997838507322056329L;

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ImportParcelEditorGui.this.save();
            }
        });
        this.parcelTableModel = new AbstractImportEditorPane.EditableCellTableModel((Object[][])null, (Object[])this.createParcelColumnHeader()){
            private static final long serialVersionUID = 5410964724244364357L;

            @Override
            protected int[] getEditableColumns() {
                return new int[]{1, 9, 10, 11, 12, 14, 15, 16, 17, 18, 19, 20};
            }
        };
        this.parcelTable = new JTable(this.parcelTableModel){
            private static final long serialVersionUID = -3714464246600955806L;

            @Override
            public Class<?> getColumnClass(int column) {
                switch (column) {
                    case 0: {
                        return Integer.class;
                    }
                    case 10: 
                    case 11: 
                    case 12: {
                        return Boolean.class;
                    }
                }
                return super.getColumnClass(column);
            }
        };
        this.parcelTable.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                int firstRow = e.getFirstRow();
                if (e.getType() == 0 && firstRow == e.getLastRow()) {
                    int row = firstRow;
                    int col = e.getColumn();
                    Boolean value = null;
                    int oCol1 = -1;
                    int oCol2 = -1;
                    switch (col) {
                        case 10: {
                            oCol1 = 11;
                            oCol2 = 12;
                            break;
                        }
                        case 11: {
                            oCol1 = 10;
                            oCol2 = 12;
                            break;
                        }
                        case 12: {
                            oCol1 = 10;
                            oCol2 = 11;
                        }
                    }
                    if (oCol1 >= 0 && oCol2 >= 0) {
                        value = (Boolean)ImportParcelEditorGui.this.parcelTableModel.getValueAt(row, col);
                        if (value == null) {
                            value = false;
                        }
                        if (value != null && value.booleanValue()) {
                            ImportParcelEditorGui.this.parcelTableModel.setValueAt(false, row, oCol1);
                            ImportParcelEditorGui.this.parcelTableModel.setValueAt(false, row, oCol2);
                        }
                    }
                }
            }
        });
        this.parcelTable.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.parcelTable.getSelectionModel().setSelectionMode(0);
        this.parcelTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int selectedCol = ImportParcelEditorGui.this.parcelTable.getSelectedColumn();
                int selectedRow = ImportParcelEditorGui.this.parcelTable.getSelectedRow();
                if (selectedRow > -1) {
                    ParcelModel parcel = (ParcelModel)ImportParcelEditorGui.this.parcelTable.getValueAt(selectedRow, 0);
                    ImportParcelEditorGui.this.fillAddress(parcel);
                    ImportParcelEditorGui.this.selectedParcel = parcel;
                    if (selectedCol == 12) {
                        ImportParcelEditorGui.this.updateImportParcelStatus(selectedRow, parcel);
                    } else if (selectedCol == 10) {
                        ImportParcelEditorGui.this.updateImportParcelProcess(selectedRow, parcel);
                    } else if (selectedCol == 11) {
                        ImportParcelEditorGui.this.updateImportParcelDelete(selectedRow);
                    }
                }
                ImportParcelEditorGui.this.parcelTable.clearSelection();
            }
        });
        this.parcelTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                super.mousePressed(e);
                this.popUp(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                super.mouseReleased(e);
                this.popUp(e);
            }

            private void popUp(MouseEvent e) {
                if (!e.isConsumed() && e.isPopupTrigger()) {
                    int row = ImportParcelEditorGui.this.parcelTable.rowAtPoint(e.getPoint());
                    if (row >= 0) {
                        final ParcelModel parcel = (ParcelModel)ImportParcelEditorGui.this.parcelTable.getValueAt(row, 0);
                        JPopupMenu popupMenu = new JPopupMenu();
                        popupMenu.add(new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.search.insertSearchText", new Serializable[0])){
                            private static final long serialVersionUID = 5489991291860698230L;

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                StringBuilder sb = new StringBuilder();
                                StreetModel street = parcel.getStreet();
                                PostcodeDistrictRelationModel pdr = street.getPostcodeDistrictRelation();
                                PostcodeModel postcode = pdr.getPostcode();
                                DistrictModel district = pdr.getDistrict();
                                CityModel city = district.getCity();
                                String cityName = city.getName();
                                String districtName = district.getName();
                                sb.append(postcode.getCountry().name()).append(" ").append(postcode.getName()).append(" ").append(cityName);
                                if (!cityName.equalsIgnoreCase(districtName)) {
                                    sb.append(" - ").append(districtName);
                                }
                                sb.append(", ").append(street.getName()).append(" ").append(parcel.getHouseNumber()).append(parcel.getHouseNumberExtension());
                                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(sb.toString()), null);
                            }
                        });
                        popupMenu.show(ImportParcelEditorGui.this.parcelTable, e.getX(), e.getY());
                    }
                    e.consume();
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                this.popUp(e);
            }
        });
        JPanel parcelPanel = new JPanel(new BorderLayout());
        parcelPanel.add((Component)new JScrollPane(this.parcelTable), "Center");
        JPanel parcelButtonPanel = new JPanel(new BorderLayout());
        JPanel parcelSubButtonPanel = new JPanel(new FlowLayout());
        parcelSubButtonPanel.add(parcelAddButton);
        parcelSubButtonPanel.add(new JButton(new AllGeocodeAction(new NominatimLocationQualifierDescriptorDto())));
        parcelSubButtonPanel.add(this.createPasteCoordinateButton());
        parcelButtonPanel.add((Component)parcelSubButtonPanel, "West");
        parcelSubButtonPanel = new JPanel(new FlowLayout());
        parcelSubButtonPanel.add(parcelSaveButton);
        parcelSubButtonPanel.add(new JButton(new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.close", new Serializable[0])){
            private static final long serialVersionUID = 4879922383719130422L;

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ImportParcelEditorGui.this.close();
            }
        }));
        parcelButtonPanel.add((Component)parcelSubButtonPanel, "East");
        parcelPanel.add((Component)parcelButtonPanel, "South");
        return parcelPanel;
    }

    private boolean save() {
        if (this.deleteParcels()) {
            String error = this.storeParcels();
            if (error != null) {
                ErrorMessagesDialog.creatAndShow(error, this.parcelTable);
                return false;
            }
            HashSet<ParcelModel> deletes = new HashSet<ParcelModel>();
            for (ParcelModel parcel : this.importMap.keySet()) {
                if (!parcel.isDeleted()) continue;
                deletes.add(parcel);
            }
            for (ParcelModel parcel : deletes) {
                this.importMap.remove(parcel);
            }
            return true;
        }
        return false;
    }

    private boolean deleteParcels() {
        LinkedList<Tupel<Integer, ParcelModel>> forDelete = new LinkedList<Tupel<Integer, ParcelModel>>();
        for (int row = 0; row < this.parcelTableModel.getRowCount(); ++row) {
            ParcelModel parcel = (ParcelModel)this.parcelTableModel.getValueAt(row, 0);
            Boolean delete = (Boolean)this.parcelTableModel.getValueAt(row, 11);
            if (delete == null || !delete.booleanValue()) continue;
            forDelete.add(new Tupel<Integer, ParcelModel>(row, parcel));
        }
        if (forDelete.size() == 0) {
            return true;
        }
        Collections.reverse(forDelete);
        int d = JOptionPane.showConfirmDialog(this, ModelEnviroment.getMessageResolver().resolveMessage("messages.parcel.delete.confirm", Integer.valueOf(forDelete.size())), ModelEnviroment.getMessageResolver().resolveMessage("messages.default.confirm", new Serializable[0]), 0);
        switch (d) {
            case 0: {
                ErrorMessages errorMessages = new ErrorMessages();
                for (final Tupel tupel : forDelete) {
                    DeleteParcelDialog dialog = new DeleteParcelDialog((ParcelModel)tupel.getElement2(), this.getModelEnviroment(), this, errorMessages){
                        private static final long serialVersionUID = 6872425691291769576L;

                        @Override
                        public void after() {
                            ImportParcelEditorGui.this.parcelTableModel.removeRow((Integer)tupel.getElement1());
                        }
                    };
                    dialog.setVisible(true);
                }
                if (errorMessages.hasErrors()) {
                    BufferedImage image;
                    try {
                        image = ImageIO.read(ImportParcelEditorGui.class.getResourceAsStream("/images/pepper.png"));
                    }
                    catch (IOException iOException) {
                        throw new RuntimeException(iOException);
                    }
                    ErrorMessageDialog errorMessageDialog = new ErrorMessageDialog(SwingUtils.findWindowParent(this), ModelEnviroment.getMessageResolver(), errorMessages, image);
                    errorMessageDialog.setVisible(true);
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    private void doClosing() {
        ModelCache modelCache = super.getModelEnviroment().getModelCache();
        for (ParcelModel parcel : this.importMap.keySet()) {
            modelCache.evictModel(parcel);
        }
        Window window = SwingUtils.findWindowParent(this);
        if (window != null) {
            window.dispose();
        } else {
            this.setVisible(false);
        }
    }

    private boolean addParcel(ParcelModel parcel) {
        if (parcel != null) {
            StreetNetCaller streetNetCaller = this.getModelEnviroment().getAllCaller().getStreetNetCaller();
            this.preImportParcelKey = streetNetCaller.generateImportParcelKey(this.preImportParcelKey);
            parcel.setImportKey(this.preImportParcelKey);
            parcel.setImportProcess(ImportParcelProcess.OPEN);
            parcel.setImportStatus(ImportParcelStatus.NOTCHECKED);
            parcel.setGeom(ImmutableGeoObjectFactory.createImmutablePoint(GeoDecimal100Factory.INSTANCE.createCoordinate(0.0, 0.0)));
            parcel.setOldGeom(ImmutableGeoObjectFactory.createImmutablePoint(GeoDecimal100Factory.INSTANCE.createCoordinate(0.0, 0.0)));
            UndoManager undoManager = this.getModelEnviroment().getUndoManager();
            undoManager.finishTransaction("add import parcel");
            try {
                undoManager.storeTransactions();
            }
            catch (ValidateException e) {
                undoManager.handleValidateException(e);
            }
            undoManager.startTransaction();
            if (GeoUtil.isNullPoint(parcel.getGeom())) {
                parcel.setImportStatus(ImportParcelStatus.NOTCHANGED);
            }
            this.importMap.put(parcel, this.getMaxIndex() + 1);
            this.parcelTableModel.addRow(this.createParcelRowData(parcel));
            return true;
        }
        JOptionPane.showMessageDialog(this, "Geb\u00e4ude kann nicht angelegt werden.");
        return false;
    }

    private Integer getMaxIndex() {
        Integer max = 0;
        for (Integer tupel : this.importMap.values()) {
            if (max.compareTo(tupel) >= 0) continue;
            max = tupel;
        }
        return max;
    }

    private void updateImportParcelDelete(int row) {
        Object o = this.parcelTable.getValueAt(row, 11);
        if (!((Boolean)o).booleanValue()) {
            this.parcelTable.setValueAt(Boolean.TRUE, row, 11);
        } else {
            this.parcelTable.setValueAt(Boolean.FALSE, row, 11);
        }
        this.parcelTable.repaint(10L);
    }

    private void updateImportParcelProcess(int row, ParcelModel parcel) {
        Object o = this.parcelTable.getValueAt(row, 10);
        if (!((Boolean)o).booleanValue()) {
            parcel.setImportProcess(ImportParcelProcess.INPROGRESS);
            this.parcelTable.setValueAt(Boolean.TRUE, row, 10);
            parcel.setImportStatus(ImportParcelStatus.NOTCHECKED);
        } else {
            parcel.setImportProcess(ImportParcelProcess.OPEN);
            this.parcelTable.setValueAt(Boolean.FALSE, row, 10);
        }
        this.parcelTable.repaint(10L);
    }

    private void updateImportParcelStatus(int row, ParcelModel parcel) {
        Object o = this.parcelTable.getValueAt(row, 12);
        String zero = ModelEnviroment.getProperties().getProperty("parcel.coordinates.ignoreZero");
        if (StringUtil.isTrue(zero) || !GeoUtil.isNullPoint(parcel.getGeom())) {
            if (((Boolean)o).booleanValue()) {
                parcel.setImportStatus(ImportParcelStatus.NOTCHECKED);
                this.parcelTable.setValueAt(Boolean.FALSE, row, 12);
            } else {
                parcel.setImportStatus(ImportParcelStatus.CHECKED);
                this.parcelTable.setValueAt(Boolean.TRUE, row, 12);
                parcel.setImportProcess(ImportParcelProcess.OPEN);
            }
        } else {
            parcel.setImportStatus(ImportParcelStatus.NOTCHANGED);
            this.parcelTable.setValueAt(Boolean.FALSE, row, 12);
            JOptionPane.showMessageDialog(this, "Das Geb\u00e4ude hat noch keine Koordinate.", "", 2);
        }
        this.parcelTable.repaint(10L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String storeParcels() {
        String error = null;
        UndoManager undoManager = this.getModelEnviroment().getUndoManager();
        undoManager.startTransaction();
        UserModel loginUser = ModelEnviroment.getUserInformation().getUserModel();
        Collection<ParcelModel> changedParcels = undoManager.getChangedObjects(ParcelModel.class);
        for (ParcelModel changedParcel : changedParcels) {
            changedParcel.setLoginUser(loginUser);
        }
        undoManager.finishTransaction("\u00dcberpr\u00fcfung der Geb\u00e4uden");
        try {
            undoManager.storeTransactions();
        }
        catch (ValidateException e) {
            error = e.getMessage();
        }
        finally {
            undoManager.joinTransaction();
            undoManager.startTransaction();
        }
        return error;
    }

    @Override
    protected void store() {
        if (this.coordinate != null && this.selectedParcel != null) {
            if (this.addressModifiable) {
                ImportCaller importCaller = this.getModelEnviroment().getAllCaller().getImportCaller();
                Country currentCountry = CountryUtil.searchCountryFuzzy(this.country.getText());
                StreetModel currentStreet = importCaller.getStreet(currentCountry, this.postcode.getText(), this.city.getText(), this.district.getText(), this.street.getText());
                this.selectedParcel.setStreet(currentStreet);
                this.selectedParcel.setHouseNumber(this.housenumber.getText());
                this.selectedParcel.setHouseNumberExtension(this.housenumberExtension.getText());
            }
            Double currentX = (Double)this.coordinateX.getValue();
            Double currentY = (Double)this.coordinateY.getValue();
            if (currentX == null || !currentX.equals(this.coordinate.getX()) || currentY == null || !currentY.equals(this.coordinate.getY())) {
                JOptionPane.showMessageDialog(this.getParent(), "Bitte die richtige Koordinate \u00fcbernehmen");
            } else {
                GeomEditorResult result = new GeomEditorResult(this.coordinate, null, null, null, false, false, false);
                ParcelModelUtil.setGeomResult(this.selectedParcel, result, this.geoClientHelper);
                this.selectedParcel.setImportStatus(ImportParcelStatus.NOTCHECKED);
            }
        }
        this.parcelTable.repaint(10L);
    }

    protected void fillAddress(ParcelModel parcel) {
        try {
            StreetModel street = parcel.getStreet();
            PostcodeDistrictRelationModel postcodeDistrictRelation = street.getPostcodeDistrictRelation();
            this.country.setText(FormUtil.getStringDisplay(postcodeDistrictRelation.getPostcode().getCountry().getIso3166_2()));
            this.city.setText(FormUtil.getStringDisplay(postcodeDistrictRelation.getDistrict().getCity().getName()));
            this.district.setText(FormUtil.getStringDisplay(postcodeDistrictRelation.getDistrict().getName()));
            this.postcode.setText(FormUtil.getStringDisplay(postcodeDistrictRelation.getPostcode().getName()));
            this.street.setText(FormUtil.getStringDisplay(street.getName()));
            this.housenumber.setText(FormUtil.getStringDisplay(parcel.getHouseNumber()));
            this.housenumberExtension.setText(FormUtil.getStringDisplay(parcel.getHouseNumberExtension()));
            this.coordinateEditorMapPane.setCoordinate(parcel.getGeom().getCoordinate(), true);
            this.coordinateEditorMapPane.gotoCoordinate();
            Coordinate c = this.coordinateEditorMapPane.getCoordinateOnMap();
            this.coordinateX.setValue(c.getX());
            this.coordinateY.setValue(c.getY());
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.coordinateEditorMapPane.getNavigatorPanel().repaint(10L);
    }

    private void fillParcelTable(List<ParcelModel> filteredParcels, boolean initFilters) {
        Object[][] dataVector = this.createParcelDataVector(filteredParcels);
        this.fillFilters(dataVector, initFilters);
        this.parcelTableModel.setDataVector(dataVector, this.createParcelColumnHeader());
        this.parcelTableModel.fireTableDataChanged();
        this.parcelTable.setRowSorter((RowSorter<? extends TableModel>)new TableRowSorter<TableModel>((TableModel)this.parcelTableModel){

            @Override
            public Comparator<?> getComparator(int column) {
                if (column == 0) {
                    return new Comparator<String>(){

                        @Override
                        public int compare(String o1, String o2) {
                            return Integer.parseInt(o1) - Integer.parseInt(o2);
                        }
                    };
                }
                return super.getComparator(column);
            }
        });
        ((TableRowSorter)this.parcelTable.getRowSorter()).setStringConverter(new TableStringConverter(){

            @Override
            public String toString(TableModel model, int row, int column) {
                String string;
                Object value = model.getValueAt(row, column);
                String string2 = string = value == null ? "" : value.toString();
                if (column == 0) {
                    ParcelModel parcel = (ParcelModel)value;
                    string = String.valueOf(ImportParcelEditorGui.this.importMap.get(parcel));
                } else if (column == 9) {
                    ParcelModel parcel = (ParcelModel)value;
                    UserModel editorUser = parcel == null ? null : parcel.getEditorUser();
                    string = editorUser == null ? "" : editorUser.getName();
                }
                return string;
            }
        });
        this.setParcelTableStyle(filteredParcels);
        this.addTabelCellComponents();
    }

    private void addTabelCellComponents() {
        UserCaller userCaller = this.getModelEnviroment().getAllCaller().getUserCaller();
        List<UserModel> allUsers = userCaller.getAllUsers();
        UserComboxCellEditor userEditor = new UserComboxCellEditor(this.parcelTable){

            @Override
            protected void afterChange(int row, UserModel user) {
                UserModel editorUser;
                ParcelModel parcel = (ParcelModel)ImportParcelEditorGui.this.parcelTable.getValueAt(row, 0);
                UserModel userModel = editorUser = parcel == null ? null : parcel.getEditorUser();
                if (!(parcel == null || editorUser != null && editorUser.equals(user))) {
                    parcel.setEditorUser(user);
                }
                String newItem = user.getName();
                boolean found = false;
                int index = 0;
                ComboBoxModel comboBoxModel = ImportParcelEditorGui.this.filters[9].getModel();
                for (int i = 0; i < comboBoxModel.getSize(); ++i) {
                    Object item = comboBoxModel.getElementAt(i);
                    int compare = FILTER_COMPARATOR.compare(item, newItem);
                    if (compare < 0) {
                        ++index;
                    }
                    if (item == null || !item.equals(newItem)) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    ImportParcelEditorGui.this.filters[9].insertItemAt(newItem, index);
                }
                ImportParcelEditorGui.this.parcelTable.setValueAt(newItem, row, 9);
                ImportParcelEditorGui.this.parcelTable.repaint(10L);
            }
        };
        for (int row = 0; row < this.parcelTable.getRowCount(); ++row) {
            userEditor.setEditorAt(row, allUsers);
        }
        this.parcelTable.getColumnModel().getColumn(9).setCellEditor(userEditor);
    }

    @Override
    protected void sortAndFilter() {
        this.parcelTable.removeAll();
        List<ParcelModel> filteredParcels = this.getFilterParcels();
        this.fillParcelTable(filteredParcels, false);
        this.parcelTable.repaint(10L);
    }

    private List<ParcelModel> getFilterParcels() {
        LinkedList<ParcelModel> filteredParcels = new LinkedList<ParcelModel>();
        for (ParcelModel parcel : this.importMap.keySet()) {
            if (!this.inFilters(parcel)) continue;
            filteredParcels.add(parcel);
        }
        return filteredParcels;
    }

    private boolean inFilters(ParcelModel parcel) {
        for (int column = 1; column < this.filters.length; ++column) {
            JComboBox jComboBox = this.filters[column];
            if (jComboBox == null || jComboBox.getSelectedItem() == null) continue;
            Object s = jComboBox.getSelectedItem();
            Object o = this.getParcelCellData(parcel, column);
            Object object = o = o == null ? "" : o;
            if (o.equals(s)) continue;
            return false;
        }
        return true;
    }

    private Object[][] createParcelDataVector(List<ParcelModel> ps) {
        Object[][] dataVector = new Object[ps.size()][13];
        int row = 0;
        for (ParcelModel p : ps) {
            dataVector[row] = this.createParcelRowData(p);
            ++row;
        }
        return dataVector;
    }

    private Object[] createParcelRowData(ParcelModel parcel) {
        Object[] rowData = new Object[13];
        rowData[0] = parcel;
        for (int column = 1; column < 13; ++column) {
            rowData[column] = this.getParcelCellData(parcel, column);
        }
        return rowData;
    }

    private Object getParcelCellData(ParcelModel parcel, int column) {
        Object o = null;
        StreetModel street = null;
        PostcodeDistrictRelationModel postcodeDistrictRelation = null;
        DistrictModel district = null;
        try {
            street = parcel.getStreet();
            postcodeDistrictRelation = street.getPostcodeDistrictRelation();
            district = postcodeDistrictRelation.getDistrict();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        switch (column) {
            case 1: {
                o = parcel.getImportKey();
                break;
            }
            case 2: {
                Country c = postcodeDistrictRelation == null ? null : postcodeDistrictRelation.getPostcode().getCountry();
                o = c == null ? "" : c.getIso3166_2();
                break;
            }
            case 3: {
                o = postcodeDistrictRelation == null || postcodeDistrictRelation.getPostcode() == null ? "" : postcodeDistrictRelation.getPostcode().getName();
                break;
            }
            case 4: {
                o = district == null || district.getCity() == null ? "" : district.getCity().getName();
                break;
            }
            case 5: {
                o = district == null ? "" : district.getName();
                break;
            }
            case 6: {
                o = street == null ? "" : street.getName();
                break;
            }
            case 7: {
                o = parcel.getHouseNumber();
                break;
            }
            case 8: {
                o = parcel.getHouseNumberExtension();
                break;
            }
            case 10: {
                o = false;
                if (parcel.getImportProcess() != ImportParcelProcess.INPROGRESS) break;
                o = true;
                break;
            }
            case 11: {
                o = false;
                break;
            }
            case 12: {
                o = false;
                if (parcel.getImportStatus() != ImportParcelStatus.CHECKED && parcel.getImportStatus() != ImportParcelStatus.CHANGED) break;
                o = true;
                break;
            }
            case 9: {
                UserModel editorUser = parcel.getEditorUser();
                o = editorUser == null ? "" : editorUser.getName();
                break;
            }
        }
        return o;
    }

    private void setParcelTableStyle(List<ParcelModel> filteredParcels) {
        this.parcelTable.setCellSelectionEnabled(false);
        this.parcelTable.setRowHeight(40);
        this.parcelTable.setRowMargin(5);
        TableColumnModel columnModel = this.parcelTable.getColumnModel();
        columnModel.getColumn(0).setPreferredWidth(20);
        columnModel.getColumn(1).setPreferredWidth(50);
        columnModel.getColumn(2).setPreferredWidth(15);
        columnModel.getColumn(3).setPreferredWidth(50);
        columnModel.getColumn(4).setPreferredWidth(100);
        columnModel.getColumn(5).setPreferredWidth(100);
        columnModel.getColumn(6).setPreferredWidth(200);
        columnModel.getColumn(7).setPreferredWidth(50);
        columnModel.getColumn(8).setPreferredWidth(50);
        columnModel.getColumn(9).setPreferredWidth(50);
        columnModel.getColumn(10).setPreferredWidth(30);
        columnModel.getColumn(11).setPreferredWidth(30);
        columnModel.getColumn(12).setPreferredWidth(30);
        MultiLineHeaderRenderer headerHenderer = new MultiLineHeaderRenderer();
        Enumeration<TableColumn> enumeration = columnModel.getColumns();
        int columnIndex = 0;
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = enumeration.nextElement();
            tableColumn.setHeaderRenderer(headerHenderer);
            if (columnIndex < 10) {
                tableColumn.setCellRenderer(new ImportParcelModelTableCellRenderer(Collections.unmodifiableMap(this.importMap)){

                    @Override
                    protected boolean isSelected(int row, int column) {
                        Object valueAt = ImportParcelEditorGui.this.parcelTable.getValueAt(row, 0);
                        return valueAt != null && valueAt.equals(ImportParcelEditorGui.this.selectedParcel);
                    }
                });
            }
            ++columnIndex;
        }
        JTableHeader th = this.parcelTable.getTableHeader();
        th.setLayout(new TableHeaderWithComponentLayout());
        th.add((Component)new JButton(new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("buttons.clear", new Serializable[0])){
            private static final long serialVersionUID = -6258824252005279477L;

            @Override
            public void actionPerformed(ActionEvent arg0) {
                for (int i = 0; i < ImportParcelEditorGui.this.sizeOfFilters; ++i) {
                    JComboBox comboBox = ImportParcelEditorGui.this.filters[i];
                    if (comboBox == null) continue;
                    comboBox.setSelectedIndex(0);
                }
                ImportParcelEditorGui.this.sortAndFilter();
            }
        }), (Object)0);
        for (int i = 1; i < this.sizeOfFilters; ++i) {
            th.add((Component)this.filters[i], (Object)i);
        }
        th.add((Component)new JLabel(""), (Object)10);
        JCheckBox deleteAll = new JCheckBox(new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.all", new Serializable[0])){
            private static final long serialVersionUID = -342150695528817526L;

            @Override
            public void actionPerformed(ActionEvent e) {
                JCheckBox source = (JCheckBox)e.getSource();
                for (int row = 0; row < ImportParcelEditorGui.this.parcelTableModel.getRowCount(); ++row) {
                    ImportParcelEditorGui.this.parcelTableModel.setValueAt(source.isSelected(), row, 11);
                }
                ImportParcelEditorGui.this.parcelTable.repaint(10L);
            }
        });
        deleteAll.setFont(UIManager.getDefaults().getFont("TextField.font"));
        th.add((Component)deleteAll, (Object)11);
    }

    private String[] createParcelColumnHeader() {
        String[] columnHeader = new String[13];
        columnHeader[0] = " \n#\n \n \n";
        MessageResolver messageResolver = ModelEnviroment.getMessageResolver();
        columnHeader[1] = " \n" + messageResolver.resolveMessage("gui.parcel.parcel", new Serializable[0]);
        columnHeader[2] = " \n" + messageResolver.resolveMessage("address.country", new Serializable[0]);
        columnHeader[3] = " \n" + messageResolver.resolveMessage("address.postcode", new Serializable[0]);
        columnHeader[4] = " \n" + messageResolver.resolveMessage("address.city", new Serializable[0]);
        columnHeader[5] = " \n" + messageResolver.resolveMessage("address.district", new Serializable[0]);
        columnHeader[6] = " \n" + messageResolver.resolveMessage("address.street", new Serializable[0]);
        columnHeader[7] = " \n" + messageResolver.resolveMessage("address.housenumber", new Serializable[0]);
        columnHeader[8] = " \n" + messageResolver.resolveMessage("address.housenumberExt", new Serializable[0]);
        columnHeader[9] = " \n" + messageResolver.resolveMessage("messages.default.editor", new Serializable[0]);
        columnHeader[10] = " \n" + messageResolver.resolveMessage("messages.default.inprogress", new Serializable[0]);
        columnHeader[11] = " \n" + messageResolver.resolveMessage("messages.default.delete", new Serializable[0]);
        columnHeader[12] = " \n" + messageResolver.resolveMessage("messages.default.take", new Serializable[0]);
        return columnHeader;
    }

    public void showDialog(String titel, Component parent) {
        JDialog dialog = new JDialog(SwingUtils.findWindowParent(parent)){
            private static final long serialVersionUID = 1772080525961418854L;

            @Override
            protected void processWindowEvent(WindowEvent e) {
                if (e.getID() == 201) {
                    ImportParcelEditorGui.this.close();
                } else {
                    super.processWindowEvent(e);
                }
            }
        };
        try {
            dialog.setIconImage(ImageIO.read(ImportParcelEditorGui.class.getResourceAsStream("/images/pepper.png")));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        dialog.setPreferredSize(new Dimension(1600, 850));
        dialog.setDefaultCloseOperation(0);
        dialog.setTitle(titel);
        this.country.setEditable(false);
        this.postcode.setEditable(false);
        this.city.setEditable(false);
        this.district.setEditable(false);
        this.street.setEditable(false);
        dialog.getContentPane().add(this);
        dialog.pack();
        SwingUtils.centerDialog(dialog, parent);
        dialog.setVisible(true);
    }

    @Override
    protected void showLegendDialog(Object o) {
    }

    @Override
    protected void clearAddress() {
        super.clearAddress();
        this.selectedParcel = null;
    }

    @Override
    protected void setAdditionalValues(LogisticQualifiedLocationDto l, boolean identifyable) {
        super.setAdditionalValues(l, identifyable);
        this.parcelId1 = identifyable ? (Long)l.getId() : null;
    }

    private void close() {
        UndoManager undoManager = this.getModelEnviroment().getUndoManager();
        int d = 1;
        if (undoManager.canUndo() || undoManager.hasCurrentTransactionChanges()) {
            d = JOptionPane.showConfirmDialog(SwingUtils.findWindowParent(this), ModelEnviroment.getMessageResolver().resolveMessage("messages.confirm.save", new Serializable[0]), ModelEnviroment.getMessageResolver().resolveMessage("messages.default.question", new Serializable[0]), 1, 3);
        }
        switch (d) {
            case 1: {
                undoManager.rollbackTransaction();
                this.doClosing();
                break;
            }
            case 0: {
                if (!this.save()) break;
                this.doClosing();
            }
        }
    }

    @Override
    protected void doAfterFindingCoordinate(ImmutablePoint point) {
    }

    private class AllGeocodeAction
    extends AbstractBusyHandlingAction {
        private static final long serialVersionUID = 7997838507322056329L;
        private LocationQualifierDescriptorDto<?> locationQualifierDescriptorDto;

        public AllGeocodeAction(LocationQualifierDescriptorDto<?> locationQualifierDescriptorDto) {
            super(ModelEnviroment.getMessageResolver().resolveMessage("messages.parcel.allGeocode", new Serializable[]{locationQualifierDescriptorDto.getName()}), new BusyDialogShowingBusyHandler(ImportParcelEditorGui.this, ModelEnviroment.getMessageResolver().resolveMessage("messages.default.pleaseWait", new Serializable[0])));
            this.locationQualifierDescriptorDto = locationQualifierDescriptorDto;
        }

        @Override
        protected void actionPerformedInternal(ActionEvent e) {
            int d = JOptionPane.showConfirmDialog(null, ModelEnviroment.getMessageResolver().resolveMessage("messages.parcel.allGeocode.confirm", new Serializable[0]), ModelEnviroment.getMessageResolver().resolveMessage("messages.default.confirm", new Serializable[0]), 2, 3);
            if (d == 0) {
                List filteredParcels = ImportParcelEditorGui.this.getFilterParcels();
                int index = 1;
                CsvWriter csvWriter = null;
                try {
                    String export = ModelEnviroment.getProperties().getProperty("importparcel.editor.geocoding.export");
                    if (StringUtil.isTrue(export)) {
                        File outputFile = File.createTempFile("Geocoding", ".csv");
                        LOGGER.info("write geocoding result to " + outputFile.getAbsolutePath());
                        csvWriter = new CsvWriter(outputFile);
                        csvWriter.setLineSeparator("\n");
                        csvWriter.writeLine(this.getHeader());
                    }
                }
                catch (Exception e1) {
                    LOGGER.error(e1.getMessage());
                }
                for (ParcelModel parcel : filteredParcels) {
                    ImmutablePointDto pointDto;
                    PostcodeDistrictRelationModel postcodeDistrictRelation;
                    parcel.setMotorSegment(null);
                    parcel.setFootSegment(null);
                    parcel.setBikeSegment(null);
                    parcel.setManualFootSegmentUpdate(false);
                    parcel.setManualMotorSegmentUpdate(false);
                    parcel.setManualBikeSegmentUpdate(false);
                    ImmutablePoint geom = parcel.getGeom();
                    ImportParcelStatus status = parcel.getImportStatus();
                    if (!GeoUtil.isNullPoint(geom) && status != null && status != ImportParcelStatus.NOTCHANGED) continue;
                    StreetModel streetModel = parcel.getStreet();
                    DistrictModel district = null;
                    PostcodeModel postcode = null;
                    CityModel city = null;
                    if (streetModel != null && (postcodeDistrictRelation = streetModel.getPostcodeDistrictRelation()) != null) {
                        district = postcodeDistrictRelation.getDistrict();
                        postcode = postcodeDistrictRelation.getPostcode();
                        if (district != null) {
                            city = district.getCity();
                        }
                    }
                    Country country = postcode == null ? null : postcode.getCountry();
                    LogisticLocationDto<Long> logisticLocationDto = new LogisticLocationDto<Long>(Long.valueOf(0L), null, null, country == null ? ImportParcelEditorGui.this.getModelEnviroment().getAllCaller().getBaseCaller().getDefaultCountry() : country, postcode == null ? "" : postcode.getName(), city == null ? "" : city.getName(), district == null ? "" : district.getName(), streetModel == null ? "" : streetModel.getName(), parcel.getHouseNumber(), parcel.getHouseNumberExtension());
                    ArrayList<LogisticQualifiedLocationDto> l = new ArrayList<LogisticQualifiedLocationDto>(ImportParcelEditorGui.this.getModelEnviroment().getAllCaller().getStreetNetCaller().searchAddressWithQualifiersParameterized(logisticLocationDto, 1, new LocationQualifierDescriptorDto[]{this.locationQualifierDescriptorDto}));
                    LogisticQualifiedLocationDto logisticQualifiedLocationDto = null;
                    if (!l.isEmpty() && (pointDto = (logisticQualifiedLocationDto = (LogisticQualifiedLocationDto)l.get(0)).getGeom()) != null && pointDto.getGeoObject() != null && logisticQualifiedLocationDto.getMatching() >= 99.0) {
                        GeomEditorResult result = new GeomEditorResult(((ImmutablePoint)pointDto.getGeoObject()).getCoordinate(), null, null, null, false, false, false);
                        ParcelModelUtil.setGeomResult(parcel, result, ImportParcelEditorGui.this.geoClientHelper);
                        parcel.setImportStatus(ImportParcelStatus.NOTCHECKED);
                    }
                    if (csvWriter != null) {
                        try {
                            LinkedList<String> line = new LinkedList<String>();
                            this.addString(line, String.valueOf(index));
                            this.addString(line, logisticLocationDto.getCountry().getVehicleSign());
                            this.addString(line, logisticLocationDto.getPostcode());
                            this.addString(line, logisticLocationDto.getCity());
                            this.addString(line, logisticLocationDto.getDistrict());
                            this.addString(line, logisticLocationDto.getStreet());
                            this.addString(line, logisticLocationDto.getHousenumber());
                            this.addString(line, logisticLocationDto.getExtension());
                            this.addString(line, "");
                            if (logisticQualifiedLocationDto != null) {
                                this.addString(line, logisticQualifiedLocationDto.getCountry().getVehicleSign());
                                this.addString(line, logisticQualifiedLocationDto.getPostcode());
                                this.addString(line, logisticQualifiedLocationDto.getCity());
                                this.addString(line, logisticQualifiedLocationDto.getDistrict());
                                this.addString(line, logisticQualifiedLocationDto.getStreet());
                                this.addString(line, logisticQualifiedLocationDto.getHousenumber());
                                this.addString(line, logisticQualifiedLocationDto.getExtension());
                                ImmutablePoint p = (ImmutablePoint)((ImmutablePoint)logisticQualifiedLocationDto.getGeom().getGeoObject()).getTransformed(Wgs84Factory.INSTANCE);
                                this.addString(line, String.valueOf(p.getX()));
                                this.addString(line, String.valueOf(p.getY()));
                                this.addString(line, String.valueOf(logisticQualifiedLocationDto.getMatching()));
                            } else {
                                line.add("");
                                line.add("");
                                line.add("");
                                line.add("");
                                line.add("");
                                line.add("");
                                line.add("");
                                line.add("");
                                line.add("");
                                line.add("");
                            }
                            csvWriter.writeLine(line);
                        }
                        catch (IOException e1) {
                            LOGGER.error(e1.getMessage());
                        }
                    }
                    ++index;
                }
                if (csvWriter != null) {
                    try {
                        csvWriter.flush();
                        csvWriter.close();
                    }
                    catch (IOException e1) {
                        LOGGER.error(e1.getMessage());
                    }
                    LOGGER.info(index + " lines are writed. ");
                }
                ImportParcelEditorGui.this.parcelTable.repaint(10L);
            }
        }

        private void addString(List<String> line, String s) {
            line.add(s == null ? "" : s);
        }

        private List<String> getHeader() {
            LinkedList<String> header = new LinkedList<String>();
            header.add("");
            header.add(ModelEnviroment.getMessageResolver().resolveMessage("address.country", new Serializable[0]));
            header.add(ModelEnviroment.getMessageResolver().resolveMessage("address.postcode", new Serializable[0]));
            header.add(ModelEnviroment.getMessageResolver().resolveMessage("address.city", new Serializable[0]));
            header.add(ModelEnviroment.getMessageResolver().resolveMessage("address.Ortsteil", new Serializable[0]));
            header.add(ModelEnviroment.getMessageResolver().resolveMessage("address.Stra\u00dfe", new Serializable[0]));
            header.add(ModelEnviroment.getMessageResolver().resolveMessage("address.housenumber", new Serializable[0]));
            header.add(ModelEnviroment.getMessageResolver().resolveMessage("address.housenumberExt", new Serializable[0]));
            header.add("");
            header.add(ModelEnviroment.getMessageResolver().resolveMessage("address.country", new Serializable[0]));
            header.add(ModelEnviroment.getMessageResolver().resolveMessage("address.postcode", new Serializable[0]));
            header.add(ModelEnviroment.getMessageResolver().resolveMessage("address.city", new Serializable[0]));
            header.add(ModelEnviroment.getMessageResolver().resolveMessage("address.Ortsteil", new Serializable[0]));
            header.add(ModelEnviroment.getMessageResolver().resolveMessage("address.Stra\u00dfe", new Serializable[0]));
            header.add(ModelEnviroment.getMessageResolver().resolveMessage("address.housenumber", new Serializable[0]));
            header.add(ModelEnviroment.getMessageResolver().resolveMessage("address.housenumberExt", new Serializable[0]));
            header.add("X");
            header.add("Y");
            header.add(ModelEnviroment.getMessageResolver().resolveMessage("address.matching", new Serializable[0]));
            return header;
        }
    }
}

