/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.importer.parcel;

import de.datomino.peppergis.client.gui.asynchronous.AbstractAsynchronousDialog;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.importer.AbstractAddressCsvImporter;
import de.datomino.peppergis.client.message.EnumMessageResolverNameGenerator;
import de.datomino.peppergis.dto.asynchronous.AsynchronousDto;
import de.datomino.peppergis.dto.importer.GenericCsvDto;
import de.datomino.peppergis.dto.importer.ParcelImportDto;
import de.datomino.peppergis.dto.importer.ParcelImportResultDto;
import de.datomino.peppergis.exception.ClientImportException;
import de.datomino.util.assistant.editor.Worker;
import de.datomino.util.assistant.model.ChoiceField;
import de.datomino.util.assistant.model.CsvColumnChoiceField;
import de.datomino.util.assistant.model.Fieldset;
import de.datomino.util.message.MessageResolver;
import de.datomino.util.message.error.ErrorMessages;
import java.awt.Component;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.apache.commons.io.FileUtils;
import org.ktde.math.projection.CoordinateFactory;
import org.ktde.util.datatypes.Tupel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientParcelImporter
extends AbstractAddressCsvImporter<ParcelImportDto> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientParcelImporter.class);
    private ChoiceField<CoordinateFactory.Projections> coordinateFactoryField;
    private CsvColumnChoiceField xField;
    private CsvColumnChoiceField yField;
    private CsvColumnChoiceField idField;
    private CsvColumnChoiceField deleteField;
    private CsvColumnChoiceField status;
    private Component parent;

    public ClientParcelImporter(Component parent) {
        this.parent = parent;
        MessageResolver messageResolver = ModelEnviroment.getMessageResolver();
        Collection<CoordinateFactory.Projections> projections = CoordinateFactory.getListableProjections();
        CoordinateFactory.Projections[] values = new CoordinateFactory.Projections[projections.size()];
        values = projections.toArray(values);
        this.coordinateFactoryField = new ChoiceField<CoordinateFactory.Projections>(messageResolver.resolveMessage("messages.default.coordinateFactory", new Serializable[0]), values, new EnumMessageResolverNameGenerator(), CoordinateFactory.Projections.Wgs84);
        this.xField = new CsvColumnChoiceField(messageResolver.resolveMessageForEnum(GenericCsvDto.AddressColumns.X), (Serializable)((Object)GenericCsvDto.AddressColumns.X), this.createRegexForXCoordinate(), false);
        this.yField = new CsvColumnChoiceField(messageResolver.resolveMessageForEnum(GenericCsvDto.AddressColumns.Y), (Serializable)((Object)GenericCsvDto.AddressColumns.Y), this.createRegexForYCoordinate(), false);
        this.idField = new CsvColumnChoiceField(messageResolver.resolveMessageForEnum(ParcelImportDto.Columns.ID), (Serializable)((Object)ParcelImportDto.Columns.ID), this.createRegex("Geb\u00e4ude-Nr.", "Geb\u00e4ude-ID", "building-ID"), true);
        this.deleteField = new CsvColumnChoiceField(messageResolver.resolveMessageForEnum(ParcelImportDto.Columns.DELETE), (Serializable)((Object)ParcelImportDto.Columns.DELETE), this.createRegex("L\u00f6schen", "zu l\u00f6schen", "entfernen"), true);
        this.status = new CsvColumnChoiceField(messageResolver.resolveMessageForEnum(ParcelImportDto.Columns.STATUS), (Serializable)((Object)ParcelImportDto.Columns.STATUS), this.createRegex("status"), true);
    }

    @Override
    protected void addCsvFields(List<CsvColumnChoiceField> choiceFields) {
        choiceFields.add(this.idField);
        super.addCsvFields(choiceFields);
        choiceFields.add(this.xField);
        choiceFields.add(this.yField);
        choiceFields.add(this.deleteField);
        choiceFields.add(this.status);
    }

    @Override
    public String getTitle() {
        return ModelEnviroment.getMessageResolver().resolveMessage("importer.parcel.title", new Serializable[0]);
    }

    @Override
    protected List<Fieldset> getAdditionalFieldsets() {
        Fieldset geo = new Fieldset(ModelEnviroment.getMessageResolver().resolveMessage("messages.importer.parcel.geo", new Serializable[0]));
        geo.addField(this.coordinateFactoryField);
        return Collections.singletonList(geo);
    }

    @Override
    protected void writeToDto(ParcelImportDto dto) {
        super.writeToDto(dto);
        dto.setCoordinateFactory((CoordinateFactory.Projections)((Object)this.coordinateFactoryField.getValue()));
        dto.setSource(((File)this.fileField.getValue()).getName());
    }

    protected ParcelImportDto getDto() {
        ParcelImportDto dto = new ParcelImportDto();
        this.writeToDto(dto);
        return dto;
    }

    @Override
    public Worker getWorker(final Window parent) {
        return new Worker(){
            private Worker.State state;
            private String resultString;

            @Override
            public void process() {
                ModelEnviroment modelEnviroment = new ModelEnviroment(null);
                StringBuilder builder = new StringBuilder();
                try {
                    Tupel parcelImportResult;
                    AbstractAsynchronousDialog<ParcelImportResultDto> asynchronousDialog = new AbstractAsynchronousDialog<ParcelImportResultDto>(parent, ModelEnviroment.getMessageResolver().resolveMessage("messages.import.parcel.importing", new Serializable[0]), ModelEnviroment.getMessageResolver().resolveMessage("messages.import.parcel.importing", new Serializable[0]), 1, true, modelEnviroment){
                        private static final long serialVersionUID = -1127458576478099632L;

                        @Override
                        protected AsynchronousDto<ParcelImportResultDto> getAsynchronousDto(String token) {
                            return this.modelEnviroment.getAllCaller().getAsynchronousCaller().getImportHouseCoordinateCsvResult(token);
                        }

                        @Override
                        protected String startAsynchronous() {
                            return this.modelEnviroment.getAllCaller().getAsynchronousCaller().importHouseCoordinateCsv(ClientParcelImporter.this.getDto());
                        }
                    };
                    try {
                        parcelImportResult = asynchronousDialog.run();
                    }
                    catch (Exception e) {
                        if (e instanceof ClientImportException) {
                            throw (ClientImportException)e;
                        }
                        if (e instanceof RuntimeException) {
                            throw (RuntimeException)e;
                        }
                        throw new RuntimeException(e);
                    }
                    ParcelImportResultDto result = (ParcelImportResultDto)parcelImportResult.getElement1();
                    this.saveReportFile(result.getFileContent());
                    builder.append(ModelEnviroment.getMessageResolver().resolveMessage("messages.importer.parcel.result", Integer.valueOf(result.getNews().size()), Integer.valueOf(result.getUpdates().size()), Integer.valueOf(result.getDeletes().size()), Integer.valueOf(result.getGenerateds().size()), Integer.valueOf(result.getRejectedCount()))).append("\n");
                    ErrorMessages errorMessages = result.getErrorMessages();
                    if (errorMessages.hasErrors()) {
                        builder.append("Fehler:\n");
                        builder.append(ModelEnviroment.getMessageResolver().resolveMessages(errorMessages, "\n", 10));
                        this.state = Worker.State.ERROR;
                    } else {
                        this.state = Worker.State.OK;
                    }
                }
                catch (ClientImportException e) {
                    LOGGER.warn(e.getMessage(), e);
                    ErrorMessages errorMessages = e.getErrorMessages();
                    if (errorMessages != null && errorMessages.hasErrors()) {
                        builder.append(ModelEnviroment.getMessageResolver().resolveMessages(errorMessages, "\n", 10));
                    }
                    builder.append(e.getMessage());
                }
                this.resultString = builder.toString();
            }

            private void saveReportFile(byte[] fileContent) {
                if (fileContent != null && fileContent.length > 0) {
                    int d;
                    JFileChooser fileChooser = new JFileChooser(System.getProperty("user.home"));
                    while ((d = fileChooser.showSaveDialog(ClientParcelImporter.this.parent)) == 0) {
                        File file = fileChooser.getSelectedFile();
                        d = 0;
                        if (file.exists()) {
                            d = JOptionPane.showConfirmDialog(ClientParcelImporter.this.parent, ModelEnviroment.getMessageResolver().resolveMessage("messages.default.question.overwriteFile", new Serializable[0]), ModelEnviroment.getMessageResolver().resolveMessage("messages.default.question", new Serializable[0]), 0, 3);
                        }
                        if (d != 0) continue;
                        try {
                            FileUtils.writeByteArrayToFile(fileChooser.getSelectedFile(), fileContent);
                            break;
                        }
                        catch (IOException e) {
                            JOptionPane.showMessageDialog(ClientParcelImporter.this.parent, e.getMessage());
                        }
                    }
                }
            }

            @Override
            public String getResultString() {
                return this.resultString;
            }

            @Override
            public Worker.State getResultState() {
                return this.state;
            }
        };
    }
}

