/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.importer.parcel;

import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.gui.parcel.ParcelAddressPane;
import de.datomino.peppergis.client.model.map.ParcelModel;
import de.datomino.peppergis.client.model.map.ParcelModelImpl;
import de.datomino.peppergis.client.model.map.StreetModel;
import de.datomino.util.geo.ImmutablePoint;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.ktde.math.projection.Coordinate;
import org.ktde.math.projection.Wgs84Factory;
import org.ktde.util.StringUtil;

public class AddParcelPane
extends JPanel {
    private static final long serialVersionUID = -7382619761503314457L;
    private NewParcelAddressPane parcelAddressPane;
    private ModelEnviroment modelEnviroment;
    private JTable parcelTable;

    public AddParcelPane(ModelEnviroment modelEnviroment) {
        super(new BorderLayout());
        this.modelEnviroment = modelEnviroment;
        this.buildLayout();
    }

    private void buildLayout() {
        this.parcelAddressPane = new NewParcelAddressPane(new ParcelModelImpl(), this.modelEnviroment, true);
        this.add((Component)this.parcelAddressPane, "North");
        this.parcelTable = new JTable(new ParcelTableModel());
        this.add((Component)new JScrollPane(this.parcelTable), "Center");
    }

    public ParcelModel getParcel() {
        return this.parcelAddressPane.getParcel();
    }

    public void adaptValuesToModel(boolean b) throws Exception {
        this.parcelAddressPane.adaptValuesToModel(b);
    }

    public boolean hasAddress(ParcelModel parcel) {
        boolean found = false;
        ParcelTableModel model = (ParcelTableModel)this.parcelTable.getModel();
        if (model.getParcels() != null) {
            for (ParcelModel p : model.getParcels()) {
                if (!parcel.getStreet().equals(p.getStreet()) || !parcel.getHouseNumber().equals(p.getHouseNumber()) || !StringUtil.getNotNull(parcel.getHouseNumberExtension()).equals(StringUtil.getNotNull(p.getHouseNumberExtension()))) continue;
                found = true;
                break;
            }
        }
        return found;
    }

    public void setParcel(ParcelModel parcel) {
        this.parcelAddressPane.setParcel(parcel);
    }

    private class ParcelTableModel
    implements TableModel {
        private List<ParcelModel> parcels;
        private List<TableModelListener> listeners = new LinkedList<TableModelListener>();

        private ParcelTableModel() {
        }

        @Override
        public int getRowCount() {
            return this.parcels == null ? 0 : this.parcels.size();
        }

        @Override
        public int getColumnCount() {
            return 5;
        }

        @Override
        public String getColumnName(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return ModelEnviroment.getMessageResolver().resolveMessage("messages.parcel.parcelId", new Serializable[0]);
                }
                case 1: {
                    return ModelEnviroment.getMessageResolver().resolveMessage("address.housenumber", new Serializable[0]);
                }
                case 2: {
                    return ModelEnviroment.getMessageResolver().resolveMessage("address.housenumberExt", new Serializable[0]);
                }
                case 3: {
                    return ModelEnviroment.getMessageResolver().resolveMessage("gis.coordinate.longitude", new Serializable[0]);
                }
                case 4: {
                    return ModelEnviroment.getMessageResolver().resolveMessage("gis.coordinate.latitude", new Serializable[0]);
                }
            }
            return "";
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return String.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            ParcelModel parcel = this.parcels.get(rowIndex);
            ImmutablePoint geom = parcel.getGeom();
            Coordinate coord = geom.getCoordinate();
            if (geom != null && (coord = geom.getCoordinate()) != null) {
                coord = Wgs84Factory.INSTANCE.createCoordinate(coord);
            }
            switch (columnIndex) {
                case 0: {
                    return parcel.getImportKey();
                }
                case 1: {
                    return parcel.getHouseNumber();
                }
                case 2: {
                    return parcel.getHouseNumberExtension();
                }
                case 3: {
                    return coord == null ? "" : Double.toString(coord.getX());
                }
                case 4: {
                    return coord == null ? "" : Double.toString(coord.getY());
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        }

        @Override
        public void addTableModelListener(TableModelListener l) {
            this.listeners.add(l);
        }

        @Override
        public void removeTableModelListener(TableModelListener l) {
            this.listeners.remove(l);
        }

        protected void fireTableModelEvent(TableModelEvent e) {
            for (TableModelListener l : this.listeners) {
                l.tableChanged(e);
            }
        }

        public void setParcels(Collection<ParcelModel> parcels) {
            if (parcels == null) {
                this.parcels = null;
            } else {
                this.parcels = new ArrayList<ParcelModel>(parcels);
                Collections.sort(this.parcels, new Comparator<ParcelModel>(){

                    @Override
                    public int compare(ParcelModel o1, ParcelModel o2) {
                        String key1 = o1.getImportKey();
                        String key2 = o2.getImportKey();
                        return key1.compareTo(key2);
                    }
                });
            }
            this.fireTableModelEvent(new TableModelEvent(this));
        }

        public List<ParcelModel> getParcels() {
            return this.parcels;
        }
    }

    private class NewParcelAddressPane
    extends ParcelAddressPane {
        private static final long serialVersionUID = 5132704478247543428L;

        public NewParcelAddressPane(ParcelModel parcel, ModelEnviroment modelEnviroment, boolean basicEnabled) {
            super(parcel, modelEnviroment, basicEnabled, true, false);
            this.street.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    StreetModel selected = NewParcelAddressPane.this.street.getSelectedItem();
                    ParcelTableModel model = (ParcelTableModel)AddParcelPane.this.parcelTable.getModel();
                    if (selected == null) {
                        model.setParcels(null);
                    } else {
                        ArrayList<ParcelModel> parcels = new ArrayList<ParcelModel>(selected.countParcels());
                        for (ParcelModel parcel : selected.iterableParcels()) {
                            parcels.add(parcel);
                        }
                        model.setParcels(parcels);
                    }
                }
            });
        }

        public ParcelModel getParcel() {
            return this.parcel;
        }
    }
}

