/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.importer.gui;

import de.datomino.util.assistant.editor.WizardDialog;
import de.datomino.util.assistant.editor.Worker;
import de.datomino.util.assistant.model.Wizard;
import java.awt.Image;
import java.awt.Window;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsynchronousWizardDialog
extends WizardDialog {
    private static final Logger LOGGER = LoggerFactory.getLogger(AsynchronousWizardDialog.class);

    public AsynchronousWizardDialog(Window parent, Wizard wizard, Worker worker, Image iconImage) {
        super(parent, wizard, worker, iconImage);
    }

    @Override
    protected void finishInternal() {
        try {
            Worker worker = this.getWorker();
            worker.process();
            String resultString = worker.getResultString();
            this.getResultPage().showResult(resultString);
            this.setUserOption(worker.getResultState());
        }
        catch (RuntimeException runtimeException) {
            try {
                LOGGER.error(runtimeException.getMessage(), runtimeException);
            }
            catch (Exception ex) {
                System.err.println("Exception!");
            }
            this.getResultPage().showResult(runtimeException.getMessage());
            this.setUserOption(Worker.State.ERROR);
        }
    }
}

