/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.importer.attribute;

import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.map.ParcelAttributeValueDescriptorModel;
import de.datomino.peppergis.client.util.wrapper.common.attribute.AttributeValueDescriptorModel;
import de.datomino.peppergis.client.util.wrapper.parcel.attribute.ParcelAttributeValueDescriptorModelAttributeWrapper;
import de.datomino.peppergis.dto.asynchronous.AsynchronousDto;
import de.datomino.peppergis.dto.attribute.AttributeCsvDto;
import de.datomino.peppergis.dto.importer.AttributeValueImportResultDto;
import de.datomino.peppergis.importer.attribute.AbstractAttributeValueImporter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.ktde.util.StringUtil;
import org.ktde.util.datatypes.Tripel;

public class ParcelAttributeValueImporter
extends AbstractAttributeValueImporter<String, AttributeCsvDto> {
    @Override
    protected List<AttributeValueDescriptorModel<?, ?>> getDescriptors() {
        Collection<ParcelAttributeValueDescriptorModel> descriptors = this.getModelEnviroment().getAllCaller().getStreetNetCaller().fetchAllParcelAttributeValueDescriptors();
        ArrayList list = new ArrayList(descriptors.size());
        for (ParcelAttributeValueDescriptorModel descriptor : descriptors) {
            list.add(new ParcelAttributeValueDescriptorModelAttributeWrapper(descriptor));
        }
        return list;
    }

    @Override
    protected List<Tripel<String, Serializable, String>> getIdentColumns() {
        return Collections.singletonList(new Tripel<String, String, String>(ModelEnviroment.getMessageResolver().resolveMessage("messages.parcel.parcelId", new Serializable[0]), "ID", this.createRegex("geb\u00e4ude-nummer", "Geb\u00e4ude-ID", "Geb\u00e4ude-Nr.")));
    }

    @Override
    protected String getDialogTitle() {
        return ModelEnviroment.getMessageResolver().resolveMessage("messages.import.importParcelAttributeValues", new Serializable[0]);
    }

    @Override
    protected String getInitialMessage() {
        return ModelEnviroment.getMessageResolver().resolveMessage("messages.import.importParcelAttributeValues", new Serializable[0]);
    }

    @Override
    protected String startAsynchronous(AttributeCsvDto attributeCsvDto) {
        return this.getModelEnviroment().getAllCaller().getAsynchronousCaller().importParcelAttributeValues(attributeCsvDto);
    }

    @Override
    protected AsynchronousDto<AttributeValueImportResultDto<String>> getAsynchronousDto(String token) {
        return this.getModelEnviroment().getAllCaller().getAsynchronousCaller().getImportParcelAttributeValueResult(token);
    }

    @Override
    public String getTitle() {
        return ModelEnviroment.getMessageResolver().resolveMessage("messages.import.importParcelAttributeValues", new Serializable[0]);
    }

    @Override
    protected String getObjectNamePlural() {
        return ModelEnviroment.getMessageResolver().resolveMessage("messages.parcel.parcels", new Serializable[0]);
    }

    @Override
    protected Serializable transformResultObjectToString(Collection<String> parcelIds) {
        return StringUtil.implode(parcelIds, ", ");
    }

    @Override
    protected AttributeCsvDto createDto() {
        return new AttributeCsvDto();
    }

    @Override
    protected String getIdentifierMessageKey() {
        return "gui.parcel.parcel";
    }
}

