/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.importer.area.worker.data;

import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.dto.importer.area.AreaShapeImportDto;
import de.datomino.peppergis.importer.area.data.MultiPolygonImportData;
import de.datomino.peppergis.importer.area.worker.data.PolygonImportDataCreator;
import de.datomino.util.command.AttributeDescriptor;
import de.datomino.util.command.ShpDbfReader;
import de.datomino.util.geo.ImmutableGeoObject;
import de.datomino.util.geo.ImmutablePolygonKind;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.ktde.math.projection.CoordinateFactory;
import org.ktde.util.datatypes.Tupel;

public class AreaFromShapeImportDataCreator
implements PolygonImportDataCreator<MultiPolygonImportData, AreaShapeImportDto> {
    private static final AreaFromShapeImportDataCreator INSTANCE = new AreaFromShapeImportDataCreator();

    private AreaFromShapeImportDataCreator() {
    }

    public static AreaFromShapeImportDataCreator getInstance() {
        return INSTANCE;
    }

    @Override
    public Collection<MultiPolygonImportData> getAreaImportData(AreaShapeImportDto dto, ModelEnviroment modelEnviroment) throws Exception {
        File shpDir = File.createTempFile("areaImport", "");
        shpDir.delete();
        shpDir.mkdirs();
        shpDir.deleteOnExit();
        File shp = new File(shpDir, "area_import.shp");
        File shx = new File(shpDir, "area_import.shx");
        File dbf = new File(shpDir, "area_import.dbf");
        FileUtils.writeByteArrayToFile(shp, dto.getShpContent());
        byte[] shxContent = dto.getShxContent();
        if (shxContent != null && shxContent.length > 0) {
            FileUtils.writeByteArrayToFile(shx, shxContent);
        }
        FileUtils.writeByteArrayToFile(dbf, dto.getDbfContent());
        Tupel<AttributeDescriptor[], List<Tupel<Object[], ImmutableGeoObject>>> tupel = ShpDbfReader.readDbf(shpDir.getAbsolutePath() + "/area_import", CoordinateFactory.getInstance(dto.getCoordinateFactory()), dto.getEncodedType());
        String shortCutColumn = dto.getShortCutColumn();
        String displayNameColumn = dto.getDescriptionColumn();
        int shortCutIndex = -1;
        int displayNameIndex = -1;
        int count = 0;
        for (AttributeDescriptor attributeDescriptor : tupel.getElement1()) {
            String name = attributeDescriptor.getName();
            if (name.equalsIgnoreCase(shortCutColumn)) {
                shortCutIndex = count;
            }
            if (name.equalsIgnoreCase(displayNameColumn)) {
                displayNameIndex = count;
            }
            ++count;
        }
        List<Tupel<Object[], ImmutableGeoObject>> data = tupel.getElement2();
        ArrayList<MultiPolygonImportData> result = new ArrayList<MultiPolygonImportData>(data.size());
        for (Tupel<Object[], ImmutableGeoObject> dataTupel : data) {
            Object[] attributeData = dataTupel.getElement1();
            MultiPolygonImportData multiPolygonImportData = new MultiPolygonImportData(attributeData[shortCutIndex].toString(), attributeData[displayNameIndex].toString());
            multiPolygonImportData.setImmutablePolygonKind((ImmutablePolygonKind)dataTupel.getElement2());
            result.add(multiPolygonImportData);
        }
        return result;
    }

    @Override
    public ImmutablePolygonKind getPolygon(MultiPolygonImportData t) throws Exception {
        return t.getImmutablePolygonKind();
    }
}

