/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.importer.area.worker.data;

import com.vividsolutions.jts.geom.TopologyException;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.dto.importer.area.AreaCsvObjectImportDto;
import de.datomino.peppergis.helper.CsvHelper;
import de.datomino.peppergis.importer.area.AbstractAreaFromStringCsvImporter;
import de.datomino.peppergis.importer.area.data.MultiPolygonImportData;
import de.datomino.peppergis.importer.area.worker.data.PolygonImportDataCreator;
import de.datomino.util.algorithm.selfintersection.PolygonSelfIntersectionKiller;
import de.datomino.util.csv.CsvLineReader;
import de.datomino.util.geo.ImmutableGeoObject;
import de.datomino.util.geo.ImmutablePolygonKind;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.ktde.math.projection.CoordinateFactory;
import org.ktde.math.projection.GeoDecimal100Factory;
import org.ktde.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAreaFromStringImportDataCreator<U extends AreaCsvObjectImportDto>
implements PolygonImportDataCreator<MultiPolygonImportData, U> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractAreaFromStringImportDataCreator.class);

    @Override
    public Collection<MultiPolygonImportData> getAreaImportData(U dto, ModelEnviroment modelEnviroment) throws Exception {
        Map<Object, String> line = null;
        LinkedHashMap<String, MultiPolygonImportData> result = new LinkedHashMap<String, MultiPolygonImportData>();
        CsvLineReader reader = CsvHelper.createReader(dto);
        while ((line = reader.readLine()) != null) {
            String key = line.get((Object)AreaCsvObjectImportDto.Columns.AREA_SHORTCUT);
            String displayName = line.get((Object)AreaCsvObjectImportDto.Columns.DISPLAY_NAME);
            String coordString = line.get((Object)AbstractAreaFromStringCsvImporter.Columns.COORDINATE_STRING);
            if (StringUtil.isBlank(coordString) || StringUtil.isBlank(key)) continue;
            MultiPolygonImportData data = (MultiPolygonImportData)result.get(key);
            if (data == null) {
                data = new MultiPolygonImportData(key, displayName);
                result.put(key, data);
            }
            data.addImportString(coordString);
        }
        ArrayList<MultiPolygonImportData> areas = new ArrayList<MultiPolygonImportData>(result.size());
        CoordinateFactory coordinateFactory = CoordinateFactory.getInstance(((AreaCsvObjectImportDto)dto).getCoordinateFactory());
        LOGGER.info(result.size() + " areas to import");
        for (MultiPolygonImportData area : result.values()) {
            List<String> importStrings = area.getImportString();
            ImmutableGeoObject poly = null;
            for (String string : importStrings) {
                ImmutablePolygonKind newPoly;
                try {
                    newPoly = this.createNewPolygon(coordinateFactory, string);
                    PolygonSelfIntersectionKiller polygonSelfIntersectionKiller = new PolygonSelfIntersectionKiller(newPoly);
                    polygonSelfIntersectionKiller.start(false);
                    newPoly = polygonSelfIntersectionKiller.getResult();
                }
                catch (Exception ex) {
                    poly = null;
                    break;
                }
                if (poly == null) {
                    poly = newPoly;
                    continue;
                }
                try {
                    poly = (ImmutablePolygonKind)poly.union(newPoly);
                }
                catch (TopologyException topologyException) {}
            }
            if (poly == null) continue;
            poly = (ImmutablePolygonKind)poly.getTransformed(GeoDecimal100Factory.INSTANCE);
            LOGGER.info(poly + "P");
            if (!this.checkPoly((ImmutablePolygonKind)poly)) continue;
            area.setImmutablePolygonKind((ImmutablePolygonKind)poly);
            areas.add(area);
        }
        LOGGER.info(areas.size() + " areas to import");
        return areas;
    }

    private boolean checkPoly(ImmutablePolygonKind poly) {
        return false;
    }

    protected abstract ImmutablePolygonKind createNewPolygon(CoordinateFactory var1, String var2) throws Exception;

    @Override
    public ImmutablePolygonKind getPolygon(MultiPolygonImportData t) throws Exception {
        return t.getImmutablePolygonKind();
    }
}

