/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.importer.area.worker;

import de.datomino.peppergis.client.model.map.StreetModel;
import de.datomino.peppergis.dto.importer.area.AreaCsvObjectImportDto;
import de.datomino.peppergis.importer.area.AreaFromConvexHullCsvImporter;
import de.datomino.peppergis.importer.area.data.CoordinateAreaImportData;
import de.datomino.peppergis.importer.area.worker.AbstractAreaFromPolygonMarkImportWorker;
import de.datomino.peppergis.importer.area.worker.data.AreaFromConvexHullCsvImportDataCreator;
import de.datomino.peppergis.importer.area.worker.data.PolygonImportDataCreator;
import de.datomino.util.algorithm.overlaping.ConvexHullOverlapingPolygonReducer;
import de.datomino.util.geo.ImmutableGeoObject;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.geo.ImmutablePolygonKind;
import de.datomino.util.geo.MarkerMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ktde.math.projection.GeoDecimal100Factory;

public class AreaFromConvexHullCsvImportWorker
extends AbstractAreaFromPolygonMarkImportWorker<CoordinateAreaImportData, AreaFromConvexHullCsvImporter, AreaCsvObjectImportDto> {
    public AreaFromConvexHullCsvImportWorker(AreaFromConvexHullCsvImporter areaFromConvexHullCsvImporter) {
        super(areaFromConvexHullCsvImporter);
    }

    @Override
    protected Set<StreetModel> getAdditionalStreets(CoordinateAreaImportData t) {
        return Collections.emptySet();
    }

    @Override
    protected MarkerMode getMarkerMode() {
        return MarkerMode.FREEHAND_HALF;
    }

    @Override
    protected PolygonImportDataCreator<CoordinateAreaImportData, AreaCsvObjectImportDto> getImportDataCreator() {
        return AreaFromConvexHullCsvImportDataCreator.getInstance();
    }

    @Override
    protected void prepareImportData(Collection<CoordinateAreaImportData> areas) {
        super.prepareImportData(areas);
        HashMap map = new HashMap();
        for (CoordinateAreaImportData area : areas) {
            List<ImmutablePoint> points = area.getPoints();
            ArrayList<ImmutableGeoObject> transformedPoints = new ArrayList<ImmutableGeoObject>(points.size());
            for (ImmutablePoint point : points) {
                transformedPoints.add(point.getTransformed(GeoDecimal100Factory.INSTANCE));
            }
            map.put(area.getAreaKey(), transformedPoints);
        }
        ConvexHullOverlapingPolygonReducer convexHullOverlapingPolygonReducer = ConvexHullOverlapingPolygonReducer.createConvexHullOverlapingPolygonReducer(map, 5, true, true);
        convexHullOverlapingPolygonReducer.start(false);
        Map result = convexHullOverlapingPolygonReducer.getResult();
        for (CoordinateAreaImportData area : areas) {
            ImmutablePolygonKind immutablePolygonKind = result.get(area.getAreaKey());
            area.setPolygon(immutablePolygonKind);
        }
    }
}

