/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.importer.area.worker;

import de.datomino.peppergis.client.communication.AreaCaller;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.UndoManager;
import de.datomino.peppergis.client.model.area.AreaLayerModel;
import de.datomino.peppergis.client.model.area.AreaObjectModel;
import de.datomino.peppergis.client.model.area.AreaObjectModelImpl;
import de.datomino.peppergis.client.model.map.SegmentModel;
import de.datomino.peppergis.dto.area.AreaLayerDto;
import de.datomino.peppergis.dto.importer.area.AreaObjectImportDto;
import de.datomino.peppergis.exception.ValidateException;
import de.datomino.peppergis.importer.area.AreaImporter;
import de.datomino.peppergis.importer.area.data.AbstractAreaImportData;
import de.datomino.peppergis.importer.area.worker.data.ImportDataCreator;
import de.datomino.peppergis.type.AreaObjectGenInfoDiscriminator;
import de.datomino.peppergis.type.SegmentType;
import de.datomino.util.assistant.editor.Worker;
import de.datomino.util.geo.ImmutablePolygonKind;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAreaImportWorker<T extends AbstractAreaImportData, S extends AreaImporter<T, U>, U extends AreaObjectImportDto>
implements Worker {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractAreaImportWorker.class);
    private int areaCount;
    private int emptyAreaCount;
    private int failedAreaCount;
    private int updatedAreaCount;
    private int notUpdatedAreaCount;
    private int failedUpdateAreaCount;
    private Worker.State state;
    private final S importer;
    private Exception exception;

    public AbstractAreaImportWorker(S importer) {
        this.importer = importer;
    }

    @Override
    public Worker.State getResultState() {
        return this.state;
    }

    @Override
    public String getResultString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.areaCount + " Gebiete importiert");
        if (this.emptyAreaCount > 0) {
            builder.append(this.emptyAreaCount + " Gebietsdefinitionen nicht importiert.");
        }
        if (this.updatedAreaCount > 0) {
            builder.append("\n" + this.updatedAreaCount + " Gebietsdefinitionen aktualisiert.");
        }
        if (this.notUpdatedAreaCount > 0) {
            builder.append("\n" + this.notUpdatedAreaCount + " bekannte Gebietsdefinitionen nicht aktualisiert.");
        }
        if (this.failedUpdateAreaCount > 0) {
            builder.append("\n" + this.failedUpdateAreaCount + " bekannte Gebietsdefinitionen lieferten Fehler beim Versuch sie zu importieren.");
        }
        if (this.failedAreaCount > 0) {
            builder.append("\n" + this.failedAreaCount + " neue Gebietsdefinitionen lieferten Fehler beim Versuch sie zu importieren.");
        }
        if (this.exception != null) {
            builder.append("\nFehler: ").append(this.exception.getMessage()).append("\n").append(ExceptionUtils.getFullStackTrace(this.exception));
        }
        return builder.toString();
    }

    @Override
    public void process() {
        try {
            Collection<T> areas;
            this.state = null;
            ModelEnviroment modelEnviroment = new ModelEnviroment(null);
            UndoManager undoManager = modelEnviroment.getUndoManager();
            Object dto = this.importer.getDto();
            AreaLayerDto layer = dto.getLayer();
            AreaLayerModel areaLayerModel = (AreaLayerModel)modelEnviroment.getModelCache().getModel(layer);
            AreaObjectGenInfoDiscriminator discriminator = areaLayerModel.getDiscriminator();
            try {
                areas = this.getImportDataCreator().getAreaImportData(dto, modelEnviroment);
            }
            catch (Exception e) {
                this.exception = e;
                LOGGER.error("Could not start importer", e);
                this.state = Worker.State.ERROR;
                return;
            }
            this.prepareImportData(areas);
            for (AbstractAreaImportData area : areas) {
                boolean ok;
                block23: {
                    undoManager.startTransaction();
                    AreaCaller areaCaller = modelEnviroment.getAllCaller().getAreaCaller();
                    String shortcut = area.getAreaKey();
                    AreaObjectModel knownmodel = areaCaller.fetchAreaObject(areaLayerModel, shortcut);
                    ok = false;
                    if (knownmodel != null) {
                        try {
                            if (this.canUpdate(knownmodel, area, modelEnviroment)) {
                                LOGGER.info("start update of area " + shortcut);
                                ok = this.updateAreaObject(knownmodel, area, modelEnviroment);
                                if (ok) {
                                    LOGGER.info("updated area " + shortcut);
                                    ++this.updatedAreaCount;
                                } else {
                                    LOGGER.info("skipped existing area " + shortcut);
                                    ++this.notUpdatedAreaCount;
                                }
                                break block23;
                            }
                            LOGGER.info("skipped existing area " + shortcut);
                            ++this.notUpdatedAreaCount;
                        }
                        catch (Exception e) {
                            LOGGER.warn("Could not update area " + shortcut, e);
                            ++this.failedUpdateAreaCount;
                        }
                    } else {
                        try {
                            LOGGER.info("start import of area " + shortcut);
                            AreaObjectModel areaObjectModel = null;
                            switch (discriminator) {
                                case AREA_OBJECT_GEN_FREEHAND: {
                                    areaObjectModel = this.createNewAreaObjectForFreehand(areaLayerModel, area, modelEnviroment);
                                }
                            }
                            boolean bl = ok = areaObjectModel != null;
                            if (ok) {
                                LOGGER.info("imported area " + shortcut);
                                ++this.areaCount;
                            } else {
                                LOGGER.info("skipped new area " + shortcut);
                                ++this.emptyAreaCount;
                            }
                        }
                        catch (Exception e) {
                            LOGGER.warn("Could not create area " + shortcut, e);
                            ++this.failedAreaCount;
                        }
                    }
                }
                undoManager.finishTransaction("import area");
                try {
                    if (!ok) {
                        undoManager.rollbackTransaction();
                        continue;
                    }
                    undoManager.storeTransactions();
                }
                catch (ValidateException e) {
                    LOGGER.error("Error while processing transaction ", e);
                    this.state = Worker.State.ERROR;
                }
            }
            if (this.state != Worker.State.ERROR) {
                this.state = this.failedAreaCount + this.failedUpdateAreaCount > 0 ? Worker.State.WARNING : Worker.State.OK;
            }
            modelEnviroment.close();
        }
        catch (Exception e) {
            LOGGER.warn("Unexpected State", e);
            this.state = Worker.State.ERROR;
        }
    }

    protected void prepareImportData(Collection<T> areas) {
    }

    protected AreaObjectModel createNewAreaObjectForFreehand(AreaLayerModel areaLayerModel, T area, ModelEnviroment modelEnviroment) {
        Collection<ImmutablePolygonKind> freehands;
        try {
            freehands = this.getFreehandPolygons(area);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (freehands.isEmpty()) {
            return null;
        }
        return this.createAreaObject(areaLayerModel, area, modelEnviroment, null, freehands);
    }

    protected abstract Collection<ImmutablePolygonKind> getFreehandPolygons(T var1) throws Exception;

    protected AreaObjectModel createNewAreaObjectForSegment(AreaLayerModel areaLayerModel, T area, ModelEnviroment modelEnviroment) {
        Collection<SegmentModel> segments;
        try {
            segments = this.getSegments(area);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        ArrayList<SegmentModel> segmentModels = new ArrayList<SegmentModel>(segments.size());
        for (SegmentModel segmentModel : segments) {
            if (segmentModel.getSegmentType() == null || segmentModel.getSegmentType() == SegmentType.DUMMY) continue;
            segmentModels.add(segmentModel);
        }
        if (segmentModels.isEmpty()) {
            return null;
        }
        return this.createAreaObject(areaLayerModel, area, modelEnviroment, segmentModels, null);
    }

    private AreaObjectModel createAreaObject(AreaLayerModel areaLayerModel, T area, ModelEnviroment modelEnviroment, List<SegmentModel> segmentModels, Collection<ImmutablePolygonKind> freehands) {
        String shortcut = ((AbstractAreaImportData)area).getAreaKey();
        String displayName = ((AbstractAreaImportData)area).getDisplayName();
        AreaObjectModelImpl areaObjectModel = new AreaObjectModelImpl();
        areaObjectModel.setShortcut(shortcut);
        areaObjectModel.setAreaLayer(areaLayerModel);
        areaObjectModel.setDisplayname(displayName);
        try {
            modelEnviroment.getAllCaller().getAreaCaller().createAreaGeometryReplace(areaObjectModel, null, freehands, modelEnviroment);
        }
        catch (IllegalStateException ex) {
            throw new RuntimeException(ex);
        }
        catch (NullPointerException ex) {
            throw new RuntimeException("NPE: " + ex.getMessage(), ex);
        }
        return areaObjectModel;
    }

    protected boolean updateAreaObject(AreaObjectModel knownmodel, T area, ModelEnviroment modelEnviroment) {
        return false;
    }

    protected boolean canUpdate(AreaObjectModel knownmodel, T area, ModelEnviroment modelEnviroment) {
        return true;
    }

    protected abstract ImportDataCreator<T, U> getImportDataCreator();

    protected abstract Collection<SegmentModel> getSegments(T var1) throws Exception;
}

