/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.importer.area.worker;

import de.datomino.peppergis.client.communication.StreetNetCaller;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.map.ParcelModel;
import de.datomino.peppergis.client.model.map.SegmentModel;
import de.datomino.peppergis.client.model.map.StreetModel;
import de.datomino.peppergis.dto.importer.area.AreaObjectImportDto;
import de.datomino.peppergis.importer.area.AreaImporter;
import de.datomino.peppergis.importer.area.data.AbstractAreaImportData;
import de.datomino.peppergis.importer.area.worker.AbstractAreaImportWorker;
import de.datomino.peppergis.importer.area.worker.data.PolygonImportDataCreator;
import de.datomino.util.collection.CollectionUtil;
import de.datomino.util.collection.Transformer;
import de.datomino.util.geo.ImmutableEnvelope;
import de.datomino.util.geo.ImmutableLineString;
import de.datomino.util.geo.ImmutableMultiPolygon;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.geo.ImmutablePolygon;
import de.datomino.util.geo.ImmutablePolygonKind;
import de.datomino.util.geo.MarkerMode;
import de.datomino.util.geo.model.BucketsFetchCallback;
import de.datomino.util.geo.model.DefaultGeoObjectBucketsModel;
import de.datomino.util.geo.model.GeomExtractor;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.ktde.math.projection.Coordinate;
import org.ktde.math.projection.Wgs84Factory;

public abstract class AbstractAreaFromPolygonMarkImportWorker<T extends AbstractAreaImportData, S extends AreaImporter<T, U>, U extends AreaObjectImportDto>
extends AbstractAreaImportWorker<T, S, U> {
    public AbstractAreaFromPolygonMarkImportWorker(S importer) {
        super(importer);
    }

    protected Set<StreetModel> getAdditionalStreets(T area) {
        return Collections.emptySet();
    }

    @Override
    protected Collection<ImmutablePolygonKind> getFreehandPolygons(T area) throws Exception {
        return Collections.singleton(this.getImportDataCreator().getPolygon(area));
    }

    @Override
    protected Collection<SegmentModel> getSegments(T area) throws Exception {
        ModelEnviroment modelEnviroment = new ModelEnviroment(null);
        final StreetNetCaller streetNetCaller = modelEnviroment.getAllCaller().getStreetNetCaller();
        DefaultGeoObjectBucketsModel<SegmentModel, ImmutableLineString> bucketsModel = new DefaultGeoObjectBucketsModel<SegmentModel, ImmutableLineString>(Wgs84Factory.INSTANCE, this.createGeomExtractor());
        bucketsModel.setFetchCallback(new BucketsFetchCallback<SegmentModel, ImmutableLineString>(){

            @Override
            public Collection<SegmentModel> fetch(Coordinate topLeft, Coordinate bottomRight) {
                return streetNetCaller.fetchSegments(topLeft, bottomRight);
            }
        });
        ImmutablePolygonKind polygon = this.getImportDataCreator().getPolygon(area);
        Collection<SegmentModel> segments = this.getSegmentsFromData(polygon, bucketsModel);
        GeomExtractor<ParcelModel, ImmutablePoint> parcelGeomExtractor = new GeomExtractor<ParcelModel, ImmutablePoint>(){

            @Override
            public ImmutablePoint getGeom(ParcelModel object) {
                return object.getGeom();
            }
        };
        DefaultGeoObjectBucketsModel<ParcelModel, ImmutablePoint> parcelBucket = new DefaultGeoObjectBucketsModel<ParcelModel, ImmutablePoint>(Wgs84Factory.INSTANCE, parcelGeomExtractor);
        parcelBucket.setFetchCallback(new BucketsFetchCallback<ParcelModel, ImmutablePoint>(){

            @Override
            public Collection<ParcelModel> fetch(Coordinate topLeft, Coordinate bottomRight) {
                return streetNetCaller.fetchParcels(topLeft, bottomRight, true);
            }
        });
        this.addSegmentsFromParcels(segments, polygon, parcelBucket);
        return segments;
    }

    private void addSegmentsFromParcels(Collection<SegmentModel> segments, ImmutablePolygonKind polygonKind, DefaultGeoObjectBucketsModel<ParcelModel, ImmutablePoint> parcelBucket) {
        List<ImmutablePolygon> polygons = polygonKind instanceof ImmutablePolygon ? Collections.singletonList((ImmutablePolygon)polygonKind) : ((ImmutableMultiPolygon)polygonKind).getParts();
        for (ImmutablePolygon polygon : polygons) {
            ImmutableEnvelope envelope = polygon.getEnvelope();
            Collection subParcels = parcelBucket.findObjects(envelope.getBottomLeft(), envelope.getTopRight());
            for (ImmutableLineString hole : polygon.getHoles()) {
                envelope = hole.getEnvelope();
                Collection cut = parcelBucket.findObjects(envelope.getBottomLeft(), envelope.getTopRight());
                for (ParcelModel c : cut) {
                    if (!hole.contains(c.getGeom()) && !hole.touches(c.getGeom())) continue;
                    subParcels.remove(c);
                }
            }
            for (ParcelModel parcel : subParcels) {
                if (!polygon.contains(parcel.getGeom()) && !polygon.touches(parcel.getGeom())) continue;
                if (parcel.getMotorSegment() != null) {
                    segments.add(parcel.getMotorSegment());
                }
                if (parcel.getFootSegment() == null) continue;
                segments.add(parcel.getFootSegment());
            }
        }
    }

    private Collection<SegmentModel> getSegmentsFromData(ImmutablePolygonKind polygonKind, DefaultGeoObjectBucketsModel<SegmentModel, ImmutableLineString> bucketsModel) {
        HashSet<SegmentModel> segmentsegmentSegmentModels = new HashSet<SegmentModel>();
        List<ImmutablePolygon> polygons = polygonKind instanceof ImmutablePolygon ? Collections.singletonList((ImmutablePolygon)polygonKind) : ((ImmutableMultiPolygon)polygonKind).getParts();
        for (ImmutablePolygon polygon : polygons) {
            LinkedList<Coordinate> coordinates = new LinkedList<Coordinate>();
            CollectionUtil.transform(polygon.getShell().getCoordinates(), coordinates, new Transformer<ImmutablePoint, Coordinate>(){

                @Override
                public Coordinate transform(ImmutablePoint t) {
                    return t.getCoordinate();
                }
            });
            ImmutableEnvelope envelope = polygon.getEnvelope();
            Collection subSegmentsegmentSegmentModels = bucketsModel.findObjects(envelope.getBottomLeft().getCoordinate(), envelope.getTopRight().getCoordinate(), coordinates, this.getMarkerMode());
            for (ImmutableLineString hole : polygon.getHoles()) {
                coordinates = new LinkedList();
                CollectionUtil.transform(hole.getCoordinates(), coordinates, new Transformer<ImmutablePoint, Coordinate>(){

                    @Override
                    public Coordinate transform(ImmutablePoint t) {
                        return t.getCoordinate();
                    }
                });
                envelope = hole.getEnvelope();
                Collection cut = bucketsModel.findObjects(envelope.getBottomLeft().getCoordinate(), envelope.getTopRight().getCoordinate(), coordinates, this.getMarkerMode());
                subSegmentsegmentSegmentModels.removeAll(cut);
            }
            segmentsegmentSegmentModels.addAll(subSegmentsegmentSegmentModels);
        }
        return segmentsegmentSegmentModels;
    }

    protected GeomExtractor<SegmentModel, ImmutableLineString> createGeomExtractor() {
        return new GeomExtractor<SegmentModel, ImmutableLineString>(){

            @Override
            public ImmutableLineString getGeom(SegmentModel object) {
                return object.getGeom();
            }
        };
    }

    protected abstract MarkerMode getMarkerMode();

    @Override
    protected abstract PolygonImportDataCreator<T, U> getImportDataCreator();
}

