/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.importer.area;

import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.importer.AbstractCsvImporter;
import de.datomino.peppergis.client.message.EnumMessageResolverNameGenerator;
import de.datomino.peppergis.client.model.area.AreaLayerModel;
import de.datomino.peppergis.dto.AbstractProxyDto;
import de.datomino.peppergis.dto.area.AreaLayerDto;
import de.datomino.peppergis.dto.importer.GenericCsvDto;
import de.datomino.peppergis.dto.importer.area.AreaCsvObjectImportDto;
import de.datomino.peppergis.importer.area.AreaImporter;
import de.datomino.peppergis.importer.area.data.CoordinateAreaImportData;
import de.datomino.peppergis.importer.area.worker.AreaFromConvexHullCsvImportWorker;
import de.datomino.peppergis.type.AreaObjectGenInfoDiscriminator;
import de.datomino.util.assistant.editor.Worker;
import de.datomino.util.assistant.model.ChoiceField;
import de.datomino.util.assistant.model.CsvColumnChoiceField;
import de.datomino.util.assistant.model.Fieldset;
import de.datomino.util.message.MessageResolver;
import java.awt.Window;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.ktde.math.projection.CoordinateFactory;
import org.ktde.util.NameGenerator;

public class AreaFromConvexHullCsvImporter
extends AbstractCsvImporter<AreaCsvObjectImportDto>
implements AreaImporter<CoordinateAreaImportData, AreaCsvObjectImportDto> {
    private ChoiceField<AreaLayerModel> layerField;
    private ChoiceField<CoordinateFactory.Projections> coordinateFactoryField;
    private CsvColumnChoiceField areaShortcutField;
    private CsvColumnChoiceField areaDisplaynameField;
    private CsvColumnChoiceField xField;
    private CsvColumnChoiceField yField;
    private ModelEnviroment modelEnviroment;

    public AreaFromConvexHullCsvImporter() {
        MessageResolver messageResolver = ModelEnviroment.getMessageResolver();
        this.areaShortcutField = new CsvColumnChoiceField(messageResolver.resolveMessageForEnum(AreaCsvObjectImportDto.Columns.AREA_SHORTCUT), (Serializable)((Object)AreaCsvObjectImportDto.Columns.AREA_SHORTCUT), this.createRegex("id", "Gebietsnummer", "Gebiets-Nr.", "Gebiets-ID", "Bezirks-ID"), false);
        this.areaDisplaynameField = new CsvColumnChoiceField(messageResolver.resolveMessageForEnum(AreaCsvObjectImportDto.Columns.DISPLAY_NAME), (Serializable)((Object)AreaCsvObjectImportDto.Columns.DISPLAY_NAME), this.createRegex("id", "Gebietsname", "Gebietsbezeichnung", "Bezirksname", "Bezirksbezeichnung"), false);
        this.modelEnviroment = new ModelEnviroment(null);
        Collection<AreaLayerModel> areas = this.modelEnviroment.getAllCaller().getAreaCaller().getAreaLayersForType(new AreaObjectGenInfoDiscriminator[]{AreaObjectGenInfoDiscriminator.AREA_OBJECT_GEN_FREEHAND});
        this.layerField = new ChoiceField<1>(messageResolver.resolveMessage("messages.import.area.layer", new Serializable[0]), (Collection<1>)areas, new NameGenerator<AreaLayerModel>(){

            @Override
            public String getName(AreaLayerModel t) {
                return t == null ? "_Bitte w\u00e4hlen" : t.getDisplayname();
            }
        });
        Collection<CoordinateFactory.Projections> projections = CoordinateFactory.getListableProjections();
        CoordinateFactory.Projections[] values = new CoordinateFactory.Projections[projections.size()];
        values = projections.toArray(values);
        this.coordinateFactoryField = new ChoiceField<CoordinateFactory.Projections>(messageResolver.resolveMessage("messages.default.coordinateFactory", new Serializable[0]), values, new EnumMessageResolverNameGenerator(), CoordinateFactory.Projections.Wgs84);
        this.xField = new CsvColumnChoiceField(messageResolver.resolveMessageForEnum(GenericCsvDto.AddressColumns.X), (Serializable)((Object)GenericCsvDto.AddressColumns.X), this.createRegexForXCoordinate(), false);
        this.yField = new CsvColumnChoiceField(messageResolver.resolveMessageForEnum(GenericCsvDto.AddressColumns.Y), (Serializable)((Object)GenericCsvDto.AddressColumns.Y), this.createRegexForYCoordinate(), false);
    }

    @Override
    public Worker getWorker(Window parent) {
        return new AreaFromConvexHullCsvImportWorker(this);
    }

    @Override
    public AreaCsvObjectImportDto getDto() {
        AreaCsvObjectImportDto areaCsvObjectImportDto = new AreaCsvObjectImportDto();
        this.writeToDto(areaCsvObjectImportDto);
        return areaCsvObjectImportDto;
    }

    @Override
    protected void writeToDto(AreaCsvObjectImportDto dto) {
        super.writeToDto(dto);
        AreaLayerModel value = (AreaLayerModel)this.layerField.getValue();
        AbstractProxyDto layerDto = value.createProxy();
        dto.setLayer((AreaLayerDto)((Object)layerDto));
        dto.setCoordinateFactory((CoordinateFactory.Projections)((Object)this.coordinateFactoryField.getValue()));
    }

    @Override
    protected void addCsvFields(List<CsvColumnChoiceField> choiceFields) {
        choiceFields.add(this.areaShortcutField);
        choiceFields.add(this.areaDisplaynameField);
        choiceFields.add(this.xField);
        choiceFields.add(this.yField);
    }

    @Override
    protected List<Fieldset> getAdditionalFieldsets() {
        Fieldset geo = new Fieldset(ModelEnviroment.getMessageResolver().resolveMessage("messages.importer.parcel.geo", new Serializable[0]));
        geo.addField(this.layerField);
        geo.addField(this.coordinateFactoryField);
        return Collections.singletonList(geo);
    }

    @Override
    public String getTitle() {
        return ModelEnviroment.getMessageResolver().resolveMessage("messages.importer.area.convexHull", new Serializable[0]);
    }
}

