/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.importer.area;

import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.importer.AbstractAddressRangeCsvImporter;
import de.datomino.peppergis.client.message.EnumMessageResolverNameGenerator;
import de.datomino.peppergis.client.model.area.AreaLayerModel;
import de.datomino.peppergis.client.model.area.AreaLayerModelImpl;
import de.datomino.peppergis.dto.importer.GenericCsvDto;
import de.datomino.peppergis.dto.importer.area.AreaCsvObjectImportDto;
import de.datomino.peppergis.importer.area.AreaImporter;
import de.datomino.peppergis.importer.area.data.AbstractAreaImportData;
import de.datomino.peppergis.type.AreaObjectGenInfoDiscriminator;
import de.datomino.util.assistant.model.ChoiceField;
import de.datomino.util.assistant.model.CsvColumnChoiceField;
import de.datomino.util.assistant.model.Fieldset;
import de.datomino.util.message.MessageResolver;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.ktde.math.projection.Coordinate;
import org.ktde.math.projection.CoordinateFactory;
import org.ktde.util.NameGenerator;
import org.ktde.util.StringUtil;
import org.ktde.util.datatypes.Tupel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAreaAddressRangeCsvImporter<T extends AbstractAreaImportData>
extends AbstractAddressRangeCsvImporter<AreaCsvObjectImportDto>
implements AreaImporter<T, AreaCsvObjectImportDto> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractAreaAddressRangeCsvImporter.class);
    private ChoiceField<AreaLayerModel> layerField;
    private ChoiceField<CoordinateFactory.Projections> coordinateFactoryField;
    private CsvColumnChoiceField areaShortcutField;
    private CsvColumnChoiceField areaDisplayNameField;
    private CsvColumnChoiceField xField;
    private CsvColumnChoiceField yField;
    private ModelEnviroment modelEnviroment = new ModelEnviroment(null);

    public AbstractAreaAddressRangeCsvImporter(boolean alloptional) {
        super(alloptional);
        Collection<AreaLayerModel> areas = this.modelEnviroment.getAllCaller().getAreaCaller().getAreaLayersForType(new AreaObjectGenInfoDiscriminator[]{AreaObjectGenInfoDiscriminator.AREA_OBJECT_GEN_FREEHAND});
        MessageResolver messageResolver = ModelEnviroment.getMessageResolver();
        this.layerField = new ChoiceField<1>(messageResolver.resolveMessage("messages.import.area.layer", new Serializable[0]), (Collection<1>)areas, new NameGenerator<AreaLayerModel>(){

            @Override
            public String getName(AreaLayerModel t) {
                return t == null ? "_Bitte w\u00e4hlen" : t.getDisplayname();
            }
        });
        Collection<CoordinateFactory.Projections> projections = CoordinateFactory.getListableProjections();
        CoordinateFactory.Projections[] values = new CoordinateFactory.Projections[projections.size()];
        values = projections.toArray(values);
        this.coordinateFactoryField = new ChoiceField<CoordinateFactory.Projections>(messageResolver.resolveMessage("messages.default.coordinateFactory", new Serializable[0]), values, new EnumMessageResolverNameGenerator(), CoordinateFactory.Projections.Wgs84);
        this.xField = new CsvColumnChoiceField(messageResolver.resolveMessageForEnum(GenericCsvDto.AddressColumns.X), (Serializable)((Object)GenericCsvDto.AddressColumns.X), "^(?:x|.*wgs.*x.*|.*x.*wgs.*|lon(gitude))$", false);
        this.yField = new CsvColumnChoiceField(messageResolver.resolveMessageForEnum(GenericCsvDto.AddressColumns.Y), (Serializable)((Object)GenericCsvDto.AddressColumns.Y), "^(?:y|.*wgs.*y.*|.*y.*wgs.*|lat(itude))$", false);
        this.areaShortcutField = new CsvColumnChoiceField(messageResolver.resolveMessageForEnum(AreaCsvObjectImportDto.Columns.AREA_SHORTCUT), (Serializable)((Object)AreaCsvObjectImportDto.Columns.AREA_SHORTCUT), "^id$", false);
        this.areaDisplayNameField = new CsvColumnChoiceField(messageResolver.resolveMessageForEnum(AreaCsvObjectImportDto.Columns.DISPLAY_NAME), (Serializable)((Object)AreaCsvObjectImportDto.Columns.DISPLAY_NAME), "^id$", false);
    }

    @Override
    protected void addCsvFields(List<CsvColumnChoiceField> choiceFields) {
        super.addCsvFields(choiceFields);
        choiceFields.add(this.areaShortcutField);
        choiceFields.add(this.areaDisplayNameField);
        choiceFields.add(this.xField);
        choiceFields.add(this.yField);
    }

    @Override
    protected List<Fieldset> getAdditionalFieldsets() {
        Fieldset geo = new Fieldset(ModelEnviroment.getMessageResolver().resolveMessage("messages.parameter.geo.title", new Serializable[0]));
        geo.addField(this.layerField);
        geo.addField(this.coordinateFactoryField);
        return Collections.singletonList(geo);
    }

    @Override
    protected void writeToDto(AreaCsvObjectImportDto dto) {
        super.writeToDto(dto);
        dto.setLayer(((AreaLayerModelImpl)this.layerField.getValue()).createDto());
        dto.setCoordinateFactory((CoordinateFactory.Projections)((Object)this.coordinateFactoryField.getValue()));
    }

    public static Tupel<Coordinate, Map<GenericCsvDto.AddressColumns, String>> getParcelFromLine(Map<Object, String> line, CoordinateFactory coordinateFactory) {
        Map<GenericCsvDto.AddressColumns, String> models = AbstractAddressRangeCsvImporter.getParcelFromLine(line);
        Coordinate coordinate = null;
        String x = line.get((Object)GenericCsvDto.AddressColumns.X);
        String y = line.get((Object)GenericCsvDto.AddressColumns.Y);
        if (!StringUtil.isBlank(x)) {
            double coordX = Double.valueOf(x);
            double coordY = Double.valueOf(y);
            coordinate = coordinateFactory.createCoordinate(coordX, coordY);
        }
        if (models == null && coordinate == null) {
            LOGGER.error("Street and coordinate is missing");
        }
        return new Tupel<Object, Map<GenericCsvDto.AddressColumns, String>>(coordinate, models);
    }
}

