/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.importer.alias;

import de.datomino.peppergis.client.communication.AsynchronousCaller;
import de.datomino.peppergis.client.gui.asynchronous.AbstractAsynchronousDialog;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.importer.AbstractCsvImporter;
import de.datomino.peppergis.dto.asynchronous.AsynchronousDto;
import de.datomino.peppergis.dto.importer.AliasCsvImportDto;
import de.datomino.peppergis.dto.importer.AliasImportReportDto;
import de.datomino.peppergis.dto.importer.AliasImportResult;
import de.datomino.peppergis.dto.importer.GenericCsvDto;
import de.datomino.peppergis.exception.ClientImportException;
import de.datomino.util.assistant.editor.Worker;
import de.datomino.util.assistant.model.CsvColumnChoiceField;
import de.datomino.util.message.error.ErrorMessages;
import java.awt.Window;
import java.io.Serializable;
import java.util.List;

public abstract class AbstractAliasImportPane
extends AbstractCsvImporter<GenericCsvDto> {
    private CsvColumnChoiceField parcleKeyField;
    private CsvColumnChoiceField nameField;
    private CsvColumnChoiceField deleteField;
    private Window parent;

    public AbstractAliasImportPane(Window parent) {
        this.parent = parent;
        this.parcleKeyField = new CsvColumnChoiceField(ModelEnviroment.getMessageResolver().resolveMessage("messages.importer.alias.parcelKey", new Serializable[0]), (Serializable)((Object)AliasCsvImportDto.Field.PARCEL_KEY), "geb\u00e4ude", false);
        this.nameField = new CsvColumnChoiceField(ModelEnviroment.getMessageResolver().resolveMessage("messages.importer.alias.name", new Serializable[0]), (Serializable)((Object)AliasCsvImportDto.Field.NAME), "name", false);
        this.deleteField = new CsvColumnChoiceField(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.delete", new Serializable[0]), (Serializable)((Object)AliasCsvImportDto.Field.DELETE), "l\u00f6schen", true);
    }

    protected abstract String excuteImport(AliasCsvImportDto var1, AsynchronousCaller var2);

    protected abstract AsynchronousDto<AliasImportReportDto> getReport(String var1, AsynchronousCaller var2);

    @Override
    protected void addCsvFields(List<CsvColumnChoiceField> choiceFields) {
        choiceFields.add(this.parcleKeyField);
        choiceFields.add(this.nameField);
        choiceFields.add(this.deleteField);
    }

    @Override
    public Worker getWorker(Window parent) {
        return new Worker(){
            private String resultString;
            private Worker.State resultState;

            @Override
            public void process() {
                StringBuilder builder = new StringBuilder();
                try {
                    ModelEnviroment modelEnviroment = new ModelEnviroment(AbstractAliasImportPane.this.parent);
                    final AsynchronousCaller asynchronousCaller = modelEnviroment.getAllCaller().getAsynchronousCaller();
                    AbstractAsynchronousDialog<AliasImportReportDto> asynchronousDialog = new AbstractAsynchronousDialog<AliasImportReportDto>(AbstractAliasImportPane.this.parent, AbstractAliasImportPane.this.getTitle(), AbstractAliasImportPane.this.getTitle(), 1, true, modelEnviroment){
                        private static final long serialVersionUID = 2870795747286928881L;

                        @Override
                        protected AsynchronousDto<AliasImportReportDto> getAsynchronousDto(String token) {
                            return AbstractAliasImportPane.this.getReport(token, asynchronousCaller);
                        }

                        @Override
                        protected String startAsynchronous() {
                            AliasCsvImportDto dto = new AliasCsvImportDto();
                            AbstractAliasImportPane.this.writeToDto(dto);
                            return AbstractAliasImportPane.this.excuteImport(dto, asynchronousCaller);
                        }
                    };
                    AliasImportReportDto report = (AliasImportReportDto)asynchronousDialog.run().getElement1();
                    builder.append(AbstractAliasImportPane.this.getResultReport(report)).append("\n");
                    ErrorMessages errorMessages = report.getErrorMessages();
                    if (errorMessages.hasErrors()) {
                        builder.append(ModelEnviroment.getMessageResolver().resolveMessage("errors.import.error", new Serializable[0]) + ":\n");
                        builder.append(ModelEnviroment.getMessageResolver().resolveMessages(errorMessages, "\n"));
                    }
                }
                catch (Exception e) {
                    if (e instanceof ClientImportException) {
                        ErrorMessages errorMessages = ((ClientImportException)e).getErrorMessages();
                        if (errorMessages != null && errorMessages.hasErrors()) {
                            builder.append(ModelEnviroment.getMessageResolver().resolveMessages(errorMessages, "\n"));
                        } else {
                            builder.append(e.getMessage());
                        }
                    }
                    if (e instanceof RuntimeException) {
                        throw (RuntimeException)e;
                    }
                    throw new RuntimeException(e);
                }
                this.resultString = builder.toString();
            }

            @Override
            public String getResultString() {
                return this.resultString;
            }

            @Override
            public Worker.State getResultState() {
                return this.resultState;
            }
        };
    }

    private String getResultReport(AliasImportReportDto report) {
        int countNew = 0;
        int countExists = 0;
        int countDeleted = 0;
        int countRejected = 0;
        for (AliasImportResult result : report.getResultList()) {
            switch (result.getResultStatus()) {
                case CHANGED: {
                    break;
                }
                case DELETED: {
                    ++countDeleted;
                    break;
                }
                case EXISTS: {
                    ++countExists;
                    break;
                }
                case NEW: {
                    ++countNew;
                    break;
                }
                case REJECTED: {
                    ++countRejected;
                }
            }
        }
        return ModelEnviroment.getMessageResolver().resolveMessage("messages.importer.alias.result", Integer.valueOf(countNew), Integer.valueOf(countExists), Integer.valueOf(countDeleted), Integer.valueOf(countRejected));
    }
}

