/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.importer.action;

import de.datomino.peppergis.client.communication.TourCaller;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.UndoManager;
import de.datomino.peppergis.client.model.base.ImportedLocationModel;
import de.datomino.peppergis.client.model.base.LocationModel;
import de.datomino.peppergis.client.model.tour.StopModel;
import de.datomino.peppergis.client.util.StreetNameComparator;
import de.datomino.peppergis.importer.stop.ImportStopEditorGui;
import de.datomino.peppergis.type.ImportedLocationStatus;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Properties;
import javax.swing.AbstractAction;

public class CheckImportStopsAction
extends AbstractAction {
    private static final long serialVersionUID = -9079954715493538352L;
    private Window parent;
    private Properties properties;

    public CheckImportStopsAction(Window parent) {
        super(ModelEnviroment.getMessageResolver().resolveMessage("importer.stop.check", new Serializable[0]));
        this.parent = parent;
        this.properties = ModelEnviroment.getProperties();
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        ModelEnviroment modelEnviroment = new ModelEnviroment(this.parent);
        TourCaller tourCaller = modelEnviroment.getAllCaller().getTourCaller();
        ArrayList<StopModel> stopsWithNullGeom = new ArrayList<StopModel>(tourCaller.fetchStopsWithNullGeom(false));
        UndoManager undoManager = modelEnviroment.getUndoManager();
        undoManager.startTransaction();
        for (StopModel nullGeom : stopsWithNullGeom) {
            LocationModel location = nullGeom.getLocation();
            ImportedLocationModel importedLocation = location == null ? null : location.getImportedLocation();
            if (importedLocation == null || importedLocation.getStatus() != null) continue;
            importedLocation.setStatus(ImportedLocationStatus.NOTCHANGED);
        }
        undoManager.finishTransaction("Aktualisieren Importe-Location-Status");
        stopsWithNullGeom.addAll(tourCaller.fetchNotCheckedStops(false));
        Collections.sort(stopsWithNullGeom, new StreetNameComparator());
        ImportStopEditorGui gui = new ImportStopEditorGui(modelEnviroment, this.properties, stopsWithNullGeom);
        gui.showDialog(ModelEnviroment.getMessageResolver().resolveMessage("importer.stop.editor.list", new Serializable[0]), this.parent);
    }
}

