/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.importer.action;

import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.importer.Importer;
import de.datomino.peppergis.exception.ClientImportException;
import de.datomino.peppergis.importer.gui.AsynchronousWizardDialog;
import de.datomino.util.assistant.editor.WizardDialog;
import de.datomino.util.assistant.editor.Worker;
import de.datomino.util.assistant.model.Wizard;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.JDialog;

public abstract class AbstractImportAction
extends AbstractAction {
    private static final long serialVersionUID = -3268720230212400191L;
    private Window parent;
    private Importer importer;
    private boolean asynchronous;

    public AbstractImportAction(Window parent, boolean asynchronous) {
        this.parent = parent;
        this.asynchronous = asynchronous;
        super.putValue("Name", this.getImporterTitle());
    }

    protected abstract String getImporterTitle();

    protected abstract Importer createImporter();

    @Override
    public void actionPerformed(ActionEvent e) {
        BufferedImage image;
        if (this.importer == null) {
            this.importer = this.createImporter();
        }
        Wizard wizard = this.importer.getWizard();
        Worker worker = this.importer.getWorker(this.parent);
        try {
            image = ImageIO.read(AbstractImportAction.class.getResourceAsStream("/images/pepper.png"));
        }
        catch (IOException ioEx) {
            throw new RuntimeException(ioEx);
        }
        WizardDialog wizardDialog = this.asynchronous ? new AsynchronousWizardDialog(this.parent, wizard, worker, image){

            @Override
            protected void modifySize(JDialog dialog) {
                super.modifySize(dialog);
                AbstractImportAction.this.modifyWizardDialogSize(dialog);
            }
        } : new WizardDialog(this.parent, wizard, worker, image){

            @Override
            protected void handleException(RuntimeException runtimeException) {
                if (runtimeException.getCause() != null && runtimeException.getCause() instanceof ClientImportException) {
                    ClientImportException cause = (ClientImportException)runtimeException.getCause();
                    this.getResultPage().showResult(ModelEnviroment.getMessageResolver().resolveMessages(cause.getErrorMessages(), "\n"));
                } else {
                    this.getResultPage().showResult(runtimeException.getMessage());
                }
            }

            @Override
            protected void modifySize(JDialog dialog) {
                super.modifySize(dialog);
                AbstractImportAction.this.modifyWizardDialogSize(dialog);
            }
        };
        wizardDialog.show();
    }

    protected void modifyWizardDialogSize(JDialog dialog) {
    }

    protected Window getParent() {
        return this.parent;
    }
}

