/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.importer;

import de.datomino.peppergis.client.gui.common.CommonDialog;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.apache.commons.lang.exception.ExceptionUtils;

public abstract class MultiAdressChooserDialog<O>
extends CommonDialog {
    private static final long serialVersionUID = -3986350018297830899L;
    private List<O> results;
    private JList list;
    private boolean identifyable;
    private Exception ex;

    public MultiAdressChooserDialog(Component parent, List<O> results, boolean identifyable, boolean streetSelection) {
        this(parent, results, identifyable, streetSelection, null);
    }

    public MultiAdressChooserDialog(Component parent, List<O> results, boolean identifyable, boolean streetSelection, Exception ex) {
        super(parent, ModelEnviroment.getMessageResolver().resolveMessage("messages.default.pleaseChoose", new Serializable[0]), Dialog.ModalityType.APPLICATION_MODAL);
        this.results = results;
        this.identifyable = identifyable;
        this.ex = ex;
        int size = results.size();
        if (size == 0) {
            if (ex == null) {
                JOptionPane.showMessageDialog(parent, ModelEnviroment.getMessageResolver().resolveMessage("messages.locationNotFound", new Serializable[0]), ModelEnviroment.getMessageResolver().resolveMessage("messages.default.information", new Serializable[0]), 1);
            } else {
                JPanel panel = new JPanel(new BorderLayout());
                panel.add((Component)new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.locationNotFound", new Serializable[0])), "North");
                JTextArea text = new JTextArea(ExceptionUtils.getFullStackTrace(ex));
                text.setEditable(false);
                text.setRows(20);
                panel.add((Component)new JScrollPane(text), "Center");
                JOptionPane.showMessageDialog(parent, panel, ModelEnviroment.getMessageResolver().resolveMessage("messages.default.information", new Serializable[0]), 1);
            }
            if (streetSelection) {
                this.setValue(null, identifyable);
            }
        } else {
            int pSize = 0;
            HashSet<String> strings = new HashSet<String>();
            for (O o : results) {
                String string = this.getString(o);
                if (strings.contains(string)) continue;
                ++pSize;
                strings.add(string);
            }
            if (pSize == 1 && !streetSelection) {
                this.setValue(results.get(0), identifyable);
            } else {
                this.buildLayout();
                this.center();
                this.pack();
                this.setVisible(true);
            }
        }
    }

    protected abstract void setValue(O var1, boolean var2);

    protected abstract String getString(O var1);

    @Override
    protected Action getOkAction() {
        return new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("buttons.ok", new Serializable[0])){
            private static final long serialVersionUID = 2338290198063260337L;

            @Override
            public void actionPerformed(ActionEvent e) {
                int index = MultiAdressChooserDialog.this.list.getSelectedIndex();
                if (index >= 0) {
                    MultiAdressChooserDialog.this.setValue(MultiAdressChooserDialog.this.results.get(index), MultiAdressChooserDialog.this.identifyable);
                    MultiAdressChooserDialog.this.dispose();
                }
            }
        };
    }

    @Override
    protected Action getCancelAction() {
        return new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("buttons.cancel", new Serializable[0])){
            private static final long serialVersionUID = -2992933960321104257L;

            @Override
            public void actionPerformed(ActionEvent e) {
                MultiAdressChooserDialog.this.dispose();
            }
        };
    }

    @Override
    protected Component getMainComponent() {
        JPanel panel = new JPanel(new BorderLayout());
        DefaultListModel<String> dlm = new DefaultListModel<String>();
        this.list = new JList(dlm);
        this.list.setSelectionMode(0);
        for (O o : this.results) {
            String string = this.getString(o);
            if (dlm.contains(string)) continue;
            dlm.addElement(string);
        }
        panel.add((Component)new JScrollPane(this.list), "Center");
        return panel;
    }
}

