/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.importer;

import de.datomino.logistic.dto.LogisticLocationDto;
import de.datomino.logistic.dto.LogisticQualifiedLocationDto;
import de.datomino.logistic.dto.qualifiers.HibernateSearchLocationQualifierDescriptorDto;
import de.datomino.logistic.dto.qualifiers.KatasterSearchLocationQualifierDto;
import de.datomino.logistic.dto.qualifiers.NominatimLocationQualifierDescriptorDto;
import de.datomino.peppergis.client.gui.AbstractLayerRenderer;
import de.datomino.peppergis.client.gui.location.AbstractLocationEditorPane;
import de.datomino.peppergis.client.gui.location.GeomEditorMapPane;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.importer.AbstractGeocodeAction;
import de.datomino.peppergis.util.FormUtil;
import de.datomino.peppergis.util.GeoUtil;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.international.country.Country;
import de.datomino.util.international.country.CountryUtil;
import de.datomino.util.swing.SpringUtilities;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.table.DefaultTableModel;
import org.apache.commons.lang.ArrayUtils;
import org.ktde.math.projection.Coordinate;
import org.ktde.math.projection.Wgs84Factory;
import org.ktde.util.StringUtil;

public abstract class AbstractImportEditorPane
extends AbstractLocationEditorPane {
    private static final long serialVersionUID = -6434871994148054613L;
    protected int sizeOfFilters;
    protected JTextField country;
    protected JTextField postcode;
    protected JTextField city;
    protected JTextField district;
    protected JTextField street;
    protected JTextField housenumber;
    protected JTextField housenumberExtension;
    protected JFormattedTextField coordinateX;
    protected JFormattedTextField coordinateY;
    private JTextField country1;
    private JTextField postcode1;
    private JTextField city1;
    private JTextField district1;
    private JTextField street1;
    private JTextField housenumber1;
    private JTextField housenumberExtension1;
    protected GeomEditorMapPane coordinateEditorMapPane;
    protected Coordinate coordinate;
    protected JFormattedTextField coordinateX1;
    protected JFormattedTextField coordinateY1;
    protected JTextField matching1;
    protected JTextField matching;
    protected boolean addressModifiable = false;
    protected JComboBox[] filters;
    protected static final Comparator<Object> FILTER_COMPARATOR = new Comparator<Object>(){

        @Override
        public int compare(Object arg0, Object arg1) {
            if (arg0 == null && arg1 == null) {
                return 0;
            }
            if (arg0 == null) {
                return -1;
            }
            if (arg1 == null) {
                return 1;
            }
            return arg0.toString().compareToIgnoreCase(arg1.toString());
        }
    };

    public AbstractImportEditorPane(ModelEnviroment modelEnviroment, Properties properties, String addressModifiableProperty) {
        super(modelEnviroment, properties);
        try {
            this.addressModifiable = Boolean.parseBoolean(properties.getProperty(addressModifiableProperty));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected abstract void store();

    protected abstract void sortAndFilter();

    @Override
    protected void showLegendDialog(Object o) {
    }

    @Override
    protected JPanel createLeftPanel() {
        JPanel leftPanel = new JPanel(new BorderLayout());
        JSplitPane subLeftPanel = new JSplitPane(1);
        JPanel addressPanel = this.createAddressPanel();
        subLeftPanel.add(new JScrollPane(addressPanel));
        JPanel searchPanel = this.createSearchPanel();
        subLeftPanel.add(new JScrollPane(searchPanel));
        subLeftPanel.setResizeWeight(0.5);
        leftPanel.add((Component)subLeftPanel, "Center");
        return leftPanel;
    }

    @Override
    public void update() {
        this.coordinateEditorMapPane.setCoordinate(this.coordinateEditorMapPane.getCoordinateEditorLayerRenderer().getCoordinate(), true);
        this.coordinateEditorMapPane.setSegments(null, null, null, false);
        this.coordinate = this.coordinateEditorMapPane.getResult().getCoordinate();
        this.coordinateX1.setValue(this.coordinate.getX());
        this.coordinateY1.setValue(this.coordinate.getY());
        this.matching1.setText("100");
    }

    private JPanel createSearchPanel() {
        JPanel searchPanel = new JPanel(new BorderLayout());
        this.country1 = new JTextField(FormUtil.getStringWithLength(" ", 50));
        this.postcode1 = new JTextField();
        this.city1 = new JTextField();
        this.district1 = new JTextField();
        this.street1 = new JTextField();
        this.housenumber1 = new JTextField();
        this.housenumberExtension1 = new JTextField();
        this.coordinateX1 = new JFormattedTextField(new DecimalFormat("###,###,##0.000000"));
        this.coordinateY1 = new JFormattedTextField(new DecimalFormat("###,###,##0.000000"));
        this.matching1 = new JTextField();
        this.coordinateX1.setEditable(false);
        this.coordinateY1.setEditable(false);
        this.matching1.setEditable(false);
        JPanel addressPanel = new JPanel(new SpringLayout());
        String label1 = ModelEnviroment.getMessageResolver().resolveMessage("address.country", new Serializable[0]);
        String label2 = ModelEnviroment.getMessageResolver().resolveMessage("address.postcode", new Serializable[0]);
        String label3 = ModelEnviroment.getMessageResolver().resolveMessage("address.city", new Serializable[0]);
        String label4 = ModelEnviroment.getMessageResolver().resolveMessage("address.district", new Serializable[0]);
        String label5 = ModelEnviroment.getMessageResolver().resolveMessage("address.street", new Serializable[0]);
        String label6 = ModelEnviroment.getMessageResolver().resolveMessage("address.housenumber", new Serializable[0]);
        String label7 = ModelEnviroment.getMessageResolver().resolveMessage("address.housenumberExt", new Serializable[0]);
        String label8 = ModelEnviroment.getMessageResolver().resolveMessage("gis.coordinate.longitude", new Serializable[0]);
        String label9 = ModelEnviroment.getMessageResolver().resolveMessage("gis.coordinate.latitude", new Serializable[0]);
        String label10 = ModelEnviroment.getMessageResolver().resolveMessage("address.matching", new Serializable[0]);
        addressPanel.add(new JLabel(label1));
        addressPanel.add(this.country1);
        addressPanel.add(new JLabel(label2));
        addressPanel.add(this.postcode1);
        addressPanel.add(new JLabel(label3));
        addressPanel.add(this.city1);
        addressPanel.add(new JLabel(label4));
        addressPanel.add(this.district1);
        addressPanel.add(new JLabel(label5));
        addressPanel.add(this.street1);
        addressPanel.add(new JLabel(label6));
        addressPanel.add(this.housenumber1);
        addressPanel.add(new JLabel(label7));
        addressPanel.add(this.housenumberExtension1);
        addressPanel.add(new JLabel(label8));
        addressPanel.add(this.coordinateX1);
        addressPanel.add(new JLabel(label9));
        addressPanel.add(this.coordinateY1);
        addressPanel.add(new JLabel(label10));
        addressPanel.add(this.matching1);
        SpringUtilities.makeCompactGrid(addressPanel, 10, 2, 1, 1, 1, 1);
        JPanel buttonPane = new JPanel(new FlowLayout());
        buttonPane.add(new JButton(new AbstractGeocodeAction("Geokodieren", this.getModelEnviroment(), new NominatimLocationQualifierDescriptorDto(), false, this){
            private static final long serialVersionUID = -3309771093663632700L;

            @Override
            protected LogisticLocationDto<Long> getLogisticLocationDto() {
                AbstractImportEditorPane.this.matching1.setText("");
                LogisticLocationDto<Long> logisticLocationDto = new LogisticLocationDto<Long>(Long.valueOf(0L), null, null, CountryUtil.searchCountryFuzzy(AbstractImportEditorPane.this.country1.getText()), AbstractImportEditorPane.this.postcode1.getText(), AbstractImportEditorPane.this.city1.getText(), AbstractImportEditorPane.this.district1.getText(), AbstractImportEditorPane.this.street1.getText(), AbstractImportEditorPane.this.housenumber1.getText(), AbstractImportEditorPane.this.housenumberExtension1.getText());
                return logisticLocationDto;
            }

            @Override
            protected void setLogisticLocationDto(LogisticQualifiedLocationDto l, boolean identifyable) {
                AbstractImportEditorPane.this.setValues(l, identifyable);
            }
        }));
        buttonPane.add(new JButton(new AbstractGeocodeAction("Internes Geokodieren", this.getModelEnviroment(), new HibernateSearchLocationQualifierDescriptorDto(), false, this){
            private static final long serialVersionUID = -2387136885360626766L;

            @Override
            protected LogisticLocationDto<Long> getLogisticLocationDto() {
                LogisticLocationDto<Long> logisticLocationDto = new LogisticLocationDto<Long>(Long.valueOf(0L), null, null, CountryUtil.searchCountryFuzzy(AbstractImportEditorPane.this.country1.getText()), AbstractImportEditorPane.this.postcode1.getText(), AbstractImportEditorPane.this.city1.getText(), AbstractImportEditorPane.this.district1.getText(), AbstractImportEditorPane.this.street1.getText(), AbstractImportEditorPane.this.housenumber1.getText(), AbstractImportEditorPane.this.housenumberExtension1.getText());
                return logisticLocationDto;
            }

            @Override
            protected void setLogisticLocationDto(LogisticQualifiedLocationDto l, boolean identifyable) {
                AbstractImportEditorPane.this.setValues(l, identifyable);
            }
        }));
        buttonPane.add(new JButton(new AbstractGeocodeAction("Externes Geokodieren", this.getModelEnviroment(), new KatasterSearchLocationQualifierDto(), false, this){
            private static final long serialVersionUID = -7062144403127719849L;

            @Override
            protected LogisticLocationDto<Long> getLogisticLocationDto() {
                LogisticLocationDto<Long> logisticLocationDto = new LogisticLocationDto<Long>(Long.valueOf(0L), null, null, CountryUtil.searchCountryFuzzy(AbstractImportEditorPane.this.country1.getText()), AbstractImportEditorPane.this.postcode1.getText(), AbstractImportEditorPane.this.city1.getText(), AbstractImportEditorPane.this.district1.getText(), AbstractImportEditorPane.this.street1.getText(), AbstractImportEditorPane.this.housenumber1.getText(), AbstractImportEditorPane.this.housenumberExtension1.getText());
                return logisticLocationDto;
            }

            @Override
            protected void setLogisticLocationDto(LogisticQualifiedLocationDto l, boolean identifyable) {
                AbstractImportEditorPane.this.setValues(l, identifyable);
            }
        }));
        JPanel searchMainPane = new JPanel(new BorderLayout());
        searchMainPane.add((Component)addressPanel, "Center");
        searchMainPane.add((Component)buttonPane, "South");
        searchMainPane.setBorder(new TitledBorder(""));
        searchPanel.add((Component)searchMainPane, "Center");
        Box interchangeBox = new Box(1);
        interchangeBox.add(new JLabel("      "));
        BasicArrowButton toSearchButton = new BasicArrowButton(3);
        toSearchButton.setAction(new AbstractAction(){
            private static final long serialVersionUID = 7694645002663893667L;

            @Override
            public void actionPerformed(ActionEvent arg0) {
                AbstractImportEditorPane.this.setTextWithEquation(AbstractImportEditorPane.this.country1, AbstractImportEditorPane.this.country.getText(), AbstractImportEditorPane.this.country);
                AbstractImportEditorPane.this.setTextWithEquation(AbstractImportEditorPane.this.postcode1, AbstractImportEditorPane.this.postcode.getText(), AbstractImportEditorPane.this.postcode);
                AbstractImportEditorPane.this.setTextWithEquation(AbstractImportEditorPane.this.city1, AbstractImportEditorPane.this.city.getText(), AbstractImportEditorPane.this.city);
                AbstractImportEditorPane.this.setTextWithEquation(AbstractImportEditorPane.this.district1, AbstractImportEditorPane.this.district.getText(), AbstractImportEditorPane.this.district);
                AbstractImportEditorPane.this.setTextWithEquation(AbstractImportEditorPane.this.street1, AbstractImportEditorPane.this.street.getText(), AbstractImportEditorPane.this.street);
                AbstractImportEditorPane.this.setTextWithEquation(AbstractImportEditorPane.this.housenumber1, AbstractImportEditorPane.this.housenumber.getText(), AbstractImportEditorPane.this.housenumber);
                AbstractImportEditorPane.this.setTextWithEquation(AbstractImportEditorPane.this.housenumberExtension1, AbstractImportEditorPane.this.housenumberExtension.getText(), AbstractImportEditorPane.this.housenumberExtension);
                AbstractImportEditorPane.this.coordinateX1.setValue(AbstractImportEditorPane.this.coordinateX.getValue());
                AbstractImportEditorPane.this.coordinateY1.setValue(AbstractImportEditorPane.this.coordinateY.getValue());
                AbstractImportEditorPane.this.coordinateEditorMapPane.setCoordinate(AbstractImportEditorPane.this.coordinate, true);
                if (AbstractImportEditorPane.this.matching == null) {
                    AbstractImportEditorPane.this.matching1.setText(null);
                } else {
                    AbstractImportEditorPane.this.matching.setText(null);
                }
            }
        });
        interchangeBox.add(toSearchButton);
        interchangeBox.add(new JLabel("      "));
        BasicArrowButton toAddressButton = new BasicArrowButton(7);
        toAddressButton.setAction(new AbstractAction(){
            private static final long serialVersionUID = -3222209051546835022L;

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (AbstractImportEditorPane.this.addressModifiable) {
                    AbstractImportEditorPane.this.setTextWithEquation(AbstractImportEditorPane.this.country, AbstractImportEditorPane.this.country1.getText(), AbstractImportEditorPane.this.country1);
                    AbstractImportEditorPane.this.setTextWithEquation(AbstractImportEditorPane.this.postcode, AbstractImportEditorPane.this.postcode1.getText(), AbstractImportEditorPane.this.postcode1);
                    AbstractImportEditorPane.this.setTextWithEquation(AbstractImportEditorPane.this.city, AbstractImportEditorPane.this.city1.getText(), AbstractImportEditorPane.this.city1);
                    AbstractImportEditorPane.this.setTextWithEquation(AbstractImportEditorPane.this.district, AbstractImportEditorPane.this.district1.getText(), AbstractImportEditorPane.this.district1);
                    AbstractImportEditorPane.this.setTextWithEquation(AbstractImportEditorPane.this.street, AbstractImportEditorPane.this.street1.getText(), AbstractImportEditorPane.this.street1);
                    AbstractImportEditorPane.this.setTextWithEquation(AbstractImportEditorPane.this.housenumber, AbstractImportEditorPane.this.housenumber1.getText(), AbstractImportEditorPane.this.housenumber1);
                    AbstractImportEditorPane.this.setTextWithEquation(AbstractImportEditorPane.this.housenumberExtension, AbstractImportEditorPane.this.housenumberExtension1.getText(), AbstractImportEditorPane.this.housenumberExtension1);
                }
                if (AbstractImportEditorPane.this.matching != null) {
                    AbstractImportEditorPane.this.matching.setText(AbstractImportEditorPane.this.matching1.getText());
                }
                try {
                    Double d = Double.parseDouble(AbstractImportEditorPane.this.matching1.getText());
                    if (d >= 99.0) {
                        AbstractImportEditorPane.this.coordinateX.setValue(AbstractImportEditorPane.this.coordinateX1.getValue());
                        AbstractImportEditorPane.this.coordinateY.setValue(AbstractImportEditorPane.this.coordinateY1.getValue());
                    } else {
                        AbstractImportEditorPane.this.coordinateX.setValue(null);
                        AbstractImportEditorPane.this.coordinateY.setValue(null);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        interchangeBox.add(toAddressButton);
        interchangeBox.add(new JLabel("      "));
        interchangeBox.setBorder(new EmptyBorder(0, 10, 0, 10));
        searchPanel.add((Component)interchangeBox, "West");
        return searchPanel;
    }

    private void setTextWithEquation(JTextField field1, String s, JTextField field) {
        String string = s = s == null ? "" : s;
        if (s.equals(field.getText())) {
            field1.setForeground(Color.BLACK);
        } else {
            field1.setForeground(Color.RED);
        }
        field1.setText(s);
    }

    private JPanel createAddressPanel() {
        this.country = new JTextField(FormUtil.getStringWithLength(" ", 50));
        this.country.setEditable(false);
        this.postcode = new JTextField();
        this.postcode.setEditable(false);
        this.city = new JTextField();
        this.city.setEditable(false);
        this.district = new JTextField();
        this.district.setEditable(false);
        this.street = new JTextField();
        this.street.setEditable(false);
        this.housenumber = new JTextField();
        this.housenumber.setEditable(false);
        this.housenumberExtension = new JTextField();
        this.housenumberExtension.setEditable(false);
        this.coordinateX = new JFormattedTextField(new DecimalFormat("###,###,##0.000000"));
        this.coordinateX.setEditable(false);
        this.coordinateY = new JFormattedTextField(new DecimalFormat("###,###,##0.000000"));
        this.coordinateY.setEditable(false);
        JPanel addressPanel = new JPanel(new SpringLayout());
        String label1 = ModelEnviroment.getMessageResolver().resolveMessage("address.country", new Serializable[0]);
        String label2 = ModelEnviroment.getMessageResolver().resolveMessage("address.postcode", new Serializable[0]);
        String label3 = ModelEnviroment.getMessageResolver().resolveMessage("address.city", new Serializable[0]);
        String label4 = ModelEnviroment.getMessageResolver().resolveMessage("address.district", new Serializable[0]);
        String label5 = ModelEnviroment.getMessageResolver().resolveMessage("address.street", new Serializable[0]);
        String label6 = ModelEnviroment.getMessageResolver().resolveMessage("address.housenumber", new Serializable[0]);
        String label7 = ModelEnviroment.getMessageResolver().resolveMessage("address.housenumberExt", new Serializable[0]);
        String label8 = ModelEnviroment.getMessageResolver().resolveMessage("gis.coordinate.longitude", new Serializable[0]);
        String label9 = ModelEnviroment.getMessageResolver().resolveMessage("gis.coordinate.latitude", new Serializable[0]);
        addressPanel.add(new JLabel(label1));
        addressPanel.add(this.country);
        addressPanel.add(new JLabel(label2));
        addressPanel.add(this.postcode);
        addressPanel.add(new JLabel(label3));
        addressPanel.add(this.city);
        addressPanel.add(new JLabel(label4));
        addressPanel.add(this.district);
        addressPanel.add(new JLabel(label5));
        addressPanel.add(this.street);
        addressPanel.add(new JLabel(label6));
        addressPanel.add(this.housenumber);
        addressPanel.add(new JLabel(label7));
        addressPanel.add(this.housenumberExtension);
        addressPanel.add(new JLabel(label8));
        addressPanel.add(this.coordinateX);
        addressPanel.add(new JLabel(label9));
        addressPanel.add(this.coordinateY);
        addressPanel.add(new JLabel("  "));
        addressPanel.add(new JLabel("  "));
        SpringUtilities.makeCompactGrid(addressPanel, 10, 2, 1, 1, 1, 1);
        JPanel buttonPane = new JPanel(new FlowLayout());
        buttonPane.add(new JButton(new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.save", new Serializable[0])){
            private static final long serialVersionUID = 1958512875661163425L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AbstractImportEditorPane.this.isAllowedAddress()) {
                    AbstractImportEditorPane.this.store();
                }
            }
        }));
        JPanel mainPane = new JPanel(new BorderLayout());
        mainPane.add((Component)addressPanel, "Center");
        mainPane.add((Component)buttonPane, "South");
        mainPane.setBorder(new TitledBorder(""));
        return mainPane;
    }

    protected boolean isAllowedAddress() {
        boolean allowed = true;
        if (this.addressModifiable) {
            Country c = CountryUtil.searchCountryFuzzy(this.country.getText());
            if (c == null) {
                int d = JOptionPane.showConfirmDialog(this, "Das Land ist nicht vorhanden. Wollen Sie trotzdem die Adresse speichern?", ModelEnviroment.getMessageResolver().resolveMessage("messages.default.confirm", new Serializable[0]), 2);
                switch (d) {
                    case 0: {
                        allowed = true;
                    }
                }
                allowed = false;
            }
            if (allowed) {
                boolean postcodeCanBlank = false;
                String postcodeDummy = "00000";
                try {
                    postcodeCanBlank = Boolean.parseBoolean(ModelEnviroment.getProperties().getProperty("importeditor.postcode.canBlank"));
                    postcodeDummy = ModelEnviroment.getProperties().getProperty("importeditor.postcode.dummyName").replaceAll("\"", "");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                boolean cityCanBlank = false;
                String cityDummy = "   ";
                try {
                    cityCanBlank = Boolean.parseBoolean(ModelEnviroment.getProperties().getProperty("importeditor.city.canBlank"));
                    cityDummy = ModelEnviroment.getProperties().getProperty("importeditor.city.dummyName").replaceAll("\"", "");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                boolean streetCanBlank = false;
                String streetDummy = "   ";
                try {
                    streetCanBlank = Boolean.parseBoolean(ModelEnviroment.getProperties().getProperty("importeditor.street.canBlank"));
                    streetDummy = ModelEnviroment.getProperties().getProperty("importeditor.street.dummyName").replaceAll("\"", "");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (StringUtil.isBlank(this.postcode.getText())) {
                    if (postcodeCanBlank) {
                        this.postcode.setText(postcodeDummy);
                    } else {
                        allowed = false;
                    }
                }
                if (StringUtil.isBlank(this.city.getText())) {
                    if (cityCanBlank) {
                        this.city.setText(cityDummy);
                    } else {
                        allowed = false;
                    }
                }
                if (StringUtil.isBlank(this.street.getText())) {
                    if (streetCanBlank) {
                        this.street.setText(streetDummy);
                    } else {
                        allowed = false;
                    }
                }
            }
            if (!allowed) {
                JOptionPane.showMessageDialog(this, "Die Adresse ist nicht vollst\u00e4ndig.");
            }
        }
        return allowed;
    }

    @Override
    protected JComponent createMapPanel() {
        if (this.coordinateEditorMapPane == null) {
            this.coordinateEditorMapPane = new GeomEditorMapPane(this, false, false){
                private static final long serialVersionUID = 6125685229028694479L;

                @Override
                protected void doAfterFindingCoordinate(ImmutablePoint point) {
                    super.doAfterFindingCoordinate(point);
                    AbstractImportEditorPane.this.doAfterFindingCoordinate(point);
                    ImmutablePoint pointToSet = (ImmutablePoint)point.getTransformed(Wgs84Factory.INSTANCE);
                    AbstractImportEditorPane.this.coordinateEditorMapPane.getxSpinner().setValue(pointToSet.getX());
                    AbstractImportEditorPane.this.coordinateEditorMapPane.getySpinner().setValue(pointToSet.getY());
                    AbstractImportEditorPane.this.coordinateEditorMapPane.update();
                }
            };
        }
        this.coordinateEditorMapPane.setCoordinate(null, true);
        return this.coordinateEditorMapPane;
    }

    protected abstract void doAfterFindingCoordinate(ImmutablePoint var1);

    @Override
    protected AbstractLayerRenderer getLayerRenderer() {
        return null;
    }

    protected void clearAddress() {
        this.country.setText("");
        this.city.setText("");
        this.district.setText("");
        this.postcode.setText("");
        this.street.setText("");
        this.housenumber.setText("");
        this.housenumberExtension.setText("");
        this.coordinateX.setText("");
        this.coordinateY.setText("");
        this.coordinateEditorMapPane.setCoordinate(null, true);
        super.repaint(10L);
    }

    protected String getFormatedString(String string) {
        return " \n" + string + "\n \n";
    }

    private void setValues(LogisticQualifiedLocationDto l, boolean identifyable) {
        String s = l.getCountry() == null ? "" : l.getCountry().getIso3166_2();
        this.setTextWithEquation(this.country1, s, this.country);
        this.setTextWithEquation(this.postcode1, l.getPostcode(), this.postcode);
        this.setTextWithEquation(this.city1, l.getCity(), this.city);
        this.setTextWithEquation(this.district1, l.getDistrict(), this.district);
        this.setTextWithEquation(this.street1, l.getStreet(), this.street);
        this.setTextWithEquation(this.housenumber1, l.getHousenumber(), this.housenumber);
        this.setTextWithEquation(this.housenumberExtension1, l.getExtension(), this.housenumberExtension);
        if (l.getGeom() != null && l.getGeom().getGeoObject() != null) {
            Coordinate c;
            this.coordinateEditorMapPane.setCoordinate(((ImmutablePoint)l.getGeom().getGeoObject()).getCoordinate(), false);
            this.coordinateEditorMapPane.setSegments(null, null, null, false);
            this.coordinateEditorMapPane.gotoCoordinate();
            this.coordinate = c = this.coordinateEditorMapPane.getCoordinateOnMap();
            this.coordinateX1.setValue(c.getX());
            this.coordinateY1.setValue(c.getY());
        } else {
            this.coordinateX1.setValue(0.0);
            this.coordinateY1.setValue(0.0);
        }
        Double matchingValue = l.getMatching();
        this.matching1.setText(matchingValue == null ? "" : matchingValue.toString());
        this.setAdditionalValues(l, identifyable);
    }

    protected void setAdditionalValues(LogisticQualifiedLocationDto l, boolean identifyable) {
    }

    protected void fillFilters(Object[][] dataVector, boolean initFilters) {
        if (initFilters) {
            Set<Integer> excludedColumns = this.getExcludedFilterColumns();
            for (int column = 1; column < this.sizeOfFilters; ++column) {
                if (excludedColumns != null && excludedColumns.contains(column)) continue;
                this.filters[column] = this.createFilterComoBox(dataVector, column);
            }
        }
    }

    protected Set<Integer> getExcludedFilterColumns() {
        return null;
    }

    protected JComboBox createFilterComoBox(Object[][] dataVector, int column) {
        HashSet<Object> valueSet = new HashSet<Object>();
        for (int row = 0; row < dataVector.length; ++row) {
            Object object = dataVector[row][column];
            if (object == null || StringUtil.isBlank(object.toString())) continue;
            if (object instanceof Collection) {
                valueSet.addAll((Collection)object);
                continue;
            }
            valueSet.add(object);
        }
        return this.createComboBox(valueSet);
    }

    protected JComboBox createComboBox(Set<Object> valueSet) {
        Vector<Object> vector = new Vector<Object>(valueSet);
        Collections.sort(vector, FILTER_COMPARATOR);
        vector.add(0, null);
        JComboBox<Object> comboBox = new JComboBox<Object>(vector);
        comboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                AbstractImportEditorPane.this.sortAndFilter();
            }
        });
        comboBox.setCursor(Cursor.getDefaultCursor());
        return comboBox;
    }

    protected JButton createPasteCoordinateButton() {
        return new JButton(new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.parcel.insertCoordinates", new Serializable[0])){
            private static final long serialVersionUID = 6587879180965881507L;

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    String data = (String)Toolkit.getDefaultToolkit().getSystemClipboard().getData(DataFlavor.stringFlavor);
                    StringTokenizer st = new StringTokenizer(data, " ,;/");
                    double y = Double.parseDouble(st.nextToken().trim());
                    double x = Double.parseDouble(st.nextToken().trim());
                    Coordinate coord = Wgs84Factory.INSTANCE.createCoordinate(x, y);
                    if (GeoUtil.isNullCoordinate(coord)) {
                        String message = ModelEnviroment.getMessageResolver().resolveMessage("messages.error.invalidCoordinate", new Serializable[0]) + " - " + x + ", " + y;
                        JOptionPane.showMessageDialog(AbstractImportEditorPane.this, message, ModelEnviroment.getMessageResolver().resolveMessage("messages.default.warning", new Serializable[0]), 2);
                    } else {
                        AbstractImportEditorPane.this.coordinateEditorMapPane.setCoordinate(coord, true);
                        AbstractImportEditorPane.this.coordinateEditorMapPane.update();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    @Override
    protected Double getResizeWeight() {
        return 0.5;
    }

    protected class EditableCellTableModel
    extends DefaultTableModel {
        private static final long serialVersionUID = 3005132323711566340L;

        public EditableCellTableModel(Object[][] tableData, Object[] colNames) {
            super(tableData, colNames);
        }

        protected int[] getEditableColumns() {
            return new int[]{1, 13, 14, 15, 16, 17, 18, 19, 20};
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return ArrayUtils.contains(this.getEditableColumns(), column);
        }
    }
}

