/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.helper;

import de.datomino.peppergis.dto.base.ExternalLocationFullDto;
import de.datomino.peppergis.dto.base.ImportedLocationFullDto;
import de.datomino.peppergis.dto.base.LocationFullDto;
import de.datomino.peppergis.helper.CommonLocationWrapper;
import de.datomino.peppergis.helper.ExternalLocationDtoWrapper;
import de.datomino.peppergis.helper.ImportedLocationDtoWrapper;

public final class LocationDtoWrapperFactory {
    private static final LocationDtoWrapperFactory INSTANCE = new LocationDtoWrapperFactory();

    protected LocationDtoWrapperFactory() {
    }

    public static LocationDtoWrapperFactory getInstance() {
        return INSTANCE;
    }

    public CommonLocationWrapper createLocationWrapper(LocationFullDto locationDo) {
        ExternalLocationFullDto externalLocationDo = (ExternalLocationFullDto)locationDo.getExternalLocation();
        if (externalLocationDo != null) {
            return new ExternalLocationDtoWrapper(externalLocationDo);
        }
        ImportedLocationFullDto importedLocationDo = (ImportedLocationFullDto)locationDo.getImportedLocation();
        if (importedLocationDo != null) {
            return new ImportedLocationDtoWrapper(importedLocationDo);
        }
        return null;
    }
}

