/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.dto.asynchronous;

import java.io.Serializable;
import java.util.Arrays;

public class AsynchronousGeneralDto<T>
implements Serializable {
    private static final long serialVersionUID = 5058371116326654808L;
    private Status status;
    private String prefix;
    private String mainMessageKey;
    private Serializable[] mainMessageArgs;
    protected String[] progressBarMessageKeys;
    protected Serializable[][] progressBarMessageArgs;
    protected int[] percent;
    private T result;
    private Exception exception;
    private boolean markedForCancel = false;

    public AsynchronousGeneralDto() {
    }

    public AsynchronousGeneralDto(int progressBarCount) {
        this.percent = new int[progressBarCount];
        Arrays.fill(this.percent, 0);
        this.progressBarMessageKeys = new String[progressBarCount];
        this.progressBarMessageArgs = new Serializable[progressBarCount][];
    }

    public Status getStatus() {
        return this.status;
    }

    public T getResult() {
        return this.result;
    }

    public Exception getException() {
        return this.exception;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public void setResult(T result) {
        this.result = result;
    }

    public void setException(Exception exception) {
        this.exception = exception;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setMainMessage(String messageKey, Serializable ... args) {
        this.mainMessageKey = messageKey;
        this.mainMessageArgs = args;
    }

    public String getMainMessageKey() {
        return this.mainMessageKey;
    }

    public Serializable[] getMainMessageArgs() {
        return this.mainMessageArgs;
    }

    public void setPercent(int percent, int progressBarIndex) {
        if (progressBarIndex >= 0 && progressBarIndex < this.percent.length) {
            this.percent[progressBarIndex] = percent;
        }
    }

    public int[] getPercent() {
        return this.percent;
    }

    public void setProgressBarMessage(String messageKeys, Serializable[] args, int progressBarIndex) {
        if (progressBarIndex >= 0 && progressBarIndex < this.progressBarMessageKeys.length) {
            this.progressBarMessageKeys[progressBarIndex] = messageKeys;
            this.progressBarMessageArgs[progressBarIndex] = args;
        }
    }

    public String[] getProgressBarMessageKeys() {
        return this.progressBarMessageKeys;
    }

    public Serializable[][] getProgressBarMessageArgs() {
        return this.progressBarMessageArgs;
    }

    public void setMarkedForCancel(boolean markedForCancel) {
        this.markedForCancel = markedForCancel;
    }

    public boolean isMarkedForCancel() {
        return this.markedForCancel;
    }

    public static enum Status {
        RUNNING,
        ERROR,
        SUCCESS,
        CANCELED;

    }
}

