/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.datamanager.util;

import de.datomino.peppergis.client.model.map.ParcelAttributeValueDescriptorModel;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import org.ktde.util.datatypes.Tripel;

public class FiltersBodyAttributes {
    private final ParcelAttributeValueDescriptorModel[] fieldValues;
    private Map<ParcelAttributeValueDescriptorModel, Tripel<? extends JPanel, JCheckBox, JCheckBox>> fieldMap = new LinkedHashMap<ParcelAttributeValueDescriptorModel, Tripel<? extends JPanel, JCheckBox, JCheckBox>>();
    private Map<ParcelAttributeValueDescriptorModel, Object> appliedDataMap = new LinkedHashMap<ParcelAttributeValueDescriptorModel, Object>();
    private Set<ParcelAttributeValueDescriptorModel> fieldsToShowInResult;
    private Set<ParcelAttributeValueDescriptorModel> mandatoryFields;
    private Map<ParcelAttributeValueDescriptorModel, Set<ParcelAttributeValueDescriptorModel>> headlines;
    private boolean changed;

    public FiltersBodyAttributes(ParcelAttributeValueDescriptorModel[] fs) {
        this.fieldValues = fs;
        this.fieldsToShowInResult = new LinkedHashSet<ParcelAttributeValueDescriptorModel>();
        this.mandatoryFields = new LinkedHashSet<ParcelAttributeValueDescriptorModel>();
        this.headlines = new LinkedHashMap<ParcelAttributeValueDescriptorModel, Set<ParcelAttributeValueDescriptorModel>>();
        this.clearChanged();
    }

    public ParcelAttributeValueDescriptorModel[] getAllFields() {
        return this.fieldValues;
    }

    public Map<ParcelAttributeValueDescriptorModel, Tripel<? extends JPanel, JCheckBox, JCheckBox>> getFieldMap() {
        return this.fieldMap;
    }

    public void put(ParcelAttributeValueDescriptorModel key, Object value) {
        if ((value != null || this.isSearchForNullValues(key)) && (this.changed |= !this.appliedDataMap.containsKey(key) || !this.mapEntryEquals(key, value))) {
            this.appliedDataMap.put(key, value);
        }
    }

    private boolean mapEntryEquals(ParcelAttributeValueDescriptorModel key, Object value) {
        return this.appliedDataMap.get(key) == null ? value == null : this.appliedDataMap.get(key).equals(value);
    }

    public void removeNull(ParcelAttributeValueDescriptorModel key) {
        if (this.appliedDataMap.containsKey(key) && this.appliedDataMap.get(key) == null) {
            this.remove(key);
        }
    }

    public void remove(ParcelAttributeValueDescriptorModel key) {
        this.changed |= this.appliedDataMap.containsKey(key);
        this.appliedDataMap.remove(key);
    }

    public Map<ParcelAttributeValueDescriptorModel, Object> getAppliedDataMap() {
        return this.appliedDataMap;
    }

    public Set<ParcelAttributeValueDescriptorModel> getFieldsToShowInResult() {
        return this.fieldsToShowInResult;
    }

    public Set<ParcelAttributeValueDescriptorModel> getMandatoryFields() {
        return this.mandatoryFields;
    }

    public boolean isMandatory(ParcelAttributeValueDescriptorModel e) {
        return this.mandatoryFields.contains(e);
    }

    public JPanel getFilterField(ParcelAttributeValueDescriptorModel field) {
        if (this.headlines.containsKey(field)) {
            throw new RuntimeException("Field must not be a headline!");
        }
        return this.fieldMap.get(field).getElement1();
    }

    public boolean isSearchForNullValues(ParcelAttributeValueDescriptorModel field) {
        if (this.headlines.containsKey(field)) {
            throw new RuntimeException("Field must not be a headline!");
        }
        return this.fieldMap.get(field).getElement3() != null && this.fieldMap.get(field).getElement3().isSelected();
    }

    public JCheckBox getCheckBox(ParcelAttributeValueDescriptorModel field) {
        if (this.headlines.containsKey(field)) {
            throw new RuntimeException("Field must not be a headline!");
        }
        return this.fieldMap.get(field).getElement2();
    }

    public Set<ParcelAttributeValueDescriptorModel> getAppliedDataKeys() {
        return this.appliedDataMap.keySet();
    }

    public ParcelAttributeValueDescriptorModel[] getFieldValues() {
        return this.fieldValues;
    }

    public Map<ParcelAttributeValueDescriptorModel, Set<ParcelAttributeValueDescriptorModel>> getHeadlines() {
        return this.headlines;
    }

    public void clear() {
        this.appliedDataMap.clear();
    }

    public void clear(Set<ParcelAttributeValueDescriptorModel> fieldsToShowInResult) {
        this.clear();
        this.fieldsToShowInResult.clear();
        if (fieldsToShowInResult != null) {
            for (ParcelAttributeValueDescriptorModel e : fieldsToShowInResult) {
                this.fieldsToShowInResult.add(e);
            }
        }
    }

    public boolean hasChanged() {
        return this.changed;
    }

    public void clearChanged() {
        this.changed = false;
    }

    public Collection<ParcelAttributeValueDescriptorModel> getVisibleFields(boolean withHeadlines) {
        return this.getVisibleFields(new VisibilityChecker<ParcelAttributeValueDescriptorModel>(), withHeadlines);
    }

    public Collection<ParcelAttributeValueDescriptorModel> getVisibleFields(VisibilityChecker<ParcelAttributeValueDescriptorModel> checker, boolean withHeadlines) {
        LinkedList<ParcelAttributeValueDescriptorModel> visibleFieldList = new LinkedList<ParcelAttributeValueDescriptorModel>();
        ParcelAttributeValueDescriptorModel head = null;
        HashSet body = null;
        HashMap<ParcelAttributeValueDescriptorModel, Set<ParcelAttributeValueDescriptorModel>> heads = withHeadlines ? new HashMap<ParcelAttributeValueDescriptorModel, Set<ParcelAttributeValueDescriptorModel>>(this.getHeadlines()) : null;
        for (ParcelAttributeValueDescriptorModel f : this.getFieldValues()) {
            if (withHeadlines && heads.get(f) != null) {
                head = f;
                body = new HashSet((Collection)heads.get(f));
                heads.remove(f);
            }
            if (!checker.check(f)) continue;
            if (body != null && body.contains(f)) {
                body.clear();
                visibleFieldList.add(head);
            }
            visibleFieldList.add(f);
        }
        return visibleFieldList;
    }

    private class VisibilityChecker<E> {
        private VisibilityChecker() {
        }

        public boolean check(E e) {
            return true;
        }
    }
}

