/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.datamanager.renderer;

import de.datomino.logistic.type.RouteVehicleType;
import de.datomino.peppergis.PeppergisConstants;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.gui.renderer.AbstractLineRenderer;
import de.datomino.peppergis.client.gui.renderer.DashLineColorRenderer;
import de.datomino.peppergis.client.gui.renderer.SolidLineRenderer;
import de.datomino.peppergis.client.gui.renderer.TripleDashLineColorRenderer;
import de.datomino.peppergis.client.model.Model;
import de.datomino.peppergis.client.model.base.LocationModel;
import de.datomino.peppergis.client.model.map.ParcelModel;
import de.datomino.peppergis.client.model.map.SegmentModel;
import de.datomino.peppergis.client.util.LocationModelUtil;
import de.datomino.peppergis.client.util.ParcelModelUtil;
import de.datomino.peppergis.client.util.model.location.LocationWrapperFactory;
import de.datomino.peppergis.util.GeoUtil;
import de.datomino.util.geo.AbstractImmutableGeoObject;
import de.datomino.util.geo.ImmutableGeoObjectFactory;
import de.datomino.util.geo.ImmutableLineString;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.geo.util.GeoUtils;
import java.awt.Color;
import java.awt.Graphics2D;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.ktde.math.projection.OpenStreetmapViewFactory;
import org.ktde.util.datatypes.Tupel;

public class DataManagerJunctionRenderModule {
    private EnumSet<RouteVehicleType> types;
    private ModelEnviroment modelEnvironment;

    public DataManagerJunctionRenderModule(ModelEnviroment modelEnvironment) {
        this.modelEnvironment = modelEnvironment;
        this.types = EnumSet.noneOf(RouteVehicleType.class);
    }

    public void render(Graphics2D g2d, double upp, LocationModel location) {
        LocationJunctionPreProcessor processor = new LocationJunctionPreProcessor(location, this.types, this.modelEnvironment);
        this.renderInternal(g2d, upp, processor);
    }

    public void render(Graphics2D g2d, double upp, ParcelModel parcel) {
        if (parcel != null) {
            ParcelJunctionPreprocessor processor = new ParcelJunctionPreprocessor(parcel, this.types, this.modelEnvironment);
            this.renderInternal(g2d, upp, processor);
        }
    }

    private void renderInternal(Graphics2D g2d, double upp, AbstractJunctionPreProcessor<? extends Model> processor) {
        for (Map.Entry<SegmentModel, EnumSet<RouteVehicleType>> entry : processor.getSegmentTypeEntries()) {
            this.renderInternal(g2d, upp, entry.getKey(), processor.getLocationPoint(), entry.getValue());
        }
    }

    private void renderInternal(Graphics2D g2d, double upp, SegmentModel segment, ImmutablePoint locationPoint, EnumSet<RouteVehicleType> types) {
        Iterator iterator = types.iterator();
        if (iterator.hasNext()) {
            AbstractLineRenderer renderer;
            Tupel<Color, Color> colorTupel;
            Color color1 = DataManagerJunctionRenderModule.getColor((RouteVehicleType)((Object)iterator.next()));
            if (iterator.hasNext()) {
                colorTupel = new Tupel<Color, Color>(color1, DataManagerJunctionRenderModule.getColor((RouteVehicleType)((Object)iterator.next())));
                renderer = iterator.hasNext() ? new TripleDashLineColorRenderer(upp, false, OpenStreetmapViewFactory.INSTANCE, DataManagerJunctionRenderModule.getColor((RouteVehicleType)((Object)iterator.next()))) : new DashLineColorRenderer(upp, false, OpenStreetmapViewFactory.INSTANCE);
            } else {
                colorTupel = new Tupel<Color, Color>(color1, color1);
                renderer = new SolidLineRenderer(upp, false, OpenStreetmapViewFactory.INSTANCE);
            }
            ImmutableLineString lineString = segment.getGeom();
            ImmutablePoint nearestPoint = GeoUtil.getShortestPerpendicular(locationPoint, lineString).getElement2();
            AbstractImmutableGeoObject geoObject = GeoUtils.getLineString(locationPoint, nearestPoint);
            if (geoObject instanceof ImmutableLineString) {
                renderer.render(g2d, (ImmutableLineString)geoObject, colorTupel, 1.0f);
            }
        }
    }

    private static Color getColor(RouteVehicleType type) {
        switch (type) {
            case BIKE: {
                return PeppergisConstants.BIKE_SEGMENT_COLOR;
            }
            case FOOT: {
                return PeppergisConstants.FOOT_SEGMENT_COLOR;
            }
            case MOTORCAR: {
                return PeppergisConstants.MOTOR_SEGMENT_COLOR;
            }
        }
        return PeppergisConstants.STREET_COLOR;
    }

    public boolean isActive() {
        return !this.types.isEmpty();
    }

    public EnumSet<RouteVehicleType> getTypes() {
        return this.types;
    }

    public void setType(RouteVehicleType type) {
        this.clearType();
        this.addType(type);
    }

    public void clearType() {
        this.types.clear();
    }

    public void addType(RouteVehicleType type) {
        if (type != null) {
            this.types.add(type);
        }
    }

    public void removeType(RouteVehicleType type) {
        if (type != null) {
            this.types.remove((Object)type);
        }
    }

    private class LocationJunctionPreProcessor
    extends AbstractJunctionPreProcessor<LocationModel> {
        public LocationJunctionPreProcessor(LocationModel model, EnumSet<RouteVehicleType> types, ModelEnviroment modelEnvironment) {
            super(DataManagerJunctionRenderModule.this, (Model)model, types, modelEnvironment);
        }

        @Override
        protected SegmentModel getSegment(LocationModel model, RouteVehicleType type, ModelEnviroment modelEnvironment) {
            return LocationModelUtil.getRouteSegment(model, type, modelEnvironment);
        }

        @Override
        protected ImmutablePoint getImmutablePoint(LocationModel model) {
            return LocationWrapperFactory.INSTANCE.createLocationWrapper(model).getGeoLocation();
        }
    }

    private class ParcelJunctionPreprocessor
    extends AbstractJunctionPreProcessor<ParcelModel> {
        public ParcelJunctionPreprocessor(ParcelModel model, EnumSet<RouteVehicleType> types, ModelEnviroment modelEnvironment) {
            super(DataManagerJunctionRenderModule.this, (Model)model, types, modelEnvironment);
        }

        @Override
        protected SegmentModel getSegment(ParcelModel model, RouteVehicleType type, ModelEnviroment modelEnvironment) {
            return ParcelModelUtil.getRouteSegment(model, type);
        }

        @Override
        protected ImmutablePoint getImmutablePoint(ParcelModel model) {
            return ImmutableGeoObjectFactory.createImmutablePoint(model.getGeom().getCoordinate());
        }
    }

    private static abstract class AbstractJunctionPreProcessor<M extends Model> {
        private Map<SegmentModel, EnumSet<RouteVehicleType>> segmentTypeMap = new HashMap<SegmentModel, EnumSet<RouteVehicleType>>();
        private ImmutablePoint locationPoint;
        final /* synthetic */ DataManagerJunctionRenderModule this$0;

        public AbstractJunctionPreProcessor(M model, EnumSet<RouteVehicleType> types, ModelEnviroment modelEnvironment) {
            this.this$0 = var1_1;
            for (RouteVehicleType type : types) {
                SegmentModel segment = this.getSegment(model, type, modelEnvironment);
                if (segment == null) continue;
                if (this.segmentTypeMap.get(segment) == null) {
                    this.segmentTypeMap.put(segment, EnumSet.of(type));
                }
                this.segmentTypeMap.get(segment).add(type);
            }
            this.locationPoint = this.getImmutablePoint(model);
        }

        public Set<Map.Entry<SegmentModel, EnumSet<RouteVehicleType>>> getSegmentTypeEntries() {
            return this.segmentTypeMap.entrySet();
        }

        public ImmutablePoint getLocationPoint() {
            return this.locationPoint;
        }

        protected abstract SegmentModel getSegment(M var1, RouteVehicleType var2, ModelEnviroment var3);

        protected abstract ImmutablePoint getImmutablePoint(M var1);
    }
}

