/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.datamanager.renderer;

import de.datomino.peppergis.client.gui.AbstractListCellRenderer;
import de.datomino.peppergis.client.model.Model;
import de.datomino.peppergis.client.model.base.LetterModel;
import de.datomino.peppergis.client.model.base.PoiModel;
import de.datomino.peppergis.client.model.base.SubscriptionModel;
import de.datomino.peppergis.client.model.map.ParcelModel;
import de.datomino.peppergis.client.model.tour.StopModel;
import de.datomino.peppergis.client.util.LetterModelUtil;
import de.datomino.peppergis.client.util.ParcelModelUtil;
import de.datomino.peppergis.client.util.PoiModelUtil;
import de.datomino.peppergis.client.util.StopModelUtil;
import de.datomino.peppergis.client.util.SubscriptionModelUtil;
import de.datomino.peppergis.datamanager.gui.DataManagerGui;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.border.EmptyBorder;

public class DataManagerComboBoxListCellRenderer
extends AbstractListCellRenderer<Model> {
    private DataManagerGui gui;
    private boolean withEmptyBorder;

    public DataManagerComboBoxListCellRenderer(DataManagerGui gui, boolean withEmptyBorder) {
        this.gui = gui;
        this.withEmptyBorder = withEmptyBorder;
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object object, int index, boolean isSelected, boolean cellHasFocus) {
        Component component = super.getListCellRendererComponent(list, object, index, isSelected, cellHasFocus);
        if (this.withEmptyBorder && component instanceof JComponent) {
            ((JComponent)component).setBorder(new EmptyBorder(5, 5, 5, 5));
        }
        return component;
    }

    @Override
    protected String getStringFromValue(Model model) {
        String str = this.gui.getModelString(model);
        if (str != null) {
            return str;
        }
        if (model instanceof ParcelModel) {
            return ParcelModelUtil.getAddress((ParcelModel)model);
        }
        if (model instanceof SubscriptionModel) {
            return SubscriptionModelUtil.getDisplayString((SubscriptionModel)model);
        }
        if (model instanceof LetterModel) {
            return LetterModelUtil.getDisplayString((LetterModel)model);
        }
        if (model instanceof PoiModel) {
            return PoiModelUtil.getShortInformation((PoiModel)model);
        }
        if (model instanceof StopModel) {
            return StopModelUtil.getDisplayString((StopModel)model);
        }
        return "";
    }
}

