/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.datamanager.handler;

import de.datomino.peppergis.client.model.Model;
import de.datomino.peppergis.client.model.map.ParcelModel;
import de.datomino.peppergis.client.util.model.location.LocationWrapperFactory;
import de.datomino.peppergis.datamanager.gui.DataManagerGui;
import java.util.LinkedList;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.ktde.util.datatypes.Tupel;

public class DataManagerListSelectionHandler
implements ListSelectionListener,
ListDataListener {
    private DataManagerGui gui;
    private boolean notBlocked;

    public DataManagerListSelectionHandler(DataManagerGui gui) {
        this.gui = gui;
        this.notBlocked = true;
    }

    @Override
    public synchronized void valueChanged(ListSelectionEvent e) {
        if (this.notBlocked) {
            this.notBlocked = false;
            this.gui.getSelectionComboBox().setModel((ComboBoxModel)this.gui.getMapEditorPanel().getPanelList().getModel());
            if (e.getSource().equals(this.gui.getTable().getSelectionModel())) {
                if (!e.getValueIsAdjusting()) {
                    ListSelectionModel lsm = (ListSelectionModel)e.getSource();
                    List<Model> selected = this.gui.getTableSelection(lsm);
                    this.gui.getDataManagerControlGui().setExportMarkedEnabled(!selected.isEmpty());
                    this.gui.setMarkedMapList(selected, null);
                    this.gui.getAliasPane().setAliasPanePresets(this.gui.getCurrentType(), selected);
                    this.gui.getSelectionComboBox().setSelectedIndex(-1);
                    this.gui.getGeoEditorPane().setAddressToSearch(LocationWrapperFactory.INSTANCE.createNullLocationWrapper());
                }
            } else if (e.getSource().equals(this.gui.getMapEditorPanel().getPanelList())) {
                LinkedList<ParcelModel> selected = null;
                if (!this.gui.getMapEditorPanel().getPanelList().isSelectionEmpty()) {
                    List<?> selectedValues = this.gui.getMapEditorPanel().getPanelList().getSelectedValuesList();
                    DefaultComboBoxModel<Model> cbm = new DefaultComboBoxModel<Model>();
                    if (selectedValues.get(0) instanceof Tupel) {
                        LinkedList<ParcelModel> parcels = new LinkedList<ParcelModel>();
                        for (Object o : selectedValues) {
                            ParcelModel parcelModel = (ParcelModel)o;
                            parcels.add(parcelModel);
                            cbm.addElement(parcelModel);
                        }
                        selected = parcels;
                    } else if (selectedValues.get(0) instanceof Model) {
                        LinkedList<Model> models = new LinkedList<Model>();
                        for (Object o : selectedValues) {
                            models.add((Model)o);
                            cbm.addElement((Model)o);
                        }
                        selected = models;
                    }
                    this.gui.getSelectionComboBox().setModel(cbm);
                }
                this.gui.getSelectionComboBox().setSelectedIndex(-1);
                this.gui.getMapEditorPanel().setSelectedInLegend(selected);
                this.gui.getAliasPane().clear();
            } else if (e.getSource().equals(this.gui.getAliasPane().getParcelList())) {
                List<ParcelModel> parcelModels = this.gui.getAliasPane().getParcelList().getSelectedValuesList();
                LinkedList<ParcelModel> parcelModelsUnSelect = null;
                if (this.gui.getAliasPane().isCtrlPressed()) {
                    parcelModelsUnSelect = new LinkedList<ParcelModel>();
                    for (int i = e.getFirstIndex(); i <= e.getLastIndex(); ++i) {
                        if (this.gui.getAliasPane().getParcelList().isSelectedIndex(i)) continue;
                        parcelModelsUnSelect.add(this.gui.getAliasPane().getParcelList().getModel().getElementAt(i));
                    }
                }
                this.gui.setMarkedTable(parcelModels, parcelModelsUnSelect, true);
                this.gui.setMarkedMapList(parcelModels, parcelModelsUnSelect);
                this.gui.getMapEditorPanel().centerModels(parcelModels, true);
                this.gui.addToParcelResult(parcelModels);
            }
            this.notBlocked = true;
        }
    }

    public boolean isNotBlocked() {
        return this.notBlocked;
    }

    public void setNotBlocked(boolean notBlocked) {
        this.notBlocked = notBlocked;
    }

    @Override
    public void intervalAdded(ListDataEvent e) {
        this.contentsChanged(e);
    }

    @Override
    public void intervalRemoved(ListDataEvent e) {
        this.contentsChanged(e);
    }

    @Override
    public void contentsChanged(ListDataEvent e) {
        if (this.notBlocked && e.getSource().equals(this.gui.getMapEditorPanel().getPanelList().getModel())) {
            this.notBlocked = false;
            ListModel<?> model = this.gui.getMapEditorPanel().getPanelList().getModel();
            LinkedList values = new LinkedList();
            if (model instanceof DefaultComboBoxModel) {
                DefaultComboBoxModel cbm = (DefaultComboBoxModel)model;
                for (int i = 0; i < cbm.getSize(); ++i) {
                    values.add(cbm.getElementAt(i));
                }
            }
            this.gui.getDataManagerControlGui().setExportMarkedEnabled(!values.isEmpty());
            if (values.size() > 0 && values.get(0) instanceof ParcelModel) {
                LinkedList<ParcelModel> parcels = new LinkedList<ParcelModel>();
                for (Object o : values) {
                    parcels.add((ParcelModel)o);
                }
                this.gui.getAliasPane().setAliasPanePresets(this.gui.getCurrentType(), parcels);
                this.gui.getAliasPane().setDoItAnyway(false);
            } else {
                this.gui.getAliasPane().clear();
            }
            this.notBlocked = true;
        }
    }
}

