/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.datamanager.handler;

import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.gui.parcel.DeleteParcelDialog;
import de.datomino.peppergis.client.model.Model;
import de.datomino.peppergis.client.model.base.PoiModel;
import de.datomino.peppergis.client.model.map.ParcelModel;
import de.datomino.peppergis.client.model.tour.StopModel;
import de.datomino.peppergis.client.util.PoiModelUtil;
import de.datomino.peppergis.client.util.StopModelUtil;
import de.datomino.peppergis.datamanager.gui.DataManagerGui;
import de.datomino.peppergis.datamanager.gui.DeleteJunctionsDialog;
import de.datomino.util.message.error.ErrorMessages;
import de.datomino.util.swing.ErrorMessageDialog;
import de.datomino.util.swing.SwingUtils;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.JList;
import javax.swing.JPopupMenu;

public class DataManagerListMouseHandler
extends MouseAdapter {
    private JList<? extends Model> list;
    private DataManagerGui gui;

    public DataManagerListMouseHandler(JList<? extends Model> list, DataManagerGui gui) {
        this.list = list;
        this.gui = gui;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.mouseReleased(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger() || e.getButton() == 3) {
            this.showPopupMenu(e);
        }
    }

    private void showPopupMenu(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        JPopupMenu popupMenu = new JPopupMenu();
        final String delete = ModelEnviroment.getMessageResolver().resolveMessage("messages.default.delete", new Serializable[0]);
        popupMenu.add(new AbstractAction(delete){
            private static final long serialVersionUID = -805497886438444321L;

            @Override
            public void actionPerformed(ActionEvent e) {
                DataManagerListMouseHandler.this.getGui().getModelEnvironment().getUndoManager().startTransaction();
                ErrorMessages errorMessages = new ErrorMessages();
                boolean notAborted = true;
                List<? extends Model> selectedValuesList = DataManagerListMouseHandler.this.getList().getSelectedValuesList();
                Iterator<? extends Model> selIterator = selectedValuesList.iterator();
                while (notAborted && selIterator.hasNext()) {
                    notAborted = DataManagerListMouseHandler.this.delete(selIterator.next(), errorMessages);
                }
                if (errorMessages.hasErrors()) {
                    BufferedImage image;
                    try {
                        image = ImageIO.read(DataManagerListMouseHandler.class.getResourceAsStream("/images/pepper.png"));
                    }
                    catch (IOException ex) {
                        throw new RuntimeException(ex);
                    }
                    ErrorMessageDialog errorMessageDialog = new ErrorMessageDialog(SwingUtils.findWindowParent(DataManagerListMouseHandler.this.getGui()), ModelEnviroment.getMessageResolver(), errorMessages, image);
                    errorMessageDialog.setVisible(true);
                    notAborted = false;
                }
                if (notAborted) {
                    DataManagerListMouseHandler.this.getGui().getModelEnvironment().getUndoManager().finishTransaction(delete);
                } else {
                    DataManagerListMouseHandler.this.getGui().getModelEnvironment().getUndoManager().rollbackTransaction();
                    DataManagerListMouseHandler.this.getGui().setMarkedMapList(selectedValuesList, new LinkedList());
                }
            }
        });
        popupMenu.add(new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.data.removeFromList", new Serializable[0])){
            private static final long serialVersionUID = -8831673773386429337L;

            @Override
            public void actionPerformed(ActionEvent e) {
                DataManagerListMouseHandler.this.getGui().setMarkedMapList(null, DataManagerListMouseHandler.this.getList().getSelectedValuesList());
            }
        });
        popupMenu.add(new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.voidSelection", new Serializable[0])){
            private static final long serialVersionUID = -805497886438444321L;

            @Override
            public void actionPerformed(ActionEvent e) {
                DataManagerListMouseHandler.this.getList().clearSelection();
            }
        });
        popupMenu.add(new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.center", new Serializable[0])){
            private static final long serialVersionUID = -805497886438444321L;

            @Override
            public void actionPerformed(ActionEvent e) {
                List<? extends Model> selectedValuesList = DataManagerListMouseHandler.this.getList().getSelectedValuesList();
                DataManagerListMouseHandler.this.getGui().getMapEditorPanel().centerModels(selectedValuesList);
            }
        });
        final String deleteJunctions = ModelEnviroment.getMessageResolver().resolveMessage("messages.default.delete.junctions", new Serializable[0]);
        popupMenu.add(new AbstractAction(deleteJunctions){
            private static final long serialVersionUID = -6441246823463341937L;

            @Override
            public void actionPerformed(ActionEvent e) {
                DeleteJunctionsDialog dialog = new DeleteJunctionsDialog(DataManagerListMouseHandler.this.getList().getSelectedValuesList(), DataManagerListMouseHandler.this.getGui().getModelEnvironment(), DataManagerListMouseHandler.this.getGui(), deleteJunctions, Dialog.ModalityType.APPLICATION_MODAL);
                dialog.setVisible(true);
            }
        });
        popupMenu.show(this.list, x, y);
    }

    private boolean delete(Model model, ErrorMessages errorMessages) {
        boolean notAborted = true;
        switch (this.gui.getCurrentType()) {
            case CUSTOMER: 
            case PICKPOINT: 
            case AREALOCATION: 
            case DELIVERERLOCATION: 
            case GROUPLOCATION: 
            case MAINLOCATION: 
            case AREADELIVERERLOCATION: {
                PoiModelUtil.deletePoi((PoiModel)model, this.getGui().getModelEnvironment(), true);
                break;
            }
            case PARCEL: {
                ParcelModel parcel = (ParcelModel)model;
                DeleteParcelDialog deleteParcelDialog = new DeleteParcelDialog(parcel, this.getGui().getModelEnvironment(), this.getGui(), errorMessages, false);
                deleteParcelDialog.setVisible(true);
                notAborted = !deleteParcelDialog.isAborted();
                break;
            }
            case STOPS: {
                StopModelUtil.deleteStop((StopModel)model, this.getGui().getModelEnvironment());
                break;
            }
        }
        if (!errorMessages.hasErrors() && notAborted && model.isDeleted()) {
            this.gui.removeModel(model);
        }
        this.getList().repaint(10L);
        return notAborted;
    }

    public JList<? extends Model> getList() {
        return this.list;
    }

    public DataManagerGui getGui() {
        return this.gui;
    }
}

