/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.datamanager.gui;

import de.datomino.peppergis.datamanager.gui.AbstractFilterField;
import de.datomino.peppergis.datamanager.util.IntervalLimitRegulator;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.ParseException;
import javax.swing.GroupLayout;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.ktde.util.StringUtil;

public class FilterRangeTextField<C extends Comparable<C>>
extends AbstractFilterField {
    private static final long serialVersionUID = -6942868580071665270L;
    JFormattedTextField textFieldFrom;
    JFormattedTextField textFieldTo;
    IntervalLimitRegulator limitRegulator;

    public FilterRangeTextField(IntervalLimitRegulator limitRegulator) {
        super(null);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        this.textFieldFrom = new JFormattedTextField(limitRegulator.getFormat());
        this.textFieldTo = new JFormattedTextField(limitRegulator.getFormat());
        this.textFieldFrom.setColumns(7);
        this.textFieldTo.setColumns(7);
        this.textFieldFrom.addPropertyChangeListener("value", new FromFieldListener());
        this.textFieldTo.addPropertyChangeListener("value", new ToFieldListener());
        this.textFieldFrom.getDocument().addDocumentListener(new FromFieldDocumentListener());
        this.textFieldTo.getDocument().addDocumentListener(new ToFieldDocumentListener());
        this.limitRegulator = limitRegulator;
        JLabel dash = new JLabel("-");
        layout.setHorizontalGroup(layout.createSequentialGroup().addComponent(this.textFieldFrom).addComponent(dash).addComponent(this.textFieldTo));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.textFieldFrom, -2, -2, -2).addComponent(dash).addComponent(this.textFieldTo, -2, -2, -2));
    }

    @Override
    public String getText() {
        this.commitEdit();
        return StringUtil.isBlank(this.textFieldFrom.getText()) && StringUtil.isBlank(this.textFieldTo.getText()) ? "" : this.textFieldFrom.getText() + " - " + this.textFieldTo.getText();
    }

    private void commitEdit() {
        try {
            if (this.textFieldFrom.hasFocus()) {
                this.textFieldFrom.commitEdit();
            }
            if (this.textFieldTo.hasFocus()) {
                this.textFieldTo.commitEdit();
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    @Override
    public Object getValue() {
        return this.limitRegulator.getTupel(this.getFromValue(), this.getToValue());
    }

    private C getFromValue() {
        this.commitEdit();
        return (C)(this.textFieldFrom.getValue() == null ? null : (Comparable)this.textFieldFrom.getValue());
    }

    private C getToValue() {
        this.commitEdit();
        return (C)(this.getTextFieldTo().getValue() == null ? null : (Comparable)this.textFieldTo.getValue());
    }

    public JFormattedTextField getTextFieldFrom() {
        return this.textFieldFrom;
    }

    public JFormattedTextField getTextFieldTo() {
        return this.textFieldTo;
    }

    private void adjustLimits() {
        this.limitRegulator.adjustLimits(this.textFieldFrom, this.textFieldTo);
    }

    private void adjustLowerLimit() {
        this.limitRegulator.adjustLowerLimit(this.textFieldFrom, this.textFieldTo);
    }

    private void adjustUpperLimit() {
        this.limitRegulator.adjustUpperLimit(this.textFieldFrom, this.textFieldTo);
    }

    @Override
    public void clear() {
        this.textFieldFrom.setText("");
        this.textFieldTo.setText("");
    }

    @Override
    public void addValueChangeListener(PropertyChangeListener listener) {
        this.textFieldFrom.addPropertyChangeListener("value", listener);
        this.textFieldTo.addPropertyChangeListener("value", listener);
    }

    private class ToFieldDocumentListener
    extends FieldDocumentListener {
        private ToFieldDocumentListener() {
        }

        @Override
        void setFocusLostBehaviour() {
            if (FilterRangeTextField.this.getTextFieldTo().getValue() != null && StringUtil.isBlank(FilterRangeTextField.this.getTextFieldTo().getText())) {
                FilterRangeTextField.this.getTextFieldTo().setValue(null);
            }
        }
    }

    private class FromFieldDocumentListener
    extends FieldDocumentListener {
        private FromFieldDocumentListener() {
        }

        @Override
        void setFocusLostBehaviour() {
            if (FilterRangeTextField.this.getTextFieldFrom().getValue() != null && StringUtil.isBlank(FilterRangeTextField.this.getTextFieldFrom().getText())) {
                FilterRangeTextField.this.getTextFieldFrom().setValue(null);
            }
        }
    }

    private abstract class FieldDocumentListener
    implements DocumentListener {
        private FieldDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.scheduleFocusLostBehaviour();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.scheduleFocusLostBehaviour();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.scheduleFocusLostBehaviour();
        }

        private void scheduleFocusLostBehaviour() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    FieldDocumentListener.this.setFocusLostBehaviour();
                }
            });
        }

        abstract void setFocusLostBehaviour();
    }

    private class ToFieldListener
    implements PropertyChangeListener {
        private ToFieldListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            FilterRangeTextField.this.adjustLimits();
            if (FilterRangeTextField.this.getTextFieldFrom().getValue() == null || FilterRangeTextField.this.getTextFieldTo().getValue() != null && ((Comparable)FilterRangeTextField.this.getTextFieldFrom().getValue()).compareTo((Comparable)FilterRangeTextField.this.getTextFieldTo().getValue()) > 0) {
                FilterRangeTextField.this.adjustLowerLimit();
            } else if (evt.getNewValue() == null) {
                FilterRangeTextField.this.getTextFieldFrom().setValue(null);
            }
        }
    }

    private class FromFieldListener
    implements PropertyChangeListener {
        private FromFieldListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            FilterRangeTextField.this.adjustLimits();
            if (FilterRangeTextField.this.getTextFieldTo().getValue() == null || FilterRangeTextField.this.getTextFieldFrom().getValue() != null && ((Comparable)FilterRangeTextField.this.getTextFieldTo().getValue()).compareTo((Comparable)FilterRangeTextField.this.getTextFieldFrom().getValue()) < 0) {
                FilterRangeTextField.this.adjustUpperLimit();
            } else if (evt.getNewValue() == null) {
                FilterRangeTextField.this.getTextFieldTo().setValue(null);
            }
        }
    }
}

