/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.datamanager.gui;

import de.datomino.peppergis.datamanager.gui.AbstractFilterField;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import java.text.ParseException;
import javax.swing.GroupLayout;
import javax.swing.JFormattedTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.ktde.util.StringUtil;

public class FilterFloatTextField
extends AbstractFilterField {
    private static final long serialVersionUID = -3763757918964002331L;
    JFormattedTextField textField;

    public FilterFloatTextField() {
        super(null);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        this.textField = new JFormattedTextField(new DecimalFormat());
        this.textField.setColumns(12);
        this.textField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.handleValueChange();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.handleValueChange();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.handleValueChange();
            }

            private void handleValueChange() {
                String valueString;
                String string = valueString = FilterFloatTextField.this.textField.getValue() == null ? null : FilterFloatTextField.this.textField.getValue().toString();
                if (!FilterFloatTextField.this.textField.getText().equals(valueString)) {
                    for (PropertyChangeListener pcl : FilterFloatTextField.this.textField.getPropertyChangeListeners("value")) {
                        pcl.propertyChange(new PropertyChangeEvent(FilterFloatTextField.this.textField, "value", valueString, FilterFloatTextField.this.textField.getText()));
                    }
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (FilterFloatTextField.this.textField.getValue() != null && StringUtil.isBlank(FilterFloatTextField.this.textField.getText())) {
                            FilterFloatTextField.this.textField.setValue(null);
                        }
                    }
                });
            }
        });
        layout.setHorizontalGroup(layout.createSequentialGroup().addComponent(this.textField));
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent(this.textField, -2, -2, -2));
    }

    @Override
    public String getText() {
        return this.textField.getText();
    }

    @Override
    public Object getValue() {
        try {
            this.textField.commitEdit();
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return ((Number)this.textField.getValue()).doubleValue();
    }

    @Override
    public void clear() {
        this.textField.setText("");
    }

    @Override
    public void addValueChangeListener(PropertyChangeListener listener) {
        this.textField.addPropertyChangeListener("value", listener);
    }
}

