/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.datamanager.gui;

import de.datomino.logistic.dto.LogisticLocationDto;
import de.datomino.logistic.type.RouteVehicleType;
import de.datomino.peppergis.client.communication.TourCaller;
import de.datomino.peppergis.client.event.ApplicationMessage;
import de.datomino.peppergis.client.geometric.GeoClientHelper;
import de.datomino.peppergis.client.gui.address.AddressPane;
import de.datomino.peppergis.client.gui.asynchronous.AbstractGeneralAsynchronousDialog;
import de.datomino.peppergis.client.gui.common.EnumComboBox;
import de.datomino.peppergis.client.gui.location.GeomEditorResult;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.Model;
import de.datomino.peppergis.client.model.area.AreaLayerModel;
import de.datomino.peppergis.client.model.area.AreaObjectModel;
import de.datomino.peppergis.client.model.area.AreaObjectParcelRelModel;
import de.datomino.peppergis.client.model.base.AttributeGroupModel;
import de.datomino.peppergis.client.model.base.CustomerModel;
import de.datomino.peppergis.client.model.base.ImportedLocationModel;
import de.datomino.peppergis.client.model.base.ImportedLocationModelImpl;
import de.datomino.peppergis.client.model.base.LetterModel;
import de.datomino.peppergis.client.model.base.LocationModel;
import de.datomino.peppergis.client.model.base.PoiModel;
import de.datomino.peppergis.client.model.base.SubscriptionModel;
import de.datomino.peppergis.client.model.map.ParcelAttributeValueDescriptorModel;
import de.datomino.peppergis.client.model.map.ParcelAttributeValueModel;
import de.datomino.peppergis.client.model.map.ParcelModel;
import de.datomino.peppergis.client.model.map.ParcelStaticChoiceAttributeValueModel;
import de.datomino.peppergis.client.model.map.SegmentModel;
import de.datomino.peppergis.client.model.tour.AreaDelivererModel;
import de.datomino.peppergis.client.model.tour.DelivererModel;
import de.datomino.peppergis.client.model.tour.StopModel;
import de.datomino.peppergis.client.model.tour.TourModel;
import de.datomino.peppergis.client.model.tour.TourPartModel;
import de.datomino.peppergis.client.model.wrapper.LocationableObjectsModelWrapper;
import de.datomino.peppergis.client.util.LocationModelUtil;
import de.datomino.peppergis.client.util.ParcelModelUtil;
import de.datomino.peppergis.client.util.model.location.ImportedLocationWrapper;
import de.datomino.peppergis.client.util.model.location.LocationWrapper;
import de.datomino.peppergis.client.util.model.location.LocationWrapperFactory;
import de.datomino.peppergis.client.util.model.location.ParcelLocationWrapper;
import de.datomino.peppergis.datamanager.gui.AbstractFilterField;
import de.datomino.peppergis.datamanager.gui.AttributeStaticChoiceFilterField;
import de.datomino.peppergis.datamanager.gui.BooleanFilterField;
import de.datomino.peppergis.datamanager.gui.DataManagerAliasPane;
import de.datomino.peppergis.datamanager.gui.DataManagerAreaLayerComboBox;
import de.datomino.peppergis.datamanager.gui.DataManagerControlGui;
import de.datomino.peppergis.datamanager.gui.DataManagerGeomEditorMapPane;
import de.datomino.peppergis.datamanager.gui.DataManagerMapEditorPanel;
import de.datomino.peppergis.datamanager.gui.FilterFloatTextField;
import de.datomino.peppergis.datamanager.gui.FilterRangeTextField;
import de.datomino.peppergis.datamanager.gui.FilterTextField;
import de.datomino.peppergis.datamanager.handler.DataManagerListSelectionHandler;
import de.datomino.peppergis.datamanager.renderer.DataManagerComboBoxListCellRenderer;
import de.datomino.peppergis.datamanager.util.FiltersBodyAttributes;
import de.datomino.peppergis.datamanager.util.IntervalLimitRegulatorDate;
import de.datomino.peppergis.datamanager.util.IntervalLimitRegulatorNumber;
import de.datomino.peppergis.dto.area.AreaLayerDto;
import de.datomino.peppergis.dto.asynchronous.AsynchronousGeneralDto;
import de.datomino.peppergis.dto.lucene.ParcelSearchDto;
import de.datomino.peppergis.dto.lucene.PoiSearchDtoImplMap;
import de.datomino.peppergis.dto.lucene.StopSearchDtoImplMap;
import de.datomino.peppergis.dto.map.ParcelAttributeValueDescriptorDto;
import de.datomino.peppergis.dto.map.ParcelAttributeValueDescriptorProxyDto;
import de.datomino.peppergis.dto.map.ParcelStaticChoiceAttributeValueProxyDto;
import de.datomino.peppergis.exception.ValidateException;
import de.datomino.peppergis.type.AreaObjectGenInfoDiscriminator;
import de.datomino.peppergis.type.AttributeValueType;
import de.datomino.peppergis.type.DataManagerType;
import de.datomino.peppergis.type.ImportedLocationProcess;
import de.datomino.peppergis.type.ImportedLocationStatus;
import de.datomino.peppergis.type.data.DataManagerFilters;
import de.datomino.peppergis.type.data.FiltersBody;
import de.datomino.util.collection.CollectionUtil;
import de.datomino.util.collection.Transformer;
import de.datomino.util.geo.ImmutableGeoObjectFactory;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.geo.dto.ImmutablePointDto;
import de.datomino.util.geo.util.GeoUtils;
import de.datomino.util.international.country.Country;
import de.datomino.util.message.MessageResolver;
import de.datomino.util.swing.SwingUtils;
import de.datomino.util.swing.WidthUnifier;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.ktde.math.projection.Coordinate;
import org.ktde.math.projection.Wgs84Factory;
import org.ktde.swing.AbstractToggleAction;
import org.ktde.util.NameGenerator;
import org.ktde.util.StringUtil;
import org.ktde.util.datatypes.Holder;
import org.ktde.util.datatypes.Quad;
import org.ktde.util.datatypes.Quint;
import org.ktde.util.datatypes.Tripel;
import org.ktde.util.datatypes.Tupel;

public class DataManagerGui
extends JPanel {
    private static final long serialVersionUID = 8940244889251596779L;
    private static final EnumMap<DataManagerFilters, EnumSet<?>> rangeFields = new EnumMap(DataManagerFilters.class);
    private static final EnumMap<DataManagerFilters, EnumSet<?>> floatFields = new EnumMap(DataManagerFilters.class);
    private static final Map<DataManagerFilters, EnumSet<? extends Enum<?>>> defaultTableColumnMap = new EnumMap(DataManagerFilters.class);
    private static final NumberFormat numberFormat;
    private final Map<Tripel<? extends Component, ? extends Component, ? extends Component>, Tupel<EnumSet<DataManagerType>, EnumSet<DataManagerFilters>>> additionalFields = new HashMap<Tripel<? extends Component, ? extends Component, ? extends Component>, Tupel<EnumSet<DataManagerType>, EnumSet<DataManagerFilters>>>();
    private ModelEnviroment modelEnvironment;
    private JRootPane rootPane;
    private DataManagerControlGui dataManagerControlGui;
    private Map<Object, FilterButton> mapFilterButtons;
    private Map<DataManagerFilters, StaticValuesFilterButton> mapStaticValuesFilterButtons;
    private JTextPane filterDisplayTextPane;
    private JPanel resultTablePane;
    private JPanel resultMapPane;
    private JPanel resultAliasPane;
    private DataManagerGeomEditorMapPane geoEditorPane;
    private JTabbedPane dataDisplayPane;
    private AbstractDataTableModel tableModel;
    private DataManagerMapEditorPanel mapEditorPanel;
    private DataManagerAliasPane aliasPane;
    private Map<DataManagerType, List<? extends Model>> resultDataMap;
    private EnumComboBox<DataManagerType> typeComboBox;
    private DataManagerAreaLayerComboBox layerComboBox;
    private JComboBox<Model> selectionComboBox;
    private JTable table;
    private DataManagerListSelectionHandler listSelectionHandler;
    private boolean noFocusChange;
    private GeoClientHelper geoClientHelper;
    private JMenu importMenu;
    private JMenu exportMenu;
    private Map<LocationModel, Tupel<LocationableObjectsModelWrapper, GeomEditorResult>> geoDeltaCache;
    private Color defaultForeground;
    private Color defaultBackground;
    private Color defaultTextPaneBackground;
    private JButton applyButton;
    private Window parentWindow;
    private WindowFocusListener windowFocusListener;
    private JTextField limit;
    private GroupLayout gLayout;
    private JPanel selectionPane;
    private JPanel filterButtonPane;

    public DataManagerGui(ModelEnviroment modelEnvironment, JRootPane rootPane, JMenu importMenu, JMenu exportMenu) {
        super(null);
        this.importMenu = importMenu;
        this.exportMenu = exportMenu;
        this.noFocusChange = false;
        this.modelEnvironment = modelEnvironment;
        this.geoClientHelper = new GeoClientHelper(modelEnvironment);
        this.rootPane = rootPane;
        this.listSelectionHandler = new DataManagerListSelectionHandler(this);
        this.mapEditorPanel = new DataManagerMapEditorPanel(this);
        this.dataManagerControlGui = new DataManagerControlGui(this);
        this.resultDataMap = new EnumMap<DataManagerType, List<? extends Model>>(DataManagerType.class);
        this.geoDeltaCache = new HashMap<LocationModel, Tupel<LocationableObjectsModelWrapper, GeomEditorResult>>();
        this.buildLayout();
        this.windowFocusListener = new WindowFocusListener(){

            @Override
            public void windowLostFocus(WindowEvent e) {
                for (FilterButton button : DataManagerGui.this.mapFilterButtons.values()) {
                    button.closeDetailsPane();
                }
            }

            @Override
            public void windowGainedFocus(WindowEvent e) {
            }
        };
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                while ((DataManagerGui.this.parentWindow = DataManagerGui.this.getMapEditorPanel().getParentWindow()) == null) {
                }
                DataManagerGui.this.parentWindow.addWindowFocusListener(DataManagerGui.this.windowFocusListener);
            }
        });
        thread.start();
    }

    private void buildLayout() {
        JLabel label = new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.maxNoItems", new Serializable[0]));
        this.limit = new JTextField();
        Tripel<JLabel, JTextField, JLabel> tripel = new Tripel<JLabel, JTextField, JLabel>(label, this.limit, new JLabel(""));
        Tupel<EnumSet<DataManagerType>, EnumSet<DataManagerFilters>> tupel = new Tupel<EnumSet<DataManagerType>, EnumSet<DataManagerFilters>>(EnumSet.allOf(DataManagerType.class), EnumSet.of(DataManagerFilters.SPECIAL));
        this.additionalFields.put(tripel, tupel);
        this.typeComboBox = new EnumComboBox<DataManagerType>(DataManagerType.class, false);
        this.typeComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    DataManagerGui.this.setType((DataManagerType)((Object)((EnumComboBox)e.getSource()).getSelectedValue()));
                }
            }
        });
        this.typeComboBox.setMaximumRowCount(Math.min(25, DataManagerType.values().length));
        this.layerComboBox = new DataManagerAreaLayerComboBox(this.modelEnvironment, true, new AreaObjectGenInfoDiscriminator[]{AreaObjectGenInfoDiscriminator.AREA_OBJECT_GEN_AREA_OBJECT, AreaObjectGenInfoDiscriminator.AREA_OBJECT_GEN_FREEHAND, AreaObjectGenInfoDiscriminator.AREA_OBJECT_GEN_UNMODIFYABLE});
        this.layerComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    DataManagerGui.this.mapEditorPanel.setLayer(DataManagerGui.this.getCurrentLayer());
                }
            }
        });
        Collection<ParcelAttributeValueDescriptorModel> parcelAttributeValueDescriptorModels = this.getModelEnvironment().getAllCaller().getStreetNetCaller().fetchAllParcelAttributeValueDescriptors();
        EnumSet<AttributeValueType[]> types = EnumSet.of(AttributeValueType.BOOLEAN, new AttributeValueType[]{AttributeValueType.INTEGER, AttributeValueType.FLOAT, AttributeValueType.DATE, AttributeValueType.STATIC_CHOICE, AttributeValueType.STRING});
        HashMap groupMap = new HashMap();
        for (ParcelAttributeValueDescriptorModel parcelAttributeValueDescriptorModel : parcelAttributeValueDescriptorModels) {
            if (!types.contains((Object)parcelAttributeValueDescriptorModel.getAttributeValueType())) continue;
            AttributeGroupModel attributeGroupModel = parcelAttributeValueDescriptorModel.getGroup();
            if (groupMap.get(attributeGroupModel) == null) {
                LinkedList list = new LinkedList();
                groupMap.put(attributeGroupModel, list);
            }
            ((Collection)groupMap.get(attributeGroupModel)).add(parcelAttributeValueDescriptorModel);
        }
        this.mapFilterButtons = new LinkedHashMap<Object, FilterButton>();
        this.mapStaticValuesFilterButtons = new EnumMap<DataManagerFilters, StaticValuesFilterButton>(DataManagerFilters.class);
        WidthUnifier unifier = new WidthUnifier();
        for (DataManagerFilters filter : DataManagerFilters.values()) {
            StaticValuesFilterButton staticValueButton = new StaticValuesFilterButton(filter);
            this.mapFilterButtons.put((Object)filter, staticValueButton);
            this.mapStaticValuesFilterButtons.put(filter, staticValueButton);
            unifier.add(staticValueButton);
        }
        this.initFieldProperties();
        for (Map.Entry entry : groupMap.entrySet()) {
            AttributeGroupModel group = (AttributeGroupModel)entry.getKey();
            AttributeFilterButton buttonAttribute = new AttributeFilterButton(group, (Collection)entry.getValue());
            this.mapFilterButtons.put(group, buttonAttribute);
            unifier.add(buttonAttribute);
        }
        unifier.unifyWidth();
        this.filterButtonPane = new JPanel(new FlowLayout(3, 4, 4));
        this.addButtons();
        this.filterButtonPane.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                JComponent jComp;
                for (FilterButton button : DataManagerGui.this.mapFilterButtons.values()) {
                    button.closeDetailsPane();
                }
                if (e.getComponent() instanceof JComponent && (jComp = (JComponent)e.getComponent()).getLayout() instanceof FlowLayout) {
                    int height;
                    FlowLayout fLayout = (FlowLayout)jComp.getLayout();
                    Dimension pref = jComp.getPreferredSize();
                    Component component = jComp.getComponent(jComp.getComponentCount() - 1);
                    pref.height = height = component.getLocation().y + component.getHeight() + jComp.getInsets().top + jComp.getInsets().bottom + fLayout.getVgap();
                    jComp.setPreferredSize(pref);
                }
                super.componentResized(e);
            }
        });
        this.filterDisplayTextPane = new JTextPane();
        this.filterDisplayTextPane.setEditable(false);
        this.defaultTextPaneBackground = this.filterDisplayTextPane.getBackground().darker();
        this.filterDisplayTextPane.setBackground(this.defaultTextPaneBackground);
        this.filterDisplayTextPane.setBorder(BorderFactory.createLoweredSoftBevelBorder());
        this.selectionComboBox = new JComboBox();
        final Holder<Boolean> holder = new Holder<Boolean>(false);
        final Holder holder2 = new Holder();
        this.selectionComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1 && !((Boolean)holder.getElement()).booleanValue()) {
                    holder.setElement(true);
                    Model newModel = (Model)((JComboBox)e.getSource()).getSelectedItem();
                    if (new EqualsBuilder().append(newModel, holder2).isEquals() || DataManagerGui.this.checkCloseConditions((Model)holder2.getElement())) {
                        holder2.setElement(newModel);
                        if (!(DataManagerGui.this.isNoFocusChange() || e.getStateChange() != 1 && newModel != null)) {
                            DataManagerGui.this.setSelectionFocus(newModel);
                        }
                    } else {
                        ((JComboBox)e.getSource()).setSelectedItem(holder2);
                    }
                    holder.setElement(false);
                }
            }
        });
        this.setSelectionComboBoxRenderer();
        BasicArrowButton backwardButton = new BasicArrowButton(7);
        backwardButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataManagerGui.this.changeFocusSelectionIndex(-1);
            }
        });
        BasicArrowButton forwardButton = new BasicArrowButton(3);
        forwardButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataManagerGui.this.changeFocusSelectionIndex(1);
            }
        });
        JPanel topButtonPane = new JPanel(new GridLayout(1, 0, 4, 0));
        JButton clearButton = new JButton(ModelEnviroment.getMessageResolver().resolveMessage("buttons.clear", new Serializable[0]));
        clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataManagerGui.this.clear();
            }
        });
        this.applyButton = new JButton(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.apply", new Serializable[0]));
        this.applyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataManagerGui.this.fetchData();
                DataManagerGui.this.applyToTable();
                DataManagerGui.this.applyToMap();
                DataManagerGui.this.applyButton.setForeground(DataManagerGui.this.defaultForeground);
                DataManagerGui.this.filterDisplayTextPane.setBackground(DataManagerGui.this.defaultTextPaneBackground);
                DataManagerGui.this.geoEditorPane.getCoordinateEditorLayerRenderer().setActive(false);
            }
        });
        JButton saveButton = new JButton(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.save", new Serializable[0]));
        saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataManagerGui.this.save();
            }
        });
        topButtonPane.add(this.applyButton);
        topButtonPane.add(clearButton);
        topButtonPane.add(saveButton);
        this.dataDisplayPane = new JTabbedPane(3);
        this.resultTablePane = new JPanel(new BorderLayout());
        this.resultMapPane = new JPanel(new BorderLayout());
        this.resultMapPane.add(this.mapEditorPanel);
        this.resultAliasPane = new JPanel(new BorderLayout());
        this.aliasPane = new DataManagerAliasPane(this.modelEnvironment, this.listSelectionHandler);
        this.resultAliasPane.add((Component)this.aliasPane, "North");
        this.geoEditorPane = new DataManagerGeomEditorMapPane(this, true);
        this.geoEditorPane.setCoordinate(Wgs84Factory.INSTANCE.createCoordinate(11.576843, 48.136308), true);
        this.geoEditorPane.getCoordinateEditorLayerRenderer().setActive(false);
        this.dataDisplayPane.add(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.list", new Serializable[0]), this.resultTablePane);
        this.dataDisplayPane.add(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.map", new Serializable[0]), this.resultMapPane);
        this.dataDisplayPane.add(ModelEnviroment.getMessageResolver().resolveMessage("messages.street.alias", new Serializable[0]), this.resultAliasPane);
        this.dataDisplayPane.addTab(ModelEnviroment.getMessageResolver().resolveMessage("messages.data.editor", new Serializable[0]), this.geoEditorPane);
        this.dataDisplayPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                DataManagerGui.this.applyGeoDeltaCache();
            }
        });
        this.selectionPane = new JPanel(null);
        GroupLayout layout = new GroupLayout(this.selectionPane);
        this.selectionPane.setLayout(layout);
        int prefSize = -2;
        int max = Integer.MAX_VALUE;
        Dimension size = this.dataDisplayPane.getPreferredSize();
        Dimension maxSize = this.filterDisplayTextPane.getMaximumSize();
        maxSize.setSize(size.width, maxSize.height);
        this.filterDisplayTextPane.setMaximumSize(maxSize);
        size.setSize(this.dataDisplayPane.getMinimumSize().width, size.height);
        this.dataDisplayPane.setPreferredSize(size);
        this.gLayout = new GroupLayout(this);
        this.setLayout(this.gLayout);
        this.gLayout.setAutoCreateContainerGaps(true);
        layout.setHorizontalGroup(layout.createSequentialGroup().addComponent(this.selectionComboBox, 0, -2, Integer.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(backwardButton, -2, -2, -2).addComponent(forwardButton, -2, -2, -2));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.selectionComboBox, -2, -2, -2).addComponent(backwardButton, -2, -2, Integer.MAX_VALUE).addComponent(forwardButton, -2, -2, Integer.MAX_VALUE));
        this.gLayout.setHorizontalGroup(this.gLayout.createParallelGroup().addGroup(this.gLayout.createSequentialGroup().addComponent(this.typeComboBox, -2, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.layerComboBox, -2, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.filterButtonPane, 0, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, -2, Integer.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(topButtonPane, -2, -2, -2)).addComponent(this.selectionPane).addComponent(this.filterDisplayTextPane, 0, -2, Integer.MAX_VALUE).addComponent(this.dataDisplayPane, 0, -2, Integer.MAX_VALUE));
        this.gLayout.setVerticalGroup(this.gLayout.createSequentialGroup().addGroup(this.gLayout.createParallelGroup(GroupLayout.Alignment.CENTER, false).addComponent(this.typeComboBox, -2, -2, -2).addComponent(this.layerComboBox, -2, -2, -2).addComponent(this.filterButtonPane, 0, -2, -2).addComponent(topButtonPane, -2, -2, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.selectionPane, -2, -2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.filterDisplayTextPane, -2, -2, -2).addComponent(this.dataDisplayPane));
        this.initTable();
        this.setType(this.typeComboBox.getSelectedValue());
        this.setApplyButtonEnabled();
    }

    private void addButtons() {
        this.filterButtonPane.removeAll();
        for (Map.Entry<Object, FilterButton> entry : this.mapFilterButtons.entrySet()) {
            if (this.getCurrentType() != DataManagerType.PARCEL && !this.mapStaticValuesFilterButtons.containsKey(entry.getKey())) continue;
            this.filterButtonPane.add(entry.getValue());
        }
    }

    private void setSelectionComboBoxRenderer() {
        this.selectionComboBox.setRenderer(new DataManagerComboBoxListCellRenderer(this, true));
    }

    public void actionBeforeClose() {
        this.clear();
        this.dataManagerControlGui.removeMenuItems();
        this.parentWindow.removeWindowFocusListener(this.windowFocusListener);
    }

    public boolean setModel(Model model) {
        boolean isParcelOrSubscriptionOrLetterOrStop = model instanceof ParcelModel || model instanceof SubscriptionModel || model instanceof LetterModel || model instanceof StopModel;
        this.showAddressAndIdForType(DataManagerType.PARCEL);
        List<? extends Model> parcelResultList = this.resultDataMap.get((Object)DataManagerType.PARCEL);
        if (model instanceof ParcelModel) {
            parcelResultList.clear();
            parcelResultList.add((ParcelModel)model);
        } else if (model instanceof SubscriptionModel) {
            ParcelModel parcel = ((SubscriptionModel)model).getLocation().getParcel();
            if (parcel == null) {
                MessageResolver resolver = ModelEnviroment.getMessageResolver();
                JOptionPane.showMessageDialog(this, resolver.resolveMessage("messages.parcel.noRelations", new Serializable[0]), resolver.resolveMessage("messages.default.error", new Serializable[0]), 0);
                return false;
            }
            parcelResultList.clear();
            parcelResultList.add(parcel);
            model = parcel;
        } else if (model instanceof LetterModel) {
            ParcelModel parcel = ((LetterModel)model).getLocation().getParcel();
            if (parcel == null) {
                MessageResolver resolver = ModelEnviroment.getMessageResolver();
                JOptionPane.showMessageDialog(this, resolver.resolveMessage("messages.parcel.noRelations", new Serializable[0]), resolver.resolveMessage("messages.default.error", new Serializable[0]), 0);
                return false;
            }
            parcelResultList.clear();
            parcelResultList.add(parcel);
            model = parcel;
        } else if (model instanceof StopModel) {
            StopModel stopModel = (StopModel)model;
            if (stopModel.getLocation().getParcel() != null) {
                parcelResultList.clear();
                parcelResultList.add(stopModel.getLocation().getParcel());
                model = stopModel.getLocation().getParcel();
            } else {
                this.showAddressAndIdForType(DataManagerType.STOPS);
                List<? extends Model> stopResultList = this.resultDataMap.get((Object)DataManagerType.STOPS);
                stopResultList.clear();
                stopResultList.add(stopModel);
            }
        }
        if (isParcelOrSubscriptionOrLetterOrStop) {
            this.applyToTable();
            this.applyToMap();
            this.setMarkedMapList(Collections.singletonList(model), null);
            this.changeFocusSelectionIndex(1);
            this.dataDisplayPane.setSelectedIndex(this.dataDisplayPane.indexOfComponent(this.geoEditorPane));
        }
        return isParcelOrSubscriptionOrLetterOrStop;
    }

    private void showAddressAndIdForType(DataManagerType type) {
        this.typeComboBox.setSelectedValue(type);
        this.mapFilterButtons.get((Object)DataManagerFilters.ADDRESS).setSelectAll(true);
        this.mapFilterButtons.get((Object)DataManagerFilters.ID).setSelectAll(true);
    }

    private void setType(DataManagerType type) {
        AbstractDataTableModel oldTableModel = this.tableModel;
        int indexOfAliasComponent = this.dataDisplayPane.indexOfComponent(this.resultAliasPane);
        if (this.dataDisplayPane.getSelectedIndex() == indexOfAliasComponent) {
            this.dataDisplayPane.setSelectedIndex(this.dataDisplayPane.indexOfComponent(this.resultTablePane));
        }
        this.dataDisplayPane.setEnabledAt(indexOfAliasComponent, false);
        for (FilterButton button : this.mapFilterButtons.values()) {
            button.invalidatePane();
        }
        switch (type) {
            case PARCEL: {
                if (this.resultDataMap.get((Object)type) == null) {
                    this.resultDataMap.put(type, new LinkedList());
                }
                if (!(this.tableModel instanceof ParcelTableModel)) {
                    this.tableModel = new ParcelTableModel();
                }
                this.dataDisplayPane.setEnabledAt(indexOfAliasComponent, true);
                break;
            }
            case CUSTOMER: 
            case PICKPOINT: 
            case AREALOCATION: 
            case DELIVERERLOCATION: 
            case GROUPLOCATION: 
            case MAINLOCATION: 
            case AREADELIVERERLOCATION: {
                if (this.resultDataMap.get((Object)type) == null) {
                    this.resultDataMap.put(type, new LinkedList());
                }
                if (type == DataManagerType.AREALOCATION) {
                    this.tableModel = new AreaLocationTableModel();
                    break;
                }
                if (type == DataManagerType.DELIVERERLOCATION || type == DataManagerType.AREADELIVERERLOCATION) {
                    this.tableModel = new DelivererLocationTableModel();
                    break;
                }
                if (type == DataManagerType.GROUPLOCATION) {
                    this.tableModel = new GroupLocationTableModel();
                    break;
                }
                if (type == DataManagerType.MAINLOCATION) {
                    this.tableModel = new MainLocationTableModel();
                    break;
                }
                if (type == DataManagerType.CUSTOMER) {
                    this.tableModel = new CustomerTableModel();
                    break;
                }
                if (type != DataManagerType.PICKPOINT) break;
                this.tableModel = new PickPointTableModel();
                break;
            }
            case STOPS: {
                if (this.resultDataMap.get((Object)type) == null) {
                    this.resultDataMap.put(type, new LinkedList());
                }
                if (this.tableModel instanceof StopTableModel) break;
                this.tableModel = new StopTableModel();
                break;
            }
        }
        if (this.mapEditorPanel != null) {
            this.mapEditorPanel.setMapEditorModel(type);
        }
        this.resultDataMap.get((Object)type).clear();
        if (this.tableModel != oldTableModel) {
            if (oldTableModel != null) {
                oldTableModel.removeTableModelListener(this.table);
            }
            this.table.setModel(this.tableModel);
        }
        this.clear();
        this.applyToTable();
        this.applyToMap();
        this.addButtons();
    }

    private void fetchData() {
        AbstractGeneralAsynchronousDialog asynchronousDialog;
        DataManagerType currentType = this.getCurrentType();
        List<? extends Model> resultList = this.resultDataMap.get((Object)currentType);
        EnumMap appliedDataMap = new EnumMap(DataManagerFilters.class);
        for (DataManagerFilters filter : DataManagerFilters.values()) {
            appliedDataMap.put(filter, this.mapStaticValuesFilterButtons.get((Object)filter).getFilter().getBody().getAppliedDataMap());
        }
        HashMap<ParcelAttributeValueDescriptorDto, Object> attributeMap = new HashMap<ParcelAttributeValueDescriptorDto, Object>();
        for (Map.Entry<Object, FilterButton> entry : this.mapFilterButtons.entrySet()) {
            if (entry.getKey() != null && !(entry.getKey() instanceof AttributeGroupModel)) continue;
            Map<? extends Object, Object> map = entry.getValue().getAppliedDataMap();
            for (Map.Entry<? extends Object, Object> subEntry : map.entrySet()) {
                Object value = subEntry.getValue();
                if (value instanceof ParcelStaticChoiceAttributeValueModel) {
                    value = (ParcelStaticChoiceAttributeValueProxyDto)((ParcelStaticChoiceAttributeValueModel)value).createProxy();
                }
                attributeMap.put((ParcelAttributeValueDescriptorProxyDto)((ParcelAttributeValueDescriptorModel)subEntry.getKey()).createProxy(), value);
            }
        }
        Integer limit = null;
        if (!StringUtil.isBlank(this.limit.getText())) {
            try {
                limit = Integer.parseInt(this.limit.getText());
            }
            catch (NumberFormatException entry) {
                // empty catch block
            }
        }
        resultList.clear();
        switch (currentType) {
            case CUSTOMER: 
            case PICKPOINT: 
            case AREALOCATION: 
            case DELIVERERLOCATION: 
            case GROUPLOCATION: 
            case MAINLOCATION: 
            case AREADELIVERERLOCATION: {
                final PoiSearchDtoImplMap poiSearchDto = new PoiSearchDtoImplMap(appliedDataMap);
                poiSearchDto.setSpecificPoiType(currentType);
                poiSearchDto.setAreaLayerDto(this.getAreaLayerDto());
                poiSearchDto.setLimit(limit);
                asynchronousDialog = new AbstractAsynchronousFetchDialog<Collection<PoiModel>>(this.getMapEditorPanel().getParentWindow(), this.getModelEnvironment()){
                    private static final long serialVersionUID = 8469687370448436166L;

                    @Override
                    protected String startAsynchronous() {
                        return this.modelEnviroment.getAllCaller().getAsynchronousCaller().searchPoi(poiSearchDto, false, true);
                    }
                };
                break;
            }
            case PARCEL: {
                final ParcelSearchDto parcelSearchDto = new ParcelSearchDto(appliedDataMap);
                parcelSearchDto.setAreaLayerDto(this.getAreaLayerDto());
                parcelSearchDto.setLimit(limit);
                parcelSearchDto.setAttributeMap(attributeMap);
                AbstractAsynchronousFetchDialog<Collection<Tupel<ParcelModel, Double>>> asynchronousDialog2 = new AbstractAsynchronousFetchDialog<Collection<Tupel<ParcelModel, Double>>>(this.getMapEditorPanel().getParentWindow(), this.getModelEnvironment()){
                    private static final long serialVersionUID = -990762673378593344L;

                    @Override
                    protected AsynchronousGeneralDto<Collection<Tupel<ParcelModel, Double>>> getAsynchronousDto(String token) {
                        return this.modelEnviroment.getAllCaller().getAsynchronousCaller().getParcelSearchResult(token);
                    }

                    @Override
                    protected String startAsynchronous() {
                        return this.modelEnviroment.getAllCaller().getAsynchronousCaller().searchParcelsFuzzyAddress(parcelSearchDto);
                    }
                };
                LinkedList parcelResults = new LinkedList();
                try {
                    parcelResults.addAll((Collection)asynchronousDialog2.run().getElement1());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                for (Tupel tupel : parcelResults) {
                    resultList.add((Model)tupel.getElement1());
                }
                this.dataManagerControlGui.setExportResultEnabled(!resultList.isEmpty());
                this.updateFilterDisplayTextField(resultList.size());
                return;
            }
            case STOPS: {
                final StopSearchDtoImplMap stopSearchDto = new StopSearchDtoImplMap(appliedDataMap);
                stopSearchDto.setLimit(limit);
                asynchronousDialog = new AbstractAsynchronousFetchDialog<Collection<StopModel>>(this.getMapEditorPanel().getParentWindow(), this.getModelEnvironment()){
                    private static final long serialVersionUID = -1273372981779732345L;

                    @Override
                    protected String startAsynchronous() {
                        return this.modelEnviroment.getAllCaller().getAsynchronousCaller().searchStops(stopSearchDto, false, true);
                    }
                };
                break;
            }
            default: {
                asynchronousDialog = null;
            }
        }
        try {
            resultList.addAll((Collection)asynchronousDialog.run().getElement1());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.dataManagerControlGui.setExportResultEnabled(!resultList.isEmpty());
        this.updateFilterDisplayTextField(resultList.size());
    }

    public void addToParcelResult(Collection<ParcelModel> parcels) {
        List<? extends Model> resultList = this.resultDataMap.get((Object)DataManagerType.PARCEL);
        for (ParcelModel parcel : parcels) {
            if (resultList.contains(parcel)) continue;
            resultList.add(parcel);
        }
        this.dataManagerControlGui.setExportResultEnabled(!resultList.isEmpty());
        this.applyToTable();
    }

    private AreaLayerDto getAreaLayerDto() {
        return this.getCurrentLayer() == null ? null : (AreaLayerDto)((Object)this.getCurrentLayer().createDto());
    }

    private void initTable() {
        this.resultTablePane.removeAll();
        this.table = new JTable(null);
        this.table.setAutoCreateRowSorter(true);
        this.table.setDefaultRenderer(Double.class, new CoordinateTableCellRenderer());
        this.table.setDefaultRenderer(GermanIntegerNumber.class, new GermanIntegerNumberTableCellRenderer());
        this.table.getSelectionModel().addListSelectionListener(this.listSelectionHandler);
        this.resultTablePane.add((Component)new JScrollPane(this.table), "Center");
    }

    private void applyToTable() {
        this.tableModel.fireTableStructureChanged();
    }

    private void applyToMap() {
        this.mapEditorPanel.applyData();
    }

    private void clear() {
        for (FilterButton filterButton : this.mapFilterButtons.values()) {
            filterButton.clear();
        }
        for (List list : this.resultDataMap.values()) {
            list.clear();
        }
        this.filterDisplayTextPane.setText("");
        this.geoEditorPane.getCoordinateEditorLayerRenderer().setActive(false);
        this.filterDisplayTextPane.setBackground(this.defaultTextPaneBackground);
        this.applyButton.setForeground(this.defaultForeground);
        this.applyToTable();
        this.applyToMap();
        this.setApplyButtonEnabled();
    }

    private void changeFocusSelectionIndex(int delta) {
        int itemCount = this.selectionComboBox.getItemCount();
        if (itemCount > 0) {
            int oldIndex = 0 <= delta ? this.selectionComboBox.getSelectedIndex() : Math.max(this.selectionComboBox.getSelectedIndex(), 0);
            int newIndex = (oldIndex + delta + itemCount) % itemCount;
            this.selectionComboBox.setSelectedIndex(newIndex);
        }
    }

    public List<Model> getTableSelection() {
        return this.getTableSelection(this.getTable().getSelectionModel());
    }

    public List<Model> getTableSelection(ListSelectionModel lsm) {
        LinkedList<Model> selected = new LinkedList<Model>();
        List<? extends Model> models = this.getDataList();
        int firstIndex = lsm.getMinSelectionIndex();
        int lastIndex = lsm.getMaxSelectionIndex();
        for (int i = firstIndex; i <= lastIndex; ++i) {
            if (!lsm.isSelectedIndex(i)) continue;
            selected.add(models.get(this.getTable().convertRowIndexToModel(i)));
        }
        return selected;
    }

    public void setSelectionFocus(Model model) {
        if (this.listSelectionHandler.isNotBlocked()) {
            if (model != null) {
                this.listSelectionHandler.setNotBlocked(false);
                List<? extends Model> list = this.tableModel.getDataList();
                int i = -1;
                i = list.indexOf(model);
                if (i != -1) {
                    i = this.table.convertRowIndexToView(i);
                    Rectangle rectangle = this.table.getCellRect(i, 0, true);
                    this.table.scrollRectToVisible(rectangle);
                }
                this.mapEditorPanel.centerModel(this.getCurrentType(), model);
                List<Model> selection = this.getTableSelection(this.getTable().getSelectionModel());
                this.aliasPane.setReferenceModel(model);
                this.aliasPane.setDoItAnyway(true);
                this.aliasPane.setAliasPanePresets(this.getCurrentType(), selection);
                this.aliasPane.getParcelList().ensureIndexIsVisible(((DefaultListModel)this.aliasPane.getParcelList().getModel()).indexOf(model));
                this.listSelectionHandler.setNotBlocked(true);
                this.setEditorTo(model);
            }
            this.geoEditorPane.setAddressToSearch(this.getLocationWrapper(model));
        }
    }

    private LocationWrapper getLocationWrapper(Model model) {
        if (model instanceof ParcelModel) {
            return LocationWrapperFactory.INSTANCE.createLocationWrapper((ParcelModel)model);
        }
        LocationModel locationModel = LocationModelUtil.getLocationModel(model);
        if (locationModel != null) {
            return LocationWrapperFactory.INSTANCE.createLocationWrapper(locationModel);
        }
        return LocationWrapperFactory.INSTANCE.createNullLocationWrapper();
    }

    public String getTitleString(String glue) {
        LinkedList<String> titleRow = new LinkedList<String>();
        for (int i = 0; i < this.tableModel.getColumnCount(); ++i) {
            titleRow.add(this.tableModel.getColumnName(this.table.convertColumnIndexToModel(i)));
        }
        return StringUtil.implode(titleRow, glue);
    }

    public String getModelString(Model model) {
        return this.getModelString(model, "  ", false);
    }

    public String getModelString(Model model, String glue, boolean inQuotationMarks) {
        List<? extends Model> list = this.tableModel.getDataList();
        int i = -1;
        i = list.indexOf(model);
        if (i != -1) {
            return this.getTableRowString(i, glue, inQuotationMarks);
        }
        return null;
    }

    public String getTableRowString(int index, String glue, boolean inQuotationMarks) {
        LinkedList<Object> dataRow = new LinkedList<Object>();
        for (int j = 0; j < this.tableModel.getColumnCount(); ++j) {
            Object valueAt = this.tableModel.getValueAt(index, this.table.convertColumnIndexToModel(j));
            Object object = valueAt = valueAt == null ? " " : valueAt;
            if (valueAt instanceof Double) {
                DecimalFormat format = new DecimalFormat("#0.000000000");
                valueAt = format.format(valueAt);
            }
            dataRow.add(valueAt);
        }
        if (inQuotationMarks) {
            return StringUtil.implode(dataRow, glue, new NameGenerator<Object>(){

                @Override
                public String getName(Object t) {
                    return t == null ? "\"null\"" : "\"" + t.toString() + "\"";
                }
            });
        }
        return StringUtil.implode(dataRow, glue);
    }

    private void setEditorTo(Model model) {
        Coordinate startCoordinate = null;
        SegmentModel motorSegment = null;
        SegmentModel footSegment = null;
        SegmentModel bikeSegment = null;
        if (this.getCurrentType() == DataManagerType.PARCEL) {
            ParcelModel parcelModel = (ParcelModel)model;
            ImmutablePoint geom = parcelModel.getGeom();
            Coordinate coordinate = startCoordinate = geom == null ? null : Wgs84Factory.INSTANCE.createCoordinate(geom.getCoordinate());
            if (startCoordinate != null) {
                motorSegment = ParcelModelUtil.getRouteSegment(parcelModel, RouteVehicleType.MOTORCAR);
                footSegment = ParcelModelUtil.getRouteSegment(parcelModel, RouteVehicleType.FOOT);
                bikeSegment = ParcelModelUtil.getRouteSegment(parcelModel, RouteVehicleType.BIKE);
            }
        } else {
            LocationModel location = LocationModelUtil.getLocationModel(model);
            if (location != null) {
                if (this.geoDeltaCache.containsKey(location)) {
                    GeomEditorResult cachedEditorResult = this.geoDeltaCache.get(location).getElement2();
                    startCoordinate = cachedEditorResult.getCoordinate();
                    motorSegment = cachedEditorResult.getMotorSegment();
                    footSegment = cachedEditorResult.getFootSegment();
                    bikeSegment = cachedEditorResult.getBikeSegment();
                }
                if (startCoordinate == null) {
                    LocationWrapper wrapper = LocationWrapperFactory.INSTANCE.createLocationWrapper(location);
                    Coordinate coordinate = wrapper.getGeoLocation() == null ? null : wrapper.getGeoLocation().getCoordinate();
                    startCoordinate = coordinate == null ? new Coordinate(Wgs84Factory.INSTANCE, 0.0, 0.0) : Wgs84Factory.INSTANCE.createCoordinate(coordinate);
                    motorSegment = LocationModelUtil.getRouteSegment(location, RouteVehicleType.MOTORCAR, this.modelEnvironment);
                    footSegment = LocationModelUtil.getRouteSegment(location, RouteVehicleType.FOOT, this.modelEnvironment);
                    bikeSegment = LocationModelUtil.getRouteSegment(location, RouteVehicleType.BIKE, this.modelEnvironment);
                }
            }
        }
        if (startCoordinate != null) {
            this.geoEditorPane.setCoordinate(startCoordinate, true, false);
            this.geoEditorPane.setSegments(motorSegment, footSegment, bikeSegment, true, false);
            this.geoEditorPane.gotoCoordinate();
        }
    }

    public void applyGeomResult(GeomEditorResult result) {
        Model model = (Model)this.selectionComboBox.getSelectedItem();
        if (model != null) {
            this.applyGeomResult(result, model);
        }
    }

    public void applyGeomResult(GeomEditorResult result, Model model) {
        this.modelEnvironment.getUndoManager().startTransaction();
        if (this.getCurrentType() == DataManagerType.PARCEL) {
            this.syncParcelChange(result, (ParcelModel)model);
        } else {
            this.syncChange(LocationModelUtil.getLocationModel(model), result);
        }
        this.modelEnvironment.getUndoManager().finishTransaction("");
    }

    private void syncParcelChange(GeomEditorResult result, ParcelModel parcel) {
        ParcelModelUtil.setGeomResult(parcel, result, this.geoClientHelper);
        LocationWrapper wrapper = LocationWrapperFactory.INSTANCE.createLocationWrapper(parcel);
        ImmutablePointDto pointDto = ImmutablePointDto.create(wrapper.getGeoLocation());
        LogisticLocationDto<Long> location = new LogisticLocationDto<Long>(wrapper.getId(), pointDto, null, wrapper.getCountry(), wrapper.getPostcode(), wrapper.getCity(), wrapper.getDistrict(), wrapper.getStreet(), wrapper.getHousenumber(), wrapper.getHousenumberExtension());
        TourCaller tourCaller = this.modelEnvironment.getAllCaller().getTourCaller();
        Collection<LocationModel> locations = tourCaller.fetchLocationsWithSameAddress(location);
        for (LocationModel l : locations) {
            LocationModelUtil.setGeomResult(l, result, this.geoClientHelper);
        }
    }

    private Boolean syncChange(LocationModel location, GeomEditorResult result) {
        LocationWrapper wrapper = LocationWrapperFactory.INSTANCE.createLocationWrapper(location);
        if (wrapper instanceof ParcelLocationWrapper) {
            this.geoDeltaCache.put(location, new Tupel<Object, GeomEditorResult>(null, result));
        } else if (wrapper instanceof ImportedLocationWrapper) {
            LocationableObjectsModelWrapper locationableObjectsDto = this.modelEnvironment.getAllCaller().getBaseCaller().getObjectsAttachedToImportedLocation(location.getImportedLocation());
            Collection<CustomerModel> customers = locationableObjectsDto.getCustomers();
            Collection<PoiModel> pois = locationableObjectsDto.getPois();
            Collection<StopModel> stops = locationableObjectsDto.getStops();
            Collection<SubscriptionModel> subscriptions = locationableObjectsDto.getSubscriptions();
            if (customers.size() + pois.size() + stops.size() + subscriptions.size() == 1) {
                this.moveImportedLocation(location, result);
            } else {
                this.geoDeltaCache.put(location, new Tupel<LocationableObjectsModelWrapper, GeomEditorResult>(locationableObjectsDto, result));
            }
        }
        return true;
    }

    private void applyGeoDeltaCache() {
        if (!this.geoDeltaCache.isEmpty()) {
            this.modelEnvironment.getUndoManager().startTransaction();
            for (Map.Entry<LocationModel, Tupel<LocationableObjectsModelWrapper, GeomEditorResult>> entry : this.geoDeltaCache.entrySet()) {
                LocationModel location = entry.getKey();
                LocationWrapper wrapper = LocationWrapperFactory.INSTANCE.createLocationWrapper(location);
                GeomEditorResult result = entry.getValue().getElement2();
                if (wrapper instanceof ParcelLocationWrapper) {
                    this.handleNewImportedLocation(wrapper, location, result);
                    continue;
                }
                if (!(wrapper instanceof ImportedLocationWrapper)) continue;
                this.handleMore(location, entry.getValue().getElement1(), wrapper, result);
            }
            this.geoDeltaCache.clear();
            this.modelEnvironment.getUndoManager().finishTransaction("Geoedit");
        }
    }

    private Boolean handleNewImportedLocation(LocationWrapper wrapper, LocationModel location, GeomEditorResult result) {
        JPanel panel = new JPanel(new BorderLayout());
        AddressPane addressPane = new AddressPane(this.modelEnvironment.getAllCaller().getBaseCaller().getDefaultCountry());
        addressPane.setLocation(wrapper);
        panel.add((Component)addressPane, "Center");
        while (true) {
            int d = JOptionPane.showConfirmDialog(SwingUtils.findWindowParent(this), panel, ModelEnviroment.getMessageResolver().resolveMessage("address.address", new Serializable[0]), 0, 3);
            switch (d) {
                case 0: {
                    boolean b = this.checkImportedLocationOccurance(addressPane.getCountry(), addressPane.getPostcode(), addressPane.getCity(), addressPane.getDistrict(), addressPane.getStreet(), addressPane.getHousenumber(), addressPane.getHousenumberExtension());
                    if (!b) {
                        location.setParcel(null);
                        ImportedLocationModelImpl ilm = new ImportedLocationModelImpl();
                        ilm.setCity(addressPane.getCity());
                        ilm.setCountry(addressPane.getCountry());
                        ilm.setDistrict(addressPane.getDistrict());
                        ilm.setHousenumber(addressPane.getHousenumber());
                        ilm.setHousenumberExtension(addressPane.getHousenumberExtension());
                        ilm.setInformation("");
                        ilm.setLoginUser(ModelEnviroment.getUserInformation().getUserModel());
                        ilm.setPostcode(addressPane.getPostcode());
                        ilm.setProcess(ImportedLocationProcess.OPEN);
                        ilm.setStatus(ImportedLocationStatus.CHECKED);
                        ilm.setStreet(addressPane.getStreet());
                        ImmutablePoint newPoint = ImmutableGeoObjectFactory.createImmutablePoint(result.getCoordinate());
                        ilm.setGeoLocation(newPoint);
                        location.setMotorSegment(result.getMotorSegment());
                        location.setFootSegment(result.getFootSegment());
                        location.setBikeSegment(result.getBikeSegment());
                        location.setImportedLocation(ilm);
                        return true;
                    }
                    JOptionPane.showMessageDialog(SwingUtils.findWindowParent(this), ModelEnviroment.getMessageResolver().resolveMessage("address.warning.addressExists", new Serializable[0]), ModelEnviroment.getMessageResolver().resolveMessage("messages.default.warning", new Serializable[0]), 2);
                    break;
                }
                case 1: {
                    return false;
                }
                case 2: {
                    return null;
                }
            }
        }
    }

    private boolean checkImportedLocationOccurance(Country country, String postcode, String city, String district, String street, Integer housenumber, String housenumberExtension) {
        Collection<ImportedLocationModel> ils = this.modelEnvironment.getAllCaller().getStreetNetCaller().findImportLocationsExact(country, postcode, city, district, street, housenumber, housenumberExtension, false);
        if (ils.isEmpty()) {
            Collection<ParcelModel> parcels = this.modelEnvironment.getAllCaller().getStreetNetCaller().fetchParcelExact(country, postcode, city, district, street, housenumber == null ? "" : housenumber.toString(), housenumberExtension);
            return !parcels.isEmpty();
        }
        return true;
    }

    private void moveImportedLocation(LocationModel location, GeomEditorResult result) {
        ImportedLocationModel ilm = location.getImportedLocation();
        ImmutablePoint newPoint = ImmutableGeoObjectFactory.createImmutablePoint(result.getCoordinate());
        ilm.setGeoLocation(newPoint);
        location.setMotorSegment(result.getMotorSegment());
        location.setFootSegment(result.getFootSegment());
        location.setBikeSegment(result.getBikeSegment());
        location.setImportedLocation(ilm);
    }

    private Boolean handleMore(LocationModel location, LocationableObjectsModelWrapper locationableObjectsDto, LocationWrapper locationWrapper, GeomEditorResult result) {
        Collection<PoiModel> pois;
        Collection<StopModel> stops;
        Collection<SubscriptionModel> subscriptions;
        StringBuilder sb = new StringBuilder(ModelEnviroment.getMessageResolver().resolveMessage("messages.importedLocation.moreObjectsAreAttached", new Serializable[0])).append(":");
        Collection<CustomerModel> customers = locationableObjectsDto.getCustomers();
        if (!customers.isEmpty()) {
            sb.append("\n\n").append(ModelEnviroment.getMessageResolver().resolveMessage("messages.customer.customers", new Serializable[0])).append(":\n").append(StringUtil.implode(customers, "\n", new NameGenerator<CustomerModel>(){

                @Override
                public String getName(CustomerModel c) {
                    return c.getCustomerNumber();
                }
            }));
        }
        if (!(subscriptions = locationableObjectsDto.getSubscriptions()).isEmpty()) {
            sb.append("\n\n").append(ModelEnviroment.getMessageResolver().resolveMessage("messages.subscription.subscriptions", new Serializable[0])).append(":\n").append(StringUtil.implode(subscriptions, "\n", new NameGenerator<SubscriptionModel>(){

                @Override
                public String getName(SubscriptionModel s) {
                    return s.getSubscriptionNumber();
                }
            }));
        }
        if (!(stops = locationableObjectsDto.getStops()).isEmpty()) {
            sb.append("\n\n").append(ModelEnviroment.getMessageResolver().resolveMessage("gui.stop.stops", new Serializable[0])).append(":\n").append(StringUtil.implode(stops, "\n", new NameGenerator<StopModel>(){

                @Override
                public String getName(StopModel s) {
                    return s.getName();
                }
            }));
        }
        if (!(pois = locationableObjectsDto.getPois()).isEmpty()) {
            sb.append("\n\n").append(ModelEnviroment.getMessageResolver().resolveMessage("messages.poi.pois", new Serializable[0])).append(":\n").append(StringUtil.implode(pois, "\n", new NameGenerator<PoiModel>(){

                @Override
                public String getName(PoiModel s) {
                    return s.getPoiNumber();
                }
            }));
        }
        JPanel panel = new JPanel(new BorderLayout());
        JTextArea area = new JTextArea(sb.toString(), 50, 0);
        area.setEditable(false);
        panel.add((Component)new JScrollPane(area), "Center");
        Object[] options = new Object[]{ModelEnviroment.getMessageResolver().resolveMessage("messages.importedLocation.moveAll", new Serializable[0]), ModelEnviroment.getMessageResolver().resolveMessage("messages.importedLocation.newAdress", new Serializable[0]), ModelEnviroment.getMessageResolver().resolveMessage("messages.default.resetChanges", new Serializable[0])};
        block6: while (true) {
            int option = JOptionPane.showOptionDialog(SwingUtils.findWindowParent(this), panel, ModelEnviroment.getMessageResolver().resolveMessage("messages.default.question", new Serializable[0]), -1, 3, null, options, null);
            switch (option) {
                case 0: {
                    this.moveImportedLocation(location, result);
                    return true;
                }
                case 1: {
                    Boolean b = this.handleNewImportedLocation(locationWrapper, location, result);
                    if (b != null && !b.booleanValue()) continue block6;
                    return b;
                }
                case 2: {
                    return false;
                }
                case 3: {
                    return null;
                }
            }
        }
    }

    public void setMarkedMapList(List<? extends Model> selected, Collection<? extends Model> unSelected) {
        this.mapEditorPanel.setMarked(this.getCurrentType(), selected, unSelected);
    }

    public synchronized void setMarkedTable(Collection<? extends Model> selected, Collection<? extends Model> unSelected, boolean aliasOverride) {
        if (this.listSelectionHandler.isNotBlocked() || aliasOverride) {
            this.listSelectionHandler.setNotBlocked(false);
            ListSelectionModel selectionModel = this.table.getSelectionModel();
            List<? extends Model> list = this.tableModel.getDataList();
            int i = -1;
            if (unSelected == null) {
                selectionModel.clearSelection();
            } else {
                for (Model model : unSelected) {
                    i = list.indexOf(model);
                    if (i == -1) continue;
                    i = this.table.convertRowIndexToView(i);
                    selectionModel.removeSelectionInterval(i, i);
                    i = -1;
                }
            }
            for (Model model : selected) {
                i = list.indexOf(model);
                if (i == -1) continue;
                i = this.table.convertRowIndexToView(i);
                selectionModel.addSelectionInterval(i, i);
                i = -1;
            }
            this.listSelectionHandler.setNotBlocked(!aliasOverride);
        }
    }

    public void updateFilterDisplayTextField(Integer resultCount) {
        String space = "  ";
        String groupDelimiter = "   ";
        LinkedList groupNamePos = new LinkedList();
        LinkedList<List<Integer>> valuePos = new LinkedList<List<Integer>>();
        StringBuilder sb = new StringBuilder();
        SimpleAttributeSet sasBold = new SimpleAttributeSet();
        SimpleAttributeSet sasIt = new SimpleAttributeSet();
        StyleConstants.setBold(sasBold, true);
        StyleConstants.setItalic(sasIt, true);
        for (Map.Entry<Object, FilterButton> e : this.mapFilterButtons.entrySet()) {
            LinkedList<List<Integer>> linkedList = new LinkedList<List<Integer>>();
            String appliedFilters = this.createAppliedFiltersString(e.getValue(), linkedList);
            if (StringUtil.isBlank(appliedFilters)) continue;
            String filterGroup = StringUtil.nullToEmpty(this.getName(e.getKey())).toUpperCase();
            ArrayList<Integer> entry = new ArrayList<Integer>(2);
            entry.add(sb.length());
            entry.add(filterGroup.length());
            groupNamePos.add(entry);
            int offset = sb.length() + filterGroup.length() + "  ".length();
            for (List list : linkedList) {
                list.set(0, (Integer)list.get(0) + offset);
            }
            valuePos.addAll(linkedList);
            sb.append(filterGroup).append("  ").append(appliedFilters).append("   ");
        }
        if (resultCount != null) {
            sb.append("[" + numberFormat.format(resultCount) + " " + ModelEnviroment.getMessageResolver().resolveMessage("messages.default.matches", new Serializable[0]) + "]");
        }
        this.filterDisplayTextPane.setText(sb.toString());
        StyledDocument styledDocument = this.filterDisplayTextPane.getStyledDocument();
        for (List list : groupNamePos) {
            styledDocument.setCharacterAttributes((Integer)list.get(0), (Integer)list.get(1), sasBold, false);
        }
        for (List list : valuePos) {
            styledDocument.setCharacterAttributes((Integer)list.get(0), (Integer)list.get(1), sasIt, false);
        }
    }

    private String createAppliedFiltersString(FilterButton filter, List<List<Integer>> positions) {
        String result = "";
        Set<?> appliedKeySet = filter.getAppliedDataKeys();
        for (Object e : appliedKeySet) {
            Object valueObject = filter.getAppliedDataMap().get(e);
            String value = valueObject instanceof ParcelStaticChoiceAttributeValueModel ? ((ParcelStaticChoiceAttributeValueModel)valueObject).getName() : (valueObject instanceof Number ? numberFormat.format(valueObject) : (valueObject instanceof Boolean ? (((Boolean)valueObject).booleanValue() ? ModelEnviroment.getMessageResolver().resolveMessage("messages.default.yes", new Serializable[0]) : ModelEnviroment.getMessageResolver().resolveMessage("messages.default.no", new Serializable[0])) : (valueObject == null ? ModelEnviroment.getMessageResolver().resolveMessage("messages.default.noValue", new Serializable[0]) : valueObject.toString())));
            if (StringUtil.isBlank(value)) continue;
            ArrayList<Integer> entry = new ArrayList<Integer>(2);
            result = result + StringUtil.nullToEmpty(this.getName(e)) + ": ";
            entry.add(result.length());
            entry.add(value.length());
            result = result + value + "  ";
            positions.add(entry);
        }
        return result;
    }

    public Class<? extends Model> getModelClass(DataManagerType type) {
        switch (type) {
            case CUSTOMER: 
            case PICKPOINT: 
            case AREALOCATION: 
            case DELIVERERLOCATION: 
            case GROUPLOCATION: 
            case MAINLOCATION: 
            case AREADELIVERERLOCATION: {
                return PoiModel.class;
            }
            case PARCEL: {
                return ParcelModel.class;
            }
            case STOPS: {
                return StopModel.class;
            }
        }
        throw new RuntimeException("Type not implemented!");
    }

    public boolean removeModel(Model model) {
        boolean lastRowSelected = this.table.isRowSelected(this.tableModel.getRowCount() - 1);
        boolean remove = this.tableModel.remove(model);
        if (lastRowSelected) {
            int i = this.tableModel.getRowCount() - 1;
            this.table.getSelectionModel().addSelectionInterval(i, i);
        }
        return remove;
    }

    public ModelEnviroment getModelEnvironment() {
        return this.modelEnvironment;
    }

    public boolean isNoFocusChange() {
        return this.noFocusChange;
    }

    public void setNoFocusChange(boolean noFocusChange) {
        this.noFocusChange = noFocusChange;
    }

    public JTabbedPane getDataDisplayPane() {
        return this.dataDisplayPane;
    }

    public Map<DataManagerType, List<? extends Model>> getResultDataMap() {
        return this.resultDataMap;
    }

    public DataManagerType getCurrentType() {
        return this.typeComboBox.getSelectedValue();
    }

    public AreaLayerModel getCurrentLayer() {
        return this.layerComboBox.getLayer();
    }

    public List<? extends Model> getDataList() {
        return this.tableModel.getDataList();
    }

    public JTable getTable() {
        return this.table;
    }

    public int getTableRowCount() {
        return this.tableModel.getRowCount();
    }

    public JComboBox<Model> getSelectionComboBox() {
        return this.selectionComboBox;
    }

    public DataManagerListSelectionHandler getListSelectionHandler() {
        return this.listSelectionHandler;
    }

    public DataManagerMapEditorPanel getMapEditorPanel() {
        return this.mapEditorPanel;
    }

    public DataManagerAliasPane getAliasPane() {
        return this.aliasPane;
    }

    public DataManagerGeomEditorMapPane getGeoEditorPane() {
        return this.geoEditorPane;
    }

    public DataManagerControlGui getDataManagerControlGui() {
        return this.dataManagerControlGui;
    }

    public JMenu getImportMenu() {
        return this.importMenu;
    }

    public JMenu getExportMenu() {
        return this.exportMenu;
    }

    public AbstractToggleAction getShowMotorSegmentAction() {
        return this.mapEditorPanel.getShowMotorSegmentAction();
    }

    public AbstractToggleAction getShowFootSegmentAction() {
        return this.mapEditorPanel.getShowFootSegmentAction();
    }

    public AbstractToggleAction getShowBikeSegmentAction() {
        return this.mapEditorPanel.getShowBikeSegmentAction();
    }

    private boolean setApplyButtonEnabled() {
        boolean enabled = false;
        for (FilterButton filterButton : this.mapFilterButtons.values()) {
            enabled |= !filterButton.getAppliedDataMap().isEmpty();
        }
        this.applyButton.setEnabled(enabled);
        return enabled;
    }

    private int getVisibleFieldCount() {
        int count = 0;
        for (Map.Entry<Object, FilterButton> e : this.mapFilterButtons.entrySet()) {
            count += e.getValue().getFieldsToShowInResult().size();
        }
        return count;
    }

    private String getName(Object o) {
        if (o instanceof Enum) {
            return ModelEnviroment.getMessageResolver().resolveMessageForEnum((Enum)o);
        }
        if (o instanceof ParcelAttributeValueDescriptorModel) {
            return ((ParcelAttributeValueDescriptorModel)o).getName();
        }
        if (o instanceof AttributeGroupModel) {
            return this.getGroupName((AttributeGroupModel)o);
        }
        return null;
    }

    private String getGroupName(AttributeGroupModel group) {
        return group == null ? ModelEnviroment.getMessageResolver().resolveMessage("messages.default.noGroup", new Serializable[0]) : group.getName();
    }

    private void initFieldProperties() {
        EnumMap address = this.mapStaticValuesFilterButtons.get((Object)DataManagerFilters.ADDRESS).getFilter().getBody().getFieldVisibleIn();
        EnumMap date = this.mapStaticValuesFilterButtons.get((Object)DataManagerFilters.DATE).getFilter().getBody().getFieldVisibleIn();
        EnumMap id = this.mapStaticValuesFilterButtons.get((Object)DataManagerFilters.ID).getFilter().getBody().getFieldVisibleIn();
        EnumMap area = this.mapStaticValuesFilterButtons.get((Object)DataManagerFilters.AREA).getFilter().getBody().getFieldVisibleIn();
        EnumMap details = this.mapStaticValuesFilterButtons.get((Object)DataManagerFilters.DETAILS).getFilter().getBody().getFieldVisibleIn();
        FiltersBody specialBody = this.mapStaticValuesFilterButtons.get((Object)DataManagerFilters.SPECIAL).getFilter().getBody();
        EnumMap special = specialBody.getFieldVisibleIn();
        EnumMap specialHeadLines = specialBody.getHeadlines();
        address.put(DataManagerFilters.AddressFields.POSTCODE, EnumSet.allOf(DataManagerType.class));
        address.put(DataManagerFilters.AddressFields.CITY, EnumSet.allOf(DataManagerType.class));
        address.put(DataManagerFilters.AddressFields.DISTRICT, EnumSet.allOf(DataManagerType.class));
        address.put(DataManagerFilters.AddressFields.STREET, EnumSet.allOf(DataManagerType.class));
        address.put(DataManagerFilters.AddressFields.HOUSENUMBER, EnumSet.allOf(DataManagerType.class));
        address.put(DataManagerFilters.AddressFields.HOUSENUMBEREXTENSION, EnumSet.allOf(DataManagerType.class));
        address.put(DataManagerFilters.AddressFields.X, EnumSet.allOf(DataManagerType.class));
        address.put(DataManagerFilters.AddressFields.Y, EnumSet.allOf(DataManagerType.class));
        date.put(DataManagerFilters.DateFields.IMPORTDATE, EnumSet.allOf(DataManagerType.class));
        date.put(DataManagerFilters.DateFields.TOURDATE, EnumSet.of(DataManagerType.STOPS));
        id.put(DataManagerFilters.IDFields.PERSONAL, EnumSet.of(DataManagerType.DELIVERERLOCATION, DataManagerType.AREADELIVERERLOCATION));
        id.put(DataManagerFilters.IDFields.TOUR, EnumSet.of(DataManagerType.STOPS));
        id.put(DataManagerFilters.IDFields.ORDER, EnumSet.noneOf(DataManagerType.class));
        id.put(DataManagerFilters.IDFields.PARCEL, EnumSet.of(DataManagerType.PARCEL));
        id.put(DataManagerFilters.IDFields.POI, EnumSet.range(DataManagerType.CUSTOMER, DataManagerType.PICKPOINT));
        area.put(DataManagerFilters.AreaFields.ID, EnumSet.of(DataManagerType.PARCEL, DataManagerType.AREALOCATION));
        area.put(DataManagerFilters.AreaFields.NAME, EnumSet.of(DataManagerType.PARCEL, DataManagerType.AREALOCATION));
        details.put(DataManagerFilters.DetailsFields.NAME, EnumSet.of(DataManagerType.DELIVERERLOCATION, DataManagerType.AREADELIVERERLOCATION));
        details.put(DataManagerFilters.DetailsFields.CUSTOMERNAME, EnumSet.of(DataManagerType.MAINLOCATION, DataManagerType.GROUPLOCATION));
        details.put(DataManagerFilters.DetailsFields.SERVICETYPE, EnumSet.noneOf(DataManagerType.class));
        special.put(DataManagerFilters.SpecialFields.JUNCTION_FOOT, EnumSet.allOf(DataManagerType.class));
        special.put(DataManagerFilters.SpecialFields.JUNCTION_BIKE, EnumSet.allOf(DataManagerType.class));
        special.put(DataManagerFilters.SpecialFields.JUNCTION_MOTOR, EnumSet.allOf(DataManagerType.class));
        specialHeadLines.put(DataManagerFilters.SpecialFields.HL_MINDISTANCE, EnumSet.range(DataManagerFilters.SpecialFields.JUNCTION_FOOT, DataManagerFilters.SpecialFields.JUNCTION_MOTOR));
    }

    public boolean checkCloseConditions(Model model) {
        return !this.geoEditorPane.isSegmentChanged(model);
    }

    public void save() {
        if (this.checkCloseConditions(null)) {
            this.applyGeoDeltaCache();
            try {
                HashMap dirtyIdsMap = new HashMap();
                Map<Class<?>, Collection<Model>> dirtyModelMap = this.getModelEnvironment().getModelCache().getAllDirtyModels();
                this.getModelEnvironment().getUndoManager().storeTransactions();
                for (Class<?> key : dirtyModelMap.keySet()) {
                    Collection<? extends Model> models = dirtyModelMap.get(key);
                    HashSet ids = new HashSet();
                    CollectionUtil.transform(models, ids, new Transformer<Model, Long>(){

                        @Override
                        public Long transform(Model t) {
                            return t.getId();
                        }
                    });
                    dirtyIdsMap.put(key, ids);
                }
                ApplicationMessage applicationMessage = new ApplicationMessage(ApplicationMessage.Message.REFRESH_MODELS);
                applicationMessage.setPayload(dirtyIdsMap);
                ModelEnviroment.getDesktopClientApplication().dispatchApplicationMessage(applicationMessage);
            }
            catch (ValidateException e1) {
                this.getModelEnvironment().getUndoManager().handleValidateException(e1);
            }
        }
    }

    static {
        rangeFields.put(DataManagerFilters.DATE, EnumSet.allOf(DataManagerFilters.DateFields.class));
        floatFields.put(DataManagerFilters.SPECIAL, EnumSet.of(DataManagerFilters.SpecialFields.JUNCTION_FOOT, DataManagerFilters.SpecialFields.JUNCTION_BIKE, DataManagerFilters.SpecialFields.JUNCTION_MOTOR));
        defaultTableColumnMap.put(DataManagerFilters.ADDRESS, EnumSet.range(DataManagerFilters.AddressFields.POSTCODE, DataManagerFilters.AddressFields.HOUSENUMBEREXTENSION));
        defaultTableColumnMap.put(DataManagerFilters.ID, EnumSet.of(DataManagerFilters.IDFields.POI));
        defaultTableColumnMap.put(DataManagerFilters.AREA, EnumSet.of(DataManagerFilters.AreaFields.ID));
        numberFormat = NumberFormat.getNumberInstance();
    }

    private static final class GermanIntegerNumberTableCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1862582320901070789L;

        public GermanIntegerNumberTableCellRenderer() {
            this.setHorizontalAlignment(4);
        }
    }

    private static final class CoordinateTableCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 3458944164482120454L;
        private static final DecimalFormat format = new DecimalFormat("#0.000000000");

        private CoordinateTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            value = value == null ? null : format.format(value);
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
    }

    private class StopTableModel
    extends AbstractDataTableModel {
        private static final long serialVersionUID = -3395969445608171244L;
        private List<StopModel> stops;

        private StopTableModel() {
            this.stops = DataManagerGui.this.getResultDataMap().get((Object)DataManagerGui.this.getCurrentType());
        }

        @Override
        public int getRowCount() {
            return this.stops.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            StopModel stopModel;
            Object field = this.getFieldAt(columnIndex);
            StopModel stopModel2 = stopModel = this.stops.isEmpty() ? null : this.stops.get(rowIndex);
            if (field != null && stopModel != null && !stopModel.isDeleted()) {
                TourPartModel tourPart;
                if (field.getClass().equals(DataManagerFilters.DateFields.class)) {
                    TourPartModel tourPart2;
                    if (((DataManagerFilters.DateFields)((Object)field)).equals((Object)DataManagerFilters.DateFields.TOURDATE) && (tourPart2 = stopModel.getTourPart()) != null) {
                        TourModel tour = tourPart2.getTour();
                        return tour == null ? null : tour.getPlannedStartTime();
                    }
                } else if (field.getClass().equals(DataManagerFilters.IDFields.class) && ((DataManagerFilters.IDFields)((Object)field)).equals((Object)DataManagerFilters.IDFields.TOUR) && (tourPart = stopModel.getTourPart()) != null) {
                    TourModel tour = tourPart.getTour();
                    return tour == null ? null : tour.getName();
                }
                return super.getValueAt(rowIndex, columnIndex);
            }
            return null;
        }

        @Override
        public List<? extends Model> getDataList() {
            return this.stops;
        }

        @Override
        public int removeModel(Model model) {
            int row = this.stops.indexOf(model);
            if (row != -1) {
                this.stops.remove(row);
            }
            return row;
        }

        @Override
        protected LocationWrapper getLocationWrapper(int rowIndex) {
            StopModel stopModel = this.stops.get(rowIndex);
            return LocationWrapperFactory.INSTANCE.createLocationWrapper(stopModel.getLocation());
        }

        @Override
        protected Model getModel(int rowIndex) {
            return this.stops.get(rowIndex);
        }
    }

    private class GroupLocationTableModel
    extends PoiTableModel {
        private static final long serialVersionUID = 1746880720316281333L;

        private GroupLocationTableModel() {
        }
    }

    private class PickPointTableModel
    extends PoiTableModel {
        private static final long serialVersionUID = -2765620450307259320L;

        private PickPointTableModel() {
        }
    }

    private class CustomerTableModel
    extends PoiTableModel {
        private static final long serialVersionUID = 797146679915394569L;

        private CustomerTableModel() {
        }
    }

    private class DelivererLocationTableModel
    extends PoiTableModel {
        private static final long serialVersionUID = 2283567493607663525L;

        private DelivererLocationTableModel() {
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            boolean isDetailsField;
            Object field = this.getFieldAt(columnIndex);
            PoiModel poiModel = this.getModelInRow(rowIndex);
            boolean isIDField = false;
            if (field != null && poiModel != null && !poiModel.isDeleted() && ((isDetailsField = field.getClass().equals(DataManagerFilters.DetailsFields.class)) || (isIDField = field.getClass().equals(DataManagerFilters.IDFields.class)))) {
                LinkedList<DelivererModel> deliverers = new LinkedList<DelivererModel>();
                LinkedList<AreaDelivererModel> areaDeliverers = new LinkedList<AreaDelivererModel>();
                for (DelivererModel delivererModel : poiModel.iterableDeliverers()) {
                    deliverers.add(delivererModel);
                }
                for (AreaDelivererModel areaDelivererModel : poiModel.iterableAreaDeliverers()) {
                    areaDeliverers.add(areaDelivererModel);
                }
                if (isDetailsField) {
                    if (((DataManagerFilters.DetailsFields)((Object)field)).equals((Object)DataManagerFilters.DetailsFields.NAME)) {
                        String delivererNameString = StringUtil.implode(deliverers, ", ", new NameGenerator<DelivererModel>(){

                            @Override
                            public String getName(DelivererModel t) {
                                return t.getName();
                            }
                        });
                        String string = StringUtil.implode(areaDeliverers, ", ", new NameGenerator<AreaDelivererModel>(){

                            @Override
                            public String getName(AreaDelivererModel t) {
                                return t.getName();
                            }
                        });
                        return delivererNameString + (StringUtil.isBlank(string) ? "" : ", ") + string;
                    }
                } else if (isIDField && ((DataManagerFilters.IDFields)((Object)field)).equals((Object)DataManagerFilters.IDFields.PERSONAL)) {
                    String delivererIDString = StringUtil.implode(deliverers, ", ", new NameGenerator<DelivererModel>(){

                        @Override
                        public String getName(DelivererModel t) {
                            return t.getDelivererNumber();
                        }
                    });
                    String string = StringUtil.implode(areaDeliverers, ", ", new NameGenerator<AreaDelivererModel>(){

                        @Override
                        public String getName(AreaDelivererModel t) {
                            return t.getDelivererNumber();
                        }
                    });
                    return delivererIDString + (StringUtil.isBlank(string) ? "" : ", ") + string;
                }
            }
            return super.getValueAt(rowIndex, columnIndex);
        }
    }

    private class AreaLocationTableModel
    extends PoiTableModel {
        private static final long serialVersionUID = -5577184625810886784L;

        private AreaLocationTableModel() {
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            Object field = this.getFieldAt(columnIndex);
            PoiModel poiModel = this.getModelInRow(rowIndex);
            if (field != null && poiModel != null && !poiModel.isDeleted() && field.getClass().equals(DataManagerFilters.AreaFields.class)) {
                LinkedList<AreaObjectModel> areaObjModels = new LinkedList<AreaObjectModel>();
                AreaObjectModel omCurrentLayer = null;
                for (AreaObjectModel model : poiModel.iterableAreaObjects()) {
                    if (DataManagerGui.this.getCurrentLayer() == null || !model.getAreaLayer().equals(DataManagerGui.this.getCurrentLayer())) {
                        areaObjModels.add(model);
                        continue;
                    }
                    omCurrentLayer = model;
                }
                switch ((DataManagerFilters.AreaFields)((Object)field)) {
                    case ID: {
                        return this.prefix(omCurrentLayer, areaObjModels, field) + StringUtil.implode(areaObjModels, ", ", new NameGenerator<AreaObjectModel>(){

                            @Override
                            public String getName(AreaObjectModel t) {
                                return t.getShortcut() + " (" + t.getAreaLayer().getDisplayname() + ")";
                            }
                        });
                    }
                    case NAME: {
                        return this.prefix(omCurrentLayer, areaObjModels, field) + StringUtil.implode(areaObjModels, ", ", new NameGenerator<AreaObjectModel>(){

                            @Override
                            public String getName(AreaObjectModel t) {
                                return t.getDisplayname() + " (" + t.getAreaLayer().getDisplayname() + ")";
                            }
                        });
                    }
                }
            }
            return super.getValueAt(rowIndex, columnIndex);
        }

        private String prefix(AreaObjectModel omCurrentLayer, LinkedList<AreaObjectModel> areaObjModels, Object field) {
            if (omCurrentLayer == null) {
                return "";
            }
            String infoString = field.equals((Object)DataManagerFilters.AreaFields.ID) ? omCurrentLayer.getShortcut() : omCurrentLayer.getDisplayname();
            String other = areaObjModels.isEmpty() ? "" : "  " + ModelEnviroment.getMessageResolver().resolveMessage("messages.data.layer.other", new Serializable[0]) + ": ";
            return omCurrentLayer.getAreaLayer().getDisplayname() + ": " + infoString + other;
        }
    }

    private class MainLocationTableModel
    extends PoiTableModel {
        private static final long serialVersionUID = -1659858790335272396L;

        private MainLocationTableModel() {
        }
    }

    private abstract class PoiTableModel
    extends AbstractDataTableModel {
        private static final long serialVersionUID = 6475096952127516835L;
        private List<PoiModel> pois;

        private PoiTableModel() {
            this.pois = (List)DataManagerGui.this.resultDataMap.get((Object)DataManagerGui.this.getCurrentType());
        }

        @Override
        public int getRowCount() {
            return this.pois.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            Object field = this.getFieldAt(columnIndex);
            PoiModel poiModel = this.getModelInRow(rowIndex);
            if (field != null && poiModel != null && !poiModel.isDeleted()) {
                if (field.getClass().equals(DataManagerFilters.IDFields.class)) {
                    if (((DataManagerFilters.IDFields)((Object)field)).equals((Object)DataManagerFilters.IDFields.POI)) {
                        return poiModel.getPoiNumber();
                    }
                } else if (field.getClass().equals(DataManagerFilters.DetailsFields.class) && ((DataManagerFilters.DetailsFields)((Object)field)).equals((Object)DataManagerFilters.DetailsFields.CUSTOMERNAME)) {
                    return poiModel.getName();
                }
                return super.getValueAt(rowIndex, columnIndex);
            }
            return null;
        }

        protected PoiModel getModelInRow(int rowIndex) {
            return this.pois.isEmpty() ? null : this.pois.get(rowIndex);
        }

        @Override
        public List<? extends Model> getDataList() {
            return this.pois;
        }

        @Override
        public int removeModel(Model model) {
            int row = this.pois.indexOf(model);
            if (row != -1) {
                this.pois.remove(row);
            }
            return row;
        }

        @Override
        protected LocationWrapper getLocationWrapper(int rowIndex) {
            PoiModel poiModel = this.pois.get(rowIndex);
            return LocationWrapperFactory.INSTANCE.createLocationWrapper(poiModel.getLocation());
        }

        @Override
        protected Model getModel(int rowIndex) {
            return this.pois.get(rowIndex);
        }
    }

    private class ParcelTableModel
    extends AbstractDataTableModel {
        private static final long serialVersionUID = -1647355589693583660L;
        private List<ParcelModel> parcels;

        private ParcelTableModel() {
            this.parcels = (List)DataManagerGui.this.resultDataMap.get((Object)DataManagerType.PARCEL);
        }

        @Override
        public int getRowCount() {
            return this.parcels.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            ParcelModel parcelModel;
            Object field = this.getFieldAt(columnIndex);
            ParcelModel parcelModel2 = parcelModel = this.parcels.isEmpty() ? null : this.parcels.get(rowIndex);
            if (field != null && parcelModel != null && !parcelModel.isDeleted()) {
                if (field.getClass().equals(DataManagerFilters.AddressFields.class)) {
                    switch ((DataManagerFilters.AddressFields)((Object)field)) {
                        case CITY: {
                            return parcelModel.getStreet().getPostcodeDistrictRelation().getDistrict().getCity().getName();
                        }
                        case DISTRICT: {
                            return parcelModel.getStreet().getPostcodeDistrictRelation().getDistrict().getName();
                        }
                        case HOUSENUMBER: {
                            Integer houseNumber = null;
                            try {
                                houseNumber = Integer.parseInt(parcelModel.getHouseNumber());
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                            return houseNumber;
                        }
                        case HOUSENUMBEREXTENSION: {
                            return parcelModel.getHouseNumberExtension();
                        }
                        case POSTCODE: {
                            return parcelModel.getStreet().getPostcodeDistrictRelation().getPostcode().getName();
                        }
                        case STREET: {
                            return parcelModel.getStreet().getName();
                        }
                        case X: {
                            return this.getCoordinate(rowIndex).getX();
                        }
                        case Y: {
                            return this.getCoordinate(rowIndex).getY();
                        }
                    }
                } else if (field.getClass().equals(DataManagerFilters.IDFields.class)) {
                    if (((DataManagerFilters.IDFields)((Object)field)).equals((Object)DataManagerFilters.IDFields.PARCEL)) {
                        return this.getParcelID(rowIndex);
                    }
                } else if (field.getClass().equals(DataManagerFilters.AreaFields.class)) {
                    LinkedList<AreaObjectModel> areaObjModels = new LinkedList<AreaObjectModel>();
                    for (AreaObjectParcelRelModel rel : parcelModel.iterableAreaObjectParcelRel()) {
                        AreaObjectModel model = rel.getAreaObject();
                        if (DataManagerGui.this.getCurrentLayer() != null && !DataManagerGui.this.getCurrentLayer().equals(model.getAreaLayer())) continue;
                        areaObjModels.add(model);
                        if (model.getAreaLayer() == null || !model.getAreaLayer().equals(DataManagerGui.this.getCurrentLayer())) continue;
                        break;
                    }
                    switch ((DataManagerFilters.AreaFields)((Object)field)) {
                        case ID: {
                            return StringUtil.implode(areaObjModels, ", ", new NameGenerator<AreaObjectModel>(){

                                @Override
                                public String getName(AreaObjectModel t) {
                                    return t.getShortcut();
                                }
                            });
                        }
                        case NAME: {
                            return StringUtil.implode(areaObjModels, ", ", new NameGenerator<AreaObjectModel>(){

                                @Override
                                public String getName(AreaObjectModel t) {
                                    return t.getDisplayname();
                                }
                            });
                        }
                    }
                } else if (field instanceof ParcelAttributeValueDescriptorModel) {
                    ParcelAttributeValueDescriptorModel parcelAttValDescModel = (ParcelAttributeValueDescriptorModel)field;
                    ParcelAttributeValueModel parcelAttrValModel = this.getAttribute(this.parcels.get(rowIndex).iterableParcelAttributeValues(), parcelAttValDescModel);
                    if (parcelAttrValModel != null) {
                        switch (parcelAttValDescModel.getAttributeValueType()) {
                            case BOOLEAN: {
                                return parcelAttrValModel.getBooleanValue();
                            }
                            case DATE: {
                                return parcelAttrValModel.getLongValue() == null ? null : new Date(parcelAttrValModel.getLongValue());
                            }
                            case FLOAT: {
                                return parcelAttrValModel.getFloatValue();
                            }
                            case INTEGER: {
                                return parcelAttrValModel.getIntegerValue();
                            }
                            case STATIC_CHOICE: {
                                return parcelAttrValModel.getStaticChoiceValue() == null ? null : parcelAttrValModel.getStaticChoiceValue().getName();
                            }
                            case STRING: {
                                return parcelAttrValModel.getStringValue();
                            }
                        }
                    }
                }
                return super.getValueAt(rowIndex, columnIndex);
            }
            return null;
        }

        private ParcelAttributeValueModel getAttribute(Iterable<ParcelAttributeValueModel> attributes, ParcelAttributeValueDescriptorModel descriptor) {
            ParcelAttributeValueModel current = null;
            for (ParcelAttributeValueModel value : attributes) {
                if (!new EqualsBuilder().append(value.getParcelAttributeValueDescriptor(), descriptor).isEquals()) continue;
                current = value;
            }
            return current;
        }

        private String getParcelID(int rowIndex) {
            return this.parcels.get(rowIndex).getImportKey();
        }

        private Coordinate getCoordinate(int rowIndex) {
            ImmutablePoint imPoint = this.parcels.get(rowIndex).getGeom();
            return Wgs84Factory.INSTANCE.createCoordinate(imPoint.getCoordinate());
        }

        @Override
        public List<? extends Model> getDataList() {
            return this.parcels;
        }

        @Override
        public int removeModel(Model model) {
            int row = this.parcels.indexOf(model);
            if (row != -1) {
                this.parcels.remove(row);
            }
            return row;
        }

        @Override
        protected LocationWrapper getLocationWrapper(int rowIndex) {
            ParcelModel parcelModel = this.parcels.get(rowIndex);
            return LocationWrapperFactory.INSTANCE.createLocationWrapper(parcelModel);
        }

        @Override
        protected Model getModel(int rowIndex) {
            return this.parcels.get(rowIndex);
        }

        @Override
        public Class<?> getColumnClass(int c) {
            if (this.getFieldAt(c) instanceof ParcelAttributeValueDescriptorModel) {
                ParcelAttributeValueDescriptorModel desc = (ParcelAttributeValueDescriptorModel)this.getFieldAt(c);
                switch (desc.getAttributeValueType()) {
                    case BOOLEAN: {
                        return Boolean.class;
                    }
                    case DATE: {
                        return Date.class;
                    }
                    case FLOAT: {
                        return Float.class;
                    }
                    case IMAGE: {
                        break;
                    }
                    case INTEGER: {
                        return Integer.class;
                    }
                    case MULTIPLE_LIST_CHOICE: 
                    case MULTI_INTEGER: {
                        break;
                    }
                    case PDF_DOWN: {
                        break;
                    }
                    case STATIC_CHOICE: {
                        break;
                    }
                    case STRING: {
                        return String.class;
                    }
                    case TEXT: {
                        return String.class;
                    }
                }
            }
            return super.getColumnClass(c);
        }
    }

    private abstract class AbstractDataTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1557982614187857362L;

        private AbstractDataTableModel() {
        }

        protected Object getFieldAt(int col) {
            Iterator itFilters = DataManagerGui.this.mapFilterButtons.values().iterator();
            int offset = col;
            Object field = null;
            while (itFilters.hasNext()) {
                Set<?> fields = ((FilterButton)itFilters.next()).getFieldsToShowInResult();
                if (fields.size() <= offset) {
                    offset -= fields.size();
                    continue;
                }
                field = fields.toArray(new Object[fields.size()])[offset];
                break;
            }
            return field;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            Object field = this.getFieldAt(columnIndex);
            if (field != null && field.getClass().equals(DataManagerFilters.AddressFields.class)) {
                LocationWrapper locationWrapper = this.getLocationWrapper(rowIndex);
                try {
                    switch ((DataManagerFilters.AddressFields)((Object)field)) {
                        case CITY: {
                            return locationWrapper.getCity();
                        }
                        case DISTRICT: {
                            return locationWrapper.getDistrict();
                        }
                        case HOUSENUMBER: {
                            return locationWrapper.getHousenumber();
                        }
                        case HOUSENUMBEREXTENSION: {
                            return locationWrapper.getHousenumberExtension();
                        }
                        case POSTCODE: {
                            return locationWrapper.getPostcode();
                        }
                        case STREET: {
                            return locationWrapper.getStreet();
                        }
                        case X: {
                            return Wgs84Factory.INSTANCE.createCoordinate(locationWrapper.getRealGeoLocation().getCoordinate()).getX();
                        }
                        case Y: {
                            return Wgs84Factory.INSTANCE.createCoordinate(locationWrapper.getRealGeoLocation().getCoordinate()).getY();
                        }
                    }
                }
                catch (NullPointerException nullPointerException) {}
            } else if (field.getClass().equals(DataManagerFilters.DateFields.class)) {
                if (((DataManagerFilters.DateFields)((Object)field)).equals((Object)DataManagerFilters.DateFields.IMPORTDATE)) {
                    return this.getModel(rowIndex).getCreationDate();
                }
            } else if (field.getClass().equals(DataManagerFilters.SpecialFields.class)) {
                LocationWrapper locationWrapper = this.getLocationWrapper(rowIndex);
                Double distance = null;
                switch ((DataManagerFilters.SpecialFields)((Object)field)) {
                    case DUPLICATES: 
                    case HL_MINDISTANCE: {
                        break;
                    }
                    case JUNCTION_BIKE: {
                        SegmentModel bikeSegment = locationWrapper.getBikeSegment();
                        if (bikeSegment != null) {
                            distance = Math.ceil(GeoUtils.getDistanceInMeter(bikeSegment.getGeom(), locationWrapper.getGeoLocation()));
                        }
                        return new GermanIntegerNumber(distance);
                    }
                    case JUNCTION_FOOT: {
                        SegmentModel footSegment = locationWrapper.getFootSegment();
                        if (footSegment != null) {
                            distance = Math.ceil(GeoUtils.getDistanceInMeter(footSegment.getGeom(), locationWrapper.getGeoLocation()));
                        }
                        return new GermanIntegerNumber(distance);
                    }
                    case JUNCTION_MOTOR: {
                        SegmentModel motorSegment = locationWrapper.getMotorSegment();
                        if (motorSegment != null) {
                            distance = Math.ceil(GeoUtils.getDistanceInMeter(motorSegment.getGeom(), locationWrapper.getGeoLocation()));
                        }
                        return new GermanIntegerNumber(distance);
                    }
                }
            }
            return null;
        }

        @Override
        public int getColumnCount() {
            return DataManagerGui.this.getVisibleFieldCount();
        }

        @Override
        public String getColumnName(int col) {
            Object fieldAt = this.getFieldAt(col);
            String name = DataManagerGui.this.getName(fieldAt);
            return name != null ? name : super.getColumnName(col);
        }

        @Override
        public Class<?> getColumnClass(int c) {
            return this.getValueAt(0, c) == null ? Object.class : this.getValueAt(0, c).getClass();
        }

        protected abstract LocationWrapper getLocationWrapper(int var1);

        protected abstract Model getModel(int var1);

        public abstract List<? extends Model> getDataList();

        public abstract int removeModel(Model var1);

        public boolean remove(Model model) {
            boolean existed;
            int row = this.removeModel(model);
            boolean bl = existed = row != -1;
            if (existed) {
                this.fireTableRowsDeleted(row, row);
            }
            return existed;
        }
    }

    private class GermanIntegerNumber
    implements Comparable<GermanIntegerNumber> {
        private Double number;

        public GermanIntegerNumber(Double number) {
            this.setNumber(number);
        }

        public String toString() {
            return this.number == null ? "" : numberFormat.format((int)this.number.doubleValue());
        }

        @Override
        public int compareTo(GermanIntegerNumber o) {
            if (this.number == null) {
                return o.getNumber() == null ? 0 : -1;
            }
            return o.getNumber() == null ? 1 : this.getNumber().compareTo(o.getNumber());
        }

        public Double getNumber() {
            return this.number;
        }

        public void setNumber(Double number) {
            this.number = number;
        }
    }

    private class AttributeFilterButton
    extends FilterButton {
        private static final long serialVersionUID = 1L;
        private AttributeGroupModel group;
        private FiltersBodyAttributes body;
        private JLayeredPane layeredPane;
        private JPanel filterDetailsPane;
        private JCheckBox selectAll;
        private AbstractAction okAction;
        private boolean visibleFieldsChanged;
        protected Point drawnButtonPoint;

        public AttributeFilterButton(AttributeGroupModel group, Collection<ParcelAttributeValueDescriptorModel> descriptors) {
            super(DataManagerGui.this.getGroupName(group), UIManager.getIcon("Table.descendingSortIcon"));
            this.visibleFieldsChanged = false;
            DataManagerGui.this.defaultForeground = this.getForeground();
            DataManagerGui.this.defaultBackground = this.getBackground();
            this.group = group;
            this.body = new FiltersBodyAttributes(descriptors.toArray(new ParcelAttributeValueDescriptorModel[descriptors.size()]));
            this.layeredPane = DataManagerGui.this.rootPane.getLayeredPane();
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int x = AttributeFilterButton.this.getX();
                    int y = AttributeFilterButton.this.getY();
                    Point buttonPoint = SwingUtilities.convertPoint(AttributeFilterButton.this.getParent(), x, y, AttributeFilterButton.this.layeredPane);
                    if (AttributeFilterButton.this.filterDetailsPane == null) {
                        AttributeFilterButton.this.drawnButtonPoint = buttonPoint;
                        AttributeFilterButton.this.filterDetailsPane = AttributeFilterButton.this.generateFilterDetailsPane();
                    }
                    if (AttributeFilterButton.this.drawnButtonPoint == null || !AttributeFilterButton.this.drawnButtonPoint.equals(buttonPoint)) {
                        AttributeFilterButton.this.filterDetailsPane.setBounds((int)buttonPoint.getX(), (int)buttonPoint.getY() + AttributeFilterButton.this.getHeight(), (int)AttributeFilterButton.this.filterDetailsPane.getPreferredSize().getWidth(), (int)AttributeFilterButton.this.filterDetailsPane.getPreferredSize().getHeight());
                        AttributeFilterButton.this.drawnButtonPoint = buttonPoint;
                    }
                    AttributeFilterButton.this.filterDetailsPane.setVisible(AttributeFilterButton.this.filterDetailsPane.isVisible() ^ true);
                    if (AttributeFilterButton.this.filterDetailsPane.isVisible()) {
                        Toolkit.getDefaultToolkit().addAWTEventListener(new AWTEventListener(){

                            @Override
                            public void eventDispatched(AWTEvent event) {
                                if (event instanceof MouseEvent) {
                                    MouseEvent mEvent = (MouseEvent)event;
                                    Point mousePointerPoint = mEvent.getPoint();
                                    Point filterDetailsPanePoint = SwingUtilities.convertPoint((Component)mEvent.getSource(), mousePointerPoint, AttributeFilterButton.this.filterDetailsPane);
                                    Point filterButtonPoint = SwingUtilities.convertPoint((Component)mEvent.getSource(), mousePointerPoint, AttributeFilterButton.this);
                                    if (mEvent.getClickCount() > 0 && !AttributeFilterButton.this.filterDetailsPane.contains(filterDetailsPanePoint) && !AttributeFilterButton.this.contains(filterButtonPoint)) {
                                        AttributeFilterButton.this.filterDetailsPane.setVisible(false);
                                        AttributeFilterButton.this.applyFilter();
                                        AttributeFilterButton.this.applyToTableIfChanged();
                                        Toolkit.getDefaultToolkit().removeAWTEventListener(this);
                                    }
                                }
                            }
                        }, 16L);
                    } else {
                        AttributeFilterButton.this.applyFilter();
                        AttributeFilterButton.this.applyToTableIfChanged();
                    }
                }
            });
            this.okAction = new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.apply", new Serializable[0])){
                private static final long serialVersionUID = 2244078186657535544L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    AttributeFilterButton.this.applyFilter();
                    AttributeFilterButton.this.applyToTableIfChanged();
                    AttributeFilterButton.this.filterDetailsPane.setVisible(false);
                }
            };
        }

        private void applyToTableIfChanged() {
            if (this.visibleFieldsChanged) {
                DataManagerGui.this.applyToTable();
                this.visibleFieldsChanged = false;
            }
        }

        @Override
        protected void paintComponent(Graphics g) {
            this.setIconTextGap((g.getFontMetrics().stringWidth(this.getText()) + 16) * -1);
            Graphics2D g2 = (Graphics2D)g.create();
            g2.setPaint(this.getBackground());
            g2.drawRoundRect(0, 0, this.getWidth() - 1, this.getHeight() - 1, 8, 8);
            super.paintComponent(g);
            g2.dispose();
        }

        @Override
        public void invalidatePane() {
            if (this.filterDetailsPane != null) {
                this.clear();
                this.filterDetailsPane.invalidate();
                this.filterDetailsPane = null;
            }
            this.setButtonEnabled();
        }

        private void setButtonEnabled() {
            this.setEnabled(this.getBody().getAllFields().length != 0);
        }

        private JPanel generateFilterDetailsPane() {
            boolean displaySelAll;
            JPanel panel = new JPanel(new BorderLayout());
            JPanel fieldWrapperPanel = new JPanel(new BorderLayout());
            JPanel fieldPanel = new JPanel(null);
            GroupLayout layout = new GroupLayout(fieldPanel);
            fieldPanel.setLayout(layout);
            layout.setAutoCreateContainerGaps(true);
            layout.setAutoCreateGaps(true);
            Quint<GroupLayout.ParallelGroup, GroupLayout.ParallelGroup, GroupLayout.ParallelGroup, GroupLayout.ParallelGroup, GroupLayout.SequentialGroup> groups = new Quint<GroupLayout.ParallelGroup, GroupLayout.ParallelGroup, GroupLayout.ParallelGroup, GroupLayout.ParallelGroup, GroupLayout.SequentialGroup>(layout.createParallelGroup(), layout.createParallelGroup(), layout.createParallelGroup(), layout.createParallelGroup(), layout.createSequentialGroup());
            layout.setHorizontalGroup(layout.createSequentialGroup().addGroup(groups.getElement1()).addGroup(groups.getElement2()).addGroup(groups.getElement3()).addGroup(groups.getElement4()));
            layout.setVerticalGroup(groups.getElement5());
            Collection<ParcelAttributeValueDescriptorModel> visibleFields = this.getBody().getVisibleFields(false);
            Collection<ParcelAttributeValueDescriptorModel> visibleFieldsWithHeadlines = this.getBody().getVisibleFields(true);
            Set<ParcelAttributeValueDescriptorModel> markedFields = this.getBody().getFieldsToShowInResult();
            this.selectAll = new JCheckBox(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.all", new Serializable[0]));
            this.selectAll.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AttributeFilterButton.this.selectAll();
                }
            });
            JLabel headline = new JLabel(DataManagerGui.this.getGroupName(this.group));
            JLabel icon = new JLabel(UIManager.getIcon("FileView.directoryIcon"));
            JLabel noValueHeadline = new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.noValue", new Serializable[0]));
            groups.getElement1().addComponent(headline);
            groups.getElement3().addComponent(noValueHeadline);
            groups.getElement4().addComponent(icon);
            groups.getElement5().addGroup(layout.createParallelGroup().addComponent(headline).addComponent(noValueHeadline).addComponent(icon));
            boolean bl = displaySelAll = visibleFields.size() > 1;
            if (displaySelAll) {
                groups.getElement4().addComponent(this.selectAll);
                groups.getElement5().addComponent(this.selectAll);
            } else {
                groups.getElement5().addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED);
            }
            for (ParcelAttributeValueDescriptorModel e : visibleFieldsWithHeadlines) {
                JLabel label = new JLabel(e.getName());
                if (!this.getBody().getHeadlines().containsKey(e)) {
                    JCheckBox checkBoxNoValue = new JCheckBox("");
                    AbstractFilterField filterField = this.getFilterField(e);
                    final JCheckBox checkBoxShow = new JCheckBox("", markedFields.contains(e));
                    checkBoxShow.addItemListener(new ItemListener(){

                        @Override
                        public void itemStateChanged(ItemEvent e) {
                            AttributeFilterButton.this.visibleFieldsChanged = true;
                        }
                    });
                    filterField.addValueChangeListener(new PropertyChangeListener(){

                        @Override
                        public void propertyChange(PropertyChangeEvent evt) {
                            checkBoxShow.setSelected(checkBoxShow.isSelected() || evt.getNewValue() != null && !evt.getNewValue().toString().equals(""));
                        }
                    });
                    this.getBody().getFieldMap().put(e, new Tripel<AbstractFilterField, JCheckBox, JCheckBox>(filterField, checkBoxShow, checkBoxNoValue));
                    this.addRow(groups, layout.createParallelGroup(GroupLayout.Alignment.CENTER), label, filterField, checkBoxNoValue, checkBoxShow);
                    continue;
                }
                this.addRow(groups, layout.createParallelGroup(GroupLayout.Alignment.CENTER), label, new JLabel(""), new JLabel(""), new JLabel(""));
                groups.getElement5().addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED);
            }
            fieldWrapperPanel.add((Component)fieldPanel, "Center");
            fieldWrapperPanel.setBorder(BorderFactory.createRaisedSoftBevelBorder());
            panel.add((Component)fieldWrapperPanel, "Center");
            this.layeredPane.add((Component)panel, JLayeredPane.MODAL_LAYER);
            int x = this.getX();
            int y = this.getY();
            Point buttonPoint = SwingUtilities.convertPoint(this.getParent(), x, y, this.layeredPane);
            int buttonPanelWidth = (int)panel.getPreferredSize().getWidth();
            int clippingOffset = Math.max(buttonPoint.x + buttonPanelWidth - this.layeredPane.getBounds().width, 0);
            panel.setBounds((int)buttonPoint.getX() - clippingOffset, (int)buttonPoint.getY() + this.getHeight(), buttonPanelWidth, (int)panel.getPreferredSize().getHeight());
            panel.setBorder(BorderFactory.createLineBorder(Color.black));
            panel.addMouseListener(new MouseAdapter(){});
            panel.setVisible(false);
            this.addEnterAction(panel);
            return panel;
        }

        private void addRow(Quint<GroupLayout.ParallelGroup, GroupLayout.ParallelGroup, GroupLayout.ParallelGroup, GroupLayout.ParallelGroup, GroupLayout.SequentialGroup> groups, GroupLayout.ParallelGroup rowGroup, Component comp1, Component comp2, Component comp3, Component comp4) {
            groups.getElement1().addComponent(comp1);
            groups.getElement2().addComponent(comp2);
            groups.getElement3().addComponent(comp3);
            groups.getElement4().addComponent(comp4);
            rowGroup.addComponent(comp1);
            rowGroup.addComponent(comp2);
            rowGroup.addComponent(comp3);
            rowGroup.addComponent(comp4);
            groups.getElement5().addGroup(rowGroup);
        }

        private void selectAll() {
            Collection<ParcelAttributeValueDescriptorModel> fields = this.getBody().getVisibleFields(false);
            for (ParcelAttributeValueDescriptorModel e : fields) {
                this.getBody().getCheckBox(e).setSelected(this.selectAll.isSelected());
            }
        }

        @Override
        public void clear() {
            if (this.selectAll != null) {
                this.selectAll.setSelected(false);
            }
            Map<ParcelAttributeValueDescriptorModel, Tripel<? extends JPanel, JCheckBox, JCheckBox>> fieldMap = this.getBody().getFieldMap();
            for (Map.Entry<ParcelAttributeValueDescriptorModel, Tripel<? extends JPanel, JCheckBox, JCheckBox>> e : fieldMap.entrySet()) {
                Tripel<? extends JPanel, JCheckBox, JCheckBox> tupel = e.getValue();
                ((AbstractFilterField)tupel.getElement1()).clear();
                tupel.getElement3().setSelected(false);
            }
            if (this.filterDetailsPane != null) {
                this.applyFilter();
            }
        }

        private void applyFilter() {
            Collection<ParcelAttributeValueDescriptorModel> fields = this.getBody().getVisibleFields(false);
            for (ParcelAttributeValueDescriptorModel f : fields) {
                if (StringUtil.isBlank(((AbstractFilterField)this.getBody().getFilterField(f)).getText())) {
                    this.getBody().remove(f);
                } else {
                    Object value = ((AbstractFilterField)this.getBody().getFilterField(f)).getValue();
                    if (value instanceof String) {
                        value = ((String)value).trim();
                    }
                    this.getBody().put(f, value);
                }
                if (this.getBody().isSearchForNullValues(f)) {
                    this.getBody().put(f, null);
                } else {
                    this.getBody().removeNull(f);
                }
                if (this.getBody().getCheckBox(f).isSelected()) {
                    this.getBody().getFieldsToShowInResult().add(f);
                    continue;
                }
                this.getBody().getFieldsToShowInResult().remove(f);
            }
            if (this.getBody().getAppliedDataMap().isEmpty()) {
                this.setForeground(DataManagerGui.this.defaultForeground);
                this.setBackground(DataManagerGui.this.defaultBackground);
            } else {
                this.setForeground(Color.BLUE);
                this.setBackground(Color.CYAN.darker());
            }
            if (this.getBody().hasChanged()) {
                DataManagerGui.this.updateFilterDisplayTextField(null);
                this.getBody().clearChanged();
                if (DataManagerGui.this.setApplyButtonEnabled()) {
                    DataManagerGui.this.applyButton.setForeground(Color.BLUE);
                    DataManagerGui.this.filterDisplayTextPane.setBackground(Color.CYAN.darker());
                } else {
                    DataManagerGui.this.filterDisplayTextPane.setBackground(DataManagerGui.this.defaultTextPaneBackground);
                }
            }
        }

        private AbstractFilterField getFilterField(ParcelAttributeValueDescriptorModel descriptor) {
            switch (descriptor.getAttributeValueType()) {
                case BOOLEAN: {
                    return new BooleanFilterField();
                }
                case STATIC_CHOICE: {
                    return new AttributeStaticChoiceFilterField(descriptor);
                }
                case DATE: {
                    return new FilterRangeTextField(new IntervalLimitRegulatorDate());
                }
                case FLOAT: 
                case INTEGER: {
                    return new FilterRangeTextField(new IntervalLimitRegulatorNumber());
                }
                case STRING: {
                    return new FilterTextField();
                }
            }
            return null;
        }

        public FiltersBodyAttributes getBody() {
            return this.body;
        }

        @Override
        public void setSelectAll(boolean selected) {
            if (this.filterDetailsPane == null) {
                this.filterDetailsPane = this.generateFilterDetailsPane();
            }
            this.selectAll.setSelected(selected);
            this.selectAll();
            this.applyFilter();
        }

        @Override
        public void closeDetailsPane() {
            if (this.filterDetailsPane != null && this.filterDetailsPane.isVisible()) {
                this.filterDetailsPane.setVisible(false);
                this.applyFilter();
                this.applyToTableIfChanged();
            }
        }

        private void addEnterAction(JPanel panel) {
            panel.getInputMap(2).put(KeyStroke.getKeyStroke("ENTER"), "enterAction");
            panel.getActionMap().put("enterAction", this.okAction);
        }

        @Override
        protected Set<?> getAppliedDataKeys() {
            return this.getBody().getAppliedDataKeys();
        }

        @Override
        protected Map<? extends Object, Object> getAppliedDataMap() {
            return this.getBody().getAppliedDataMap();
        }

        @Override
        protected Set<?> getFieldsToShowInResult() {
            return this.getBody().getFieldsToShowInResult();
        }
    }

    private class StaticValuesFilterButton
    extends FilterButton {
        private static final long serialVersionUID = 3965971151790000721L;
        private DataManagerFilters filter;
        private JLayeredPane layeredPane;
        private JPanel filterDetailsPane;
        private JCheckBox selectAll;
        private AbstractAction okAction;
        private boolean visibleFieldsChanged;
        private Point drawnButtonPoint;

        public StaticValuesFilterButton(DataManagerFilters filter) {
            super(ModelEnviroment.getMessageResolver().resolveMessageForEnum(filter), UIManager.getIcon("Table.descendingSortIcon"));
            this.visibleFieldsChanged = false;
            DataManagerGui.this.defaultForeground = this.getForeground();
            DataManagerGui.this.defaultBackground = this.getBackground();
            this.filter = filter;
            this.layeredPane = DataManagerGui.this.rootPane.getLayeredPane();
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int x = StaticValuesFilterButton.this.getX();
                    int y = StaticValuesFilterButton.this.getY();
                    Point buttonPoint = SwingUtilities.convertPoint(StaticValuesFilterButton.this.getParent(), x, y, StaticValuesFilterButton.this.layeredPane);
                    if (StaticValuesFilterButton.this.filterDetailsPane == null) {
                        StaticValuesFilterButton.this.drawnButtonPoint = buttonPoint;
                        StaticValuesFilterButton.this.filterDetailsPane = StaticValuesFilterButton.this.generateFilterDetailsPane();
                    }
                    if (StaticValuesFilterButton.this.drawnButtonPoint == null || !StaticValuesFilterButton.this.drawnButtonPoint.equals(buttonPoint)) {
                        StaticValuesFilterButton.this.filterDetailsPane.setBounds((int)buttonPoint.getX(), (int)buttonPoint.getY() + StaticValuesFilterButton.this.getHeight(), (int)StaticValuesFilterButton.this.filterDetailsPane.getPreferredSize().getWidth(), (int)StaticValuesFilterButton.this.filterDetailsPane.getPreferredSize().getHeight());
                        StaticValuesFilterButton.this.drawnButtonPoint = buttonPoint;
                    }
                    StaticValuesFilterButton.this.filterDetailsPane.setVisible(StaticValuesFilterButton.this.filterDetailsPane.isVisible() ^ true);
                    if (StaticValuesFilterButton.this.filterDetailsPane.isVisible()) {
                        Toolkit.getDefaultToolkit().addAWTEventListener(new AWTEventListener(){

                            @Override
                            public void eventDispatched(AWTEvent event) {
                                if (event instanceof MouseEvent) {
                                    MouseEvent mEvent = (MouseEvent)event;
                                    Point mousePointerPoint = mEvent.getPoint();
                                    Point filterDetailsPanePoint = SwingUtilities.convertPoint((Component)mEvent.getSource(), mousePointerPoint, StaticValuesFilterButton.this.filterDetailsPane);
                                    Point filterButtonPoint = SwingUtilities.convertPoint((Component)mEvent.getSource(), mousePointerPoint, StaticValuesFilterButton.this);
                                    if (mEvent.getClickCount() > 0 && !StaticValuesFilterButton.this.filterDetailsPane.contains(filterDetailsPanePoint) && !StaticValuesFilterButton.this.contains(filterButtonPoint)) {
                                        StaticValuesFilterButton.this.filterDetailsPane.setVisible(false);
                                        StaticValuesFilterButton.this.applyFilter();
                                        StaticValuesFilterButton.this.applyToTableIfChanged();
                                        Toolkit.getDefaultToolkit().removeAWTEventListener(this);
                                    }
                                }
                            }
                        }, 16L);
                    } else {
                        StaticValuesFilterButton.this.applyFilter();
                        StaticValuesFilterButton.this.applyToTableIfChanged();
                    }
                }
            });
            this.okAction = new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.apply", new Serializable[0])){
                private static final long serialVersionUID = 2244078186657535544L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    StaticValuesFilterButton.this.applyFilter();
                    StaticValuesFilterButton.this.applyToTableIfChanged();
                    StaticValuesFilterButton.this.filterDetailsPane.setVisible(false);
                }
            };
        }

        private void applyToTableIfChanged() {
            if (this.visibleFieldsChanged) {
                DataManagerGui.this.applyToTable();
                this.visibleFieldsChanged = false;
            }
        }

        @Override
        protected void paintComponent(Graphics g) {
            this.setIconTextGap((g.getFontMetrics().stringWidth(this.getText()) + 16) * -1);
            Graphics2D g2 = (Graphics2D)g.create();
            g2.setPaint(this.getBackground());
            g2.drawRoundRect(0, 0, this.getWidth() - 1, this.getHeight() - 1, 8, 8);
            super.paintComponent(g);
            g2.dispose();
        }

        @Override
        public void invalidatePane() {
            if (this.filterDetailsPane != null) {
                this.clear();
                this.filterDetailsPane.invalidate();
                this.filterDetailsPane = null;
            }
            this.setButtonEnabled();
        }

        private void setButtonEnabled() {
            boolean isEnabled = false;
            EnumMap fieldAvailableInMap = this.filter.getBody().getFieldVisibleIn();
            for (EnumSet<DataManagerType> enumSet : fieldAvailableInMap.values()) {
                isEnabled = isEnabled || enumSet.contains(DataManagerGui.this.typeComboBox.getSelectedValue());
            }
            this.setEnabled(isEnabled);
        }

        private JPanel generateFilterDetailsPane() {
            boolean displaySelAll;
            JPanel panel = new JPanel(new BorderLayout());
            JPanel fieldWrapperPanel = new JPanel(new BorderLayout());
            JPanel fieldPanel = new JPanel(null);
            GroupLayout layout = new GroupLayout(fieldPanel);
            fieldPanel.setLayout(layout);
            layout.setAutoCreateContainerGaps(true);
            layout.setAutoCreateGaps(true);
            Quad<GroupLayout.ParallelGroup, GroupLayout.ParallelGroup, GroupLayout.ParallelGroup, GroupLayout.SequentialGroup> groups = new Quad<GroupLayout.ParallelGroup, GroupLayout.ParallelGroup, GroupLayout.ParallelGroup, GroupLayout.SequentialGroup>(layout.createParallelGroup(), layout.createParallelGroup(), layout.createParallelGroup(), layout.createSequentialGroup());
            layout.setHorizontalGroup(layout.createSequentialGroup().addGroup(groups.getElement1()).addGroup(groups.getElement2()).addGroup(groups.getElement3()));
            layout.setVerticalGroup(groups.getElement4());
            Collection visibleFields = this.filter.getBody().getVisibleFields((DataManagerType)((Object)DataManagerGui.this.typeComboBox.getSelectedValue()), false);
            Collection visibleFieldsWithHeadlines = this.filter.getBody().getVisibleFields((DataManagerType)((Object)DataManagerGui.this.typeComboBox.getSelectedValue()), true);
            EnumSet markedFields = this.filter.getBody().getFieldsToShowInResult();
            this.selectAll = new JCheckBox(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.all", new Serializable[0]));
            this.selectAll.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    StaticValuesFilterButton.this.selectAll();
                }
            });
            JLabel headline = new JLabel(ModelEnviroment.getMessageResolver().resolveMessageForEnum(this.filter));
            JLabel icon = new JLabel(UIManager.getIcon("FileView.directoryIcon"));
            groups.getElement1().addComponent(headline);
            groups.getElement3().addComponent(icon);
            groups.getElement4().addGroup(layout.createParallelGroup().addComponent(headline).addComponent(icon));
            boolean bl = displaySelAll = visibleFields.size() > 1;
            if (displaySelAll) {
                groups.getElement3().addComponent(this.selectAll);
                groups.getElement4().addComponent(this.selectAll);
            } else {
                groups.getElement4().addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED);
            }
            for (Object e : visibleFieldsWithHeadlines) {
                JLabel jLabel = new JLabel(ModelEnviroment.getMessageResolver().resolveMessageForEnum((Enum<?>)e));
                if (!this.filter.getBody().getHeadlines().containsKey(e)) {
                    AbstractFilterField filterField = rangeFields.get((Object)this.filter) != null && ((EnumSet)rangeFields.get((Object)this.filter)).contains(e) ? new FilterRangeTextField(new IntervalLimitRegulatorDate()) : (floatFields.get((Object)this.filter) != null && ((EnumSet)floatFields.get((Object)this.filter)).contains(e) ? new FilterFloatTextField() : new FilterTextField());
                    final JCheckBox checkBox = new JCheckBox("", markedFields.contains(e));
                    checkBox.addItemListener(new ItemListener(){

                        @Override
                        public void itemStateChanged(ItemEvent e) {
                            StaticValuesFilterButton.this.visibleFieldsChanged = true;
                        }
                    });
                    filterField.addValueChangeListener(new PropertyChangeListener(){

                        @Override
                        public void propertyChange(PropertyChangeEvent evt) {
                            checkBox.setSelected(checkBox.isSelected() || evt.getNewValue() != null && !evt.getNewValue().toString().equals(""));
                        }
                    });
                    this.filter.getBody().getFieldMap().put(e, new Tupel<AbstractFilterField, JCheckBox>(filterField, checkBox));
                    this.addRow(groups, layout.createParallelGroup(GroupLayout.Alignment.CENTER), jLabel, filterField, checkBox);
                    continue;
                }
                this.addRow(groups, layout.createParallelGroup(GroupLayout.Alignment.CENTER), jLabel, new JLabel(""), new JLabel(""));
                groups.getElement4().addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED);
            }
            if (DataManagerGui.this.additionalFields != null && !DataManagerGui.this.additionalFields.isEmpty()) {
                boolean first = true;
                for (Map.Entry entry : DataManagerGui.this.additionalFields.entrySet()) {
                    if (!((EnumSet)((Tupel)entry.getValue()).getElement1()).contains((Object)DataManagerGui.this.getCurrentType()) || !((EnumSet)((Tupel)entry.getValue()).getElement2()).contains((Object)this.filter)) continue;
                    if (first) {
                        groups.getElement4().addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED);
                        first = false;
                    }
                    Tripel tripel = (Tripel)entry.getKey();
                    this.addRow(groups, layout.createParallelGroup(GroupLayout.Alignment.CENTER), (Component)tripel.getElement1(), (Component)tripel.getElement2(), (Component)tripel.getElement3());
                }
            }
            fieldWrapperPanel.add((Component)fieldPanel, "Center");
            fieldWrapperPanel.setBorder(BorderFactory.createRaisedSoftBevelBorder());
            panel.add((Component)fieldWrapperPanel, "Center");
            this.layeredPane.add((Component)panel, JLayeredPane.MODAL_LAYER);
            int x = this.getX();
            int y = this.getY();
            Point point = SwingUtilities.convertPoint(this.getParent(), x, y, this.layeredPane);
            panel.setBounds((int)point.getX(), (int)point.getY() + this.getHeight(), (int)panel.getPreferredSize().getWidth(), (int)panel.getPreferredSize().getHeight());
            panel.setBorder(BorderFactory.createLineBorder(Color.black));
            panel.addMouseListener(new MouseAdapter(){});
            panel.setVisible(false);
            this.addEnterAction(panel);
            return panel;
        }

        private void addRow(Quad<GroupLayout.ParallelGroup, GroupLayout.ParallelGroup, GroupLayout.ParallelGroup, GroupLayout.SequentialGroup> groups, GroupLayout.ParallelGroup rowGroup, Component comp1, Component comp2, Component comp3) {
            groups.getElement1().addComponent(comp1);
            groups.getElement2().addComponent(comp2);
            groups.getElement3().addComponent(comp3);
            rowGroup.addComponent(comp1);
            rowGroup.addComponent(comp2);
            rowGroup.addComponent(comp3);
            groups.getElement4().addGroup(rowGroup);
        }

        private void selectAll() {
            Collection enumConstants = this.filter.getBody().getVisibleFields((DataManagerType)((Object)DataManagerGui.this.typeComboBox.getSelectedValue()), false);
            for (Enum e : enumConstants) {
                this.filter.getBody().getCheckBox(e).setSelected(this.selectAll.isSelected());
            }
        }

        @Override
        public void clear() {
            if (this.selectAll != null) {
                this.selectAll.setSelected(false);
            }
            EnumMap fieldMap = this.filter.getBody().getFieldMap();
            this.filter.getBody().clear((EnumSet)defaultTableColumnMap.get((Object)this.filter), DataManagerGui.this.getCurrentType());
            EnumSet markedFields = this.filter.getBody().getFieldsToShowInResult();
            for (Map.Entry e : fieldMap.entrySet()) {
                Tupel<JPanel, JCheckBox> tupel = e.getValue();
                ((AbstractFilterField)tupel.getElement1()).clear();
                tupel.getElement2().setSelected(markedFields.contains(e.getKey()));
            }
            this.setForeground(DataManagerGui.this.defaultForeground);
            this.setBackground(DataManagerGui.this.defaultBackground);
        }

        private void applyFilter() {
            Collection enumConstants = this.filter.getBody().getVisibleFields((DataManagerType)((Object)DataManagerGui.this.typeComboBox.getSelectedValue()), false);
            for (Enum e : enumConstants) {
                if (StringUtil.isBlank(((AbstractFilterField)this.filter.getBody().getFilterField(e)).getText())) {
                    this.filter.getBody().remove(e);
                } else {
                    Object value = ((AbstractFilterField)this.filter.getBody().getFilterField(e)).getValue();
                    if (value instanceof String) {
                        value = ((String)value).trim();
                    }
                    this.filter.getBody().put(e, value);
                }
                if (this.filter.getBody().getCheckBox(e).isSelected()) {
                    this.filter.getBody().getFieldsToShowInResult().add(e);
                    continue;
                }
                this.filter.getBody().getFieldsToShowInResult().remove(e);
            }
            if (this.filter.getBody().getAppliedDataMap().isEmpty()) {
                this.setForeground(DataManagerGui.this.defaultForeground);
                this.setBackground(DataManagerGui.this.defaultBackground);
            } else {
                this.setForeground(Color.BLUE);
                this.setBackground(Color.CYAN.darker());
            }
            if (this.filter.getBody().hasChanged()) {
                DataManagerGui.this.updateFilterDisplayTextField(null);
                this.filter.getBody().clearChanged();
                if (DataManagerGui.this.setApplyButtonEnabled()) {
                    DataManagerGui.this.applyButton.setForeground(Color.BLUE);
                    DataManagerGui.this.filterDisplayTextPane.setBackground(Color.CYAN.darker());
                } else {
                    DataManagerGui.this.filterDisplayTextPane.setBackground(DataManagerGui.this.defaultTextPaneBackground);
                }
            }
        }

        public DataManagerFilters getFilter() {
            return this.filter;
        }

        @Override
        public void setSelectAll(boolean selected) {
            if (this.filterDetailsPane == null) {
                this.filterDetailsPane = this.generateFilterDetailsPane();
            }
            this.selectAll.setSelected(selected);
            this.selectAll();
            this.applyFilter();
        }

        @Override
        public void closeDetailsPane() {
            if (this.filterDetailsPane != null && this.filterDetailsPane.isVisible()) {
                this.filterDetailsPane.setVisible(false);
                this.applyFilter();
                this.applyToTableIfChanged();
            }
        }

        private void addEnterAction(JPanel panel) {
            panel.getInputMap(2).put(KeyStroke.getKeyStroke("ENTER"), "enterAction");
            panel.getActionMap().put("enterAction", this.okAction);
        }

        @Override
        protected Set<?> getAppliedDataKeys() {
            return this.getFilter().getBody().getAppliedDataKeys();
        }

        @Override
        protected Map<? extends Object, Object> getAppliedDataMap() {
            return this.getFilter().getBody().getAppliedDataMap();
        }

        @Override
        protected Set<?> getFieldsToShowInResult() {
            return this.getFilter().getBody().getFieldsToShowInResult();
        }
    }

    private abstract class FilterButton
    extends JButton {
        private static final long serialVersionUID = 1L;

        public FilterButton(String resolveMessageForEnum, Icon icon) {
            super(resolveMessageForEnum, icon);
        }

        protected abstract Set<?> getAppliedDataKeys();

        protected abstract Map<? extends Object, Object> getAppliedDataMap();

        protected abstract void clear();

        protected abstract void setSelectAll(boolean var1);

        protected abstract void invalidatePane();

        protected abstract void closeDetailsPane();

        protected abstract Set<?> getFieldsToShowInResult();
    }

    private abstract class AbstractAsynchronousFetchDialog<C extends Collection<?>>
    extends AbstractGeneralAsynchronousDialog<C, AsynchronousGeneralDto<C>> {
        private static final long serialVersionUID = 5231862493493660469L;

        public AbstractAsynchronousFetchDialog(Window parent, ModelEnviroment modelEnvironment) {
            super(parent, ModelEnviroment.getMessageResolver().resolveMessage("messages.default.database.access", new Serializable[0]), ModelEnviroment.getMessageResolver().resolveMessage("messages.default.pleaseWait", new Serializable[0]), 0, false, modelEnvironment, false);
        }

        @Override
        protected AsynchronousGeneralDto<C> getAsynchronousDto(String token) {
            return this.modelEnviroment.getAllCaller().getAsynchronousCaller().getSearchResult(token);
        }
    }
}

