/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.datamanager.gui;

import de.datomino.peppergis.client.auth.UserInformation;
import de.datomino.peppergis.client.gui.area.AreaLayerProvider;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.area.AreaLayerModel;
import de.datomino.peppergis.type.AreaObjectGenInfoDiscriminator;
import de.datomino.peppergis.type.UserRole;
import java.awt.Component;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public class DataManagerAreaLayerComboBox
extends JComboBox<Object>
implements AreaLayerProvider {
    private static final long serialVersionUID = -1364108468780621071L;
    private boolean emptyItem;

    public DataManagerAreaLayerComboBox(ModelEnviroment modelEnviroment, boolean emptyItem, AreaObjectGenInfoDiscriminator[] areaObjectGenInfoDiscriminators, boolean writableOnly, Collection<AreaLayerModel> exclusions) {
        this(DataManagerAreaLayerComboBox.fetchAreaLayers(modelEnviroment, areaObjectGenInfoDiscriminators, writableOnly, exclusions), emptyItem);
    }

    public DataManagerAreaLayerComboBox(ModelEnviroment modelEnviroment, boolean emptyItem, AreaObjectGenInfoDiscriminator[] areaObjectGenInfoDiscriminators, boolean writableOnly) {
        this(DataManagerAreaLayerComboBox.fetchAreaLayers(modelEnviroment, areaObjectGenInfoDiscriminators, writableOnly, null), emptyItem);
    }

    public DataManagerAreaLayerComboBox(ModelEnviroment modelEnviroment, boolean emptyItem, AreaObjectGenInfoDiscriminator[] areaObjectGenInfoDiscriminators) {
        this(modelEnviroment, emptyItem, areaObjectGenInfoDiscriminators, false);
    }

    public DataManagerAreaLayerComboBox(boolean emptyItem) {
        this(null, emptyItem);
    }

    public DataManagerAreaLayerComboBox(Collection<AreaLayerModel> models, boolean emptyItem) {
        this.emptyItem = emptyItem;
        this.setRenderer(new Renderer(this.getRenderer()));
        this.setModels(models);
    }

    public void setModels(Iterable<AreaLayerModel> models) {
        this.removeAllItems();
        if (this.emptyItem) {
            this.addItem(">" + ModelEnviroment.getMessageResolver().resolveMessage("messages.data.layer.all", new Serializable[0]) + "<");
        }
        if (models != null) {
            for (AreaLayerModel t : models) {
                this.addItem(t);
            }
        }
    }

    private static Collection<AreaLayerModel> fetchAreaLayers(ModelEnviroment modelEnviroment, AreaObjectGenInfoDiscriminator[] areaObjectGenInfoDiscriminators, boolean writableOnly, Collection<AreaLayerModel> exclusions) {
        UserInformation userInformation;
        Collection<AreaLayerModel> areaLayersForType = modelEnviroment.getAllCaller().getAreaCaller().getAreaLayersForType(areaObjectGenInfoDiscriminators);
        if (exclusions != null) {
            ArrayList<AreaLayerModel> filtered = new ArrayList<AreaLayerModel>(areaLayersForType.size());
            for (AreaLayerModel areaLayerModel : areaLayersForType) {
                if (exclusions.contains(areaLayerModel)) continue;
                filtered.add(areaLayerModel);
            }
            areaLayersForType = filtered;
        }
        if (writableOnly && !(userInformation = ModelEnviroment.getUserInformation()).isAdmin() && !userInformation.hasAtLeastOneRole(UserRole.AREA_ADMIN, UserRole.DISPONENT_SUPER)) {
            Map<UserRole, Set<Long>> rightInformation = userInformation.getRightInformation();
            Set<Long> set = rightInformation.get((Object)UserRole.AREA_ADMIN);
            ArrayList<AreaLayerModel> filtered = new ArrayList<AreaLayerModel>(areaLayersForType.size());
            if (set != null) {
                for (AreaLayerModel areaLayerModel : areaLayersForType) {
                    if (!set.contains(areaLayerModel.getId())) continue;
                    filtered.add(areaLayerModel);
                }
            }
            areaLayersForType = filtered;
        }
        return areaLayersForType;
    }

    protected String getStringRepresentation(AreaLayerModel t) {
        return t.getDisplayname();
    }

    public boolean isEmptyItem() {
        return this.emptyItem;
    }

    @Override
    public void setSelectedItem(Object anObject) {
        if (anObject == null && this.emptyItem) {
            super.setSelectedIndex(0);
        } else {
            super.setSelectedItem(anObject);
        }
    }

    @Override
    public AreaLayerModel getLayer() {
        return this.getSelectedItem() instanceof String ? null : (AreaLayerModel)this.getSelectedItem();
    }

    private class Renderer<T>
    implements ListCellRenderer<T> {
        private ListCellRenderer<T> parent;

        public Renderer(ListCellRenderer<T> parent) {
            this.parent = parent;
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends T> list, T value, int index, boolean isSelected, boolean cellHasFocus) {
            String string = value == null ? null : (value instanceof String ? value.toString() : DataManagerAreaLayerComboBox.this.getStringRepresentation((AreaLayerModel)value));
            return this.parent.getListCellRendererComponent(list, string, index, isSelected, cellHasFocus);
        }
    }
}

