/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.datamanager.gui;

import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.map.ParcelAttributeValueDescriptorModel;
import de.datomino.peppergis.client.model.map.ParcelStaticChoiceAttributeValueModel;
import de.datomino.peppergis.datamanager.gui.AbstractFilterField;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;

public class AttributeStaticChoiceFilterField
extends AbstractFilterField {
    private static final long serialVersionUID = 1L;
    private JComboBox<ParcelStaticChoiceValueItem> comboBox;
    private ParcelStaticChoiceValueItem noConstraintItem;

    public AttributeStaticChoiceFilterField(ParcelAttributeValueDescriptorModel descriptor) {
        super(null);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        this.comboBox = new JComboBox();
        this.noConstraintItem = new ParcelStaticChoiceValueItem(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.all", new Serializable[0]));
        this.comboBox.addItem(this.noConstraintItem);
        for (ParcelStaticChoiceAttributeValueModel staticChoiceValueModel : descriptor.iterableStaticChoiceValues()) {
            this.comboBox.addItem(new ParcelStaticChoiceValueItem(staticChoiceValueModel));
        }
        layout.setHorizontalGroup(layout.createSequentialGroup().addComponent(this.comboBox));
        layout.setVerticalGroup(layout.createParallelGroup().addComponent(this.comboBox));
    }

    @Override
    public String getText() {
        return ((ParcelStaticChoiceValueItem)this.comboBox.getSelectedItem()).getText();
    }

    @Override
    public Object getValue() {
        return ((ParcelStaticChoiceValueItem)this.comboBox.getSelectedItem()).getStaticChoiceValue();
    }

    @Override
    public void clear() {
        this.comboBox.setSelectedItem(this.noConstraintItem);
    }

    @Override
    public void addValueChangeListener(PropertyChangeListener listener) {
        this.comboBox.addPropertyChangeListener("value", listener);
    }

    private class ParcelStaticChoiceValueItem {
        private ParcelStaticChoiceAttributeValueModel staticChoiceValue;
        private String emptyItem = "";

        public ParcelStaticChoiceValueItem(ParcelStaticChoiceAttributeValueModel staticChoiceValue) {
            this.staticChoiceValue = staticChoiceValue;
        }

        public ParcelStaticChoiceValueItem(String emptyItem) {
            this.staticChoiceValue = null;
            this.emptyItem = emptyItem;
        }

        public ParcelStaticChoiceAttributeValueModel getStaticChoiceValue() {
            return this.staticChoiceValue;
        }

        public String toString() {
            ParcelStaticChoiceAttributeValueModel staticChoiceValue = this.getStaticChoiceValue();
            return staticChoiceValue == null ? this.emptyItem : staticChoiceValue.getName();
        }

        public String getText() {
            String string = this.toString();
            return string.equals(this.emptyItem) ? "" : string;
        }
    }
}

