/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.datamanager.actions;

import de.datomino.peppergis.client.file.FileUtil;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.Model;
import de.datomino.peppergis.datamanager.gui.DataManagerGui;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;

public class DataClientExportFileAction
extends AbstractAction {
    private static final long serialVersionUID = 8217045393540910534L;
    private Window parent;
    private String fileExtension;
    private DataManagerGui gui;
    private boolean markedOnly;

    public DataClientExportFileAction(Window parent, String fileExtension, DataManagerGui gui, boolean markedOnly) {
        super(markedOnly ? ModelEnviroment.getMessageResolver().resolveMessage("messages.area.mark", new Serializable[0]) : ModelEnviroment.getMessageResolver().resolveMessage("messages.data.result", new Serializable[0]));
        this.parent = parent;
        this.fileExtension = fileExtension;
        this.gui = gui;
        this.markedOnly = markedOnly;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        StringBuilder builder = new StringBuilder();
        String glue = ",";
        builder.append(this.gui.getTitleString(",")).append("\n");
        if (this.markedOnly) {
            List<Model> models = this.gui.getTableSelection();
            for (Model model : models) {
                builder.append(this.gui.getModelString(model, ",", true)).append("\n");
            }
        } else {
            for (int i = 0; i < this.gui.getTableRowCount(); ++i) {
                builder.append(this.gui.getTableRowString(this.gui.getTable().convertRowIndexToModel(i), ",", true)).append("\n");
            }
        }
        try {
            FileUtil.saveFile(Collections.singletonMap(ModelEnviroment.getMessageResolver().resolveMessageForEnum(this.gui.getCurrentType()), builder.toString().getBytes("UTF-8")), this.parent, this.fileExtension);
        }
        catch (IOException e1) {
            JOptionPane.showMessageDialog(this.parent, ModelEnviroment.getMessageResolver().resolveMessage("messages.default.error", new Serializable[0]), e1.getMessage(), 0);
        }
    }
}

