/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.configuration.gui.subscription;

import de.datomino.peppergis.client.gui.common.CommonDialog;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.Model;
import de.datomino.peppergis.client.model.map.ParcelModel;
import de.datomino.peppergis.client.util.model.location.LocationWrapper;
import de.datomino.peppergis.configuration.gui.subscription.AbstractModelWithNoParcelDialog;
import de.datomino.peppergis.dto.importer.ParcelImportResultDto;
import de.datomino.peppergis.dto.location.SimpleAddressDto;
import de.datomino.peppergis.exception.ValidateException;
import de.datomino.util.swing.SwingUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.GroupLayout;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.event.ChangeEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.ktde.util.StringUtil;
import org.ktde.util.datatypes.Tupel;

public abstract class AbstractModelWithNoParcelDialog<M extends Model>
extends CommonDialog {
    private static final long serialVersionUID = 7537143091410732697L;
    private SubscriptionsWithNoParcelPane pane;
    ModelEnviroment modelEnvironment;

    public AbstractModelWithNoParcelDialog(Component parent, Collection<M> subscriptions, ModelEnviroment modelEnvironment) {
        super(parent, "", Dialog.ModalityType.APPLICATION_MODAL);
        this.modelEnvironment = modelEnvironment;
        this.pane = new SubscriptionsWithNoParcelPane(subscriptions);
        this.buildLayout();
        this.pack();
        TableColumn column = this.pane.getTable().getColumnModel().getColumn(0);
        column.setPreferredWidth(column.getPreferredWidth() * 4);
        SwingUtils.center((Window)this, parent);
    }

    protected abstract LocationWrapper getLocationWrapper(M var1);

    protected abstract String getFirstColumnName();

    protected abstract String getDisplayString(M var1);

    protected abstract void delete(M var1);

    protected abstract Collection<M> processModels(boolean var1);

    @Override
    protected Action getOkAction() {
        return new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.ok", new Serializable[0])){
            private static final long serialVersionUID = -7103856324992005670L;

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractModelWithNoParcelDialog.this.modelEnvironment.getUndoManager().startTransaction();
                for (Model model : AbstractModelWithNoParcelDialog.this.pane.getTableModel().getModelsDelete()) {
                    AbstractModelWithNoParcelDialog.this.delete(model);
                }
                AbstractModelWithNoParcelDialog.this.modelEnvironment.getUndoManager().finishTransaction("process");
                try {
                    AbstractModelWithNoParcelDialog.this.modelEnvironment.getUndoManager().storeTransactions();
                }
                catch (ValidateException validateException) {
                    // empty catch block
                }
                ArrayList<SimpleAddressDto> addressDtos = new ArrayList<SimpleAddressDto>(AbstractModelWithNoParcelDialog.this.pane.getTableModel().getModelsNewParcel().size());
                StringBuilder sb = new StringBuilder();
                Tupel<Collection<ParcelModel>, ParcelImportResultDto> result = null;
                Integer i = 0;
                boolean first = true;
                for (Object model : AbstractModelWithNoParcelDialog.this.pane.getTableModel().getModelsNewParcel()) {
                    LocationWrapper wrapper = AbstractModelWithNoParcelDialog.this.getLocationWrapper(model);
                    if (StringUtil.isBlank(wrapper.getPostcode()) || StringUtil.isBlank(wrapper.getCity()) || StringUtil.isBlank(wrapper.getStreet()) || wrapper.getHousenumber() == null) {
                        if (first) {
                            sb.append(ModelEnviroment.getMessageResolver().resolveMessage("messages.import.followingaddressesnotimported", new Serializable[0]) + "\n\n");
                            first = false;
                        }
                        i = i + 1;
                        sb.append(i.toString() + ")   " + AbstractModelWithNoParcelDialog.this.getDisplayString(model) + "\n");
                        continue;
                    }
                    SimpleAddressDto addressDto = new SimpleAddressDto();
                    addressDto.setStreet(wrapper.getStreet());
                    addressDto.setPostcode(wrapper.getPostcode());
                    addressDto.setCity(wrapper.getCity());
                    addressDto.setStreet(wrapper.getStreet());
                    addressDto.setHousenumber(wrapper.getHousenumber().toString());
                    addressDto.setHousenumberExtension(wrapper.getHousenumberExtension());
                    addressDtos.add(addressDto);
                }
                if (!addressDtos.isEmpty()) {
                    result = AbstractModelWithNoParcelDialog.this.modelEnvironment.getAllCaller().getImportCaller().importParcelsSetId(addressDtos, 10, "J");
                    AbstractModelWithNoParcelDialog.this.processModels(false);
                    AbstractModelWithNoParcelDialog.this.processModels(true);
                }
                if (sb.length() > 0 || result != null && ((ParcelImportResultDto)result.getElement2()).getRejected() != null && !result.getElement2().getRejected().isEmpty()) {
                    JTextPane textPane = new JTextPane();
                    first = true;
                    if (result != null && result.getElement2().getRejected() != null) {
                        for (String str : result.getElement2().getRejected()) {
                            if (first) {
                                sb.append(ModelEnviroment.getMessageResolver().resolveMessage("messages.import.noparcelscreated", new Serializable[0]) + "\n\n");
                                first = false;
                            }
                            i = i + 1;
                            sb.append(i.toString() + ")   " + str + "\n");
                        }
                    }
                    textPane.setText(sb.toString());
                    Dimension prefSize = textPane.getPreferredSize();
                    prefSize.width = (int)((double)AbstractModelWithNoParcelDialog.this.getPreferredSize().width * 1.25);
                    textPane.setPreferredSize(prefSize);
                    JOptionPane.showMessageDialog(AbstractModelWithNoParcelDialog.this, new JScrollPane(textPane), ModelEnviroment.getMessageResolver().resolveMessage("messages.default.warning", new Serializable[0]), 2);
                }
                AbstractModelWithNoParcelDialog.this.modelEnvironment.close();
                AbstractModelWithNoParcelDialog.this.dispose();
            }
        };
    }

    @Override
    protected Action getCancelAction() {
        return new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.cancel", new Serializable[0])){
            private static final long serialVersionUID = -7163646133113809655L;

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractModelWithNoParcelDialog.this.modelEnvironment.close();
                AbstractModelWithNoParcelDialog.this.dispose();
            }
        };
    }

    @Override
    protected Component getMainComponent() {
        return this.pane;
    }

    @Override
    protected Action[] getAdditionalWestActions() {
        Action[] prevWestActions = super.getAdditionalWestActions();
        Action[] westActions = new Action[prevWestActions.length + 2];
        System.arraycopy(prevWestActions, 0, westActions, 0, prevWestActions.length);
        westActions[westActions.length - 2] = this.pane.getMarkAllForDeleteAction();
        westActions[westActions.length - 1] = this.pane.getMarkAllForNewParcelAction();
        return westActions;
    }

    public ModelEnviroment getModelEnvironment() {
        return this.modelEnvironment;
    }

    private class SubscriptionsWithNoParcelPane
    extends JPanel {
        private static final long serialVersionUID = -6633058209829316068L;
        private JTable table;
        private de.datomino.peppergis.configuration.gui.subscription.AbstractModelWithNoParcelDialog$SubscriptionsWithNoParcelPane.ModelNoParcelTableModel tableModel;

        public SubscriptionsWithNoParcelPane(Collection<M> models) {
            super(null);
            GroupLayout layout = new GroupLayout(this);
            this.setLayout(layout);
            layout.setAutoCreateContainerGaps(true);
            this.tableModel = new ModelNoParcelTableModel(models);
            this.table = new JTable((TableModel)this.tableModel){
                private static final long serialVersionUID = 5596102303722167045L;

                @Override
                public void editingStopped(ChangeEvent e) {
                    super.editingStopped(e);
                    ((ModelNoParcelTableModel)this.getModel()).editingStopped(this.convertRowIndexToModel(this.getSelectedRow()), this.convertColumnIndexToModel(this.getSelectedColumn()));
                }
            };
            this.table.setAutoCreateRowSorter(true);
            JScrollPane scrollPane = new JScrollPane(this.table);
            layout.setHorizontalGroup(layout.createSequentialGroup().addComponent(scrollPane));
            layout.setVerticalGroup(layout.createParallelGroup().addComponent(scrollPane));
        }

        public Action getMarkAllForDeleteAction() {
            return new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.delete.all", new Serializable[0])){
                private static final long serialVersionUID = -2675574107192259232L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    SubscriptionsWithNoParcelPane.this.tableModel.markAllForDelete();
                }
            };
        }

        public Action getMarkAllForNewParcelAction() {
            return new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.parcel.new.all", new Serializable[0])){
                private static final long serialVersionUID = 7785865078535201402L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    SubscriptionsWithNoParcelPane.this.tableModel.markAllForNewParcel();
                }
            };
        }

        public JTable getTable() {
            return this.table;
        }

        public de.datomino.peppergis.configuration.gui.subscription.AbstractModelWithNoParcelDialog$SubscriptionsWithNoParcelPane.ModelNoParcelTableModel getTableModel() {
            return this.tableModel;
        }

        private class ModelNoParcelTableModel
        extends AbstractTableModel {
            private static final long serialVersionUID = 6904448926664039376L;
            List<M> models;
            Set<M> modelsDelete;
            Set<M> modelsNewParcel;

            public ModelNoParcelTableModel(Collection<M> models) {
                this.models = new ArrayList(models);
                this.modelsDelete = new HashSet(models);
                this.modelsNewParcel = new HashSet();
            }

            @Override
            public int getColumnCount() {
                return 3;
            }

            @Override
            public int getRowCount() {
                return this.models.size();
            }

            @Override
            public Object getValueAt(int row, int column) {
                Model model = (Model)this.models.get(row);
                switch (column) {
                    case 0: {
                        return AbstractModelWithNoParcelDialog.this.getDisplayString(model);
                    }
                    case 1: {
                        return this.modelsDelete.contains(model);
                    }
                    case 2: {
                        return this.modelsNewParcel.contains(model);
                    }
                }
                return null;
            }

            @Override
            public boolean isCellEditable(int row, int column) {
                return column > 0;
            }

            public void editingStopped(int row, int column) {
                if (row == -1 || column == -1) {
                    return;
                }
                Object value = this.getValueAt(row, column);
                Model model = (Model)this.models.get(row);
                if (value instanceof Boolean) {
                    if (column == 1) {
                        this.modelsNewParcel.remove(model);
                        this.modelsDelete.add(model);
                    } else if (column == 2) {
                        this.modelsDelete.remove(model);
                        this.modelsNewParcel.add(model);
                    }
                    this.fireTableRowsUpdated(row, row);
                }
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                switch (columnIndex) {
                    case 0: {
                        return String.class;
                    }
                    case 1: {
                        return Boolean.class;
                    }
                    case 2: {
                        return Boolean.class;
                    }
                }
                return super.getColumnClass(columnIndex);
            }

            @Override
            public String getColumnName(int column) {
                switch (column) {
                    case 0: {
                        return AbstractModelWithNoParcelDialog.this.getFirstColumnName();
                    }
                    case 1: {
                        return ModelEnviroment.getMessageResolver().resolveMessage("messages.default.delete", new Serializable[0]);
                    }
                    case 2: {
                        return ModelEnviroment.getMessageResolver().resolveMessage("messages.parcel.new", new Serializable[0]);
                    }
                }
                return super.getColumnName(column);
            }

            public void markAllForDelete() {
                this.modelsDelete.addAll(this.modelsNewParcel);
                this.modelsNewParcel.clear();
                this.fireTableDataChanged();
            }

            public void markAllForNewParcel() {
                this.modelsNewParcel.addAll(this.modelsDelete);
                this.modelsDelete.clear();
                this.fireTableDataChanged();
            }

            public Set<M> getModelsDelete() {
                return this.modelsDelete;
            }

            public Set<M> getModelsNewParcel() {
                return this.modelsNewParcel;
            }
        }
    }
}

