/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.configuration.gui.renderer;

import de.datomino.peppergis.client.gui.renderer.editor.ColorValueEditor;
import de.datomino.peppergis.client.gui.renderer.editor.IntegerValueEditor;
import de.datomino.peppergis.configuration.gui.renderer.AbstractDefaultRendererSettingsPane;
import de.datomino.util.geo.swing.renderer.CirclePointRenderer;
import java.awt.Color;
import java.awt.Component;

public class CircleDefaultRendererSettingsPane
extends AbstractDefaultRendererSettingsPane {
    private static final long serialVersionUID = -4046003296077631085L;
    private ColorValueEditor colorValueEditor;
    private IntegerValueEditor radiusValueEditor;
    private IntegerValueEditor alphaValueEditor;

    @Override
    protected Component getComponentForParameter(Enum<?> e) {
        CirclePointRenderer.Parameters parameter = (CirclePointRenderer.Parameters)e;
        switch (parameter) {
            case COLOR: {
                if (this.colorValueEditor == null) {
                    this.colorValueEditor = new ColorValueEditor(Color.BLACK);
                }
                return this.colorValueEditor;
            }
            case RADIUS: {
                if (this.radiusValueEditor == null) {
                    this.radiusValueEditor = new IntegerValueEditor(0);
                }
                return this.radiusValueEditor;
            }
            case ALPHA: {
                if (this.alphaValueEditor == null) {
                    this.alphaValueEditor = new IntegerValueEditor(100, 0, 100);
                }
                return this.alphaValueEditor;
            }
        }
        throw new RuntimeException();
    }

    @Override
    protected Enum<?>[] getParameters() {
        return CirclePointRenderer.Parameters.values();
    }

    @Override
    protected void setValue(Enum<?> e, String value) {
        CirclePointRenderer.Parameters parameter = (CirclePointRenderer.Parameters)e;
        switch (parameter) {
            case COLOR: {
                this.colorValueEditor.setSerializedValue(value);
                break;
            }
            case RADIUS: {
                this.radiusValueEditor.setSerializedValue(value);
                break;
            }
            case ALPHA: {
                this.alphaValueEditor.setSerializedValue(value);
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
    }

    @Override
    protected String getValue(Enum<?> e) {
        CirclePointRenderer.Parameters parameter = (CirclePointRenderer.Parameters)e;
        switch (parameter) {
            case COLOR: {
                return this.colorValueEditor.getSerializedValue();
            }
            case RADIUS: {
                return this.radiusValueEditor.getSerializedValue();
            }
            case ALPHA: {
                return this.alphaValueEditor.getSerializedValue();
            }
        }
        throw new RuntimeException();
    }
}

