/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.configuration.gui.renderer;

import de.datomino.peppergis.client.gui.common.EnumComboBox;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.configuration.gui.renderer.AbstractDefaultRendererSettingsPane;
import de.datomino.peppergis.configuration.gui.renderer.CircleDefaultRendererSettingsPane;
import de.datomino.peppergis.configuration.gui.renderer.DashLineDefaultRendererSettingsPane;
import de.datomino.peppergis.configuration.gui.renderer.HatchLineDefaultRendererSettingsPane;
import de.datomino.peppergis.configuration.gui.renderer.HatchQuadDefaultRendererSettingsPane;
import de.datomino.peppergis.configuration.gui.renderer.IconPointDefaultRendererSettingsPane;
import de.datomino.peppergis.configuration.gui.renderer.IsoscelesTriangleDefaultRendererSettingsPane;
import de.datomino.peppergis.configuration.gui.renderer.PlainDefaultRendererSettingsPane;
import de.datomino.peppergis.configuration.gui.renderer.RandomAreaDefaultRendererSettingsPane;
import de.datomino.peppergis.configuration.gui.renderer.RectangleDefaultRendererSettingsPane;
import de.datomino.peppergis.configuration.gui.renderer.SolidLineDefaultRendererSettingsPane;
import de.datomino.peppergis.type.RendererType;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.swing.JPanel;
import org.apache.commons.lang.ArrayUtils;
import org.ktde.util.application.DynamicAttributedProperties;

public abstract class AbstractDefaultRendererChooserPane
extends JPanel {
    private static final long serialVersionUID = -3023919084882170456L;
    private EnumComboBox<RendererType> rendererTypes;
    private JPanel card;
    private CardLayout cardLayout;
    private Map<RendererType, AbstractDefaultRendererSettingsPane> rendererPanes;
    private ModelEnviroment modelEnviroment;

    public AbstractDefaultRendererChooserPane(ModelEnviroment modelEnviroment) {
        super(new BorderLayout());
        this.modelEnviroment = modelEnviroment;
        this.buildLayout();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.rendererTypes.setEnabled(enabled);
        for (int i = 0; i < this.card.getComponentCount(); ++i) {
            this.card.getComponent(i).setEnabled(enabled);
        }
    }

    public void loadValues(String prefix, Properties tempProps) {
        String rendererTypeString;
        DynamicAttributedProperties properties = ModelEnviroment.getProperties();
        String string = rendererTypeString = tempProps == null ? null : tempProps.getProperty(prefix);
        if (rendererTypeString == null) {
            rendererTypeString = properties.getProperty(prefix);
        }
        RendererType rendererType = null;
        try {
            rendererType = RendererType.valueOf(rendererTypeString);
        }
        catch (Exception ex) {
            rendererType = this.getDefaultRendererType();
        }
        if (!ArrayUtils.contains((Object[])this.getRendererTypes(), (Object)rendererType)) {
            rendererType = this.getDefaultRendererType();
        }
        this.rendererTypes.setSelectedValue(rendererType);
        AbstractDefaultRendererSettingsPane rendererSettingsPane = this.rendererPanes.get((Object)rendererType);
        rendererSettingsPane.loadValues(prefix + ".parameter.", tempProps);
        this.cardLayout.show(this.card, rendererType.name());
    }

    private void buildLayout() {
        Enum[] rendererTypes = this.getRendererTypes();
        this.rendererTypes = new EnumComboBox(RendererType.class, false, rendererTypes);
        this.rendererTypes.addActionListener(new RenderTypeActionListener());
        this.add(this.rendererTypes, "North");
        this.cardLayout = new CardLayout();
        this.card = new JPanel(this.cardLayout);
        this.rendererPanes = new HashMap<RendererType, AbstractDefaultRendererSettingsPane>();
        this.add((Component)this.card, "Center");
        for (Enum rendererType : rendererTypes) {
            AbstractDefaultRendererSettingsPane rendererSettingsPane = this.createRendererSettingsPane((RendererType)rendererType);
            this.card.add((Component)rendererSettingsPane, rendererType.name());
            this.rendererPanes.put((RendererType)rendererType, rendererSettingsPane);
        }
    }

    private AbstractDefaultRendererSettingsPane createRendererSettingsPane(RendererType rendererType) {
        switch (rendererType) {
            case CIRCLE: {
                return new CircleDefaultRendererSettingsPane();
            }
            case DASH_LINE: {
                return new DashLineDefaultRendererSettingsPane();
            }
            case HATCH_QUAD: {
                return new HatchQuadDefaultRendererSettingsPane();
            }
            case ICON_POINT: {
                return new IconPointDefaultRendererSettingsPane(this.modelEnviroment);
            }
            case INVISIBLE: {
                return null;
            }
            case ISOSCELES_TRIANGLE: {
                return new IsoscelesTriangleDefaultRendererSettingsPane();
            }
            case PLAIN: {
                return new PlainDefaultRendererSettingsPane();
            }
            case RECTANGLE: {
                return new RectangleDefaultRendererSettingsPane();
            }
            case SOLID_LINE: {
                return new SolidLineDefaultRendererSettingsPane();
            }
            case RANDOM_AREA: {
                return new RandomAreaDefaultRendererSettingsPane();
            }
            case HATCH_LINE: {
                return new HatchLineDefaultRendererSettingsPane();
            }
        }
        throw new RuntimeException();
    }

    protected abstract RendererType[] getRendererTypes();

    protected abstract RendererType getDefaultRendererType();

    public Properties createProperties(String prefix) {
        Properties properties = new Properties();
        RendererType rendererType = this.rendererTypes.getSelectedValue();
        properties.setProperty(prefix, rendererType.name());
        AbstractDefaultRendererSettingsPane rendererSettingsPane = this.rendererPanes.get((Object)rendererType);
        rendererSettingsPane.addProperties(properties, prefix + ".parameter.");
        return properties;
    }

    private class RenderTypeActionListener
    implements ActionListener {
        private RenderTypeActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            RendererType rendererType = (RendererType)((Object)AbstractDefaultRendererChooserPane.this.rendererTypes.getSelectedValue());
            AbstractDefaultRendererChooserPane.this.cardLayout.show(AbstractDefaultRendererChooserPane.this.card, rendererType.name());
        }
    }
}

