/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.configuration.gui.job.schedule.parameter.special;

import de.datomino.peppergis.client.gui.area.AreaLayerComboBox;
import de.datomino.peppergis.client.gui.area.DefaultAreaObjectChooserPane;
import de.datomino.peppergis.client.gui.common.DatePicker;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.area.AreaLayerModel;
import de.datomino.peppergis.type.AreaObjectGenInfoDiscriminator;
import de.datomino.util.swing.SpringUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SpringLayout;

public class ExportParcelOfChangedAreasSettingsPane
extends JPanel {
    private static final long serialVersionUID = 1943537542558486740L;
    private JCheckBox useDate;
    private DatePicker datePicker;
    private AreaLayerComboBox areaLayerComboBox;
    private AreaLayerComboBox targetAreaLayerComboBox;
    private DefaultAreaObjectChooserPane areaObjectChooserPane;
    private ModelEnviroment modelEnviroment;

    public ExportParcelOfChangedAreasSettingsPane(ModelEnviroment modelEnviroment) {
        super(new BorderLayout());
        this.modelEnviroment = modelEnviroment;
        this.buildLayout();
        AreaLayerModel layer = (AreaLayerModel)this.areaLayerComboBox.getSelectedItem();
        this.areaObjectChooserPane.setAreaLayerModel(layer);
    }

    private void buildLayout() {
        JPanel head = new JPanel(new SpringLayout());
        head.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("message.export.parcel.changesSince", new Serializable[0])));
        JPanel datePane = new JPanel(new BorderLayout());
        this.useDate = new JCheckBox();
        datePane.add((Component)this.useDate, "West");
        this.datePicker = new DatePicker();
        this.datePicker.setEnabled(false);
        datePane.add((Component)this.datePicker, "East");
        head.add(datePane);
        head.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.area.layer", new Serializable[0])));
        this.areaLayerComboBox = new AreaLayerComboBox(this.modelEnviroment, false, AreaObjectGenInfoDiscriminator.values());
        head.add(this.areaLayerComboBox);
        head.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("message.export.parcel.targetLayer", new Serializable[0])));
        this.targetAreaLayerComboBox = new AreaLayerComboBox(this.modelEnviroment, true, AreaObjectGenInfoDiscriminator.values());
        head.add(this.targetAreaLayerComboBox);
        SpringUtilities.makeCompactGrid(head, 3, 2, 5, 5, 2, 2);
        this.add((Component)head, "North");
        this.areaObjectChooserPane = new DefaultAreaObjectChooserPane(this.modelEnviroment);
        this.areaLayerComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AreaLayerModel areaLayer = (AreaLayerModel)ExportParcelOfChangedAreasSettingsPane.this.areaLayerComboBox.getSelectedItem();
                ExportParcelOfChangedAreasSettingsPane.this.areaObjectChooserPane.setAreaLayerModel(areaLayer);
            }
        });
        this.useDate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExportParcelOfChangedAreasSettingsPane.this.datePicker.setEnabled(ExportParcelOfChangedAreasSettingsPane.this.useDate.isSelected());
            }
        });
    }

    public Date getDate() {
        return this.useDate.isSelected() ? this.datePicker.getValue() : null;
    }

    public Collection<Long> getAreas() {
        return this.areaObjectChooserPane.getSelectedAreaObjects();
    }

    public boolean isShowAllSelected() {
        return this.areaObjectChooserPane.isShowAllSelected();
    }

    public AreaLayerModel getLayer() {
        return this.areaLayerComboBox.getLayer();
    }

    public AreaLayerModel getTargetLayer() {
        return this.targetAreaLayerComboBox.getLayer();
    }

    public void setDate(Date date) {
        if (date == null) {
            this.useDate.setSelected(false);
        } else {
            this.useDate.setSelected(true);
            this.datePicker.setSelectedItem(date);
        }
    }

    public void setAreas(Collection<Long> areaObjectIds) {
        if (areaObjectIds == null) {
            this.areaObjectChooserPane.setShowAllSelected(true);
        } else {
            this.areaObjectChooserPane.setShowAllSelected(false);
            this.areaObjectChooserPane.setSelectionIds(areaObjectIds);
        }
    }

    public void setLayer(AreaLayerModel areaLayerModel) {
        this.areaLayerComboBox.setSelectedItem(areaLayerModel);
    }

    public void setTargetLayer(AreaLayerModel targetAreaLayer) {
        this.targetAreaLayerComboBox.setSelectedItem(targetAreaLayer);
    }
}

