/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.configuration.gui.job.schedule.parameter.special;

import de.datomino.peppergis.client.gui.area.AreaLayerChooserList;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.area.AreaLayerModel;
import de.datomino.peppergis.type.AreaObjectGenInfoDiscriminator;
import de.datomino.util.swing.SpringUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.SpringLayout;

public class DeprecatedSubscriptionCleanerJobSettingsPane
extends JPanel {
    private static final long serialVersionUID = 2767396466429810119L;
    private JSpinner days;
    private AreaLayerChooserList areaLayerChooserList;
    private JCheckBox layersEnabled;
    private ModelEnviroment modelEnviroment;

    public DeprecatedSubscriptionCleanerJobSettingsPane(ModelEnviroment modelEnviroment) {
        super(new BorderLayout());
        this.modelEnviroment = modelEnviroment;
        this.buildLayout();
    }

    private void buildLayout() {
        JPanel panel = new JPanel(new SpringLayout());
        panel.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.days", new Serializable[0])));
        this.days = new JSpinner(new SpinnerNumberModel((Number)0, Integer.valueOf(0), null, (Number)1));
        panel.add(this.days);
        JLabel label = new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.area.layer", new Serializable[0]));
        label.setVerticalAlignment(1);
        panel.add(label);
        JPanel layerPanel = new JPanel(new BorderLayout());
        JPanel checkBoxPanel = new JPanel(new BorderLayout());
        this.layersEnabled = new JCheckBox();
        this.layersEnabled.setSelected(false);
        checkBoxPanel.add((Component)this.layersEnabled, "North");
        layerPanel.add((Component)checkBoxPanel, "West");
        this.areaLayerChooserList = new AreaLayerChooserList(this.modelEnviroment.getAllCaller().getAreaCaller().getAreaLayersForType(AreaObjectGenInfoDiscriminator.values()));
        layerPanel.add((Component)this.areaLayerChooserList, "Center");
        panel.add(layerPanel);
        SpringUtilities.makeCompactGrid(panel, 2, 2, 5, 5, 5, 5);
        this.add((Component)panel, "North");
        this.areaLayerChooserList.setEnabled(false);
        this.layersEnabled.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean b = DeprecatedSubscriptionCleanerJobSettingsPane.this.layersEnabled.isSelected();
                DeprecatedSubscriptionCleanerJobSettingsPane.this.areaLayerChooserList.setEnabled(b);
            }
        });
    }

    public void setDays(int days) {
        this.days.setValue(days);
    }

    public int getDays() {
        return (Integer)this.days.getValue();
    }

    public void setAreaLayers(Collection<AreaLayerModel> layers) {
        if (layers == null) {
            this.areaLayerChooserList.setEnabled(false);
            this.layersEnabled.setSelected(false);
            this.areaLayerChooserList.setSelectedAreaLayer(Collections.emptyList());
        } else {
            this.areaLayerChooserList.setEnabled(true);
            this.layersEnabled.setSelected(true);
            this.areaLayerChooserList.setSelectedAreaLayer(layers);
        }
    }

    public Collection<AreaLayerModel> getAreaLayers() {
        if (this.layersEnabled.isSelected()) {
            return this.areaLayerChooserList.getSelectedAreaLayers();
        }
        return null;
    }

    public void setAreaLayerIds(Collection<Long> areaLayers) {
        Collection<AreaLayerModel> layers = null;
        if (areaLayers != null) {
            layers = this.modelEnviroment.getAllCaller().getAreaCaller().getAreaLayerForIds(areaLayers);
        }
        this.setAreaLayers(layers);
    }
}

