/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.configuration.gui.job.schedule.parameter;

import de.datomino.util.swing.SpringUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.SpringLayout;
import org.ktde.util.datatypes.Tripel;
import org.ktde.util.datatypes.Tupel;

public class SimpleUserJobParameterPane
extends JPanel {
    private static final long serialVersionUID = 5747709524180472413L;
    private Map<String, Tupel<Class<?>, Component>> compMap;

    public SimpleUserJobParameterPane(List<Tripel<String, String, Class<?>>> data) {
        super(new BorderLayout());
        this.buildLayout(data);
    }

    private void buildLayout(List<Tripel<String, String, Class<?>>> data) {
        JPanel panel = new JPanel(new SpringLayout());
        this.compMap = new HashMap();
        for (Tripel<String, String, Class<?>> tripel : data) {
            String key = tripel.getElement1();
            String name = tripel.getElement2();
            Class<?> clazz = tripel.getElement3();
            JSpinner comp = null;
            if (!clazz.equals(Integer.class)) {
                throw new RuntimeException("Unsupported class: " + clazz);
            }
            panel.add(new JLabel(name));
            comp = new JSpinner(new SpinnerNumberModel((Number)0, null, null, (Number)1));
            panel.add(comp);
            this.compMap.put(key, new Tupel(clazz, comp));
        }
        SpringUtilities.makeCompactGrid(panel, data.size(), 2, 5, 5, 5, 5);
        this.add((Component)panel, "North");
    }

    public Object getValue(String key) {
        Tupel<Class<?>, Component> tupel = this.compMap.get(key);
        Class<?> clazz = tupel.getElement1();
        Component comp = tupel.getElement2();
        if (clazz.equals(Integer.class)) {
            JSpinner spinner = (JSpinner)comp;
            return (Integer)spinner.getValue();
        }
        return null;
    }

    public void setValue(String key, Object value) {
        Tupel<Class<?>, Component> tupel = this.compMap.get(key);
        Class<?> clazz = tupel.getElement1();
        Component comp = tupel.getElement2();
        if (clazz.equals(Integer.class)) {
            JSpinner spinner = (JSpinner)comp;
            spinner.setValue(value);
        }
    }
}

