/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.configuration.gui.job.schedule;

import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.admin.JobScheduleModel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.ktde.util.StringUtil;

public class JobScheduleTableModel
implements TableModel {
    private List<JobScheduleModel> jobSchedules;
    private List<TableModelListener> listeners = new ArrayList<TableModelListener>();
    private Map<String, String> nameMap;

    public JobScheduleTableModel(Map<String, String> nameMap) {
        this.nameMap = nameMap;
    }

    @Override
    public int getRowCount() {
        return this.jobSchedules == null ? 0 : this.jobSchedules.size();
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public String getColumnName(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return ModelEnviroment.getMessageResolver().resolveMessage("messages.default.name", new Serializable[0]);
            }
            case 1: {
                return ModelEnviroment.getMessageResolver().resolveMessage("messages.job", new Serializable[0]);
            }
            case 2: {
                return ModelEnviroment.getMessageResolver().resolveMessage("messages.job.cron", new Serializable[0]);
            }
        }
        return null;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return String.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        JobScheduleModel jobScheduleModel = this.jobSchedules.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return jobScheduleModel.getName();
            }
            case 1: {
                String name = this.nameMap.get(jobScheduleModel.getJobBeanName());
                return StringUtil.isBlank(name) ? "?" : name;
            }
            case 2: {
                return jobScheduleModel.getCronExpression();
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.listeners.remove(l);
    }

    protected void fireTableModelEvent(TableModelEvent e) {
        for (TableModelListener l : this.listeners) {
            l.tableChanged(e);
        }
    }

    public void setJobSchedules(List<JobScheduleModel> jobSchedules) {
        this.jobSchedules = jobSchedules;
        this.fireTableModelEvent(new TableModelEvent(this));
    }

    public JobScheduleModel getJobScheduleAt(int row) {
        return this.jobSchedules.get(row);
    }

    public JobScheduleModel removeJobScheduleAt(int row) {
        JobScheduleModel remove = this.jobSchedules.remove(row);
        this.fireTableModelEvent(new TableModelEvent(this));
        return remove;
    }

    public void addJobSchedule(JobScheduleModel jobScheduleModel) {
        this.jobSchedules.add(jobScheduleModel);
        this.fireTableModelEvent(new TableModelEvent(this));
    }
}

