/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.configuration.gui.job;

import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.dto.job.JobDto;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class JobPane
extends JPanel {
    private static final long serialVersionUID = -909893722660537524L;
    private JTable jobTable;
    private ModelEnviroment modelEnviroment;

    public JobPane(ModelEnviroment modelEnviroment) {
        super(new BorderLayout());
        this.modelEnviroment = modelEnviroment;
        List<JobDto> jobs = modelEnviroment.getAllCaller().getJobCaller().getJobs();
        this.jobTable = new JTable(new JobTableModel(jobs));
        this.jobTable.setSelectionMode(0);
        this.jobTable.getTableHeader().setReorderingAllowed(false);
        this.jobTable.getColumnModel().getColumn(0).setPreferredWidth(300);
        this.jobTable.setRowHeight(Math.round((float)this.jobTable.getRowHeight() * 1.2f));
        this.add((Component)new JScrollPane(this.jobTable), "Center");
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)new JButton(new StartJobAction()), "East");
        panel.add((Component)new JButton(new RefreshAction()), "West");
        this.add((Component)panel, "South");
    }

    private class JobTableModel
    implements TableModel {
        private List<JobDto> jobs;
        private List<TableModelListener> tableModelListeners = new LinkedList<TableModelListener>();

        public JobTableModel(List<JobDto> jobs) {
            this.jobs = jobs;
        }

        @Override
        public int getRowCount() {
            return this.jobs.size();
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public String getColumnName(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return ModelEnviroment.getMessageResolver().resolveMessage("messages.default.name", new Serializable[0]);
                }
                case 1: {
                    return ModelEnviroment.getMessageResolver().resolveMessage("messages.job.active", new Serializable[0]);
                }
                case 2: {
                    return ModelEnviroment.getMessageResolver().resolveMessage("messages.job.running", new Serializable[0]);
                }
            }
            return "?";
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return String.class;
                }
                case 1: 
                case 2: {
                    return Boolean.class;
                }
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            JobDto job = this.jobs.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return job.getName();
                }
                case 1: {
                    return job.isActive();
                }
                case 2: {
                    return job.isRunning();
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        }

        @Override
        public void addTableModelListener(TableModelListener l) {
            this.tableModelListeners.add(l);
        }

        @Override
        public void removeTableModelListener(TableModelListener l) {
            this.tableModelListeners.remove(l);
        }

        public void setJobs(List<JobDto> jobs) {
            this.jobs = jobs;
            this.fireModelChanged();
        }

        public List<JobDto> getJobs() {
            return this.jobs;
        }

        private void fireModelChanged() {
            TableModelEvent tableModelEvent = new TableModelEvent(this);
            for (TableModelListener tableModelListener : this.tableModelListeners) {
                tableModelListener.tableChanged(tableModelEvent);
            }
        }
    }

    private class StartJobAction
    extends AbstractAction {
        private static final long serialVersionUID = 6716797577374943188L;

        public StartJobAction() {
            super(ModelEnviroment.getMessageResolver().resolveMessage("messages.job.start", new Serializable[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = JobPane.this.jobTable.getSelectedRow();
            if (row >= 0) {
                JobTableModel model = (JobTableModel)JobPane.this.jobTable.getModel();
                JobDto job = model.getJobs().get(row);
                JobPane.this.modelEnviroment.getAllCaller().getJobCaller().startJob(job.getName());
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                List<JobDto> jobs = JobPane.this.modelEnviroment.getAllCaller().getJobCaller().getJobs();
                model.setJobs(jobs);
            }
        }
    }

    private class RefreshAction
    extends AbstractAction {
        private static final long serialVersionUID = -4102986605919677913L;

        public RefreshAction() {
            super(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.refresh", new Serializable[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JobTableModel model = (JobTableModel)JobPane.this.jobTable.getModel();
            List<JobDto> jobs = JobPane.this.modelEnviroment.getAllCaller().getJobCaller().getJobs();
            model.setJobs(jobs);
        }
    }
}

