/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.configuration.gui.area.action;

import de.datomino.peppergis.client.gui.area.DefaultAreaObjectChooserPane;
import de.datomino.peppergis.client.gui.asynchronous.AbstractAsynchronousDialog;
import de.datomino.peppergis.client.gui.common.AbstractModelComboBox;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.area.AreaAttributeValueDescriptorModel;
import de.datomino.peppergis.client.model.area.AreaAttributeValueModel;
import de.datomino.peppergis.client.model.area.AreaLayerModel;
import de.datomino.peppergis.dto.area.AreaLayerDto;
import de.datomino.peppergis.dto.asynchronous.AsynchronousDto;
import de.datomino.peppergis.dto.common.CollectionDto;
import de.datomino.peppergis.type.AreaObjectGenInfoDiscriminator;
import de.datomino.peppergis.type.AttributeValueType;
import de.datomino.peppergis.type.UserRole;
import de.datomino.util.swing.SpringUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.SpringLayout;
import org.ktde.util.StringUtil;
import org.ktde.util.datatypes.Tupel;

public abstract class AbstractDuplicateLayerAction
extends AbstractAction {
    private static final long serialVersionUID = 7756989399161610630L;
    private Window parent;
    private ModelEnviroment modelEnviroment;
    private boolean split;
    private boolean selectAreas;

    public AbstractDuplicateLayerAction(Window parent, ModelEnviroment modelEnviroment, boolean split, boolean selectAreas) {
        super(ModelEnviroment.getMessageResolver().resolveMessage(split ? "messages.default.splitDuplicate" : "messages.default.duplicate", new Serializable[0]));
        this.parent = parent;
        this.modelEnviroment = modelEnviroment;
        this.split = split;
        this.selectAreas = selectAreas;
        this.setEnabled(ModelEnviroment.getUserInformation().isAdmin() || ModelEnviroment.getUserInformation().hasAtLeastOneRole(UserRole.AREA_ADMIN, UserRole.DISPONENT_SUPER));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        AreaLayerModel areaLayer;
        if ((!this.split || this.existsAreaAttributeForText()) && (areaLayer = this.getSelectedAreaLayer()) != null) {
            if (areaLayer.getDiscriminator() != AreaObjectGenInfoDiscriminator.AREA_OBJECT_GEN_UNMODIFYABLE) {
                DuplicateSettings settings = this.askDuplicateSettings(areaLayer);
                if (settings != null) {
                    AreaAttributeValueDescriptorModel areaAttributeValueDescriptorModel = null;
                    if (this.split && (areaAttributeValueDescriptorModel = this.askSplitAttributeValueDescriptor()) != null && !this.checkAreaAttributeValueDescriptor(areaLayer, areaAttributeValueDescriptorModel)) {
                        areaAttributeValueDescriptorModel = null;
                    }
                    if (!this.split || areaAttributeValueDescriptorModel != null) {
                        final boolean rels = settings.isRels();
                        final boolean geoms = settings.isGeoms();
                        final boolean subscriptions = settings.isSubscriptions();
                        final boolean pois = settings.isPois();
                        final boolean delivererLayerRels = settings.isDelivererLayerRels();
                        final Collection<Long> areaObjectIds = settings.getAreas();
                        final AreaAttributeValueDescriptorModel fAreaAttributeValueDescriptorModel = areaAttributeValueDescriptorModel;
                        AbstractAsynchronousDialog<CollectionDto<AreaLayerDto>> dialog = new AbstractAsynchronousDialog<CollectionDto<AreaLayerDto>>(this.parent, ModelEnviroment.getMessageResolver().resolveMessage("messages.default.duplicate", new Serializable[0]), ModelEnviroment.getMessageResolver().resolveMessage("messages.default.duplicate", new Serializable[0]), 1, this.modelEnviroment){
                            private static final long serialVersionUID = -966301314204297851L;

                            @Override
                            protected String startAsynchronous() {
                                return AbstractDuplicateLayerAction.this.modelEnviroment.getAllCaller().getAsynchronousCaller().cloneAreaLayer(areaLayer, AbstractDuplicateLayerAction.this.split ? null : AbstractDuplicateLayerAction.this.getNewAreaLayerName(areaLayer.getDisplayname()), rels, geoms, subscriptions, pois, delivererLayerRels, fAreaAttributeValueDescriptorModel, areaObjectIds);
                            }

                            @Override
                            protected AsynchronousDto<CollectionDto<AreaLayerDto>> getAsynchronousDto(String token) {
                                return AbstractDuplicateLayerAction.this.modelEnviroment.getAllCaller().getAsynchronousCaller().getCloneAreaLayerResult(token);
                            }
                        };
                        Tupel run = null;
                        try {
                            run = dialog.run();
                        }
                        catch (Exception e1) {
                            throw new RuntimeException(e1);
                        }
                        for (AreaLayerDto dto : ((CollectionDto)run.getElement1()).getCollection()) {
                            AreaLayerModel newAreaLayer = (AreaLayerModel)this.modelEnviroment.getModelCache().getModel(dto);
                            this.addAndSelectAreaLayer(newAreaLayer);
                        }
                    }
                }
            } else {
                JOptionPane.showMessageDialog(this.parent, areaLayer.getDisplayname() + " darf nicht dupliziert werden.", "", 2);
            }
        }
    }

    private boolean existsAreaAttributeForText() {
        Collection<AreaAttributeValueDescriptorModel> areaAttributeValueDescriptors = this.modelEnviroment.getAllCaller().getAreaCaller().fetchAllAreaAttributeValueDescriptors();
        for (AreaAttributeValueDescriptorModel desc : areaAttributeValueDescriptors) {
            if (desc.getAttributeValueType() != AttributeValueType.STRING) continue;
            return true;
        }
        JOptionPane.showMessageDialog(this.parent, ModelEnviroment.getMessageResolver().resolveMessage("messages.area.duplicate.noTextAttribute", new Serializable[0]), ModelEnviroment.getMessageResolver().resolveMessage("messages.default.warning", new Serializable[0]), 2);
        return false;
    }

    private boolean checkAreaAttributeValueDescriptor(AreaLayerModel currentLayer, AreaAttributeValueDescriptorModel areaAttributeValueDescriptorModel) {
        Collection<AreaLayerModel> layers = this.modelEnviroment.getAllCaller().getAreaCaller().getAreaLayersForType(new AreaObjectGenInfoDiscriminator[]{currentLayer.getDiscriminator()});
        HashSet<String> layerNames = new HashSet<String>();
        for (AreaLayerModel layer : layers) {
            layerNames.add(layer.getDisplayname());
        }
        Collection<AreaAttributeValueModel> areaAttributes = this.modelEnviroment.getAllCaller().getAreaCaller().getAreaAttributeValuesByAreaLayerAndDescriptor(currentLayer, areaAttributeValueDescriptorModel);
        TreeSet<String> missingLayers = new TreeSet<String>();
        for (AreaAttributeValueModel areaAttribute : areaAttributes) {
            String newLayerName = areaAttribute.getStringValue();
            if (StringUtil.isBlank(newLayerName) || layerNames.contains(newLayerName)) continue;
            missingLayers.add(newLayerName);
        }
        if (!missingLayers.isEmpty()) {
            JOptionPane.showMessageDialog(this.parent, ModelEnviroment.getMessageResolver().resolveMessage("messages.area.duplicate.missingLayers", new Serializable[]{StringUtil.implode(missingLayers, ", ")}), ModelEnviroment.getMessageResolver().resolveMessage("messages.default.error", new Serializable[0]), 0);
            return false;
        }
        return true;
    }

    private AreaAttributeValueDescriptorModel askSplitAttributeValueDescriptor() {
        Collection<AreaAttributeValueDescriptorModel> areaAttributeValueDescriptors = this.modelEnviroment.getAllCaller().getAreaCaller().fetchAllAreaAttributeValueDescriptors();
        TreeSet<AreaAttributeValueDescriptorModel> descs = new TreeSet<AreaAttributeValueDescriptorModel>(new Comparator<AreaAttributeValueDescriptorModel>(){

            @Override
            public int compare(AreaAttributeValueDescriptorModel o1, AreaAttributeValueDescriptorModel o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        for (AreaAttributeValueDescriptorModel desc : areaAttributeValueDescriptors) {
            if (desc.getAttributeValueType() != AttributeValueType.STRING) continue;
            descs.add(desc);
        }
        JPanel panel = new JPanel(new SpringLayout());
        panel.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.layer.duplicate.split.attributeQuestion", new Serializable[0])));
        AbstractModelComboBox<AreaAttributeValueDescriptorModel> descBox = new AbstractModelComboBox<AreaAttributeValueDescriptorModel>(descs, false){
            private static final long serialVersionUID = -7397530614471063124L;

            @Override
            protected String getStringRepresentation(AreaAttributeValueDescriptorModel t) {
                return t.getName();
            }
        };
        JPanel subPanel = new JPanel(new BorderLayout());
        subPanel.add((Component)descBox, "West");
        panel.add(subPanel);
        SpringUtilities.makeCompactGrid(panel, 2, 1, 5, 5, 5, 5);
        int d = JOptionPane.showConfirmDialog(this.parent, panel, ModelEnviroment.getMessageResolver().resolveMessage("messages.default.question", new Serializable[0]), 0);
        if (d == 0) {
            return (AreaAttributeValueDescriptorModel)descBox.getSelectedItem();
        }
        return null;
    }

    protected abstract AreaLayerModel getSelectedAreaLayer();

    protected abstract String getNewAreaLayerName(String var1);

    protected abstract void addAndSelectAreaLayer(AreaLayerModel var1);

    private DuplicateSettings askDuplicateSettings(AreaLayerModel areaLayerModel) {
        JPanel panel = new JPanel(new SpringLayout());
        panel.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.area.duplicate.objectQuestion", new Serializable[0])));
        JCheckBox relBox = new JCheckBox(ModelEnviroment.getMessageResolver().resolveMessage("messages.importer.parcelAreaRelation", new Serializable[0]), true);
        panel.add(relBox);
        JCheckBox geomBox = new JCheckBox(ModelEnviroment.getMessageResolver().resolveMessage("messages.area.surface", new Serializable[0]), true);
        panel.add(geomBox);
        JCheckBox subscriptionBox = new JCheckBox(ModelEnviroment.getMessageResolver().resolveMessage("messages.subscription.subscriptions", new Serializable[0]), true);
        panel.add(subscriptionBox);
        JCheckBox poiBox = new JCheckBox(ModelEnviroment.getMessageResolver().resolveMessage("gui.stop.stops", new Serializable[0]), true);
        panel.add(poiBox);
        JCheckBox delivererLayerRelBox = new JCheckBox(ModelEnviroment.getMessageResolver().resolveMessage("messages.area.delivererLayerRelations", new Serializable[0]), true);
        panel.add(delivererLayerRelBox);
        DefaultAreaObjectChooserPane defaultAreaObjectChooserPane = null;
        if (this.selectAreas) {
            panel.add(new JSeparator());
            defaultAreaObjectChooserPane = new DefaultAreaObjectChooserPane(areaLayerModel, this.modelEnviroment);
            panel.add(defaultAreaObjectChooserPane);
        }
        SpringUtilities.makeCompactGrid(panel, 6 + (this.selectAreas ? 2 : 0), 1, 5, 5, 2, 2);
        int d = JOptionPane.showConfirmDialog(this.parent, panel, ModelEnviroment.getMessageResolver().resolveMessage("messages.default.question", new Serializable[0]), 0, 3);
        if (d == 0) {
            return new DuplicateSettings(relBox.isSelected(), geomBox.isSelected(), subscriptionBox.isSelected(), poiBox.isSelected(), delivererLayerRelBox.isSelected(), this.selectAreas ? defaultAreaObjectChooserPane.getSelectedAreaObjects() : null);
        }
        return null;
    }

    private static class DuplicateSettings {
        private boolean rels;
        private boolean geoms;
        private boolean subscriptions;
        private boolean pois;
        private boolean delivererLayerRels;
        private Collection<Long> areas;

        public DuplicateSettings(boolean rels, boolean geoms, boolean subscriptions, boolean pois, boolean delivererLayerRels, Collection<Long> areas) {
            this.rels = rels;
            this.geoms = geoms;
            this.subscriptions = subscriptions;
            this.pois = pois;
            this.delivererLayerRels = delivererLayerRels;
            this.areas = areas;
        }

        public boolean isRels() {
            return this.rels;
        }

        public boolean isGeoms() {
            return this.geoms;
        }

        public boolean isSubscriptions() {
            return this.subscriptions;
        }

        public boolean isPois() {
            return this.pois;
        }

        public boolean isDelivererLayerRels() {
            return this.delivererLayerRels;
        }

        public Collection<Long> getAreas() {
            return this.areas;
        }
    }
}

