/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.configuration.gui.area;

import de.datomino.peppergis.client.gui.common.CommonDialog;
import de.datomino.peppergis.client.gui.common.DialogDisposeAction;
import de.datomino.peppergis.client.gui.common.EnumComboBox;
import de.datomino.peppergis.client.gui.image.ImageComboBoxChooserPane;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.gui.renderer.editor.ColorValueEditor;
import de.datomino.peppergis.client.model.area.AreaLayerModel;
import de.datomino.peppergis.client.model.area.AreaLayerModelImpl;
import de.datomino.peppergis.client.util.AbstractDocumentListener;
import de.datomino.peppergis.configuration.gui.area.AreaLayerDetaillessConfigurationPane;
import de.datomino.peppergis.configuration.gui.area.AreaLayerElement;
import de.datomino.peppergis.configuration.gui.area.action.AbstractDuplicateLayerAction;
import de.datomino.peppergis.configuration.gui.renderer.AreaDefaultRendererChooserPane;
import de.datomino.peppergis.configuration.gui.renderer.LineDefaultRendererChooserPane;
import de.datomino.peppergis.exception.ValidateException;
import de.datomino.peppergis.type.AreaObjectGenInfoDiscriminator;
import de.datomino.peppergis.type.UserRole;
import de.datomino.util.PropertyUtil;
import de.datomino.util.geo.swing.FreeHandMarkerNavigatorRenderer;
import de.datomino.util.geo.swing.PaintUtil;
import de.datomino.util.swing.SpringUtilities;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.SpringLayout;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.ktde.util.application.ClientApplicationProperties;
import org.ktde.util.datatypes.Tupel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AreaLayerDialog
extends CommonDialog {
    private static final long serialVersionUID = -1076944764891544148L;
    private static final Logger LOGGER = LoggerFactory.getLogger(AreaLayerDialog.class);
    private static final String NEW_AREA_LAYER_NAME = ModelEnviroment.getMessageResolver().resolveMessage("messages.area.newLayer", new Serializable[0]);
    private ModelEnviroment modelEnviroment;
    private JList areaLayers;
    private JTextField areaDisplayName;
    private EnumComboBox<AreaObjectGenInfoDiscriminator> discriminator;
    private AreaDefaultRendererChooserPane areaRendererPane;
    private AreaDefaultRendererChooserPane markAreaRendererPane;
    private LineDefaultRendererChooserPane lineRendererPane;
    private DialogDisposeAction disposeAction = new DialogDisposeAction(this);
    private OkAction okAction = new OkAction();
    private AddLayerAction addLayerAction = new AddLayerAction();
    private DeleteLayerAction deleteLayerAction = new DeleteLayerAction();
    private AbstractDuplicateLayerAction regularDuplicateLayerAction;
    private AbstractDuplicateLayerAction splitDuplicateLayerAction;
    private Integer lastSelectedIndex;
    private Map<String, Tupel<AreaLayerModel, Properties>> propertiesToSet = new HashMap<String, Tupel<AreaLayerModel, Properties>>();
    private String applicationName;
    private ColorValueEditor markColorEditor;
    private JSpinner markAlpha;
    private AreaLayerDetaillessConfigurationPane areaLayerDetaillessConfigurationPane;
    private JTextArea printInfo;
    private ImageComboBoxChooserPane imageComboBoxChooserPane;
    private boolean micro;
    private boolean macro;

    public AreaLayerDialog(Window owner, ModelEnviroment modelEnviroment, String applicationName) {
        super((Component)owner, ModelEnviroment.getMessageResolver().resolveMessage("messages.area.layer.configuration", new Serializable[0]), Dialog.ModalityType.APPLICATION_MODAL);
        this.modelEnviroment = modelEnviroment;
        this.applicationName = applicationName;
        this.micro = this.modelEnviroment.getAllCaller().getAreaCaller().isMicroCellAllowed();
        this.macro = this.modelEnviroment.getAllCaller().getAreaCaller().isMacroCellAllowed();
        this.regularDuplicateLayerAction = new DialogDuplicateLayerAction(this, modelEnviroment, false, true);
        this.splitDuplicateLayerAction = new DialogDuplicateLayerAction(this, modelEnviroment, true, false);
        this.buildLayout();
        this.pack();
        this.center();
        this.fillData();
        this.modelEnviroment.getUndoManager().startTransaction();
    }

    @Override
    protected Action getCancelAction() {
        return this.disposeAction;
    }

    @Override
    protected Component getMainComponent() {
        JPanel panel = this.createMainTab();
        return panel;
    }

    private JPanel createMainTab() {
        Color extractedColor;
        JPanel panel = new JPanel(new SpringLayout());
        JSplitPane layerPanel = new JSplitPane(1);
        JPanel listPanel = this.createLayerListPanel();
        layerPanel.setLeftComponent(listPanel);
        JTabbedPane tabbedPane = new JTabbedPane();
        JPanel editPanel = this.createCommonEditPanel();
        tabbedPane.add(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.common", new Serializable[0]), editPanel);
        JPanel detaillessPane = this.createDetaillessPane();
        if (ModelEnviroment.getUserInformation().hasAtLeastOneRole(UserRole.ADMIN)) {
            tabbedPane.add(ModelEnviroment.getMessageResolver().resolveMessage("messages.area.detailless.configuration", new Serializable[0]), detaillessPane);
        }
        layerPanel.setRightComponent(tabbedPane);
        panel.add(layerPanel);
        JPanel markColorPanel = new JPanel(new SpringLayout());
        String markColorString = ModelEnviroment.getProperties().getProperty("areas.markColor");
        String markAlphaString = ModelEnviroment.getProperties().getProperty("areas.markAlpha");
        Color markColor = new Color(FreeHandMarkerNavigatorRenderer.AREACOLOR.getRed(), FreeHandMarkerNavigatorRenderer.AREACOLOR.getGreen(), FreeHandMarkerNavigatorRenderer.AREACOLOR.getBlue());
        if (markColorString != null && (extractedColor = PaintUtil.extractColor(0, markColorString)) != null) {
            markColor = new Color(extractedColor.getRed(), extractedColor.getGreen(), extractedColor.getBlue(), markColor.getAlpha());
        }
        Integer alpha = FreeHandMarkerNavigatorRenderer.AREACOLOR.getAlpha();
        if (markAlphaString != null) {
            try {
                alpha = Integer.valueOf(markAlphaString);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (alpha != null) {
                markColor = new Color(markColor.getRed(), markColor.getGreen(), markColor.getBlue(), PaintUtil.transform100BaseAlpha(alpha));
            }
        }
        markColorPanel.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.color", new Serializable[0])));
        this.markColorEditor = new ColorValueEditor(markColor);
        markColorPanel.add(this.markColorEditor);
        markColorPanel.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.color.alpha", new Serializable[0])));
        this.markAlpha = new JSpinner(new SpinnerNumberModel(PaintUtil.transform256BaseAlpha(markColor.getAlpha()), 0, 100, 1));
        markColorPanel.add(this.markAlpha);
        SpringUtilities.makeCompactGrid(markColorPanel, 2, 2, 5, 5, 2, 2);
        panel.add(markColorPanel);
        SpringUtilities.makeCompactGrid(panel, 2, 1, 5, 5, 2, 2);
        return panel;
    }

    private JPanel createDetaillessPane() {
        this.areaLayerDetaillessConfigurationPane = new AreaLayerDetaillessConfigurationPane(this.modelEnviroment);
        return this.areaLayerDetaillessConfigurationPane;
    }

    private JPanel createCommonEditPanel() {
        JPanel editPanel = new JPanel(new BorderLayout());
        JPanel subEditPanel = new JPanel(new SpringLayout());
        JPanel subSubEditPanel = new JPanel(new SpringLayout());
        this.areaDisplayName = new JTextField(10);
        this.areaDisplayName.getDocument().addDocumentListener(new TextDocumentListener());
        subSubEditPanel.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.name", new Serializable[0])));
        subSubEditPanel.add(this.areaDisplayName);
        SpringUtilities.makeCompactGrid(subSubEditPanel, 1, 2, 2, 2, 5, 5);
        subEditPanel.add(subSubEditPanel);
        subSubEditPanel = new JPanel(new SpringLayout());
        subSubEditPanel.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage(AreaObjectGenInfoDiscriminator.class.getName(), new Serializable[0])));
        Enum[] discriminator = this.filterDiscriminators();
        this.discriminator = new EnumComboBox(AreaObjectGenInfoDiscriminator.class, false, discriminator);
        this.discriminator.addActionListener(new DiscriminatorActionListener());
        this.discriminator.setEnabled(false);
        subSubEditPanel.add(this.discriminator);
        SpringUtilities.makeCompactGrid(subSubEditPanel, 1, 2, 2, 2, 5, 5);
        subEditPanel.add(subSubEditPanel);
        subEditPanel.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.line.rendering", new Serializable[0])));
        this.lineRendererPane = new LineDefaultRendererChooserPane(this.modelEnviroment);
        this.lineRendererPane.setEnabled(false);
        subEditPanel.add(this.lineRendererPane);
        subEditPanel.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.area.rendering", new Serializable[0])));
        this.areaRendererPane = new AreaDefaultRendererChooserPane(this.modelEnviroment);
        this.areaRendererPane.setEnabled(false);
        subEditPanel.add(this.areaRendererPane);
        subEditPanel.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.area.rendering.mark", new Serializable[0])));
        this.markAreaRendererPane = new AreaDefaultRendererChooserPane(this.modelEnviroment);
        this.markAreaRendererPane.setEnabled(false);
        subEditPanel.add(this.markAreaRendererPane);
        subEditPanel.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.arealayer.printInfo", new Serializable[0])));
        this.printInfo = new JTextArea("", 3, 20);
        this.printInfo.setEditable(false);
        this.printInfo.getDocument().addDocumentListener(new AbstractDocumentListener(){

            @Override
            protected void handleChange() {
                AreaLayerElement areaLayerElement = (AreaLayerElement)AreaLayerDialog.this.areaLayers.getSelectedValue();
                if (areaLayerElement != null && (ModelEnviroment.getUserInformation().isAdmin() || ModelEnviroment.getUserInformation().hasUserRole(UserRole.AREA_ADMIN))) {
                    areaLayerElement.getAreaLayerModel().setPrintInfo(AreaLayerDialog.this.printInfo.getText());
                    AreaLayerDialog.this.areaLayers.repaint(10L);
                }
            }
        });
        subEditPanel.add(new JScrollPane(this.printInfo));
        subEditPanel.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.image", new Serializable[0])));
        this.imageComboBoxChooserPane = new ImageComboBoxChooserPane(this.modelEnviroment);
        subEditPanel.add(this.imageComboBoxChooserPane);
        this.imageComboBoxChooserPane.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AreaLayerElement areaLayerElement = (AreaLayerElement)AreaLayerDialog.this.areaLayers.getSelectedValue();
                if (areaLayerElement != null && (ModelEnviroment.getUserInformation().isAdmin() || ModelEnviroment.getUserInformation().hasUserRole(UserRole.AREA_ADMIN))) {
                    areaLayerElement.getAreaLayerModel().setLogo(AreaLayerDialog.this.imageComboBoxChooserPane.getSelectedItem());
                    AreaLayerDialog.this.areaLayers.repaint(10L);
                }
            }
        });
        SpringUtilities.makeCompactGrid(subEditPanel, 12, 1, 5, 5, 2, 2);
        editPanel.add((Component)subEditPanel, "Center");
        return editPanel;
    }

    private AreaObjectGenInfoDiscriminator[] filterDiscriminators() {
        AreaObjectGenInfoDiscriminator[] discriminator = AreaObjectGenInfoDiscriminator.values();
        AreaObjectGenInfoDiscriminator[] mDiscriminator = new AreaObjectGenInfoDiscriminator[discriminator.length - (this.micro ? 0 : 1) - (this.macro ? 0 : 1)];
        int i = 0;
        block4: for (AreaObjectGenInfoDiscriminator disc : discriminator) {
            switch (disc) {
                case AREA_OBJECT_MICRO_CELL: {
                    if (!this.micro) continue block4;
                    mDiscriminator[i++] = disc;
                    continue block4;
                }
                case AREA_OBJECT_MACRO_CELL: {
                    if (!this.macro) continue block4;
                    mDiscriminator[i++] = disc;
                    continue block4;
                }
                default: {
                    mDiscriminator[i++] = disc;
                }
            }
        }
        discriminator = mDiscriminator;
        return discriminator;
    }

    private JPanel createLayerListPanel() {
        JPanel listPanel = new JPanel(new BorderLayout());
        this.areaLayers = new JList();
        JScrollPane scroll = new JScrollPane(this.areaLayers);
        listPanel.add((Component)scroll, "Center");
        this.areaLayers.setSelectionMode(0);
        this.areaLayers.addListSelectionListener(new AreaListSelectionListener());
        JPanel listButtonPanel = new JPanel(new FlowLayout());
        JButton addButton = new JButton(this.addLayerAction);
        listButtonPanel.add(addButton);
        listButtonPanel.add(new JButton(this.regularDuplicateLayerAction));
        listButtonPanel.add(new JButton(this.splitDuplicateLayerAction));
        JButton deleteButton = new JButton(this.deleteLayerAction);
        listButtonPanel.add(deleteButton);
        JPanel buttonPanel = new JPanel(new BorderLayout());
        buttonPanel.add((Component)listButtonPanel, "East");
        listPanel.add((Component)buttonPanel, "South");
        listPanel.setBorder(new TitledBorder(ModelEnviroment.getMessageResolver().resolveMessage("messages.area.layer", new Serializable[0])));
        return listPanel;
    }

    @Override
    protected Action getOkAction() {
        return this.okAction;
    }

    private void fillData() {
        AreaObjectGenInfoDiscriminator[] discriminator = this.filterDiscriminators();
        Collection<AreaLayerModel> areaLayers = this.modelEnviroment.getAllCaller().getAreaCaller().getAreaLayersForType(discriminator);
        DefaultListModel<AreaLayerElement> listModel = new DefaultListModel<AreaLayerElement>();
        for (AreaLayerModel areaLayerModel : areaLayers) {
            listModel.addElement(new AreaLayerElement(areaLayerModel));
        }
        this.areaLayers.setModel(listModel);
        this.areaLayers.setSelectedIndices(new int[0]);
        this.areaDisplayName.setEnabled(false);
        this.printInfo.setEditable(false);
        this.imageComboBoxChooserPane.setEnabled(false);
    }

    private void putPropertiesForAreaLayer() {
        if (this.lastSelectedIndex != null) {
            AreaLayerElement areaLayerElement = (AreaLayerElement)this.areaLayers.getModel().getElementAt(this.lastSelectedIndex);
            AreaLayerModel areaLayerModel = areaLayerElement.getAreaLayerModel();
            Long id = areaLayerModel.getId();
            String idString = id == null ? "T" + areaLayerModel.getTempUUID() : id.toString();
            Properties areaProps = this.areaRendererPane.createProperties("layerstyle." + idString + ".fill");
            Properties borderProps = this.lineRendererPane.createProperties("layerstyle." + idString + ".border");
            Properties markProps = this.markAreaRendererPane.createProperties("layerstyle." + idString + ".mark");
            this.propertiesToSet.put(idString, new Tupel<AreaLayerModel, Properties>(areaLayerModel, PropertyUtil.mergeProperties(areaProps, borderProps, markProps)));
        }
    }

    private String getNewAreaLayerName(String defaultName) {
        boolean found;
        String newName = defaultName;
        int suffixCount = 1;
        DefaultListModel listModel = (DefaultListModel)this.areaLayers.getModel();
        int size = listModel.getSize();
        block0: do {
            found = true;
            for (int i = 0; i < size; ++i) {
                AreaLayerElement element = (AreaLayerElement)listModel.getElementAt(i);
                if (!element.getAreaLayerModel().getDisplayname().equals(newName)) continue;
                newName = defaultName + "_" + suffixCount;
                ++suffixCount;
                found = false;
                continue block0;
            }
        } while (!found);
        return newName;
    }

    private class DialogDuplicateLayerAction
    extends AbstractDuplicateLayerAction {
        private static final long serialVersionUID = -1310112740466709313L;

        public DialogDuplicateLayerAction(Window parent, ModelEnviroment modelEnviroment, boolean split, boolean selectAreas) {
            super(parent, modelEnviroment, split, selectAreas);
        }

        @Override
        protected AreaLayerModel getSelectedAreaLayer() {
            if (AreaLayerDialog.this.lastSelectedIndex != null) {
                DefaultListModel dlm = (DefaultListModel)AreaLayerDialog.this.areaLayers.getModel();
                AreaLayerElement element = (AreaLayerElement)dlm.getElementAt(AreaLayerDialog.this.lastSelectedIndex);
                return element.getAreaLayerModel();
            }
            return null;
        }

        @Override
        protected String getNewAreaLayerName(String displayname) {
            return AreaLayerDialog.this.getNewAreaLayerName(displayname);
        }

        @Override
        protected void addAndSelectAreaLayer(AreaLayerModel layerModel) {
            DefaultListModel dlm = (DefaultListModel)AreaLayerDialog.this.areaLayers.getModel();
            dlm.addElement(new AreaLayerElement(layerModel));
            AreaLayerDialog.this.areaLayers.setSelectedIndex(dlm.size() - 1);
        }
    }

    private class DeleteLayerAction
    extends AbstractAction {
        private static final long serialVersionUID = -1086286998318286451L;

        public DeleteLayerAction() {
            super(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.delete", new Serializable[0]));
            this.setEnabled(ModelEnviroment.getUserInformation().isAdmin() || ModelEnviroment.getUserInformation().hasAtLeastOneRole(UserRole.AREA_ADMIN, UserRole.DISPONENT_SUPER));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int d;
            if (AreaLayerDialog.this.lastSelectedIndex != null && (d = JOptionPane.showConfirmDialog(AreaLayerDialog.this, ModelEnviroment.getMessageResolver().resolveMessage("messages.area.delete.confirmDeleteAlert", new Serializable[]{AreaLayerDialog.this.areaLayers.getSelectedValue().toString()}), ModelEnviroment.getMessageResolver().resolveMessage("messages.default.delete", new Serializable[0]), 2, 2)) == 0) {
                AreaLayerElement areaLayerElement = (AreaLayerElement)AreaLayerDialog.this.areaLayers.getModel().getElementAt(AreaLayerDialog.this.lastSelectedIndex);
                AreaLayerModel areaLayer = areaLayerElement.getAreaLayerModel();
                if (areaLayer.getId() == null) {
                    areaLayer.delete();
                } else {
                    AreaLayerDialog.this.modelEnviroment.getAllCaller().getAreaCaller().deleteAreaLayer(areaLayer);
                    AreaLayerDialog.this.modelEnviroment.getModelCache().evictModel(areaLayer);
                    AreaLayerDialog.this.modelEnviroment.getUndoManager().removeFromChangeObjects(areaLayer);
                }
                DefaultListModel listModel = (DefaultListModel)AreaLayerDialog.this.areaLayers.getModel();
                AreaLayerDialog.this.lastSelectedIndex = null;
                listModel.removeElement(new AreaLayerElement(areaLayer));
            }
        }
    }

    private class AddLayerAction
    extends AbstractAction {
        private static final long serialVersionUID = -1086286998318286451L;

        public AddLayerAction() {
            super(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.add", new Serializable[0]));
            this.setEnabled(ModelEnviroment.getUserInformation().isAdmin() || ModelEnviroment.getUserInformation().hasAtLeastOneRole(UserRole.AREA_ADMIN, UserRole.DISPONENT_SUPER));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DefaultListModel listModel = (DefaultListModel)AreaLayerDialog.this.areaLayers.getModel();
            int size = listModel.getSize();
            AreaLayerModelImpl newAreaLayerModel = new AreaLayerModelImpl();
            newAreaLayerModel.setDisplayname(AreaLayerDialog.this.getNewAreaLayerName(NEW_AREA_LAYER_NAME));
            listModel.addElement(new AreaLayerElement(newAreaLayerModel));
            AreaLayerDialog.this.areaLayers.setSelectedIndex(size);
        }
    }

    private class OkAction
    extends AbstractAction {
        private static final long serialVersionUID = 3280449595070962158L;

        public OkAction() {
            super(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.ok", new Serializable[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AreaLayerDialog.this.areaLayerDetaillessConfigurationPane.setCurrentValues();
            AreaLayerDialog.this.modelEnviroment.getUndoManager().finishTransaction("");
            try {
                AreaLayerDialog.this.putPropertiesForAreaLayer();
                AreaLayerDialog.this.modelEnviroment.getUndoManager().storeTransactions();
                for (Map.Entry entry : AreaLayerDialog.this.propertiesToSet.entrySet()) {
                    Tupel tupel = (Tupel)entry.getValue();
                    AreaLayerModel areaLayerModel = (AreaLayerModel)tupel.getElement1();
                    Properties sProperties = (Properties)tupel.getElement2();
                    for (Map.Entry<Object, Object> sEntry : sProperties.entrySet()) {
                        int firstdot;
                        String key = sEntry.getKey().toString();
                        if (key.charAt((firstdot = key.indexOf(46)) + 1) == 'T') {
                            String start = key.substring(0, firstdot + 1);
                            String end = key.substring(firstdot + 1);
                            firstdot = end.indexOf(46);
                            key = start + areaLayerModel.getId().toString() + end.substring(firstdot);
                        }
                        ModelEnviroment.getProperties().setDynamicProperty(key, sEntry.getValue().toString());
                    }
                }
                ModelEnviroment.getProperties().setDynamicProperty("areas.markColor", AreaLayerDialog.this.markColorEditor.getSerializedValue());
                Integer markAlphaValue = (Integer)AreaLayerDialog.this.markAlpha.getValue();
                ModelEnviroment.getProperties().setDynamicProperty("areas.markAlpha", markAlphaValue.toString());
                Color markColor = AreaLayerDialog.this.markColorEditor.getValue();
                Integer rAlpha = PaintUtil.transform100BaseAlpha(markAlphaValue);
                markColor = new Color(markColor.getRed(), markColor.getGreen(), markColor.getBlue(), rAlpha);
                FreeHandMarkerNavigatorRenderer.setMarkColor(markColor);
                ClientApplicationProperties.saveDynamicProperties(AreaLayerDialog.this.applicationName, ModelEnviroment.getProperties());
                AreaLayerDialog.this.modelEnviroment.getAllCaller().getBaseCaller().updateUserProperties(ModelEnviroment.getProperties());
                AreaLayerDialog.this.dispose();
            }
            catch (ValidateException e1) {
                AreaLayerDialog.this.modelEnviroment.getUndoManager().handleValidateException(e1);
            }
            catch (FileNotFoundException ex) {
                LOGGER.warn(ex.getMessage(), ex);
            }
            catch (IOException ex) {
                LOGGER.warn(ex.getMessage(), ex);
            }
        }
    }

    private class DiscriminatorActionListener
    implements ActionListener {
        private DiscriminatorActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AreaLayerElement areaLayerElement = (AreaLayerElement)AreaLayerDialog.this.areaLayers.getSelectedValue();
            if (areaLayerElement != null) {
                areaLayerElement.getAreaLayerModel().setDiscriminator((AreaObjectGenInfoDiscriminator)((Object)AreaLayerDialog.this.discriminator.getSelectedValue()));
            }
        }
    }

    private class TextDocumentListener
    implements DocumentListener {
        private TextDocumentListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.handleChange();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.handleChange();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.handleChange();
        }

        private void handleChange() {
            AreaLayerElement areaLayerElement = (AreaLayerElement)AreaLayerDialog.this.areaLayers.getSelectedValue();
            if (areaLayerElement != null && (ModelEnviroment.getUserInformation().isAdmin() || ModelEnviroment.getUserInformation().hasAtLeastOneRole(UserRole.AREA_ADMIN, UserRole.DISPONENT_SUPER))) {
                areaLayerElement.getAreaLayerModel().setDisplayname(AreaLayerDialog.this.areaDisplayName.getText());
                AreaLayerDialog.this.areaLayers.repaint(10L);
            }
        }
    }

    private class AreaListSelectionListener
    implements ListSelectionListener {
        private AreaListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (AreaLayerDialog.this.lastSelectedIndex != null && !AreaLayerDialog.this.lastSelectedIndex.equals(AreaLayerDialog.this.areaLayers.getSelectedIndex())) {
                AreaLayerDialog.this.putPropertiesForAreaLayer();
            }
            AreaLayerElement areaLayerElement = (AreaLayerElement)AreaLayerDialog.this.areaLayers.getSelectedValue();
            AreaLayerModel areaLayerModel = null;
            if (areaLayerElement == null) {
                AreaLayerDialog.this.areaDisplayName.setText("");
                AreaLayerDialog.this.areaDisplayName.setEnabled(false);
                AreaLayerDialog.this.discriminator.setEnabled(false);
                AreaLayerDialog.this.areaRendererPane.setEnabled(false);
                AreaLayerDialog.this.markAreaRendererPane.setEnabled(false);
                AreaLayerDialog.this.lineRendererPane.setEnabled(false);
                AreaLayerDialog.this.printInfo.setEditable(false);
                AreaLayerDialog.this.lastSelectedIndex = null;
                AreaLayerDialog.this.imageComboBoxChooserPane.setSelectedItem(null);
                AreaLayerDialog.this.imageComboBoxChooserPane.setEnabled(false);
            } else {
                areaLayerModel = areaLayerElement.getAreaLayerModel();
                Long id = areaLayerModel.getId();
                String idString = id == null ? "T" + areaLayerModel.getTempUUID() : id.toString();
                AreaLayerDialog.this.areaDisplayName.setText(areaLayerModel.getDisplayname());
                AreaLayerDialog.this.areaDisplayName.setEnabled(ModelEnviroment.getUserInformation().isAdmin() || ModelEnviroment.getUserInformation().hasAtLeastOneRole(UserRole.AREA_ADMIN, UserRole.DISPONENT_SUPER));
                Tupel tupel = (Tupel)AreaLayerDialog.this.propertiesToSet.get(idString);
                Properties tempProperties = tupel == null ? null : (Properties)tupel.getElement2();
                AreaLayerDialog.this.areaRendererPane.loadValues("layerstyle." + idString + ".fill", tempProperties);
                AreaLayerDialog.this.lineRendererPane.loadValues("layerstyle." + idString + ".border", tempProperties);
                AreaLayerDialog.this.markAreaRendererPane.loadValues("layerstyle." + idString + ".mark", tempProperties);
                AreaLayerDialog.this.areaRendererPane.setEnabled(true);
                AreaLayerDialog.this.lineRendererPane.setEnabled(true);
                AreaLayerDialog.this.markAreaRendererPane.setEnabled(true);
                AreaObjectGenInfoDiscriminator discriminator = areaLayerModel.getDiscriminator();
                if (discriminator == null) {
                    AreaLayerDialog.this.discriminator.setSelectedIndex(0);
                } else {
                    AreaLayerDialog.this.discriminator.setSelectedValue(discriminator);
                }
                AreaLayerDialog.this.discriminator.setEnabled(id == null);
                AreaLayerDialog.this.printInfo.setText(areaLayerModel.getPrintInfo() == null ? "" : areaLayerModel.getPrintInfo());
                AreaLayerDialog.this.printInfo.setEditable(true);
                AreaLayerDialog.this.lastSelectedIndex = AreaLayerDialog.this.areaLayers.getSelectedIndex();
                AreaLayerDialog.this.imageComboBoxChooserPane.setSelectedItem(areaLayerModel.getLogo());
                AreaLayerDialog.this.imageComboBoxChooserPane.setEnabled(true);
            }
            AreaLayerDialog.this.areaLayerDetaillessConfigurationPane.setAreaLayer(areaLayerModel);
        }
    }
}

