/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.configuration.gui.admin.user;

import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.UndoManager;
import de.datomino.peppergis.client.model.admin.SubSessionModel;
import de.datomino.peppergis.client.model.admin.UserModel;
import de.datomino.peppergis.client.model.admin.UserModelImpl;
import de.datomino.peppergis.client.model.admin.UserPropertyModel;
import de.datomino.peppergis.client.model.admin.UserRoleObjectModel;
import de.datomino.peppergis.client.model.admin.UserSessionModel;
import de.datomino.peppergis.configuration.gui.admin.user.SingleUserPanel;
import de.datomino.peppergis.exception.ValidateException;
import de.datomino.util.message.error.ErrorMessages;
import de.datomino.util.swing.SwingUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.ktde.util.StringUtil;

public class UserDialog
extends JDialog {
    private static final long serialVersionUID = 6654627723472276960L;
    private List<UserModel> users;
    private JList userList;
    private Action addUserAction;
    private Action removeUserAction;
    private ModelEnviroment modelEnviroment;
    private SingleUserPanel singleUserPanel;
    private Integer lastSelectedIndex;

    public UserDialog(Window parent, ModelEnviroment modelEnviroment) {
        super(parent, ModelEnviroment.getMessageResolver().resolveMessage("gui.userdialog.title", new Serializable[0]), Dialog.ModalityType.APPLICATION_MODAL);
        this.modelEnviroment = modelEnviroment;
        this.buildLayout();
        this.fillValues();
        this.pack();
        SwingUtils.centerDialog(this, parent);
        this.setVisible(true);
    }

    private void fillValues() {
        this.users = this.modelEnviroment.getAllCaller().getUserCaller().getAllUsers();
        DefaultListModel dlm = (DefaultListModel)this.userList.getModel();
        for (UserModel userModel : this.users) {
            dlm.addElement(new UserItem(userModel));
        }
    }

    private void buildLayout() {
        try {
            this.setIconImage(ImageIO.read(UserDialog.class.getResourceAsStream("/images/pepper.png")));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        JSplitPane panel = new JSplitPane(1);
        JPanel allUserPanel = new JPanel(new BorderLayout());
        this.userList = new JList(new DefaultListModel());
        this.userList.setSelectionMode(0);
        this.userList.addListSelectionListener(new AllUserListSelectionListener());
        JScrollPane scroll = new JScrollPane(this.userList);
        scroll.setHorizontalScrollBarPolicy(32);
        allUserPanel.add((Component)scroll, "Center");
        JPanel buttonPanel = new JPanel();
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.addUserAction = new AddUserAction();
        JButton addUser = new JButton(this.addUserAction);
        buttonPanel.add(addUser);
        this.removeUserAction = new RemoveUserAction();
        JButton removeUser = new JButton(this.removeUserAction);
        buttonPanel.add(removeUser);
        allUserPanel.add((Component)buttonPanel, "South");
        allUserPanel.setBorder(new TitledBorder(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.user", new Serializable[0])));
        panel.setLeftComponent(allUserPanel);
        this.singleUserPanel = new SingleUserPanel(this, this.modelEnviroment){
            private static final long serialVersionUID = -7092884487690393204L;

            @Override
            protected Collection<UserModel> getAllUsersInCache() {
                return UserDialog.this.users;
            }
        };
        panel.setRightComponent(this.singleUserPanel);
        this.getContentPane().add((Component)panel, "Center");
        JPanel mainButtonPanel = new JPanel(new BorderLayout());
        mainButtonPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JPanel mainSubButtonPanel = new JPanel();
        JButton ok = new JButton(new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("gui.common.ok", new Serializable[0])){
            private static final long serialVersionUID = 4718399144264291044L;

            @Override
            public void actionPerformed(ActionEvent e) {
                UserModel userModel = UserDialog.this.singleUserPanel.getUserModel();
                if (userModel != null) {
                    ErrorMessages errorMessages = UserDialog.this.singleUserPanel.validateInput();
                    if (errorMessages.hasErrors()) {
                        JOptionPane.showMessageDialog(UserDialog.this, StringUtil.implode(ModelEnviroment.getMessageResolver().resolveMessages(errorMessages.getErrorMessages()), "\n"), ModelEnviroment.getMessageResolver().resolveMessage("gui.common.errormessage.window.title", new Serializable[0]), 0);
                    } else {
                        UserDialog.this.singleUserPanel.setValuesToModel();
                        this.storeAndDispose();
                    }
                } else {
                    this.storeAndDispose();
                }
            }

            private void storeAndDispose() {
                UndoManager undoManager = UserDialog.this.modelEnviroment.getUndoManager();
                undoManager.finishTransaction("");
                try {
                    undoManager.storeTransactions();
                    UserDialog.this.dispose();
                }
                catch (ValidateException e1) {
                    undoManager.handleValidateException(e1);
                }
            }
        });
        mainSubButtonPanel.add(ok);
        JButton cancel = new JButton(new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("gui.common.cancel", new Serializable[0])){
            private static final long serialVersionUID = 6204734983424127581L;

            @Override
            public void actionPerformed(ActionEvent e) {
                UserDialog.this.dispose();
            }
        });
        mainSubButtonPanel.add(cancel);
        mainButtonPanel.add((Component)mainSubButtonPanel, "East");
        this.getContentPane().add((Component)mainButtonPanel, "South");
    }

    private class UserItem {
        private UserModel userModel;

        public UserItem(UserModel userModel) {
            this.userModel = userModel;
        }

        public UserModel getUserModel() {
            return this.userModel;
        }

        public String toString() {
            return this.userModel.getLogin();
        }
    }

    private class RemoveUserAction
    extends AbstractAction {
        private static final long serialVersionUID = -4839993614103163349L;

        public RemoveUserAction() {
            super(ModelEnviroment.getMessageResolver().resolveMessage("gui.userdialog.remove", new Serializable[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            UserItem userItem = (UserItem)UserDialog.this.userList.getSelectedValue();
            UserModel userModel = userItem.getUserModel();
            for (UserRoleObjectModel userRoleObjectModel : userModel.iterableUserRoleObjects()) {
                userRoleObjectModel.delete();
            }
            for (UserSessionModel userSession : userModel.iterableUserSessions()) {
                for (SubSessionModel subSessionModel : userSession.iterableSubSessions()) {
                    subSessionModel.delete();
                }
                userSession.delete();
            }
            for (UserPropertyModel userPropertyModel : userModel.iterableUserProperties()) {
                userPropertyModel.delete();
            }
            userModel.delete();
            DefaultListModel dlm = (DefaultListModel)UserDialog.this.userList.getModel();
            dlm.removeElement(userItem);
        }
    }

    private class AddUserAction
    extends AbstractAction {
        private static final long serialVersionUID = -7464791679315677266L;

        public AddUserAction() {
            super(ModelEnviroment.getMessageResolver().resolveMessage("gui.userdialog.add", new Serializable[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            UserModel userModel = UserDialog.this.singleUserPanel.getUserModel();
            if (userModel != null) {
                ErrorMessages errorMessages = UserDialog.this.singleUserPanel.validateInput();
                if (errorMessages.hasErrors()) {
                    JOptionPane.showMessageDialog(UserDialog.this, StringUtil.implode(ModelEnviroment.getMessageResolver().resolveMessages(errorMessages.getErrorMessages()), "\n"), ModelEnviroment.getMessageResolver().resolveMessage("gui.common.errormessage.window.title", new Serializable[0]), 0);
                } else {
                    UserDialog.this.singleUserPanel.setValuesToModel();
                    this.addUserToList();
                }
            } else {
                this.addUserToList();
            }
        }

        private void addUserToList() {
            UserModelImpl userModel = new UserModelImpl();
            userModel.setLogin("Login...");
            userModel.setName("");
            DefaultListModel dlm = (DefaultListModel)UserDialog.this.userList.getModel();
            UserItem userItem = new UserItem(userModel);
            dlm.addElement(userItem);
            UserDialog.this.userList.setSelectedValue(userItem, true);
        }
    }

    private class AllUserListSelectionListener
    implements ListSelectionListener {
        private boolean internalChange;

        private AllUserListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!this.internalChange) {
                ErrorMessages errorMessages = null;
                UserModel userModel = UserDialog.this.singleUserPanel.getUserModel();
                if (userModel != null && !(errorMessages = UserDialog.this.singleUserPanel.validateInput()).hasErrors()) {
                    UserDialog.this.singleUserPanel.setValuesToModel();
                }
                if (errorMessages == null || !errorMessages.hasErrors()) {
                    UserItem userItem = (UserItem)UserDialog.this.userList.getSelectedValue();
                    if (userItem == null) {
                        UserDialog.this.singleUserPanel.clear();
                        UserDialog.this.removeUserAction.setEnabled(false);
                        UserDialog.this.singleUserPanel.setEnabled(false);
                        UserDialog.this.lastSelectedIndex = null;
                    } else {
                        UserDialog.this.singleUserPanel.setUser(userItem.getUserModel());
                        UserDialog.this.removeUserAction.setEnabled(true);
                        UserDialog.this.singleUserPanel.setEnabled(true);
                        UserDialog.this.lastSelectedIndex = UserDialog.this.userList.getSelectedIndex();
                    }
                } else {
                    this.internalChange = true;
                    UserDialog.this.userList.setSelectedIndex(UserDialog.this.lastSelectedIndex);
                    this.internalChange = false;
                    JOptionPane.showMessageDialog(UserDialog.this, StringUtil.implode(ModelEnviroment.getMessageResolver().resolveMessages(errorMessages.getErrorMessages()), "\n"), ModelEnviroment.getMessageResolver().resolveMessage("gui.common.errormessage.window.title", new Serializable[0]), 0);
                }
            }
        }
    }
}

