/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.configuration.gui.admin.user;

import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.base.BranchModel;
import de.datomino.util.message.MessageResolver;
import de.datomino.util.swing.SwingUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JPanel;

public class BranchSelectionDialog
extends JDialog {
    private static final long serialVersionUID = -8017626574369183199L;
    private JComboBox branchComboBox;
    private MessageResolver messageResolver;
    private ModelEnviroment modelEnviroment;
    private OkCallBack okCallBack;
    private Action okAction;
    private Long branchId;

    public BranchSelectionDialog(Window parent, ModelEnviroment modelEnviroment, MessageResolver messageResolver, OkCallBack okCallback) {
        super(parent, messageResolver.resolveMessage("gui.userdialog.chooseBranch", new Serializable[0]), Dialog.ModalityType.APPLICATION_MODAL);
        this.setResizable(false);
        this.modelEnviroment = modelEnviroment;
        this.messageResolver = messageResolver;
        this.okCallBack = okCallback;
        this.buildLayout();
        this.pack();
        this.setSize(Math.max(this.getWidth(), 200), this.getHeight());
        SwingUtils.centerDialog(this, parent);
    }

    private void buildLayout() {
        try {
            this.setIconImage(ImageIO.read(BranchSelectionDialog.class.getResourceAsStream("/images/pepper.png")));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        this.getContentPane().setLayout(new BorderLayout());
        List<BranchModel> branchModels = this.modelEnviroment.getAllCaller().getTourCaller().fetchAllBranchs();
        BranchItem[] branchItems = new BranchItem[branchModels.size()];
        int counter = 0;
        for (BranchModel branchModel : branchModels) {
            branchItems[counter] = new BranchItem(branchModel);
            ++counter;
        }
        this.branchComboBox = new JComboBox<BranchItem>(branchItems);
        this.branchComboBox.addActionListener(new BranchComboBoxActionListener());
        this.branchComboBox.setBorder(BorderFactory.createEmptyBorder(10, 0, 5, 0));
        this.getContentPane().add((Component)this.branchComboBox, "Center");
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        this.okAction = new AbstractAction(this.messageResolver.resolveMessage("gui.common.ok", new Serializable[0])){
            private static final long serialVersionUID = -8463156910122073166L;

            @Override
            public void actionPerformed(ActionEvent e) {
                BranchSelectionDialog.this.branchId = ((BranchItem)BranchSelectionDialog.this.branchComboBox.getSelectedItem()).getBranchModel().getId();
                BranchSelectionDialog.this.okCallBack.doOkCallback(BranchSelectionDialog.this.branchId);
                BranchSelectionDialog.this.dispose();
            }
        };
        JButton ok = new JButton(this.okAction);
        this.okAction.setEnabled(counter > 0);
        panel.add(ok);
        JButton cancel = new JButton(new AbstractAction(this.messageResolver.resolveMessage("gui.common.cancel", new Serializable[0])){
            private static final long serialVersionUID = -8463156910122073166L;

            @Override
            public void actionPerformed(ActionEvent e) {
                BranchSelectionDialog.this.branchId = null;
                BranchSelectionDialog.this.dispose();
            }
        });
        panel.add(cancel);
        this.getContentPane().add((Component)panel, "South");
    }

    public Long getBranchId() {
        return this.branchId;
    }

    public static interface OkCallBack {
        public void doOkCallback(Long var1);
    }

    private class BranchComboBoxActionListener
    implements ActionListener {
        private BranchComboBoxActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int index = BranchSelectionDialog.this.branchComboBox.getSelectedIndex();
            BranchSelectionDialog.this.okAction.setEnabled(index >= 0);
        }
    }

    private class BranchItem {
        private BranchModel branchModel;

        public BranchItem(BranchModel branchModel) {
            this.branchModel = branchModel;
        }

        public String toString() {
            return this.branchModel.getName();
        }

        public BranchModel getBranchModel() {
            return this.branchModel;
        }
    }
}

