/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.configuration.gui.admin.user;

import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.area.AreaLayerModel;
import de.datomino.peppergis.type.AreaObjectGenInfoDiscriminator;
import de.datomino.util.message.MessageResolver;
import de.datomino.util.swing.SwingUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JPanel;

class AreaLayerSelectionDialog
extends JDialog {
    private static final long serialVersionUID = -2415587030830783269L;
    private JComboBox areaLayerComboBox;
    private MessageResolver messageResolver;
    private ModelEnviroment modelEnviroment;
    private Long areaLayerId;
    private OkCallBack okCallBack;
    private Action okAction;

    public AreaLayerSelectionDialog(Window parent, ModelEnviroment modelEnviroment, MessageResolver messageResolver, OkCallBack okCallBack) {
        super(parent, messageResolver.resolveMessage("gui.userdialog.chooseAreaLayer", new Serializable[0]), Dialog.ModalityType.APPLICATION_MODAL);
        this.setResizable(false);
        this.modelEnviroment = modelEnviroment;
        this.messageResolver = messageResolver;
        this.okCallBack = okCallBack;
        this.buildLayout();
        this.pack();
        this.setSize(Math.max(this.getWidth(), 200), this.getHeight());
        SwingUtils.centerDialog(this, parent);
    }

    private void buildLayout() {
        try {
            this.setIconImage(ImageIO.read(AreaLayerSelectionDialog.class.getResourceAsStream("/images/pepper.png")));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        this.getContentPane().setLayout(new BorderLayout());
        Collection<AreaLayerModel> areaLayerModels = this.modelEnviroment.getAllCaller().getAreaCaller().getAreaLayersForType(AreaObjectGenInfoDiscriminator.values());
        AreaLayerItem[] areaLayerItems = new AreaLayerItem[areaLayerModels.size()];
        int counter = 0;
        for (AreaLayerModel areaLayerModel : areaLayerModels) {
            areaLayerItems[counter] = new AreaLayerItem(areaLayerModel);
            ++counter;
        }
        this.areaLayerComboBox = new JComboBox<AreaLayerItem>(areaLayerItems);
        this.areaLayerComboBox.setBorder(BorderFactory.createEmptyBorder(10, 0, 5, 0));
        this.areaLayerComboBox.addActionListener(new AreaComboBoxActionListener());
        this.getContentPane().add((Component)this.areaLayerComboBox, "Center");
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        this.okAction = new AbstractAction(this.messageResolver.resolveMessage("gui.common.ok", new Serializable[0])){
            private static final long serialVersionUID = -8463156910122073166L;

            @Override
            public void actionPerformed(ActionEvent e) {
                AreaLayerSelectionDialog.this.areaLayerId = ((AreaLayerItem)AreaLayerSelectionDialog.this.areaLayerComboBox.getSelectedItem()).getAreaLayerModel().getId();
                AreaLayerSelectionDialog.this.okCallBack.doOkCallback(AreaLayerSelectionDialog.this.areaLayerId);
                AreaLayerSelectionDialog.this.dispose();
            }
        };
        JButton ok = new JButton(this.okAction);
        this.okAction.setEnabled(counter > 0);
        panel.add(ok);
        JButton cancel = new JButton(new AbstractAction(this.messageResolver.resolveMessage("gui.common.cancel", new Serializable[0])){
            private static final long serialVersionUID = -8463156910122073166L;

            @Override
            public void actionPerformed(ActionEvent e) {
                AreaLayerSelectionDialog.this.areaLayerId = null;
                AreaLayerSelectionDialog.this.dispose();
            }
        });
        panel.add(cancel);
        this.getContentPane().add((Component)panel, "South");
    }

    public Long getAreaLayerId() {
        return this.areaLayerId;
    }

    private class AreaComboBoxActionListener
    implements ActionListener {
        private AreaComboBoxActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int index = AreaLayerSelectionDialog.this.areaLayerComboBox.getSelectedIndex();
            AreaLayerSelectionDialog.this.okAction.setEnabled(index >= 0);
        }
    }

    static interface OkCallBack {
        public void doOkCallback(Long var1);
    }

    private class AreaLayerItem {
        private AreaLayerModel areaLayerModel;

        public AreaLayerItem(AreaLayerModel areaLayerModel) {
            this.areaLayerModel = areaLayerModel;
        }

        public String toString() {
            return this.areaLayerModel.getDisplayname();
        }

        public AreaLayerModel getAreaLayerModel() {
            return this.areaLayerModel;
        }
    }
}

