/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.configuration.gui.actions;

import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.util.message.error.ErrorMessages;
import de.datomino.util.swing.ErrorMessageDialog;
import de.datomino.util.swing.SpringUtilities;
import de.datomino.util.swing.SwingUtils;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SpringLayout;
import org.ktde.util.datatypes.Tripel;

public class TriggerMapUpdateAction
extends AbstractAction {
    private static final long serialVersionUID = 8933050020125834703L;
    private Component parent;

    public TriggerMapUpdateAction(Component parent) {
        super(ModelEnviroment.getMessageResolver().resolveMessage("messages.map.triggerUpdate", new Serializable[0]));
        this.parent = parent;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Window window = SwingUtils.findWindowParent(this.parent);
        JPanel panel = new JPanel(new SpringLayout());
        panel.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.map.triggerUpdate.question", new Serializable[0])));
        JCheckBox keepOrigAreaTours = new JCheckBox(ModelEnviroment.getMessageResolver().resolveMessage("messages.map.triggerUpdate.keepOrigAreaTours", new Serializable[0]));
        panel.add(keepOrigAreaTours);
        SpringUtilities.makeCompactGrid(panel, 2, 1, 5, 5, 5, 5);
        int d = JOptionPane.showConfirmDialog(window, panel, ModelEnviroment.getMessageResolver().resolveMessage("messages.default.question", new Serializable[0]), 0, 3);
        if (d == 0) {
            ModelEnviroment modelEnviroment = new ModelEnviroment(this.parent);
            Tripel<Date, Date, ErrorMessages> update = modelEnviroment.getAllCaller().getMapDataCaller().triggerForMapUpdate(keepOrigAreaTours.isSelected());
            modelEnviroment.close();
            if (update.getElement3().hasErrors()) {
                BufferedImage image;
                try {
                    image = ImageIO.read(TriggerMapUpdateAction.class.getResourceAsStream("/images/pepper.png"));
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
                ErrorMessageDialog errorMessageDialog = new ErrorMessageDialog(SwingUtils.findWindowParent(this.parent), ModelEnviroment.getMessageResolver(), update.getElement3(), image);
                errorMessageDialog.setVisible(true);
                return;
            }
            Date current = update.getElement1();
            Date newest = update.getElement2();
            if (newest == null) {
                JOptionPane.showMessageDialog(window, ModelEnviroment.getMessageResolver().resolveMessage("messages.map.triggerUpdate.allUnknown", new Serializable[0]), ModelEnviroment.getMessageResolver().resolveMessage("messages.default.error", new Serializable[0]), 0);
            } else if (newest.getTime() == 0L && current != null && current.getTime() == 0L) {
                JOptionPane.showMessageDialog(window, ModelEnviroment.getMessageResolver().resolveMessage("messages.map.triggerUpdate.notAllowed", new Serializable[0]), ModelEnviroment.getMessageResolver().resolveMessage("messages.default.information", new Serializable[0]), 1);
            } else {
                SimpleDateFormat sdf = new SimpleDateFormat("dd-MM-yyyy HH:mm");
                String currentString = current == null ? "?" : sdf.format(current);
                if (current != null && (current.after(newest) || current.equals(newest))) {
                    JOptionPane.showMessageDialog(window, ModelEnviroment.getMessageResolver().resolveMessage("messages.map.triggerUpdate.alreadyUptodate", new Serializable[]{currentString}), ModelEnviroment.getMessageResolver().resolveMessage("messages.default.information", new Serializable[0]), 1);
                } else {
                    JOptionPane.showMessageDialog(window, ModelEnviroment.getMessageResolver().resolveMessage("messages.map.triggerUpdate.willUpdate", new Serializable[]{currentString, sdf.format(newest)}), ModelEnviroment.getMessageResolver().resolveMessage("messages.default.information", new Serializable[0]), 1);
                }
            }
        }
    }
}

